/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.contract.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.contract.client.AbstractContractStatisticalReportFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ContractStatisticalReportFilterUI
extends AbstractContractStatisticalReportFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ContractStatisticalReportFilterUI.class);

    public void onLoad() throws Exception {
        super.onLoad();
        this.initEditor();
        this.initListener();
        this.clear();
    }

    private void initEditor() {
        AdminByOrgRangePromptBox selector = new AdminByOrgRangePromptBox();
        this.prmtAdmin.setSelector((KDPromptSelector)selector);
    }

    protected void initListener() {
        super.initListener();
        this.prmtAdmin.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent event) {
                try {
                    ContractStatisticalReportFilterUI.this.prmtAdmin_dataChanged(event);
                }
                catch (Exception e) {
                    ContractStatisticalReportFilterUI.this.handUIException(e);
                }
            }
        });
    }

    private void prmtAdmin_dataChanged(DataChangeEvent event) throws Exception {
        EmployeeClientUtils.setComboBoxLevel((DataChangeEvent)event, (KDComboBox)this.comboOrgLevel);
    }

    public CustomerParams getCommonCustomerParams() {
        CustomerParams params = new CustomerParams();
        String adminId = null;
        if (this.prmtAdmin.getValue() instanceof AdminOrgUnitInfo) {
            adminId = ((AdminOrgUnitInfo)this.prmtAdmin.getValue()).getId().toString();
        }
        params.addCustomerParam(this.prmtAdmin.getName(), adminId);
        params.putBoolean(this.rdDisplayChild.getName(), this.rdDisplayChild.isSelected());
        params.putBoolean(this.rdDisplayLevel.getName(), this.rdDisplayLevel.isSelected());
        params.putBoolean(this.rdDisplayAll.getName(), this.rdDisplayAll.isSelected());
        params.putInt(this.comboOrgLevel.getName(), this.comboOrgLevel.getSelectedIndex());
        params.putBoolean(this.rdContinuous.getName(), this.rdContinuous.isSelected());
        params.putBoolean(this.rdFixed.getName(), this.rdFixed.isSelected());
        params.putBoolean(this.rdLimit.getName(), this.rdLimit.isSelected());
        return params;
    }

    public void setCommonCustomerParams(CustomerParams cp) {
        String adminId = cp.getCustomerParam(this.prmtAdmin.getName());
        AdminOrgUnitInfo adminInfo = null;
        if (!StringUtils.isEmpty((String)adminId)) {
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminId));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.prmtAdmin.setValue(adminInfo);
        this.rdDisplayChild.setSelected(cp.getBoolean(this.rdDisplayChild.getName()));
        this.rdDisplayLevel.setSelected(cp.getBoolean(this.rdDisplayLevel.getName()));
        this.rdDisplayAll.setSelected(cp.getBoolean(this.rdDisplayAll.getName()));
        if (cp.getInt(this.comboOrgLevel.getName()) != 0) {
            this.comboOrgLevel.setSelectedIndex(cp.getInt(this.comboOrgLevel.getName()));
        }
        this.rdContinuous.setSelected(cp.getBoolean(this.rdContinuous.getName()));
        this.rdFixed.setSelected(cp.getBoolean(this.rdFixed.getName()));
        this.rdLimit.setSelected(cp.getBoolean(this.rdLimit.getName()));
    }

    public com.kingdee.eas.base.commonquery.client.CustomerParams getCustomerParams() {
        return com.kingdee.eas.base.commonquery.client.CustomerParams.castToClientCustomerParams((CustomerParams)this.getCommonCustomerParams());
    }

    public void setCustomerParams(com.kingdee.eas.base.commonquery.client.CustomerParams cp) {
        this.setCommonCustomerParams(cp.castToCommonCustomerParams());
    }

    public void clear() {
        super.clear();
        this.rdDisplayChild.setSelected(true);
        this.rdContinuous.setSelected(true);
    }

    public boolean verify() {
        return super.verify();
    }

    ReportFilterInfo getReportFilterInfo() {
        ReportFilterInfo filterInfo = new ReportFilterInfo();
        if (this.prmtAdmin.getValue() instanceof AdminOrgUnitInfo) {
            filterInfo.setAdminId(((AdminOrgUnitInfo)this.prmtAdmin.getValue()).getId().toString());
        }
        int orgLevel = 0;
        if (this.rdDisplayChild.isSelected()) {
            orgLevel = 0;
        } else if (this.rdDisplayLevel.isSelected()) {
            orgLevel = -1;
            Object obj = this.comboOrgLevel.getSelectedItem();
            if (obj instanceof Integer) {
                orgLevel = (Integer)obj - 1;
            }
        } else if (this.rdDisplayAll.isSelected()) {
            orgLevel = -1;
        }
        filterInfo.setOrgLevel(orgLevel);
        int condition = -1;
        if (this.rdContinuous.isSelected()) {
            condition = -1;
        } else if (this.rdFixed.isSelected()) {
            condition = 0;
        } else if (this.rdLimit.isSelected()) {
            condition = 1;
        }
        filterInfo.setCondition(condition);
        return filterInfo;
    }

    static class ReportFilterInfo {
        private String adminId;
        private int orgLevel = 0;
        private int condition = -1;

        private ReportFilterInfo() {
        }

        public String getAdminId() {
            return this.adminId;
        }

        public void setAdminId(String adminId) {
            this.adminId = adminId;
        }

        public int getOrgLevel() {
            return this.orgLevel;
        }

        public void setOrgLevel(int orgLevel) {
            this.orgLevel = orgLevel;
        }

        public int getCondition() {
            return this.condition;
        }

        public void setCondition(int condition) {
            this.condition = condition;
        }
    }
}

