/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.elecontract.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.HRBillBaseInfo;
import com.kingdee.eas.hr.base.app.util.MetaDataServerUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.hr.contract.ContractPreNewSignBizBillInfo;
import com.kingdee.eas.hr.contract.EContractSignState;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogFactory;
import com.kingdee.eas.hr.contract.EmpEleContractDelLogInfo;
import com.kingdee.eas.hr.contract.EmpEleContractException;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordCollection;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordFactory;
import com.kingdee.eas.hr.contract.EmpOtherEleContractSignRecordInfo;
import com.kingdee.eas.hr.contract.IEmpEleContractSignRecord;
import com.kingdee.eas.hr.contract.IEmpOtherEleContractSignRecord;
import com.kingdee.eas.hr.contract.IOtherFollowPreNewConEntry;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryCollection;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryFactory;
import com.kingdee.eas.hr.contract.OtherFollowPreNewConEntryInfo;
import com.kingdee.eas.hr.elecontract.util.EmpElectronicContractUtilsEx;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.EmployeeOtherContractFactory;
import com.kingdee.eas.hr.emp.EmployeeOtherContractInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmpEleContractFollowUtils {
    private static Logger logger = LoggerFactory.getLogger(EmpEleContractFollowUtils.class);

    public static String readEmpOtherContractNumber(Context ctx) throws EASBizException, BOSException {
        HROrgUnitInfo hrInfo = ContextUtil.getCurrentHRUnit((Context)ctx);
        String mainOrgID = hrInfo.getId().toString();
        EmployeeOtherContractInfo employeeOtherContractInfo = new EmployeeOtherContractInfo();
        boolean hasCodingRule = EmpEleContractFollowUtils.hasCodingRule((IObjectValue)employeeOtherContractInfo, mainOrgID);
        String numberTemp = null;
        if (hasCodingRule) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                numberTemp = iCodingRuleManager.getNumber((IObjectValue)employeeOtherContractInfo, mainOrgID);
                return numberTemp;
            }
            catch (BOSException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            return null;
        }
        return numberTemp;
    }

    public static boolean isEmpOtherContractNumberExist(Context ctx, String numberTemp) throws BOSException, EASBizException {
        String oql = "where contractNo ='" + numberTemp + "'";
        return EmployeeOtherContractFactory.getLocalInstance((Context)ctx).exists(oql) || OtherFollowPreNewConEntryFactory.getLocalInstance(ctx).exists(oql);
    }

    public static boolean hasCodingRule(IObjectValue model, String orgId) {
        try {
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            if (orgId != null && orgId.trim().length() > 0 && iCodingRuleManager.isExist(model, orgId)) {
                return true;
            }
            String companyId = EmpEleContractFollowUtils.getNextCompanyId();
            return companyId != null && companyId.trim().length() > 0 && iCodingRuleManager.isExist(model, companyId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static String getNextCompanyId() throws Exception {
        ObjectUuidPK pk;
        ICtrlUnit iCtrlUnit = CtrlUnitFactory.getRemoteInstance();
        CtrlUnitInfo rootCU = iCtrlUnit.getCtrlUnitInfo((IObjectPK)(pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4")));
        if (rootCU != null) {
            return rootCU.getId().toString();
        }
        return null;
    }

    public static void updateOtherFollowPreNewConEntrySignStatus(Context ctx, String entryId, EContractSignState signState) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)entryId)) {
            IOtherFollowPreNewConEntry otherFollowPreNewConEntryLocalInstance = OtherFollowPreNewConEntryFactory.getLocalInstance(ctx);
            OtherFollowPreNewConEntryInfo otherFollowPreNewConEntryInfo = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)entryId));
            view.setFilter(filterInfo);
            logger.error("EmpElectronicOContractUtilsEx.updateContractPreNewSignBizBillEntrySignStatus view : " + view);
            OtherFollowPreNewConEntryCollection otherFollowPreNewConEntryCollection = otherFollowPreNewConEntryLocalInstance.getOtherFollowPreNewConEntryCollection(view);
            if (otherFollowPreNewConEntryCollection != null && otherFollowPreNewConEntryCollection.size() > 0) {
                otherFollowPreNewConEntryInfo = otherFollowPreNewConEntryCollection.get(0);
            }
            if (otherFollowPreNewConEntryInfo != null) {
                logger.error("EmpElectronicOtherContractUtils.updateOtherFollowPreNewConEntrySignStatus otherFollowPreNewConEntryInfo : " + otherFollowPreNewConEntryInfo.getId());
            } else {
                logger.error("EmpElectronicOtherContractUtils.updateOtherFollowPreNewConEntrySignStatus otherFollowPreNewConEntryInfo is null ");
            }
            if (otherFollowPreNewConEntryInfo != null) {
                otherFollowPreNewConEntryInfo.setSignState(signState);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("signState"));
                otherFollowPreNewConEntryLocalInstance.updatePartial(otherFollowPreNewConEntryInfo, selector);
            }
        }
    }

    public static void doUpdateStateInBill(Context ctx, HRBillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        boolean isSigningOrCompleteInOne;
        boolean isCompleteInOne;
        int i;
        if (billBaseInfo == null) {
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billBaseInfo.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        IEmpEleContractSignRecord empEleConSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection empEconSignRecordColl = empEleConSignRecordLocalInstance.getEmpEleContractSignRecordCollection(viewInfo);
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection empOtherEconSignRecordColl = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(viewInfo);
        boolean isComplete = true;
        boolean isSigningOrComplete = true;
        int empOtherEconSignRecordCollSize = empOtherEconSignRecordColl.size();
        for (i = 0; i < empEconSignRecordColl.size(); ++i) {
            isCompleteInOne = false;
            isSigningOrCompleteInOne = false;
            EmpEleContractSignRecordInfo empEleConSignRecordInfo = empEconSignRecordColl.get(i);
            if (empEleConSignRecordInfo.isIsSigned()) {
                isCompleteInOne = true;
            }
            if (empEleConSignRecordInfo.isIsPersonSign()) {
                isSigningOrCompleteInOne = true;
            }
            isComplete = isComplete && isCompleteInOne;
            isSigningOrComplete = isSigningOrComplete && isSigningOrCompleteInOne;
            logger.info("EmpEleContractFollowUtils.doUpdateStateInBill EmployeeContract isComplete:" + isComplete + ",isSigningOrComplete:" + isSigningOrComplete);
        }
        for (i = 0; i < empOtherEconSignRecordCollSize; ++i) {
            isCompleteInOne = false;
            isSigningOrCompleteInOne = false;
            EmpOtherEleContractSignRecordInfo empOtherEleConSignRecordInfo = empOtherEconSignRecordColl.get(i);
            if (empOtherEleConSignRecordInfo.isIsSigned()) {
                isCompleteInOne = true;
            }
            if (empOtherEleConSignRecordInfo.isIsPersonSign()) {
                isSigningOrCompleteInOne = true;
            }
            isComplete = isComplete && isCompleteInOne;
            isSigningOrComplete = isSigningOrComplete && isSigningOrCompleteInOne;
            logger.info("EmpEleContractFollowUtils.doUpdateStateInBill Contract isComplete:" + isComplete + ",isSigningOrComplete:" + isSigningOrComplete);
        }
        SelectorItemCollection totalSelector = new SelectorItemCollection();
        totalSelector.add(new SelectorItemInfo("totalState"));
        totalSelector.add(new SelectorItemInfo("lastUpdateTime"));
        totalSelector.add(new SelectorItemInfo("lastUpdateUser"));
        billBaseInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
        billBaseInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
        String billBosType = billBaseInfo.getId().getType().toString();
        logger.info("billBosType---->:" + billBosType);
        ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billBaseInfo.getId().getType());
        if (isComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.complete);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        } else if (!isComplete && isSigningOrComplete) {
            billBaseInfo.put("totalState", (Object)EContractSignState.signing);
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        }
    }

    public static boolean isSignComplete(Context ctx, String billId) throws BOSException, EASBizException {
        int i;
        boolean isSigned = true;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
        filterInfo.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        IEmpEleContractSignRecord empEleConSignRecordLocalInstance = EmpEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpEleContractSignRecordCollection empEconSignRecordColl = empEleConSignRecordLocalInstance.getEmpEleContractSignRecordCollection(view);
        IEmpOtherEleContractSignRecord empEleContractSignRecordLocalInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection empOtherEconSignRecordColl = empEleContractSignRecordLocalInstance.getEmpOtherEleContractSignRecordCollection(view);
        int empOtherEconSignRecordCollSize = empOtherEconSignRecordColl.size();
        for (i = 0; i < empEconSignRecordColl.size(); ++i) {
            EmpEleContractSignRecordInfo empEleConSignRecordInfo = empEconSignRecordColl.get(i);
            if (empEleConSignRecordInfo.isIsSigned()) continue;
            isSigned = false;
            logger.info("EmpEleContractFollowUtils.isSignComplete employeeContract isSigned:" + isSigned + " contractNo:" + empEleConSignRecordInfo.getContractNO());
            return isSigned;
        }
        for (i = 0; i < empOtherEconSignRecordCollSize; ++i) {
            EmpOtherEleContractSignRecordInfo empOtherEleConSignRecordInfo = empOtherEconSignRecordColl.get(i);
            if (empOtherEleConSignRecordInfo.isIsSigned()) continue;
            isSigned = false;
            logger.info("EmpEleContractFollowUtils.isSignComplete otherContract isSigned:" + isSigned + " contractNo:" + empOtherEleConSignRecordInfo.getContractNO());
            return isSigned;
        }
        return isSigned;
    }

    public static int getSignEContractCount(Context ctx, String billId) throws BOSException, EASBizException {
        int counts = 1;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("billId", (Object)billId));
            filter.getFilterItems().add(new FilterItemInfo("isInvalid", (Object)0, CompareType.EQUALS));
            view.setFilter(filter);
            IEmpOtherEleContractSignRecord iEmpOtherEleConRecord = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
            counts += iEmpOtherEleConRecord.getCount(view);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return counts;
    }

    public static void updateEContractTotalStateInBill(Context ctx, HRBillBaseInfo billBaseInfo, EContractSignState signState) throws BOSException, EASBizException {
        if (billBaseInfo == null) {
            return;
        }
        SelectorItemCollection totalSelector = new SelectorItemCollection();
        totalSelector.add(new SelectorItemInfo("totalState"));
        totalSelector.add(new SelectorItemInfo("lastUpdateTime"));
        totalSelector.add(new SelectorItemInfo("lastUpdateUser"));
        if (billBaseInfo.getId() != null) {
            String billBosType = billBaseInfo.getId().getType().toString();
            logger.info("billBosType---->:" + billBosType);
            ICoreBase bizInterface = MetaDataServerUtil.getBizInterface((Context)ctx, (BOSObjectType)billBaseInfo.getId().getType());
            billBaseInfo.put("totalState", (Object)signState);
            billBaseInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            billBaseInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            bizInterface.updatePartial((CoreBaseInfo)billBaseInfo, totalSelector);
        }
    }

    public static void checkEmpEleContractTotalStatus(Context ctx, HRBillBaseInfo billBaseInfo) throws BOSException, EASBizException {
        if (billBaseInfo instanceof ContractPreNewSignBizBillInfo) {
            int signStatusValue;
            ContractPreNewSignBizBillInfo conPreNewBizBillInfo = (ContractPreNewSignBizBillInfo)billBaseInfo;
            EContractSignState signStatus = conPreNewBizBillInfo.getTotalState();
            int n = signStatusValue = signStatus != null ? signStatus.getValue() : -999;
            if (signStatus != null && signStatusValue != 1) {
                throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NOT_SIGNING, new Object[]{signStatus.getAlias()});
            }
            if (signStatusValue == -999) {
                throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_SIGNING_STATUS_IS_NULL);
            }
        }
    }

    public static void verifyContractSignStatusAndContractClassify(Context ctx, EmployeeContractInfo employeeContractInfo) throws EmpEleContractException {
        ContractTempletInfo contractTemplet = employeeContractInfo.getContractTemplet();
        if (!contractTemplet.isIsElectronicSign() || employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 0) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_CONTRACTTEMPLET);
        }
        if (contractTemplet.isIsElectronicSign() && employeeContractInfo.getContractClassify() != null && employeeContractInfo.getContractClassify().getValue() == 1) {
            throw new EmpEleContractException(EmpEleContractException.BATCHEMPLOYEESIGN_IS_FAIL_FOR_FROM_SSC);
        }
        if (employeeContractInfo.getSignStatus() == null) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_SIGNSTATUS_IS_NULL);
        }
        if (employeeContractInfo.getSignStatus() != null && (employeeContractInfo.getSignStatus().getValue() == 1 || employeeContractInfo.getSignStatus().getValue() == 2 || employeeContractInfo.getSignStatus().getValue() == 6)) {
            throw new EmpEleContractException(EmpEleContractException.CANNOT_BATCH_EMPLOYEE_SIGN);
        }
    }

    public static void checkContractBizBillSignStatus(EContractSignState signStatus) throws EmpEleContractException {
        if (EContractSignState.nosign != signStatus && EContractSignState.signing != signStatus && EContractSignState.partyASigned != signStatus) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_OVER);
        }
    }

    public static void checkContractBizBillTotalStatus(EContractSignState signStatus) throws EmpEleContractException {
        if (EContractSignState.abandon == signStatus) {
            throw new EmpEleContractException(EmpEleContractException.ELECTRONIC_CONTRACT_IS_ALREADY_ABANDON);
        }
        if (EContractSignState.complete != signStatus) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_IS_SIGNING);
        }
    }

    public static void deleteEmpOtherEleContractRelatedTable(Context ctx, EmployeeOtherContractInfo contractInfo) throws BOSException, EASBizException {
        IEmpOtherEleContractSignRecord empOtherSignRecordInstance = EmpOtherEleContractSignRecordFactory.getLocalInstance(ctx);
        EmpOtherEleContractSignRecordCollection recordCollection = empOtherSignRecordInstance.getEmpOtherEleContractSignRecordCollection("where contract.id= '" + contractInfo.getId().toString() + "'");
        for (int i = 0; i < recordCollection.size(); ++i) {
            EmpOtherEleContractSignRecordInfo empOtherEleConSignRecordInfo = recordCollection.get(i);
            EmpEleContractDelLogInfo logInfo = new EmpEleContractDelLogInfo();
            logInfo.setEContractNo(empOtherEleConSignRecordInfo.getEContractNO());
            logInfo.setEmpName(contractInfo.getPreEntryPerson().getName(LocaleUtils.locale_l1), LocaleUtils.locale_l1);
            logInfo.setEmpName(contractInfo.getPreEntryPerson().getName(LocaleUtils.locale_l2), LocaleUtils.locale_l2);
            logInfo.setEmpName(contractInfo.getPreEntryPerson().getName(LocaleUtils.locale_l3), LocaleUtils.locale_l3);
            logInfo.setEmpNum(contractInfo.getPreEntryPerson().getNumber());
            logInfo.setIdCardNO(contractInfo.getPreEntryPerson().getIdCardNO());
            logInfo.setPassportNO(contractInfo.getPreEntryPerson().getPassportNO());
            logInfo.setCreator(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setLastUpdateUser(HRUtilExtend.getCurrentUserInfo((Context)ctx));
            logInfo.setCreateTime(HRUtilExtend.getCurTimestamp());
            logInfo.setLastUpdateTime(HRUtilExtend.getCurTimestamp());
            EmpEleContractDelLogFactory.getLocalInstance(ctx).save((CoreBaseInfo)logInfo);
        }
        EmpEleContractFollowUtils.deleteEmpOtherEleConSignRecordInfo(empOtherSignRecordInstance, contractInfo.getId().toString());
        EmpElectronicContractUtilsEx.deleteContractBillMiddleInfo(ctx, contractInfo.getId().toString());
    }

    public static void deleteEmpOtherEleConSignRecordInfo(IEmpOtherEleContractSignRecord conOtherSignRecordInstance, String contractId) throws EASBizException, BOSException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("contract.id", (Object)contractId));
            conOtherSignRecordInstance.delete(filter);
        }
    }

    public static void deleteEmpOtherContractInfo(Context ctx, String contractId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)contractId)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)contractId));
            EmployeeOtherContractFactory.getLocalInstance((Context)ctx).delete(filter);
        }
    }

    public static void checkWhetherUnCheckBizBillBySignStatus(EContractSignState signStatus, String operation) throws EmpEleContractException {
        if (EContractSignState.nosign == signStatus || EContractSignState.signing == signStatus || EContractSignState.partyASigned == signStatus || EContractSignState.complete == signStatus) {
            throw new EmpEleContractException(EmpEleContractException.EMP_ELE_CONTRACT_CANNOT_UNTICHECK, new Object[]{operation});
        }
    }
}

