/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bizunit.BizUnitInfo;
import com.kingdee.bos.metadata.entity.DataType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.ui.ComponentInfo;
import com.kingdee.bos.metadata.ui.UIObjectInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.uict.client.util.BizConfigureHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.ep.client.util.UictUtils;
import com.kingdee.eas.hr.emp.EmpBatTreConEntryInfo;
import com.kingdee.eas.hr.emp.EmpBatTreConInfo;
import com.kingdee.eas.hr.emp.EmpBatchF7Helper;
import com.kingdee.eas.hr.emp.EmpEntityPropertyInfo;
import com.kingdee.eas.hr.emp.EmployeeEditPageSchemeInfo;
import com.kingdee.eas.hr.emp.EmployeePageCollection;
import com.kingdee.eas.hr.emp.EmployeePageFactory;
import com.kingdee.eas.hr.emp.EmployeePageGroupInfo;
import com.kingdee.eas.hr.emp.EmployeePageInfo;
import com.kingdee.eas.hr.emp.HrEmpBizException;
import com.kingdee.eas.hr.emp.client.EmpFieldPermissionUtil;
import com.kingdee.eas.hr.emp.client.util.MetaDataHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

public class EmpBatTreConUtil {
    private static Logger logger = Logger.getLogger(EmpBatTreConUtil.class);
    private static final String REF_ENTITY = "refEntity";
    private static final String QUERY_INFO = "queryInfo";
    private static final String SELECTOR = "selector";
    private static final String ENUM_NAME = "enumName";
    private static final String LENGTH = "length";
    private static final String DATA_TYPE = "dataType";
    private static final String SORT = "sort";
    private static final String SEQ = "seq";
    private static final String ALIGNMENT = "alignment";
    private static final String SHOW_ONTABLE = "showOntable";
    private static final String IS_SYSTEM_PROPERTY = "isSystemProperty";
    private static final String FREEZE = "freeze";
    private static final String IS_HIDE = "isHide";
    private static final String COLUMN_WITH = "columnWith";
    private static final String ENABLE = "enable";
    private static final String NOT_NULL = "notNull";
    private static final String ENTITY_ALIAS = "entityAlias";
    private static final String NUMBER = "number";
    private static final String ENTITY_NAME = "entityName";
    private static final String DISPLAY_NAME = "displayName";
    private static final String NAME = "name";

    public static DefaultKingdeeTreeNode createTreeNodeBySchemeId(String sid, EmpBatTreConInfo editData) throws Exception {
        long start = System.currentTimeMillis();
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)"Root");
        if (editData != null) {
            EmpBatTreConUtil.createTreeNodeByEmpBatTreCon(rootTreeNode, editData, null, false);
            return rootTreeNode;
        }
        StringBuffer sql = new StringBuffer();
        String locale = SysContext.getSysContext().getLocale().toString();
        sql.append("select page.FID ID, page.FName_").append(locale).append(" Name, page.FUIName UIName, ");
        sql.append("page.FIsSystemPage SystemPage, page.FIsBasePage BasePage, ");
        sql.append("page.FPageContent PageContent, page.FIndex FIndex, page.FType Type, ");
        sql.append("page.FIsDynMutiPage IsDynMutiPage, page.FDynMutiPageSortCode DynMutiPageSortCode, ");
        sql.append("scheme.FID schemeID, scheme.FNumber schemeNumber, scheme.FName_").append(locale).append(" schemeName, ");
        sql.append("pagegroup.FID groupID, pagegroup.FName_").append(locale).append(" groupName, pagegroup.FIndex groupIndex, ");
        sql.append("syspage.FEntityName sysEntityName, syspage.FType sysType, syspage.FUIName sysUIName ");
        sql.append("from T_HR_EmployeePage page ");
        sql.append("left join T_HR_EmployeePageGroup pagegroup on page.FGroupID = pagegroup.FID ");
        sql.append("left join T_HR_EmployeeEditPageScheme scheme on page.FSchemeID = scheme.FID ");
        sql.append("left join T_HR_EmployeeSystemPage syspage on page.FUIName = syspage.FUIName ");
        sql.append("where pagegroup.FID is not null and (page.FType = 0 or page.FType = 1) ");
        sql.append("and scheme.FID = '").append(sid).append("' order by pagegroup.FIndex, page.FIndex, page.FIsDynMutiPage,page.FDynMutiPageSortCode, page.FID");
        EmployeePageCollection employeePageCollection = new EmployeePageCollection();
        ISQLExecutor executor = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rowSet = executor.executeSQL();
        while (rowSet.next()) {
            boolean disableFlag;
            EmployeePageInfo pageInfo = new EmployeePageInfo();
            pageInfo.setId(BOSUuid.read((String)rowSet.getString("ID")));
            pageInfo.setName(rowSet.getString("Name"));
            pageInfo.setUiName(rowSet.getString("UIName"));
            if (!StringUtils.isEmpty((String)rowSet.getString("sysUIName"))) {
                pageInfo.setSystemPage(true);
            } else {
                pageInfo.setSystemPage(false);
            }
            pageInfo.setBasePage(rowSet.getBoolean("BasePage"));
            pageInfo.setPageContent(rowSet.getString("PageContent"));
            pageInfo.setIndexOf(rowSet.getInt("FIndex"));
            pageInfo.setType(rowSet.getBoolean("Type"));
            EmployeeEditPageSchemeInfo schemeInfo = new EmployeeEditPageSchemeInfo();
            schemeInfo.setId(BOSUuid.read((String)rowSet.getString("schemeID")));
            schemeInfo.setNumber(rowSet.getString("schemeNumber"));
            schemeInfo.setName(rowSet.getString("schemeName"));
            pageInfo.setScheme(schemeInfo);
            EmployeePageGroupInfo groupInfo = new EmployeePageGroupInfo();
            groupInfo.setId(BOSUuid.read((String)rowSet.getString("groupID")));
            groupInfo.setName(rowSet.getString("groupName"));
            groupInfo.setIndexOf(rowSet.getInt("groupIndex"));
            pageInfo.setGroup(groupInfo);
            if (pageInfo.isType() == rowSet.getBoolean("sysType")) {
                pageInfo.put("EntityName", rowSet.getString("sysEntityName"));
            }
            if (disableFlag = EmpFieldPermissionUtil.disableUISet.contains(pageInfo.getUiName())) continue;
            employeePageCollection.add(pageInfo);
        }
        if (employeePageCollection != null && employeePageCollection.size() > 0) {
            logger.info((Object)("in T_HR_EmployeePage table,find " + employeePageCollection.size() + " rows ."));
            int n = employeePageCollection.size();
            for (int i = 0; i < n; ++i) {
                long startTemp = System.currentTimeMillis();
                EmployeePageInfo employeePageInfo = employeePageCollection.get(i);
                DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)employeePageCollection.get(i));
                EmpBatTreConUtil.createLeafNode(subTreeNode, null, employeePageInfo);
                rootTreeNode.add((MutableTreeNode)subTreeNode);
                long endTmep = System.currentTimeMillis();
                logger.info((Object)("the NO." + (i + 1) + " page spent " + (endTmep - startTemp) + " ms "));
            }
        }
        long end = System.currentTimeMillis();
        logger.info((Object)("the build tree time is " + (end - start) + " ms"));
        return rootTreeNode;
    }

    private static String getOrgTypeFromEntity(BizUnitInfo bizUnitInfo) {
        if (bizUnitInfo != null && bizUnitInfo.getEntity() != null) {
            return bizUnitInfo.getEntity().getExtendedProperty("OrgType");
        }
        return null;
    }

    public static void createTreeNodeByEmpBatTreCon(DefaultKingdeeTreeNode rootTreeNode, EmpBatTreConInfo editData, Boolean bool, boolean bool2) throws BOSException, SQLException, JDOMException, IOException {
        long start = System.currentTimeMillis();
        if (editData != null) {
            HashSet<String> set = new HashSet<String>();
            if (editData.getEntry() != null && editData.getEntry().size() > 0) {
                int n = editData.getEntry().size();
                for (int i = 0; i < n; ++i) {
                    DefaultKingdeeTreeNode subTreeNode;
                    boolean disableFlag;
                    EmployeePageInfo empPage = editData.getEntry().get(i).getEmpPage();
                    if (empPage.getName() == null || empPage.getName().trim().equals("")) {
                        empPage.setName(editData.getEntry().get(i).getEmpPageName());
                    }
                    if (disableFlag = EmpFieldPermissionUtil.disableUISet.contains(empPage.getUiName())) continue;
                    if (empPage.getUiName() != null) {
                        String uiName = empPage.getUiName();
                        if (uiName != null && uiName.indexOf("$$") > 0) {
                            uiName = uiName.substring(0, empPage.getUiName().indexOf("$$"));
                        }
                        String entity = MetaDataHelper.getEntityByUIName(uiName);
                        set.add(entity);
                    }
                    if (bool == null) {
                        subTreeNode = new DefaultKingdeeTreeNode((Object)empPage);
                        EmpBatTreConUtil.createLeafNode(subTreeNode, editData.getEntry().get(i), empPage);
                        rootTreeNode.add((MutableTreeNode)subTreeNode);
                        continue;
                    }
                    if (bool.booleanValue() != editData.getEntry().get(i).getEmpPage().isType()) continue;
                    subTreeNode = new DefaultKingdeeTreeNode((Object)editData.getEntry().get(i).getEmpPage());
                    EmpBatTreConUtil.createLeafNode(subTreeNode, editData.getEntry().get(i), empPage);
                    rootTreeNode.add((MutableTreeNode)subTreeNode);
                }
            }
            if (bool2) {
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select id,name,uiName,systemPage,basePage,pageContent,indexOf,type,scheme.id,scheme.number,scheme.name,").append("group.id,group.name,group.indexOf ");
            sql.append(" where  group.id is not null and (type=0 or type=1 ) and scheme.id='").append(editData.getEmpScheme().getId()).append("'  ");
            if (editData.getEntry() != null && editData.getEntry().size() > 0) {
                int n = editData.getEntry().size();
                for (int i = 0; i < n; ++i) {
                    sql.append(" and id!='").append(editData.getEntry().get(i).getEmpPage().getId()).append("' ");
                }
            }
            sql.append(" order by group.indexOf,indexOf,id ");
            EmployeePageCollection employeePageCollection = EmployeePageFactory.getRemoteInstance().getEmployeePageCollection(sql.toString());
            if (employeePageCollection != null && employeePageCollection.size() > 0) {
                logger.info((Object)("in T_HR_EmployeePage table,find " + employeePageCollection.size() + " rows ."));
                int n = employeePageCollection.size();
                for (int i = 0; i < n; ++i) {
                    boolean disableFlag;
                    long startTemp = System.currentTimeMillis();
                    EmployeePageInfo employeePageInfo = employeePageCollection.get(i);
                    if (employeePageInfo.getUiName() != null) {
                        String entity;
                        String uiName = employeePageInfo.getUiName();
                        if (uiName != null && uiName.indexOf("$$") > 0) {
                            uiName = uiName.substring(0, employeePageInfo.getUiName().indexOf("$$"));
                        }
                        if (set.contains(entity = MetaDataHelper.getEntityByUIName(uiName))) {
                            logger.info((Object)("the NO" + (i + 1) + " page is Repeat.(page.id is:" + employeePageInfo.getId() + " page.UiName is:" + employeePageInfo.getUiName() + " page.name is:" + employeePageInfo.getName()));
                            continue;
                        }
                        set.add(entity);
                    }
                    if (!(disableFlag = EmpFieldPermissionUtil.disableUISet.contains(employeePageInfo.getUiName()))) {
                        DefaultKingdeeTreeNode subTreeNode = new DefaultKingdeeTreeNode((Object)employeePageCollection.get(i));
                        rootTreeNode.add((MutableTreeNode)subTreeNode);
                    }
                    long endTmep = System.currentTimeMillis();
                    logger.info((Object)("the NO." + (i + 1) + " page spent " + (endTmep - startTemp) + " ms "));
                }
            }
            long end = System.currentTimeMillis();
            logger.info((Object)("the build tree time is " + (end - start) + " ms"));
        }
    }

    public static void createLeafNode(DefaultKingdeeTreeNode subTreeNode, EmpBatTreConEntryInfo entryInfo, EmployeePageInfo employeePageInfo) throws BOSException, SQLException, JDOMException, IOException {
        logger.info((Object)("-------------begin create " + employeePageInfo.getName() + " page (page'id is " + employeePageInfo.getId() + ")  TreeNode ------------------"));
        if (entryInfo != null) {
            logger.info((Object)(employeePageInfo.getName() + " is saved page"));
            String xmlStr = entryInfo.getPageContent();
            EmpBatTreConUtil.buildNodeByXMLStr(employeePageInfo, subTreeNode, xmlStr);
            return;
        }
        if (employeePageInfo.isSystemPage()) {
            UIObjectInfo editModel;
            String editUIPK;
            BizUnitInfo bizUnit;
            logger.info((Object)(employeePageInfo.getName() + "is System page"));
            String entityName = employeePageInfo.getString("EntityName");
            if ((entityName == null || "".equals(entityName)) && ((entityName = MetaDataHelper.getEntityByUIName(employeePageInfo.getUiName())) == null || "".equals(entityName))) {
                logger.info((Object)(employeePageInfo.getName() + "'UIName is " + employeePageInfo.getUiName() + " and entityName is not in T_HR_EmployeeSystemPage and not in MetaDataHelper "));
                return;
            }
            HashSet set = new HashSet();
            String entityName2 = null;
            UIObjectInfo uIObjectInfo = BizConfigureHelper.loadUIObject((MetaDataPK)MetaDataPK.create((String)employeePageInfo.getUiName()));
            if (uIObjectInfo != null) {
                entityName2 = uIObjectInfo.getBizUnitPK() != null && !uIObjectInfo.getBizUnitPK().trim().equals("") ? uIObjectInfo.getBizUnitPK() : entityName.replaceFirst(".app.", ".");
                entityName2 = EmpBatTreConUtil.dowithErrorPath(entityName2);
                bizUnit = BizConfigureHelper.loadBizUnit((IMetaDataPK)MetaDataPK.create((String)entityName2));
                editUIPK = null;
                if (bizUnit != null) {
                    editUIPK = bizUnit.getString("editUIPK");
                }
                editModel = null;
                editModel = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)editUIPK));
                if (editModel != null) {
                    EmpBatTreConUtil.getItemByUiobjectInfo(editModel, set);
                }
            } else {
                if (employeePageInfo.getUiName() != null && employeePageInfo.getUiName().indexOf("$$") > 0) {
                    employeePageInfo.setUiName(employeePageInfo.getUiName().substring(0, employeePageInfo.getUiName().indexOf("$$")));
                }
                uIObjectInfo = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create((String)employeePageInfo.getUiName()));
                bizUnit = UictUtils.loadBizUnit((IMetaDataPK)MetaDataPK.create((String)uIObjectInfo.getBizUnitPK()));
                editUIPK = null;
                if (bizUnit != null) {
                    editUIPK = bizUnit.getString("editUIPK");
                }
                if ((editModel = UictUtils.loadUI((IMetaDataPK)MetaDataPK.create(editUIPK))) != null) {
                    EmpBatTreConUtil.getItemByUiobjectInfo(editModel, set);
                }
            }
            logger.info((Object)(" after filter  BizConfigureListUI have " + set.size() + " properties contains " + set));
            if (set.size() < 1) {
                return;
            }
            EntityObjectInfo entityInfo = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            entityInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            PropertyCollection pColl = entityInfo.getInheritedNoDuplicatedProperties();
            logger.info((Object)(employeePageInfo.getName() + " page have " + pColl.size() + " properties"));
            HashSet<String> reSet = new HashSet<String>();
            int n = pColl.size();
            for (int i = 0; i < n; ++i) {
                PropertyInfo propertyInfo = pColl.get(i);
                if (!set.contains(propertyInfo.getName())) {
                    reSet.add(propertyInfo.getName());
                    continue;
                }
                if (EmpBatTreConUtil.isOldDataAndNeedToClear(entityName, propertyInfo.getName())) continue;
                if (EmpBatTreConUtil.checkIsDefaultProperty(entityName, propertyInfo.getName())) {
                    logger.info((Object)(propertyInfo.getName() + " property is default property"));
                    continue;
                }
                EmpEntityPropertyInfo epInfo = new EmpEntityPropertyInfo();
                epInfo.setNotNull(false);
                epInfo.setEnable(true);
                String propertyName = propertyInfo.getName();
                epInfo.setPropertyName(propertyName);
                epInfo.setPropertyAlias(propertyInfo.getAlias());
                epInfo.setEntityName(entityName);
                DefaultKingdeeTreeNode leafNode = new DefaultKingdeeTreeNode((Object)epInfo);
                subTreeNode.add((MutableTreeNode)leafNode);
            }
            logger.info((Object)(employeePageInfo.getName() + " page add " + subTreeNode.getChildCount() + " properties"));
            if (reSet.size() > 0) {
                logger.info((Object)("the properties is not in BizConfigureListUI contains " + reSet));
            }
        } else {
            logger.info((Object)(employeePageInfo.getName() + " is Dynamic page"));
            String xmlStr = employeePageInfo.getPageContent();
            if (xmlStr == null || xmlStr.trim().equals("")) {
                return;
            }
            EmpBatTreConUtil.buildNodeByXMLStr(employeePageInfo, subTreeNode, xmlStr);
        }
    }

    private static void getItemByUiobjectInfo(UIObjectInfo editModel, Set set) {
        ComponentInfo info = null;
        int j = editModel.getComponents().size();
        for (int i = 0; i < j; ++i) {
            info = editModel.getComponents().get(i);
            if (info.getComponents().size() > 0) {
                EmpBatTreConUtil.getChildItemByUiobjectInfo(info, set);
                continue;
            }
            if (info.getPropertyBindings().size() <= 0) continue;
            set.add(info.getPropertyBindings().get(0).getBingdingField());
        }
    }

    private static void getChildItemByUiobjectInfo(ComponentInfo editModel, Set set) {
        ComponentInfo info = null;
        int j = editModel.getComponents().size();
        for (int i = 0; i < j; ++i) {
            info = editModel.getComponents().get(i);
            if (info.getComponents().size() > 0) {
                EmpBatTreConUtil.getChildItemByUiobjectInfo(info, set);
                continue;
            }
            if (info.getPropertyBindings().size() <= 0) continue;
            set.add(info.getPropertyBindings().get(0).getBingdingField());
        }
    }

    public static void buildNodeByXMLStr(EmployeePageInfo employeePageInfo, DefaultKingdeeTreeNode subTreeNode, String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        Element fieldList = root.getChild("fieldList");
        if (fieldList != null && fieldList.getChildren().size() > 0) {
            logger.info((Object)(employeePageInfo.getName() + " page have " + fieldList.getChildren().size() + " properties "));
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                Element field = (Element)fieldList.getChildren().get(i);
                EmpEntityPropertyInfo info = EmpBatTreConUtil.getEmpEntityPropertyInfobyElement(field, true);
                if (info == null) {
                    logger.info((Object)(" the NO." + (i + 1) + " peoperty is null so not add the peoperty"));
                    continue;
                }
                if (info.getEntityName() == null || "".equals(info.getEntityName().trim())) {
                    String uiName;
                    if (employeePageInfo.getUiName() == null || employeePageInfo.getUiName().trim().equals("")) {
                        try {
                            EmployeePageInfo employeePageInfo2 = EmployeePageFactory.getRemoteInstance().getEmployeePageInfo("select id,uiName where id='" + employeePageInfo.getId() + "'");
                            employeePageInfo.setUiName(employeePageInfo2.getUiName());
                        }
                        catch (Exception e) {
                            logger.error((Object)e.getMessage());
                            continue;
                        }
                    }
                    if ((uiName = employeePageInfo.getUiName()) == null || uiName.trim().equals("")) {
                        MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label44"), employeePageInfo.getName()));
                        break;
                    }
                    String entityName = MetaDataHelper.getEntityByUIName(uiName);
                    info.setEntityName(entityName);
                }
                if (info.getEntityName() == null || "".equals(info.getEntityName().trim())) {
                    MsgBox.showInfo((String)MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label45"), employeePageInfo.getName()));
                    break;
                }
                if (!EmpBatTreConUtil.checkPropertyInEntity(info)) {
                    logger.info((Object)(" the NO." + (i + 1) + "  peoperty is not in entity(info.property is " + info.getPropertyName() + " and info.entityName is " + info.getEntityName() + ")"));
                    continue;
                }
                DefaultKingdeeTreeNode leafNode = new DefaultKingdeeTreeNode((Object)info);
                subTreeNode.add((MutableTreeNode)leafNode);
            }
            logger.info((Object)(employeePageInfo.getName() + " page add " + subTreeNode.getChildCount() + " properties "));
        }
    }

    private static boolean checkPropertyInEntity(EmpEntityPropertyInfo info) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)info.getEntityName()));
        String propertyName = info.getPropertyName();
        if (propertyName.indexOf(".") > 0) {
            propertyName = propertyName.split("\\.")[0];
        }
        return entityInfo.getEntityProperties().containsKey((Object)propertyName);
    }

    public static Map buildMapByXMLStr(String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        Element fieldList = root.getChild("fieldList");
        HashMap<String, EmpEntityPropertyInfo> map = new HashMap<String, EmpEntityPropertyInfo>();
        if (fieldList != null && fieldList.getChildren().size() > 0) {
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                Element field = (Element)fieldList.getChildren().get(i);
                EmpEntityPropertyInfo info = EmpBatTreConUtil.getEmpEntityPropertyInfobyElement(field, true);
                if (info == null) continue;
                map.put(info.getPropertyName() + ":" + (info.getEntityName() == null ? "" : info.getEntityName()), info);
            }
        }
        return map;
    }

    public static List buildListByXMLStr(String pageid, String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        Element fieldList = root.getChild("fieldList");
        ArrayList<EmpEntityPropertyInfo> list = new ArrayList<EmpEntityPropertyInfo>();
        if (fieldList != null && fieldList.getChildren().size() > 0) {
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                Element field = (Element)fieldList.getChildren().get(i);
                EmpEntityPropertyInfo info = EmpBatTreConUtil.getEmpEntityPropertyInfobyElement(field, false);
                if (info == null) continue;
                list.add(info);
            }
        }
        return list;
    }

    public static List buildListByXMLStr(String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        Element fieldList = root.getChild("fieldList");
        ArrayList<EmpEntityPropertyInfo> list = new ArrayList<EmpEntityPropertyInfo>();
        if (fieldList != null && fieldList.getChildren().size() > 0) {
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                Element field = (Element)fieldList.getChildren().get(i);
                EmpEntityPropertyInfo info = EmpBatTreConUtil.getEmpEntityPropertyInfobyElement(field, false);
                if (info == null) continue;
                list.add(info);
            }
        }
        return list;
    }

    public static void buildNodeByXMLStr(DefaultKingdeeTreeNode subTreeNode, String xmlStr) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(xmlStr));
        Element root = doc.getRootElement();
        Element fieldList = root.getChild("fieldList");
        if (fieldList != null && fieldList.getChildren().size() > 0) {
            int size = fieldList.getChildren().size();
            for (int i = 0; i < size; ++i) {
                Element field = (Element)fieldList.getChildren().get(i);
                EmpEntityPropertyInfo info = EmpBatTreConUtil.getEmpEntityPropertyInfobyElement(field, true);
                if (info == null) continue;
                DefaultKingdeeTreeNode leafNode = new DefaultKingdeeTreeNode((Object)info);
                subTreeNode.add((MutableTreeNode)leafNode);
            }
        }
    }

    public static boolean checkIsDefaultProperty(String entityName, String propertyName) {
        if (entityName == null || entityName.trim().equals("")) {
            return false;
        }
        return entityName.equals("com.kingdee.eas.basedata.person.app.Person") && (NUMBER.equals(propertyName) || NAME.equals(propertyName));
    }

    public static List createEmpEntityPropertyInfobyUIName(String uiName, boolean type, boolean bool) throws BOSException, SQLException {
        ArrayList<EmpEntityPropertyInfo> list = new ArrayList<EmpEntityPropertyInfo>();
        StringBuffer sql = new StringBuffer("SELECT FName_");
        sql.append(SysContext.getSysContext().getLocale());
        sql.append(",FEntityName FROM T_HR_EmployeeSystemPage WHERE FType = " + (type ? 1 : 0) + " and FUINAME='" + uiName + "'");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        if (rows.next()) {
            String entityName = rows.getString("FEntityName");
            if ((entityName == null || "".equals(entityName)) && ((entityName = MetaDataHelper.getEntityByUIName(uiName)) == null || "".equals(entityName))) {
                throw new RuntimeException((Throwable)((Object)new HrEmpBizException(HrEmpBizException.EXCEPTION14, new Object[]{uiName})));
            }
            EntityObjectInfo entityInfo = null;
            IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
            entityInfo = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)entityName));
            PropertyCollection pColl = entityInfo.getInheritedNoDuplicatedProperties();
            int n = pColl.size();
            for (int i = 0; i < n; ++i) {
                PropertyInfo propertyInfo = pColl.get(i);
                if (EmpBatTreConUtil.checkIsDefaultProperty(entityName, propertyInfo.getName())) continue;
                EmpEntityPropertyInfo epInfo = new EmpEntityPropertyInfo();
                epInfo.setNotNull(false);
                epInfo.setEnable(true);
                epInfo.setPropertyName(propertyInfo.getName());
                epInfo.setPropertyAlias(propertyInfo.getAlias());
                epInfo.setEntityName(entityName);
                list.add(epInfo);
            }
        }
        return list;
    }

    public static EmpEntityPropertyInfo getEmpEntityPropertyInfobyElement(Element field, boolean bool) {
        EmpEntityPropertyInfo info = new EmpEntityPropertyInfo();
        String propertyName = field.getChild(NAME).getText();
        if (propertyName.equals("jobLevel") || propertyName.equals("pastJobLevel")) {
            return null;
        }
        String propertyAlias = field.getChild(DISPLAY_NAME).getText();
        if (propertyAlias != null) {
            propertyAlias = propertyAlias.replaceAll(EASResource.getString((String)"com.kingdee.eas.hr.emp.EmpBatchResource.position"), EASResource.getString((String)"com.kingdee.eas.hr.emp.EmpBatchResource.1_lbl"));
            info.setPropertyAlias(propertyAlias);
        } else {
            info.setPropertyAlias(field.getChild(DISPLAY_NAME).getText());
        }
        info.setPropertyName(field.getChild(NAME).getText());
        if (field.getChild(ENTITY_NAME) != null) {
            info.setEntityName(field.getChild(ENTITY_NAME).getText());
        }
        if (bool) {
            if ("com.kingdee.eas.hr.standby.app.StandbyPerson".equals(info.getEntityName()) || "com.kingdee.eas.hr.kt.app.CadreWorkExpCur".equals(info.getEntityName()) || "com.kingdee.eas.hr.tobacco.app.PersonClass".equals(info.getEntityName())) {
                logger.info((Object)"info's entityName is in(com.kingdee.eas.hr.standby.app.StandbyPerson,com.kingdee.eas.hr.kt.app.CadreWorkExpCur) so return info null;");
                return null;
            }
            if ("com.kingdee.eas.basedata.person.app.Person".equals(info.getEntityName()) && (NUMBER.equals(info.getPropertyName()) || NAME.equals(info.getPropertyName()))) {
                logger.info((Object)("info's entityName=com.kingdee.eas.basedata.person.app.Person and property(" + info.getPropertyName() + ") is default property so return info null;"));
                return null;
            }
        }
        if (field.getChild(ENTITY_ALIAS) != null) {
            info.setEntityAlias(field.getChild(ENTITY_ALIAS).getText());
        }
        info.setNotNull(false);
        info.setEnable(true);
        if (field.getChild(NOT_NULL) != null) {
            info.setNotNull(Boolean.valueOf(field.getChild(NOT_NULL).getText()));
        }
        if (field.getChild(ENABLE) != null) {
            info.setEnable(Boolean.valueOf(field.getChild(ENABLE).getText()));
        } else {
            info.setEnable(true);
        }
        if (field.getChild(COLUMN_WITH) != null) {
            info.setColumnWith(field.getChild(COLUMN_WITH) == null ? -1 : Integer.parseInt(field.getChild(COLUMN_WITH).getText().toString().trim()));
        } else {
            info.setColumnWith(-1);
        }
        if (field.getChild(IS_HIDE) != null) {
            info.setHide(field.getChild(IS_HIDE) == null ? false : Boolean.valueOf(field.getChild(IS_HIDE).getText()));
        } else {
            info.setHide(false);
        }
        if (field.getChild(FREEZE) != null) {
            info.setFreeze(field.getChild(FREEZE) == null ? false : Boolean.valueOf(field.getChild(FREEZE).getText()));
        } else {
            info.setFreeze(false);
        }
        if (field.getChild(IS_SYSTEM_PROPERTY) != null) {
            info.setSystemProperty(Boolean.valueOf(field.getChild(IS_SYSTEM_PROPERTY).getText()));
        } else {
            info.setSystemProperty(false);
        }
        if (field.getChild(SHOW_ONTABLE) != null) {
            info.setShowOntable(Boolean.valueOf(field.getChild(SHOW_ONTABLE).getText()));
        }
        if (field.getChild(ALIGNMENT) != null) {
            info.setAlignment(Integer.parseInt(field.getChild(ALIGNMENT).getText()));
        } else {
            info.setAlignment(-1);
        }
        if (field.getChild(SEQ) != null) {
            info.setSeq(Integer.parseInt(field.getChild(SEQ).getText().toString().trim()));
        }
        if (field.getChild(SORT) != null) {
            info.setSort(field.getChild(SORT) == null ? false : Boolean.valueOf(field.getChild(SORT).getText()));
        }
        if (field.getChild(DATA_TYPE) != null) {
            Element dataType = field.getChild(DATA_TYPE);
            if (dataType.getChild(NAME) != null) {
                info.setDateType(dataType.getChild(NAME).getText());
            }
            if (dataType.getChild(LENGTH) != null) {
                info.setPropertyLength(Integer.parseInt(dataType.getChild(LENGTH).getText()));
            }
            if (dataType.getChild(ENUM_NAME) != null) {
                info.setEnumName(dataType.getChild(ENUM_NAME).getText());
            }
            if (dataType.getChild(SELECTOR) != null) {
                info.setSelector(dataType.getChild(SELECTOR).getText());
                info.setType(1);
            } else {
                info.setType(0);
            }
            if (dataType.getChild(QUERY_INFO) != null) {
                info.setQueryInfo(dataType.getChild(QUERY_INFO).getText());
            }
            if (dataType.getChild(REF_ENTITY) != null) {
                info.setRefEntityName(dataType.getChild(REF_ENTITY).getText());
            }
        }
        return info;
    }

    public static DefaultKingdeeTreeNode createImportTree(DefaultKingdeeTreeNode existNode) throws BOSException, SQLException, JDOMException, IOException {
        EmployeePageInfo employeePageInfo = (EmployeePageInfo)existNode.getUserObject();
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)employeePageInfo);
        EmpBatTreConUtil.createLeafNode(rootTreeNode, null, employeePageInfo);
        if (existNode != null) {
            int n = existNode.getChildCount();
            block0: for (int i = 0; i < n; ++i) {
                EmpEntityPropertyInfo eInfo = (EmpEntityPropertyInfo)((DefaultKingdeeTreeNode)existNode.getChildAt(i)).getUserObject();
                String name = eInfo.getPropertyName();
                int m = rootTreeNode.getChildCount();
                for (int j = 0; j < m; ++j) {
                    DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)rootTreeNode.getChildAt(j);
                    EmpEntityPropertyInfo info = (EmpEntityPropertyInfo)((DefaultKingdeeTreeNode)rootTreeNode.getChildAt(j)).getUserObject();
                    if (!info.getPropertyName().equals(name)) continue;
                    rootTreeNode.remove((MutableTreeNode)childNode);
                    continue block0;
                }
            }
        }
        return rootTreeNode;
    }

    public static void traceNode(DefaultKingdeeTreeNode root, List list) throws Exception {
        if (root.getUserObject() instanceof EmpEntityPropertyInfo && root.isChecked()) {
            list.add(root);
            return;
        }
        for (int i = 0; i < root.getChildCount(); ++i) {
            if (!(root.getChildAt(i) instanceof DefaultKingdeeTreeNode)) continue;
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            EmpBatTreConUtil.traceNode(node, list);
        }
    }

    public static List getSelectNode(DefaultKingdeeTreeNode root) throws Exception {
        ArrayList list = new ArrayList();
        EmpBatTreConUtil.traceNode(root, list);
        return list;
    }

    public static String convertListToXML(EmployeePageInfo info, List propertyList) throws BOSException, EASBizException {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        root.addContent((Content)fieldList);
        String sql = "SELECT FEntityName,FEntityInfoName,FType,FQueryInfo,FSelector FROM T_HR_F7Info";
        IRowSet rows = SQLExecutorFactory.getRemoteInstance((String)sql).executeSQL();
        EmpEntityPropertyInfo epInfo = null;
        EntityObjectInfo entityInfo = null;
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        HashMap entityMap = new HashMap();
        int size = propertyList.size();
        for (int i = 0; i < size; ++i) {
            Element field;
            block11: {
                PropertyInfo propertyInfo;
                Element dataType;
                block9: {
                    block10: {
                        epInfo = (EmpEntityPropertyInfo)propertyList.get(i);
                        field = new Element("field");
                        field.addContent((Content)new Element(NAME).setText(epInfo.getPropertyName()));
                        field.addContent((Content)new Element(DISPLAY_NAME).setText(epInfo.getPropertyAlias().trim()));
                        field.addContent((Content)new Element(ENTITY_NAME).setText(epInfo.getEntityName()));
                        field.addContent((Content)new Element("entityDisplayName").setText(epInfo.getEntityAlias()));
                        field.addContent((Content)new Element(NOT_NULL).setText(Boolean.toString(epInfo.isNotNull())));
                        field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(epInfo.isEnable())));
                        field.addContent((Content)new Element(SHOW_ONTABLE).setText(Boolean.toString(epInfo.isShowOntable())));
                        field.addContent((Content)new Element(SEQ).setText(String.valueOf(epInfo.getSeq())));
                        field.addContent((Content)new Element(FREEZE).setText(Boolean.toString(epInfo.isFreeze())));
                        field.addContent((Content)new Element(COLUMN_WITH).setText(String.valueOf(epInfo.getColumnWith() < 0 ? 100 : epInfo.getColumnWith())));
                        field.addContent((Content)new Element(ALIGNMENT).setText(String.valueOf(epInfo.getAlignment() < 0 ? 10 : epInfo.getAlignment())));
                        field.addContent((Content)new Element(SORT).setText(Boolean.toString(epInfo.isSort())));
                        field.addContent((Content)new Element(IS_HIDE).setText(Boolean.toString(epInfo.isHide())));
                        if (epInfo.isSystemProperty()) {
                            field.addContent((Content)new Element("systemProperty").setText(Boolean.toString(epInfo.isSystemProperty())));
                        }
                        dataType = new Element(DATA_TYPE);
                        field.addContent((Content)dataType);
                        entityInfo = entityMap.get(epInfo.getEntityName()) == null ? loader.getEntity((IMetaDataPK)MetaDataPK.create((String)epInfo.getEntityName())) : (EntityObjectInfo)entityMap.get(epInfo.getEntityName());
                        String propertyName = epInfo.getPropertyName();
                        if (epInfo.getPropertyName().indexOf(".") >= 0) {
                            String[] propertys = epInfo.getPropertyName().split("\\.");
                            propertyName = propertys[0];
                        }
                        if (!((propertyInfo = entityInfo.getPropertyByName(propertyName)) instanceof OwnPropertyInfo)) break block9;
                        dataType.addContent((Content)new Element(NAME).setText(((OwnPropertyInfo)propertyInfo).getDataType().getName()));
                        if (!((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.STRING)) break block10;
                        int stringLength = ((OwnPropertyInfo)propertyInfo).getMappingField().getLength();
                        dataType.addContent((Content)new Element(LENGTH).setText(Integer.toString(stringLength)));
                        break block11;
                    }
                    if (!((OwnPropertyInfo)propertyInfo).getDataType().equals((Object)DataType.ENUM)) break block11;
                    dataType.addContent((Content)new Element(ENUM_NAME).setText(((OwnPropertyInfo)propertyInfo).getEnumType().getFullName()));
                    break block11;
                }
                if (propertyInfo instanceof LinkPropertyInfo) {
                    boolean isConfiged = EmpBatTreConUtil.addF7Info(dataType, rows, ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject().getFullName());
                    if (!isConfiged) {
                        EntityObjectInfo supplierEntity = ((LinkPropertyInfo)propertyInfo).getRelationship().getSupplierObject();
                        supplierEntity = loader.getEntity((IMetaDataPK)MetaDataPK.create((String)supplierEntity.getFullName()));
                        dataType.addContent((Content)new Element(NAME).setText("CommonF7"));
                        String defaultF7 = supplierEntity.getExtendedProperty("defaultF7Query");
                        if (StringUtils.isEmpty((String)defaultF7)) {
                            EmpBatchF7Helper f7Helter = new EmpBatchF7Helper();
                            if (f7Helter.getF7QuerybyEntity(supplierEntity.getFullName()) == null) {
                                logger.info((Object)supplierEntity.getFullName());
                                throw new HrEmpBizException(HrEmpBizException.EXCEPTION4, new Object[]{info.getName(), epInfo.getPropertyAlias(), supplierEntity.getFullName()});
                            }
                            defaultF7 = f7Helter.getF7QuerybyEntity(supplierEntity.getFullName());
                        }
                        dataType.addContent((Content)new Element(QUERY_INFO).setText(defaultF7));
                        dataType.addContent((Content)new Element(REF_ENTITY).setText(supplierEntity.getFullName()));
                    }
                } else {
                    logger.info((Object)"ERROR !!");
                    continue;
                }
            }
            fieldList.addContent((Content)field);
        }
        if (info.get("DISPLAYTYPE") != null) {
            Element displayTypeElement = new Element("displayType");
            displayTypeElement.setText(((Boolean)info.get("DISPLAYTYPE")).toString());
            root.addContent((Content)displayTypeElement);
        }
        return null;
    }

    private static boolean addF7Info(Element dataType, IRowSet rows, String entityName) throws BOSException {
        try {
            rows.beforeFirst();
            boolean isConfiged = false;
            while (rows.next()) {
                if (!rows.getString("FEntityName").equals(entityName)) continue;
                if (rows.getInt("FType") == 0) {
                    return isConfiged;
                }
                isConfiged = true;
                dataType.addContent((Content)new Element(NAME).setText("CustomF7"));
                dataType.addContent((Content)new Element(SELECTOR).setText(rows.getString("FSelector")));
                dataType.addContent((Content)new Element(QUERY_INFO).setText(rows.getString("FQueryInfo")));
                dataType.addContent((Content)new Element(REF_ENTITY).setText(rows.getString("FEntityInfoName")));
                break;
            }
            return isConfiged;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String convertListToXML2(EmployeePageInfo info, List propertyList) throws BOSException, EASBizException {
        if (info.isType()) {
            return EmpBatTreConUtil.convertListToXML(info, propertyList);
        }
        return EmpBatTreConUtil.convertListToXML(info, propertyList);
    }

    public static String convertListToXML3(List propertyList) {
        Document doc = new Document();
        Element root = new Element("ui");
        doc.setRootElement(root);
        Element fieldList = new Element("fieldList");
        root.addContent((Content)fieldList);
        EmpEntityPropertyInfo epInfo = null;
        if (propertyList != null && propertyList.size() > 0) {
            int size = propertyList.size();
            for (int i = 0; i < size; ++i) {
                epInfo = (EmpEntityPropertyInfo)propertyList.get(i);
                Element field = new Element("field");
                field.addContent((Content)new Element(NAME).setText(epInfo.getPropertyName()));
                field.addContent((Content)new Element(DISPLAY_NAME).setText(epInfo.getPropertyAlias()));
                field.addContent((Content)new Element(ENTITY_NAME).setText(epInfo.getEntityName()));
                field.addContent((Content)new Element("entityDisplayName").setText(epInfo.getEntityAlias()));
                field.addContent((Content)new Element(NOT_NULL).setText(Boolean.toString(epInfo.isNotNull())));
                field.addContent((Content)new Element(ENABLE).setText(Boolean.toString(epInfo.isEnable())));
                field.addContent((Content)new Element(SHOW_ONTABLE).setText(Boolean.toString(epInfo.isShowOntable())));
                field.addContent((Content)new Element(SEQ).setText(String.valueOf(epInfo.getSeq())));
                field.addContent((Content)new Element(FREEZE).setText(Boolean.toString(epInfo.isFreeze())));
                field.addContent((Content)new Element(COLUMN_WITH).setText(String.valueOf(epInfo.getColumnWith() < 0 ? 100 : epInfo.getColumnWith())));
                field.addContent((Content)new Element(ALIGNMENT).setText(String.valueOf(epInfo.getAlignment() < 0 ? 10 : epInfo.getAlignment())));
                field.addContent((Content)new Element(SORT).setText(Boolean.toString(epInfo.isSort())));
                field.addContent((Content)new Element(IS_HIDE).setText(Boolean.toString(epInfo.isHide())));
                fieldList.addContent((Content)field);
            }
        }
        return null;
    }

    public static void checkTableEmpty(String title, KDTable table, String[] colNames) throws EASBizException {
        int n = colNames.length;
        for (int i = 0; i < n; ++i) {
            EmpBatTreConUtil.checkTableEmpty(title, table, colNames[i]);
        }
    }

    public static void checkTableEmpty(String title, KDTable table, String colName) throws EASBizException {
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object temp = table.getRow(i).getCell(colName).getValue();
            if (temp != null && temp.toString() != null && !temp.toString().trim().equals("")) continue;
            throw new HrEmpBizException(HrEmpBizException.EXCEPTION5, new Object[]{title == null ? "" : title, i + 1, table.getHeadRow(0).getCell(colName).getValue()});
        }
    }

    public static void setTableColumnEnum(KDTable kdtable, String columnName, String emumString) {
        KDComboBox kdtable_emum_ComboBox = new KDComboBox();
        kdtable_emum_ComboBox.setName(kdtable.getName() + "_emum_ComboBox");
        kdtable_emum_ComboBox.setVisible(true);
        kdtable_emum_ComboBox.addItems(EnumUtils.getEnumList((String)emumString).toArray());
        KDTDefaultCellEditor kdtable_emum_CellEditor = new KDTDefaultCellEditor((JComboBox)kdtable_emum_ComboBox);
        kdtable.getColumn(columnName).setEditor((ICellEditor)kdtable_emum_CellEditor);
    }

    public static void checkTableRepeat(String title, KDTable table, String colName) throws EASBizException {
        int n = table.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object temp = table.getRow(i).getCell(colName).getValue();
            for (int j = i + 1; j < n; ++j) {
                if (!temp.equals(table.getRow(j).getCell(colName).getValue())) continue;
                throw new HrEmpBizException(HrEmpBizException.EXCEPTION6, new Object[]{title == null ? "" : title, i + 1, j + 1, table.getHeadRow(0).getCell(colName).getValue()});
            }
        }
    }

    public static List buildDefaultPropertyInfos() {
        String personName = EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label86");
        String personEntity = "com.kingdee.eas.basedata.person.app.Person";
        String personPositionName = EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label87");
        String personPositionEntity = "com.kingdee.eas.hr.emp.app.PersonPosition";
        ArrayList<EmpEntityPropertyInfo> infos = new ArrayList<EmpEntityPropertyInfo>(5);
        EmpEntityPropertyInfo info = new EmpEntityPropertyInfo();
        info.setDateType(DataType.STRING.getName());
        info.setEnable(true);
        info.setEntityAlias(personName);
        info.setEntityName(personEntity);
        info.setEnumName(null);
        info.setHide(false);
        info.setNotNull(true);
        info.setPropertyAlias(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label78"));
        info.setPropertyLength(80);
        info.setPropertyName(NUMBER);
        info.setQueryInfo(null);
        info.setRefEntityName(null);
        info.setSelector(null);
        info.setSort(true);
        info.setSystemProperty(true);
        info.setShowOntable(true);
        info.setType(1);
        info.setColumnWith(100);
        info.setAlignment(10);
        infos.add(info);
        info = new EmpEntityPropertyInfo();
        info.setDateType(DataType.STRING.getName());
        info.setEnable(true);
        info.setEntityAlias(personName);
        info.setEntityName(personEntity);
        info.setEnumName(null);
        info.setHide(false);
        info.setNotNull(true);
        info.setPropertyAlias(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label80"));
        info.setPropertyLength(80);
        info.setPropertyName(NAME);
        info.setQueryInfo(null);
        info.setRefEntityName(null);
        info.setSelector(null);
        info.setSort(true);
        info.setSystemProperty(true);
        info.setShowOntable(true);
        info.setType(1);
        info.setColumnWith(100);
        info.setAlignment(10);
        infos.add(info);
        info = new EmpEntityPropertyInfo();
        info.setDateType("CommonF7");
        info.setEnable(true);
        info.setEntityAlias(personPositionName);
        info.setEntityName(personPositionEntity);
        info.setEnumName(null);
        info.setHide(false);
        info.setNotNull(true);
        info.setPropertyAlias(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label75"));
        info.setPropertyLength(80);
        info.setPropertyName("primaryPosition");
        info.setQueryInfo("com.kingdee.eas.basedata.org.app.PositionF7Query");
        info.setRefEntityName("com.kingdee.eas.basedata.org.app.Position");
        info.setSelector(null);
        info.setSort(true);
        info.setSystemProperty(true);
        info.setShowOntable(true);
        info.setType(1);
        info.setColumnWith(100);
        info.setAlignment(10);
        infos.add(info);
        info = new EmpEntityPropertyInfo();
        info.setDateType("CommonF7");
        info.setEnable(true);
        info.setEntityAlias(personPositionName);
        info.setEntityName(personPositionEntity);
        info.setEnumName(null);
        info.setHide(true);
        info.setNotNull(true);
        info.setPropertyAlias(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label74"));
        info.setPropertyLength(80);
        info.setPropertyName("personDep");
        info.setQueryInfo(null);
        info.setRefEntityName(null);
        info.setSelector(null);
        info.setSort(true);
        info.setSystemProperty(true);
        info.setShowOntable(true);
        info.setType(1);
        info.setColumnWith(100);
        info.setAlignment(10);
        infos.add(info);
        info = new EmpEntityPropertyInfo();
        info.setDateType(DataType.STRING.getName());
        info.setEnable(true);
        info.setEntityAlias(personPositionName);
        info.setEntityName(personPositionEntity);
        info.setEnumName(null);
        info.setHide(true);
        info.setNotNull(true);
        info.setPropertyAlias(EASResource.getString((String)"com.kingdee.eas.hr.emp.HrEmpBizResource", (String)"label82"));
        info.setPropertyLength(80);
        info.setPropertyName("personDep.displayName");
        info.setQueryInfo(null);
        info.setRefEntityName(null);
        info.setSelector(null);
        info.setSort(true);
        info.setSystemProperty(true);
        info.setShowOntable(true);
        info.setType(1);
        info.setColumnWith(100);
        info.setAlignment(10);
        infos.add(info);
        return infos;
    }

    private static String dowithErrorPath(String entityName) {
        String name = entityName;
        if ("com.kingdee.eas.hr.train.PersonCheckUp".equals(entityName)) {
            name = "com.kingdee.eas.hr.emp.PersonCheckUp";
        }
        return name;
    }

    private static boolean isOldDataAndNeedToClear(String entityName, String fieldName) {
        boolean toClear = false;
        if ("KQDJRQ".equalsIgnoreCase(fieldName)) {
            toClear = true;
        } else if ("com.kingdee.eas.hr.emp.app.FamilyEvite".equalsIgnoreCase(entityName) && ("auditor".equalsIgnoreCase(fieldName) || "description".equalsIgnoreCase(fieldName))) {
            toClear = true;
        }
        return toClear;
    }
}

