/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.hr.emp.client.AbstractEmpCollectSettingUI;
import com.kingdee.eas.hr.emp.client.EmpCollNewFilterInfo;
import com.kingdee.eas.hr.emp.client.EmpCollQueryFilterInfo;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EmpCollectSettingUI
extends AbstractEmpCollectSettingUI {
    private static final Logger logger = CoreUIObject.getLogger(EmpCollectSettingUI.class);
    EmpCollNewFilterInfo filterInfo = null;
    EmpCollQueryFilterInfo queryInfo = null;
    public ArrayList noSelectedColumns = null;
    public boolean isCancel = true;

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        this.isCancel = false;
        this.noSelectedColumns = this.getNoSelectedColumns();
        this.getUIWindow().close();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.filterInfo = (EmpCollNewFilterInfo)this.getUIContext().get("filterInfo");
        this.queryInfo = (EmpCollQueryFilterInfo)this.getUIContext().get("queryInfo");
        this.noSelectedColumns = (ArrayList)this.getUIContext().get("noSelectedColumns");
        if (this.filterInfo == null) {
            // empty if block
        }
        this.tblMain.checkParsed();
        this.initTables();
        this.setColSelected();
    }

    private IRow addTblRow(String name) {
        IRow row = this.tblMain.addRow();
        if (this.noSelectedColumns != null && this.noSelectedColumns.contains(name)) {
            row.getCell("isSelected").setValue((Object)Boolean.FALSE);
        } else {
            row.getCell("isSelected").setValue((Object)Boolean.TRUE);
        }
        row.getCell("column").setUserObject((Object)name);
        row.getCell("column").setValue((Object)EmployeeClientUtils.getAlias(name));
        return row;
    }

    private void initTables() {
        this.addTblRow("COUNT");
        if (this.queryInfo.objType == 0) {
            this.addTblRow("PERSENT");
        } else if (this.queryInfo.objType == 2) {
            this.addTblRow("PERSENT");
        }
        if (this.filterInfo.isAnalyse) {
            this.addTblRow(this.getCalCuColumnKey());
            this.addTblRow("RATE");
        }
        this.addTblRow("PARTIMECOUNT");
        this.addTblRow("ONSTRCOUNT");
        this.addTblRow("OFFSTRCOUNT");
    }

    private void setColSelected() {
        if (this.noSelectedColumns == null) {
            return;
        }
        IRow row = null;
        String colName = null;
        int size = this.tblMain.getRowCount();
        block0: for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            int size2 = this.noSelectedColumns.size();
            for (int j = 0; j < size2; ++j) {
                colName = (String)this.noSelectedColumns.get(j);
                if (!colName.equals((String)row.getCell("column").getUserObject())) continue;
                row.getCell("isSelected").setValue((Object)Boolean.FALSE);
                continue block0;
            }
        }
    }

    private String getCalCuColumnKey() {
        switch (this.filterInfo.analyseType) {
            case 0: {
                return "LASTPERIODCOUNT";
            }
            case 1: {
                return "LASTYEARCOUNT";
            }
        }
        return "LASTYEARSCOUNT";
    }

    private ArrayList getNoSelectedColumns() {
        ArrayList<Object> list = new ArrayList<Object>();
        IRow row = null;
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.tblMain.getRow(i);
            if (((Boolean)row.getCell("isSelected").getValue()).booleanValue()) continue;
            list.add(row.getCell("column").getUserObject());
        }
        return list;
    }
}

