/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonCertification;
import com.kingdee.eas.hr.emp.PYTypeEnum;
import com.kingdee.eas.hr.emp.PersonCertificationCollection;
import com.kingdee.eas.hr.emp.PersonCertificationFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCertifyUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class EmployeeCertifyUI
extends AbstractEmployeeCertifyUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    public void setTableCellEditor() {
        this.kdtCertify.getColumn("period").setEditor(EmployeeClientUtils.getIntCellEditor());
        this.kdtCertify.getColumn("date").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtCertify.getColumn("date").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnCertiAddNew, (JButton)this.btnCertiDelete);
        this.kdtCertify.checkParsed();
        this.setTableCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtCertify);
            this.btnCertiAddNew.setEnabled(false);
            this.btnCertiDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtCertify, "name");
        EmployeeClientUtils.setColumnBackColor(this.kdtCertify, "number");
        this.kdtCertify.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtCertify, "number");
        EmployeeClientUtils.setCellEditor(this.kdtCertify, "name");
        EmployeeClientUtils.setCellEditor(this.kdtCertify, "organ");
        EmployeeClientUtils.setCellEditor(this.kdtCertify, "level");
        KDFormattedTextField kft = new KDFormattedTextField();
        kft.setDataType(4);
        kft.setDataVerifierType(12);
        kft.setMaximumValue((Comparable)new Float(100.0f));
        kft.setMinimumValue((Comparable)new Float(0.0));
        kft.setPrecision(1);
        this.kdtCertify.getColumn("period").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kft));
        KDComboBox combo = new KDComboBox(PYTypeEnum.getEnumList().toArray());
        this.kdtCertify.getColumn("pyType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)combo));
    }

    private PersonCertificationCollection getPCColl(String empId) throws BOSException {
        IPersonCertification ipc = PersonCertificationFactory.getRemoteInstance();
        String oql = "select * ";
        oql = oql + " where person.id = '" + empId + "'";
        return ipc.getPersonCertificationCollection(oql);
    }

    private void loadCertis() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonCertificationCollection c = this.getPCColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.kdtCertify.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtCertify, "name");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtCertify, "number");
        EmployeeClientUtils.checkHasInputRows(this.kdtCertify, this.delList);
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonCertification ipc = PersonCertificationFactory.getRemoteInstance();
        ipc.saveAll(EmployeeClientUtils.getCertiCollectionByKDTable(this.kdtCertify, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void refresh() throws Exception {
        this.kdtCertify.removeRows();
        this.loadCertis();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionCertiAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtCertify);
    }

    @Override
    public void actionCertiDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtCertify, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.btnCertiAddNew.setEnabled(false);
            this.btnCertiDelete.setEnabled(false);
            this.kdtCertify.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

