/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMenuManager;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.basedata.hraux.util.HRTreeUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.tree.NewOrgTreeHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.OrgStringUtil;
import com.kingdee.eas.hr.compensation.util.HRSchemeUtils;
import com.kingdee.eas.hr.emp.EmpCollectFacadeFactory;
import com.kingdee.eas.hr.emp.IEmpCollectFacade;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeCollectUI;
import com.kingdee.eas.hr.emp.client.EmpCollNewFilterInfo;
import com.kingdee.eas.hr.emp.client.EmpCollQueryFilterInfo;
import com.kingdee.eas.hr.emp.client.EmpCollectSettingUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeeCollectFilterNewUI;
import com.kingdee.eas.hr.emp.client.EmployeeCollectFilterQueryUI;
import com.kingdee.eas.hr.emp.client.HRCellTreeRenderer;
import com.kingdee.eas.hr.emp.client.HRCellUserObject;
import com.kingdee.eas.hr.emp.client.HRTreeTable;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;

public class EmployeeCollectUI
extends AbstractEmployeeCollectUI {
    private static final int COUNT_COL_WIDTH = 50;
    private static final int PARTIMECOUNT_COL_WIDTH = 50;
    private static final int ONSTRCOUNT_COL_WIDTH = 50;
    private static final int OFFSTRCOUNT_COL_WIDTH = 50;
    private static final int LASTYEARCOUNT_COL_WIDTH = 70;
    private static final int RATE_COL_WIDTH = 50;
    private static final int PERSENT_COL_WIDTH = 70;
    private static final int FNAME_COL_WIDTH = 200;
    EmpCollNewFilterInfo filterInfo = null;
    EmpCollQueryFilterInfo queryInfo = null;
    ArrayList noSelectedColumns;
    private boolean isFirstDefaultQuery = true;
    private HashMap parentRowMap = null;
    private HashMap childParentMap = new HashMap();
    private String adminIds = null;
    private CommonQueryDialog dialog = null;
    private HashMap allAdminOrgMap;
    private static final String BASE_STRING = "(" + EmployeeClientUtils.getAlias("ORGUNIT_BASE") + ")";
    DefaultKingdeeTreeNode orgRoot = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.hr.emp.client.EmployeeCollectUI");
    private IMetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.emp.app.EmployeeQuery");
    int groupCount = -1;
    int beginYear = -1;
    int beginMonth = -1;
    int endYear = -1;
    int endMonth = -1;
    int beginQuarter = -1;
    int endQuarter = -1;
    int beginHalfYear = -1;
    int endHalfYear = -1;
    int groupColCount = 4;

    private ArrayList setNoSelectedColumns() {
        ArrayList<String> noSelectedColumns = new ArrayList<String>();
        noSelectedColumns.add("PARTIMECOUNT");
        noSelectedColumns.add("ONSTRCOUNT");
        noSelectedColumns.add("OFFSTRCOUNT");
        if (this.queryInfo.objType == 1) {
            noSelectedColumns.add("PERSENT");
        }
        return noSelectedColumns;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrintPreview);
        this.setButtonDefaultStyl(this.btnPrint);
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.btnPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.btnSetting.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.menuItemExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.menuItemPrint.setIcon(EASResource.getIcon((String)"imgTbtn_print"));
        this.menuItemPrintPreview.setIcon(EASResource.getIcon((String)"imgTbtn_preview"));
        this.menuItemSetting.setIcon(EASResource.getIcon((String)"imgTbtn_pagesetting"));
        this.btnExport.setVisible(false);
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtPerson);
        this.kdtPerson.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.kdtPerson);
        this.kdtPerson.getPrintManager().printPreview();
    }

    private void initParam() throws EASBizException, BOSException {
    }

    private void initInnerFilter() throws Exception {
        this.beginYear = DateTimeUtils.getYear((Date)this.filterInfo.beginDate);
        this.endYear = DateTimeUtils.getYear((Date)this.filterInfo.endDate);
        this.beginMonth = this.filterInfo.beginDate.getMonth();
        this.endMonth = this.filterInfo.endDate.getMonth();
        this.beginQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.beginDate);
        this.endQuarter = DateTimeUtils.getQuarter((Date)this.filterInfo.endDate);
        this.beginHalfYear = EmployeeClientUtils.getHalfYear(this.beginQuarter);
        this.endHalfYear = EmployeeClientUtils.getHalfYear(this.endQuarter);
        if (this.filterInfo.intervalType.equals("YEAR")) {
            this.groupCount = this.endYear + 1 - this.beginYear;
        } else if (this.filterInfo.intervalType.equals("QUARTER")) {
            this.groupCount = (this.endYear - this.beginYear) * 4 + (this.endQuarter - this.beginQuarter + 1);
        } else if (this.filterInfo.intervalType.equals("MONTH")) {
            this.groupCount = (this.endYear - this.beginYear) * 12 + (this.endMonth - this.beginMonth + 1);
        } else if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            this.groupCount = (this.endYear - this.beginYear) * 2 + (this.endHalfYear - this.beginHalfYear + 1);
        }
        ++this.beginMonth;
        ++this.endMonth;
        this.groupColCount = this.filterInfo.isAnalyse ? 7 : 5;
        if (this.queryInfo.positionLevel == -1) {
            this.queryInfo.positionLevel = 1;
        }
        if (this.queryInfo.objType == 0) {
            this.orgRoot = HRTreeUtil.createAdminTreeNodeByUserRange((boolean)false, (boolean)this.queryInfo.showVirtualOrg, (boolean)true, (!this.queryInfo.includeSealUp ? 1 : 0) != 0, null);
            if (this.orgRoot == null) {
                return;
            }
            if (this.queryInfo.orgInfo != null) {
                HashMap<String, DefaultKingdeeTreeNode> map = new HashMap<String, DefaultKingdeeTreeNode>();
                map.put(this.getAdminIdByAdminNode(this.orgRoot), this.orgRoot);
                this.overTreeNodeSimple(this.orgRoot, map);
                this.orgRoot = (DefaultKingdeeTreeNode)map.get(this.queryInfo.orgInfo.getId().toString());
            }
            if (this.orgRoot == null) {
                return;
            }
            this.orgRoot.setParent(null);
            if (this.queryInfo.orgLevel != -1) {
                int level = this.queryInfo.orgLevel;
                if (this.queryInfo.isDisplayBase) {
                    ++level;
                }
                this.handleOrgRoot(this.orgRoot, level);
            }
            ArrayList list = new ArrayList();
            this.addIdByOverTreeNode(this.orgRoot, list);
            int size = list.size();
            if (size == 0) {
                this.adminIds = "''";
            } else {
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < size; ++i) {
                    if (i == 0) {
                        sb.append("'");
                        sb.append(list.get(i).toString());
                        sb.append("'");
                        continue;
                    }
                    sb.append(", '");
                    sb.append(list.get(i).toString());
                    sb.append("'");
                }
                this.adminIds = sb.toString();
            }
        }
        if (this.queryInfo.objType == 2) {
            Object[] orgInfos = this.queryInfo.orgInfos;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < orgInfos.length; ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(((OrgUnitInfo)orgInfos[i]).getId().toString());
                sb.append("'");
            }
            this.adminIds = sb.toString();
            this.orgRoot = OrgStringUtil.buildTreeNodeByOrgs((Object[])orgInfos);
        }
    }

    private void handleOrgRoot(DefaultKingdeeTreeNode node, int orgLevel) {
        if (node.getLevel() >= orgLevel) {
            node.removeAllChildren();
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.handleOrgRoot((DefaultKingdeeTreeNode)node.getChildAt(i), orgLevel);
        }
    }

    private void addIdByOverTreeNode(DefaultKingdeeTreeNode node, ArrayList list) {
        String adminId = this.getAdminIdByAdminNode(node);
        if (node.getChildCount() == 0) {
            if (!list.contains(adminId)) {
                list.add(adminId);
            }
        } else {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.addIdByOverTreeNode((DefaultKingdeeTreeNode)node.getChildAt(i), list);
            }
            if (!list.contains(adminId)) {
                list.add(adminId);
            }
        }
    }

    private int getPositionLevel() {
        return this.queryInfo.positionLevel == -1 ? 0 : this.queryInfo.positionLevel - 1;
    }

    private IRowSet getBaseDatas() throws Exception {
        IEmpCollectFacade iemp = EmpCollectFacadeFactory.getRemoteInstance();
        if (StringUtils.isEmpty((String)this.adminIds)) {
            return null;
        }
        if (!this.filterInfo.isAnalyse) {
            return iemp.getAdminRows(this.filterInfo.beginDate, this.filterInfo.endDate, this.filterInfo.intervalType, this.adminIds);
        }
        Date[] dates = this.getLastDates();
        return iemp.getAdminRows(this.filterInfo.beginDate, this.filterInfo.endDate, dates[0], dates[1], this.filterInfo.intervalType, this.adminIds);
    }

    private IRowSet getDatasNew2() throws Exception {
        IEmpCollectFacade iemp = EmpCollectFacadeFactory.getRemoteInstance();
        if (this.queryInfo.objType == 1) {
            if (!this.filterInfo.isAnalyse) {
                return iemp.getPositionRows(this.filterInfo.beginDate, this.filterInfo.endDate, this.filterInfo.intervalType, this.queryInfo.positionInfo.getId().toString(), this.getPositionLevel());
            }
            Date[] dates = this.getLastDates();
            return iemp.getPositionRows(this.filterInfo.beginDate, this.filterInfo.endDate, dates[0], dates[1], this.filterInfo.intervalType, this.queryInfo.positionInfo.getId().toString(), this.getPositionLevel());
        }
        if (StringUtils.isEmpty((String)this.adminIds)) {
            return null;
        }
        if (!this.filterInfo.isAnalyse) {
            return iemp.getNewRows(this.filterInfo.beginDate, this.filterInfo.endDate, this.filterInfo.intervalType, this.adminIds, this.queryInfo.isOnlySelectOrg);
        }
        Date[] dates = this.getLastDates();
        return iemp.getNewRows(this.filterInfo.beginDate, this.filterInfo.endDate, dates[0], dates[1], this.filterInfo.intervalType, this.adminIds, this.queryInfo.isOnlySelectOrg);
    }

    private Date[] getLastDates() {
        Date[] dates = new Date[2];
        switch (this.filterInfo.analyseType) {
            case 0: {
                if (this.filterInfo.intervalType.equals("YEAR")) {
                    dates[0] = DateTimeUtils.addYear((Date)this.filterInfo.beginDate, (int)-1);
                    dates[1] = DateTimeUtils.addYear((Date)this.filterInfo.endDate, (int)-1);
                    break;
                }
                if (this.filterInfo.intervalType.equals("HALFYEAR")) {
                    dates[0] = DateTimeUtils.addMonth((Date)this.filterInfo.beginDate, (int)-6);
                    dates[1] = DateTimeUtils.addMonth((Date)this.filterInfo.endDate, (int)-6);
                    break;
                }
                if (this.filterInfo.intervalType.equals("QUARTER")) {
                    dates[0] = DateTimeUtils.addMonth((Date)this.filterInfo.beginDate, (int)-3);
                    dates[1] = DateTimeUtils.addMonth((Date)this.filterInfo.endDate, (int)-3);
                    break;
                }
                dates[0] = DateTimeUtils.addMonth((Date)this.filterInfo.beginDate, (int)-1);
                dates[1] = DateTimeUtils.addMonth((Date)this.filterInfo.endDate, (int)-1);
                break;
            }
            case 1: {
                dates[0] = DateTimeUtils.addYear((Date)this.filterInfo.beginDate, (int)-1);
                dates[1] = DateTimeUtils.addYear((Date)this.filterInfo.endDate, (int)-1);
                break;
            }
            case 2: {
                dates[0] = DateTimeUtils.addYear((Date)this.filterInfo.beginDate, (int)(-1 * this.filterInfo.numberOfYears));
                dates[1] = DateTimeUtils.addYear((Date)this.filterInfo.endDate, (int)(-1 * this.filterInfo.numberOfYears));
            }
        }
        return dates;
    }

    private String getSuffixByData(int year, int interval) {
        if (interval != -100) {
            String tmp = "_" + String.valueOf(year) + "_" + String.valueOf(interval) + "_";
            return tmp + this.filterInfo.intervalType;
        }
        return "_" + String.valueOf(year);
    }

    private String getSuffixByLastData(int year, int interval) {
        String result = null;
        if (interval == -100) {
            result = this.filterInfo.analyseType == 2 ? "_" + String.valueOf(year + this.filterInfo.numberOfYears) : "_" + String.valueOf(year + 1);
        } else {
            switch (this.filterInfo.analyseType) {
                case 2: {
                    result = "_" + String.valueOf(year + this.filterInfo.numberOfYears) + "_" + String.valueOf(interval) + "_";
                    break;
                }
                case 1: {
                    result = "_" + String.valueOf(year + 1) + "_" + String.valueOf(interval) + "_";
                    break;
                }
                default: {
                    result = interval == 2 && this.filterInfo.intervalType.equals("HALFYEAR") || interval == 4 && this.filterInfo.intervalType.equals("QUARTER") || interval == 12 && this.filterInfo.intervalType.equals("MONTH") ? "_" + String.valueOf(year + 1) + "_" + String.valueOf(1) + "_" : "_" + String.valueOf(year) + "_" + String.valueOf(interval + 1) + "_";
                }
            }
        }
        return result;
    }

    private String getColName(String suffix, String name) {
        return name + suffix;
    }

    private String getPercentFmtStr() {
        return "#,##0.00%";
    }

    private void calcuPercent() {
        if (!this.filterInfo.isCaculatePercent) {
            return;
        }
        String zeroStr = "0";
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpAllValue = null;
        double tmpCount = -1.0;
        double tmpAllCount = -1.0;
        String colNameSuffix = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            for (int j = 0; j < rowCount; ++j) {
                if (j == 0) {
                    tmpAllValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue();
                    if (tmpAllValue == null || tmpAllValue.toString().equals(zeroStr)) continue;
                    tmpAllCount = Double.parseDouble(tmpAllValue.toString());
                }
                if ((tmpValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue()) == null || tmpValue.toString().equals(zeroStr) || tmpAllCount == 0.0) continue;
                tmpCount = Double.parseDouble(tmpValue.toString());
                this.kdtPerson.getRow(j).getCell("PERSENT" + colNameSuffix).setValue((Object)new Double(tmpCount * 100.0 / tmpAllCount));
            }
        }
    }

    protected void fillTable(ArrayList valueList) {
        String orgIdColName = "FAdminOrgID";
        String orgNameColName = "FName";
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        HashMap values = null;
        HashMap map = null;
        int minLevel = -1;
        int level = -1;
        ArrayList list = null;
        int count = valueList.size();
        for (int k = 0; k < count; ++k) {
            values = (HashMap)valueList.get(k);
            level = (Integer)values.get("FLevel");
            if (k == 0) {
                minLevel = level;
            }
            IRow row = this.kdtPerson.addRow();
            HRCellUserObject orgCellObj = new HRCellUserObject();
            orgCellObj.setCompanyId(values.get(orgIdColName).toString());
            orgCellObj.setName(values.get(orgNameColName).toString());
            orgCellObj.setLongNumber(values.get("FLongNumber").toString());
            orgCellObj.setLevel(level);
            if (level == minLevel + this.queryInfo.positionLevel - 1) {
                orgCellObj.setIsLeaf(true);
            } else {
                orgCellObj.setIsLeaf((Boolean)values.get("FIsLeaf"));
            }
            orgCellObj.setExpanded(true);
            row.getCell(orgIdColName).setValue((Object)values.get(orgIdColName).toString());
            row.getCell(orgNameColName).setValue((Object)orgCellObj);
            row.getCell(orgNameColName).setRenderer((IBasicRender)orgCellRen);
            list = (ArrayList)values.get("valueList");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = (HashMap)list.get(i);
                int tmpYear = (Integer)map.get("FYear");
                int tmpInteval = (Integer)map.get("FInterval");
                String tmpColNameSuffix = this.getSuffixByData(tmpYear, tmpInteval);
                String tmpLstYrColNameSuffix = this.getSuffixByLastData(tmpYear, tmpInteval);
                if (this.isInPeriodNew(tmpYear, tmpInteval, true)) {
                    row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)((Integer)map.get("FCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "PARTIMECOUNT")).setValue((Object)((Integer)map.get("FPartimeCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "OFFSTRCOUNT")).setValue((Object)((Integer)map.get("FOffStreCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)((Integer)map.get("FOnStreCount")));
                }
                if (!this.filterInfo.isAnalyse || !this.isInPeriodNew(tmpYear, tmpInteval, false)) continue;
                row.getCell(this.getCalCuColumnKey(tmpLstYrColNameSuffix) + this.getSuffixByInterval()).setValue((Object)((Integer)map.get("FCount")));
            }
        }
        if (this.filterInfo.isAnalyse) {
            this.calcuRate();
        }
        if (this.filterInfo.isCaculatePercent) {
            this.calcuPercent();
        }
    }

    private int[] getAdminOrgRootRow(List valueList) {
        String tmpLongNumber = null;
        int count = valueList.size();
        String[] currLongNumber = new String[count];
        boolean isExistRoot = false;
        int lastMask = 0;
        int[] rootRowCount = new int[count];
        for (int i = 0; i < count; ++i) {
            currLongNumber[i] = (String)valueList.get(i);
            if (currLongNumber[i] == null || (lastMask = currLongNumber[i].lastIndexOf("!")) < 0) continue;
            for (int j = i; j >= 0; --j) {
                tmpLongNumber = currLongNumber[i].substring(0, lastMask = lastMask < 0 ? 0 : lastMask);
                if (!StringUtils.isEmpty((String)tmpLongNumber) && tmpLongNumber.equals(currLongNumber[j])) {
                    lastMask = tmpLongNumber.lastIndexOf("!");
                    rootRowCount[i] = j;
                    isExistRoot = true;
                    continue;
                }
                if (isExistRoot) continue;
                rootRowCount[i] = i;
            }
            isExistRoot = false;
        }
        return rootRowCount;
    }

    private void calcuPercent3(List valueList) {
        if (!this.filterInfo.isCaculatePercent) {
            return;
        }
        String zeroStr = "0";
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpAllValue = null;
        double tmpCount = 0.0;
        double tmpAllCount = 0.0;
        String colNameSuffix = null;
        int level = 0;
        IRow row = null;
        int[] rootRowCount = this.getAdminOrgRootRow(valueList);
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            tmpAllValue = null;
            for (int j = 0; j < rowCount; ++j) {
                row = this.kdtPerson.getRow(j);
                level = (Integer)row.getUserObject();
                tmpValue = row.getCell("COUNT" + colNameSuffix).getValue();
                if (level == 0 && tmpValue == null || tmpValue == null || tmpValue.toString().equals(zeroStr)) continue;
                if (tmpValue != null && rootRowCount[j] == j) {
                    tmpAllValue = tmpValue;
                    tmpAllCount = Double.parseDouble(tmpAllValue.toString());
                }
                tmpCount = Double.parseDouble(tmpValue.toString());
                if (tmpAllCount == 0.0) continue;
                row.getCell("PERSENT" + colNameSuffix).setValue((Object)new Double(tmpCount / tmpAllCount));
            }
        }
    }

    private void calcuPercent3Old() {
        if (!this.filterInfo.isCaculatePercent) {
            return;
        }
        String zeroStr = "0";
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpAllValue = null;
        double tmpCount = 0.0;
        double tmpAllCount = 0.0;
        String colNameSuffix = null;
        int level = 0;
        IRow row = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            tmpAllValue = null;
            for (int j = 0; j < rowCount; ++j) {
                row = this.kdtPerson.getRow(j);
                level = (Integer)row.getUserObject();
                tmpValue = row.getCell("COUNT" + colNameSuffix).getValue();
                if (level == 0 && tmpValue == null) continue;
                if (level == 0 && tmpValue != null) {
                    tmpAllValue = tmpValue;
                    tmpAllCount = Double.parseDouble(tmpAllValue.toString());
                }
                if (level != 0 && tmpAllValue == null && tmpValue != null) {
                    tmpAllValue = tmpValue;
                    tmpAllCount = Double.parseDouble(tmpAllValue.toString());
                }
                if (tmpValue == null || tmpValue.toString().equals(zeroStr)) continue;
                tmpCount = Double.parseDouble(tmpValue.toString());
                if (tmpAllCount == 0.0) continue;
                row.getCell("PERSENT" + colNameSuffix).setValue((Object)new Double(tmpCount / tmpAllCount));
            }
        }
    }

    private void calcuPercentByFull() {
        if (!this.filterInfo.isCaculatePercent) {
            return;
        }
        int rowCount = this.kdtPerson.getRowCount();
        String colNameSuffix = null;
        IRow row = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            for (int j = 0; j < rowCount; ++j) {
                row = this.kdtPerson.getRow(j);
                row.getCell("PERSENT" + colNameSuffix).setValue((Object)new Double(1.0));
            }
        }
    }

    private String getCalCuColumnKey(String colNameSuffix) {
        switch (this.filterInfo.analyseType) {
            case 0: {
                return "LASTPERIODCOUNT" + colNameSuffix;
            }
            case 1: {
                return "LASTYEARCOUNT" + colNameSuffix;
            }
        }
        return "LASTYEARSCOUNT" + colNameSuffix;
    }

    private String getSuffixByInterval() {
        if (this.filterInfo.intervalType.equals("YEAR")) {
            return "";
        }
        return this.filterInfo.intervalType;
    }

    private void calcuRate() {
        if (!this.filterInfo.isAnalyse) {
            return;
        }
        int rowCount = this.kdtPerson.getRowCount();
        Object tmpValue = null;
        Object tmpLstYrValue = null;
        String colNameSuffix = null;
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            for (int j = 0; j < rowCount; ++j) {
                tmpValue = this.kdtPerson.getRow(j).getCell("COUNT" + colNameSuffix).getValue();
                if (tmpValue == null || (tmpLstYrValue = this.kdtPerson.getRow(j).getCell(this.getCalCuColumnKey(colNameSuffix)).getValue()) == null) continue;
                double tmpCount = Double.parseDouble(tmpValue.toString());
                double tmpLstYrCount = Double.parseDouble(tmpLstYrValue.toString());
                if (tmpLstYrCount == 0.0) continue;
                this.kdtPerson.getRow(j).getCell("RATE" + colNameSuffix).setValue((Object)new Double((tmpCount - tmpLstYrCount) * 1.0 / tmpLstYrCount));
            }
        }
    }

    private void getDataList(DefaultKingdeeTreeNode treeNode, ArrayList list) {
        if (treeNode.getUserObject() != null) {
            list.add(treeNode.getUserObject());
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            this.getDataList((DefaultKingdeeTreeNode)treeNode.getChildAt(i), list);
        }
    }

    private DefaultKingdeeTreeNode getRoot(IRowSet rows) throws Exception {
        if (rows.size() == 0) {
            return null;
        }
        DefaultKingdeeTreeNode root = null;
        DefaultKingdeeTreeNode curNode = null;
        DefaultKingdeeTreeNode parent = null;
        DefaultKingdeeTreeNode childNode = null;
        int curLevel = -1;
        Integer index = null;
        int childCount = -1;
        String curId = null;
        int i = 0;
        boolean flag = true;
        while (rows.next()) {
            if (i == 0) {
                root = this.makeNode(rows);
                curLevel = this.getLevel(root);
                curId = this.getId(root);
                curNode = root;
            } else if (!curId.equals(rows.getString("FAdminOrgID"))) {
                parent = curLevel == rows.getInt("FLevel") ? (DefaultKingdeeTreeNode)curNode.getParent() : (curLevel < rows.getInt("FLevel") ? curNode : this.getParent(curNode, curLevel - rows.getInt("FLevel")));
                curNode = this.makeNode(rows);
                index = this.getIndex(curNode);
                if (index == -100) {
                    parent.add((MutableTreeNode)curNode);
                } else {
                    childCount = parent.getChildCount();
                    if (childCount == 0) {
                        parent.add((MutableTreeNode)curNode);
                    } else if (index == 0) {
                        parent.insert((MutableTreeNode)curNode, 0);
                    } else {
                        flag = true;
                        int size = childCount;
                        for (int j = 0; j < size; ++j) {
                            childNode = (DefaultKingdeeTreeNode)parent.getChildAt(j);
                            if (index >= this.getIndex(childNode)) continue;
                            parent.insert((MutableTreeNode)curNode, j);
                            flag = false;
                            break;
                        }
                        if (flag) {
                            parent.add((MutableTreeNode)curNode);
                        }
                    }
                }
            } else {
                this.putValues(rows, curNode);
            }
            ++i;
            curId = rows.getString("FAdminOrgID");
            curLevel = rows.getInt("FLevel");
        }
        return root;
    }

    private String getId(DefaultKingdeeTreeNode node) {
        return ((HashMap)node.getUserObject()).get("FAdminOrgID").toString();
    }

    private void putValues(IRowSet rows, DefaultKingdeeTreeNode node) throws Exception {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("FInterval", rows.getInt("FInterval"));
        values.put("FYear", rows.getInt("FYear"));
        values.put("FCount", rows.getInt("FCount"));
        values.put("FPartimeCount", rows.getInt("FPartimeCount"));
        values.put("FOffStreCount", rows.getInt("FOffStreCount"));
        values.put("FOnStreCount", rows.getInt("FOnStreCount"));
        values.put("FOnStreCount2", rows.getInt("FONSTRECOUNT2"));
        HashMap map = (HashMap)node.getUserObject();
        ((ArrayList)map.get("valueList")).add(values);
    }

    private String getAdminIdByAdminNode(DefaultKingdeeTreeNode node) {
        AdminOrgUnitInfo adminInfo = null;
        if (node.getUserObject() instanceof AdminOrgUnitInfo) {
            adminInfo = (AdminOrgUnitInfo)node.getUserObject();
        }
        if (adminInfo != null) {
            return adminInfo.getId().toString();
        }
        return null;
    }

    private void overTreeNodeSimple(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            this.overTreeNodeSimple(node, nodeMap);
        }
    }

    private void overTreeNode(DefaultKingdeeTreeNode root, HashMap nodeMap) throws Exception {
        DefaultKingdeeTreeNode node = null;
        int count = root.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            nodeMap.put(this.getAdminIdByAdminNode(node), node);
            node.setUserObject(this.makeEmptyObject(node));
            this.overTreeNode(node, nodeMap);
        }
    }

    private DefaultKingdeeTreeNode buildTreeNode(DefaultKingdeeTreeNode root, IRowSet rows) throws Exception {
        if (root == null) {
            return null;
        }
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        if (root.getUserObject() != null) {
            nodeMap.put(this.getAdminIdByAdminNode(root), root);
            root.setUserObject(this.makeEmptyObject(root));
        }
        this.overTreeNode(root, nodeMap);
        String adminId = null;
        while (rows.next()) {
            adminId = rows.getString("FAdminOrgID");
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodeMap.get(adminId);
            node.setUserObject(this.makeNodeObject(rows, node));
        }
        return root;
    }

    private Object makeEmptyObject(DefaultKingdeeTreeNode node) throws Exception {
        AdminOrgUnitInfo info = (AdminOrgUnitInfo)node.getUserObject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
        if (parent != null && parent.getUserObject() instanceof HashMap) {
            this.childParentMap.put(info.getId().toString(), ((HashMap)parent.getUserObject()).get("FAdminOrgID").toString());
        }
        if (HRTreeUtil.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            map.put("isEnable", false);
        } else {
            map.put("isEnable", true);
        }
        map.put("FLongNumber", info.getLongNumber());
        map.put("FIndex", info.getIndex());
        map.put("FIsLeaf", node.isLeaf());
        map.put("FLevel", node.getLevel());
        map.put("FAdminOrgID", info.getId().toString());
        if (info.getName() != null) {
            map.put("FName", info.getName());
        } else {
            map.put("FName", "");
        }
        if (OrgF7InnerUtils.isTreeNodeDisable((DefaultKingdeeTreeNode)node)) {
            map.put("IsVisual", Boolean.TRUE);
        } else {
            map.put("IsVisual", Boolean.FALSE);
        }
        ArrayList list = new ArrayList();
        map.put("valueList", list);
        return map;
    }

    private Object makeNodeObject(IRowSet rows, DefaultKingdeeTreeNode node) throws Exception {
        HashMap map = (HashMap)node.getUserObject();
        ArrayList list = (ArrayList)map.get("valueList");
        list.add(this.adminValueRowSet2Map(rows));
        map.put("valueList", list);
        return map;
    }

    private Map adminValueRowSet2Map(IRowSet rows) throws Exception {
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("FInterval", rows.getInt("FInterval"));
        values.put("FYear", rows.getInt("FYear"));
        values.put("FCount", rows.getInt("FCount"));
        values.put("FPartimeCount", rows.getInt("FPartimeCount"));
        values.put("FOffStreCount", rows.getInt("FOffStreCount"));
        values.put("FOnStreCount", rows.getInt("FOnStreCount"));
        values.put("FOnStreCount2", rows.getInt("FOnStreCount2"));
        return values;
    }

    private DefaultKingdeeTreeNode makeNode(IRowSet rows) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FLongNumber", rows.getString("FLongNumber"));
        map.put("FIndex", rows.getInt("FIndex"));
        map.put("FIsLeaf", rows.getBoolean("FIsLeaf"));
        map.put("FLevel", rows.getInt("FLevel"));
        map.put("FAdminOrgID", rows.getString("FAdminOrgID"));
        if (rows.getString("FName") != null) {
            map.put("FName", rows.getString("FName"));
        } else {
            map.put("FName", "");
        }
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        values.put("FInterval", rows.getInt("FInterval"));
        values.put("FYear", rows.getInt("FYear"));
        values.put("FCount", rows.getInt("FCount"));
        values.put("FPartimeCount", rows.getInt("FPartimeCount"));
        values.put("FOffStreCount", rows.getInt("FOffStreCount"));
        values.put("FOnStreCount", rows.getInt("FOnStreCount"));
        values.put("FOnStreCount2", rows.getInt("FOnStreCount2"));
        ArrayList<HashMap<String, Integer>> list = new ArrayList<HashMap<String, Integer>>();
        list.add(values);
        map.put("valueList", list);
        logger.debug((Object)rows.getString("FName"));
        return new DefaultKingdeeTreeNode(map);
    }

    private DefaultKingdeeTreeNode getParent(DefaultKingdeeTreeNode node, int levelInteval) {
        DefaultKingdeeTreeNode parent = null;
        if (levelInteval == 0) {
            return (DefaultKingdeeTreeNode)node.getParent();
        }
        parent = (DefaultKingdeeTreeNode)node.getParent();
        return this.getParent(parent, levelInteval - 1);
    }

    private Integer getIndex(DefaultKingdeeTreeNode node) {
        return (Integer)((HashMap)node.getUserObject()).get("FIndex");
    }

    private int getLevel(DefaultKingdeeTreeNode node) {
        return (Integer)((HashMap)node.getUserObject()).get("FLevel");
    }

    private void loadTableData() throws Exception {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                return EmployeeCollectUI.this.loadTableData2();
            }
        });
        dlg.show();
    }

    private Object loadTableData2() throws Exception {
        IRowSet datas = this.getDatasNew2();
        if (datas == null) {
            return null;
        }
        DefaultKingdeeTreeNode root = null;
        if (this.queryInfo.objType == 0 || this.queryInfo.objType == 2 && this.orgRoot != null) {
            root = this.buildTreeNode(this.orgRoot, datas);
            if (root == null) {
                return null;
            }
            if (this.queryInfo.isDisplayBase) {
                DefaultKingdeeTreeNode baseRootNode = this.getNodeBaseData();
                HashMap nodeMap = new HashMap();
                this.assembleNodeMap(baseRootNode, nodeMap);
                this.insertBaseNode(root, nodeMap);
                this.deleteMostLevelNode(root, this.queryInfo.orgLevel + 1);
            }
            ArrayList valueList = new ArrayList();
            this.getDataList(root, valueList);
            this.fillTable2(valueList);
        } else if (this.queryInfo.objType == 2) {
            IAdminOrgUnit iadmin = AdminOrgUnitFactory.getRemoteInstance();
            AdminOrgUnitCollection col = iadmin.getAdminOrgUnitCollection("select id,displayName,level where id in (" + this.adminIds + ") order by longNumber");
            HashMap adminValuesMap = new HashMap();
            while (datas.next()) {
                String adminId = datas.getString("FAdminOrgID");
                if (!adminValuesMap.containsKey(adminId)) {
                    adminValuesMap.put(adminId, new ArrayList());
                }
                List valueList = (List)adminValuesMap.get(adminId);
                valueList.add(this.adminValueRowSet2Map(datas));
            }
            ArrayList adminList = new ArrayList();
            for (int i = 0; i < col.size(); ++i) {
                AdminOrgUnitInfo adminInfo = col.get(i);
                HashMap<String, Object> adminMap = new HashMap<String, Object>();
                adminMap.put("FAdminOrgID", adminInfo.getId().toString());
                adminMap.put("FLevel", adminInfo.getLevel());
                adminMap.put("FName", adminInfo.getDisplayName());
                adminMap.put("valueList", adminValuesMap.get(adminInfo.getId().toString()));
                adminList.add(adminMap);
            }
            this.fillTable2(adminList);
        } else {
            try {
                root = this.getRoot(datas);
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                SQLUtils.cleanup((ResultSet)datas);
            }
            if (root == null) {
                return null;
            }
            ArrayList valueList = new ArrayList();
            this.getDataList(root, valueList);
            this.fillTable(valueList);
        }
        return null;
    }

    protected void fillTable2(ArrayList valueList) throws Exception {
        String orgIdColName = "FAdminOrgID";
        String orgNameColName = "FName";
        HRCellTreeRenderer orgCellRen = new HRCellTreeRenderer();
        HashMap values = null;
        HashMap map = null;
        int minLevel = -1;
        int level = -1;
        ArrayList list = null;
        ArrayList<String> longNumberList = new ArrayList<String>();
        this.parentRowMap = new HashMap();
        int count = valueList.size();
        for (int k = 0; k < count; ++k) {
            values = (HashMap)valueList.get(k);
            IRow row = this.kdtPerson.addRow();
            level = (Integer)values.get("FLevel");
            if (values.containsKey("FLongNumber")) {
                if (k == 0) {
                    minLevel = level;
                }
                this.parentRowMap.put(values.get("FAdminOrgID"), row);
                if (((Boolean)values.get("IsVisual")).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                }
                HRCellUserObject orgCellObj = new HRCellUserObject();
                orgCellObj.setCompanyId(values.get(orgIdColName).toString());
                orgCellObj.setName(values.get(orgNameColName).toString());
                orgCellObj.setLongNumber(values.get("FLongNumber").toString());
                longNumberList.add(values.get("FLongNumber").toString());
                orgCellObj.setLevel(level);
                row.setUserObject((Object)level);
                if (this.queryInfo.objType == 1) {
                    if (level == minLevel + this.queryInfo.positionLevel - 1) {
                        orgCellObj.setIsLeaf(true);
                    } else {
                        orgCellObj.setIsLeaf((Boolean)values.get("FIsLeaf"));
                    }
                } else {
                    orgCellObj.setIsLeaf((Boolean)values.get("FIsLeaf"));
                }
                orgCellObj.setExpanded(true);
                row.getCell(orgIdColName).setValue((Object)values.get(orgIdColName).toString());
                row.getCell(orgNameColName).setValue((Object)orgCellObj);
                row.getCell(orgNameColName).setRenderer((IBasicRender)orgCellRen);
                if (!Boolean.valueOf(values.get("isEnable").toString()).booleanValue()) {
                    row.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
                    continue;
                }
            } else {
                row.getCell(orgIdColName).setValue((Object)values.get(orgIdColName).toString());
                row.getCell(orgNameColName).setValue(values.get(orgNameColName));
                row.setUserObject((Object)level);
            }
            list = (ArrayList)values.get("valueList");
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                map = (HashMap)list.get(i);
                int tmpYear = (Integer)map.get("FYear");
                int tmpInteval = (Integer)map.get("FInterval");
                String tmpColNameSuffix = this.getSuffixByData(tmpYear, tmpInteval);
                String tmpLstYrColNameSuffix = this.getSuffixByLastData(tmpYear, tmpInteval);
                if (this.isInPeriodNew(tmpYear, tmpInteval, true)) {
                    row.getCell(this.getColName(tmpColNameSuffix, "COUNT")).setValue((Object)((Integer)map.get("FCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "PARTIMECOUNT")).setValue((Object)((Integer)map.get("FPartimeCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "OFFSTRCOUNT")).setValue((Object)((Integer)map.get("FOffStreCount")));
                    row.getCell(this.getColName(tmpColNameSuffix, "ONSTRCOUNT")).setValue((Object)((Integer)map.get("FOnStreCount")));
                }
                if (!this.filterInfo.isAnalyse || !this.isInPeriodNew(tmpYear, tmpInteval, false)) continue;
                row.getCell(this.getCalCuColumnKey(tmpLstYrColNameSuffix) + this.getSuffixByInterval()).setValue((Object)((Integer)map.get("FCount")));
            }
        }
        if (this.filterInfo.isAnalyse) {
            this.calcuRate();
        }
        if (this.filterInfo.isCaculatePercent) {
            if (values.containsKey("FLongNumber")) {
                if (!this.queryInfo.isDisplayBase) {
                    this.calcuPercent3(longNumberList);
                } else {
                    this.calcuPercent3Old();
                }
            } else {
                this.calcuPercentByFull();
            }
        }
    }

    private void insertBaseNode(DefaultKingdeeTreeNode root, Map nodeMap) throws Exception {
        Map userObject = (Map)root.getUserObject();
        if (!Boolean.TRUE.equals(userObject.get("FIsLeaf"))) {
            String adminOrgUnitId = (String)userObject.get("FAdminOrgID");
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)nodeMap.get(adminOrgUnitId);
            if (node != null) {
                this.setBaseNode(node);
                root.insert((MutableTreeNode)node, 0);
            }
            int count = root.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.insertBaseNode((DefaultKingdeeTreeNode)root.getChildAt(i), nodeMap);
            }
        }
    }

    private void setBaseNode(DefaultKingdeeTreeNode node) {
        node.removeAllChildren();
        Map userObject = (Map)node.getUserObject();
        userObject.put("FIsLeaf", Boolean.TRUE);
        Integer level = (Integer)userObject.get("FLevel");
        level = level != null ? Integer.valueOf(level + 1) : Integer.valueOf(0);
        userObject.put("FLevel", level);
        userObject.put("FName", userObject.get("FName") + BASE_STRING);
    }

    private void assembleNodeMap(DefaultKingdeeTreeNode root, Map nodeMap) {
        Map userObject = (Map)root.getUserObject();
        if (!Boolean.TRUE.equals(userObject.get("FIsLeaf"))) {
            String adminOrgUnitId = (String)userObject.get("FAdminOrgID");
            nodeMap.put(adminOrgUnitId, root);
            int count = root.getChildCount();
            for (int i = 0; i < count; ++i) {
                this.assembleNodeMap((DefaultKingdeeTreeNode)root.getChildAt(i), nodeMap);
            }
        }
    }

    private DefaultKingdeeTreeNode getNodeBaseData() throws Exception {
        this.setAllAdminOrgMap();
        String rootAdminOrgId = (String)((Map)this.orgRoot.getUserObject()).get("FAdminOrgID");
        DefaultKingdeeTreeNode rootNode = (DefaultKingdeeTreeNode)this.allAdminOrgMap.get(rootAdminOrgId);
        DefaultKingdeeTreeNode cloneRootNode = (DefaultKingdeeTreeNode)rootNode.clone();
        this.cloneRootNode(rootNode, cloneRootNode);
        rootNode = cloneRootNode;
        ArrayList idList = new ArrayList();
        this.addIdByOverTreeNode(rootNode, idList);
        StringBuffer sb = new StringBuffer();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(idList.get(i).toString());
            sb.append("'");
        }
        this.adminIds = sb.length() > 0 ? sb.toString() : "''";
        IRowSet datas = this.getBaseDatas();
        if (datas == null) {
            return null;
        }
        this.buildTreeNode(rootNode, datas);
        return rootNode;
    }

    private void setAllAdminOrgMap() throws Exception {
        DefaultKingdeeTreeNode rootNode = null;
        rootNode = !this.queryInfo.includeSealUp ? NewOrgTreeHelper.createAllAdminTreeNodeRefresh((boolean)true, (boolean)false) : NewOrgTreeHelper.createAllAdminTreeNodeRefresh((boolean)true, (boolean)true);
        this.allAdminOrgMap = new HashMap();
        this.allAdminOrgMap.put(this.getAdminIdByAdminNode(rootNode), rootNode);
        this.overTreeNodeSimple(rootNode, this.allAdminOrgMap);
    }

    private void cloneRootNode(DefaultKingdeeTreeNode rootNode, DefaultKingdeeTreeNode cloneRootNode) {
        DefaultKingdeeTreeNode node = null;
        DefaultKingdeeTreeNode newNode = null;
        int count = rootNode.getChildCount();
        for (int i = 0; i < count; ++i) {
            node = (DefaultKingdeeTreeNode)rootNode.getChildAt(i);
            newNode = (DefaultKingdeeTreeNode)node.clone();
            cloneRootNode.add((MutableTreeNode)newNode);
            this.cloneRootNode(node, newNode);
        }
    }

    private void deleteMostLevelNode(DefaultKingdeeTreeNode root, int level) {
        DefaultKingdeeTreeNode node = null;
        Map userObject = null;
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            userObject = (Map)node.getUserObject();
            if ((Integer)userObject.get("FLevel") == level && userObject.get("FName").toString().indexOf(BASE_STRING) == -1) {
                root.remove(i);
                continue;
            }
            if (Boolean.TRUE.equals(userObject.get("FIsLeaf"))) continue;
            this.deleteMostLevelNode(node, level);
        }
    }

    private boolean isInPeriodNew(int year, int count, boolean isCurrent) {
        if (this.filterInfo.intervalType.equals("YEAR")) {
            if (isCurrent) {
                return year >= this.beginYear && year <= this.endYear;
            }
            switch (this.filterInfo.analyseType) {
                case 2: {
                    return year >= this.beginYear - this.filterInfo.numberOfYears && year <= this.endYear - this.filterInfo.numberOfYears;
                }
            }
            return year >= this.beginYear - 1 && year <= this.endYear - 1;
        }
        if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            if (isCurrent) {
                return year * 2 + count >= this.beginYear * 2 + this.beginHalfYear && year * 2 + count <= this.endYear * 2 + this.endHalfYear;
            }
            switch (this.filterInfo.analyseType) {
                case 2: {
                    return year * 2 + count >= (this.beginYear - this.filterInfo.numberOfYears) * 2 + this.beginHalfYear && year * 2 + count <= (this.endYear - this.filterInfo.numberOfYears) * 2 + this.endHalfYear;
                }
                case 1: {
                    return year * 2 + count >= (this.beginYear - 1) * 2 + this.beginHalfYear && year * 2 + count <= (this.endYear - 1) * 2 + this.endHalfYear;
                }
            }
            return year * 2 + count >= this.beginYear * 2 + this.beginHalfYear - 1 && year * 2 + count <= this.endYear * 2 + this.endHalfYear - 1;
        }
        if (this.filterInfo.intervalType.equals("QUARTER")) {
            if (isCurrent) {
                return year * 4 + count >= this.beginYear * 4 + this.beginQuarter && year * 4 + count <= this.endYear * 4 + this.endQuarter;
            }
            switch (this.filterInfo.analyseType) {
                case 2: {
                    return year * 4 + count >= (this.beginYear - this.filterInfo.numberOfYears) * 4 + this.beginQuarter && year * 4 + count <= (this.endYear - this.filterInfo.numberOfYears) * 4 + this.endQuarter;
                }
                case 1: {
                    return year * 4 + count >= (this.beginYear - 1) * 4 + this.beginQuarter && year * 4 + count <= (this.endYear - 1) * 4 + this.endQuarter;
                }
            }
            return year * 4 + count >= this.beginYear * 4 + this.beginQuarter - 1 && year * 4 + count <= this.endYear * 4 + this.endQuarter - 1;
        }
        if (isCurrent) {
            return year * 12 + count >= this.beginYear * 12 + this.beginMonth && year * 12 + count <= this.endYear * 12 + this.endMonth;
        }
        switch (this.filterInfo.analyseType) {
            case 2: {
                return year * 12 + count >= (this.beginYear - this.filterInfo.numberOfYears) * 12 + this.beginHalfYear && year * 12 + count <= (this.endYear - this.filterInfo.numberOfYears) * 12 + this.endHalfYear;
            }
            case 1: {
                return year * 12 + count >= (this.beginYear - 1) * 12 + this.beginMonth && year * 12 + count <= (this.endYear - 1) * 12 + this.endMonth;
            }
        }
        return year * 12 + count >= this.beginYear * 12 + this.beginMonth - 1 && year * 12 + count <= this.endYear * 12 + this.endMonth - 1;
    }

    private String getColNameSuffix(int curGroup) {
        String suffix = "_";
        int year = -1;
        int num = -1;
        if (this.filterInfo.intervalType.equals("YEAR")) {
            suffix = suffix + (this.beginYear + curGroup - 1);
        } else if (this.filterInfo.intervalType.equals("QUARTER")) {
            num = (this.beginQuarter + curGroup - 1) % 4;
            year = (this.beginQuarter + curGroup - 1) / 4 + this.beginYear;
            if (num == 0) {
                num = 4;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "QUARTER";
        } else if (this.filterInfo.intervalType.equals("MONTH")) {
            num = (this.beginMonth + curGroup - 1) % 12;
            year = (this.beginMonth + curGroup - 1) / 12 + this.beginYear;
            if (num == 0) {
                num = 12;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "MONTH";
        } else if (this.filterInfo.intervalType.equals("HALFYEAR")) {
            num = (this.beginHalfYear + curGroup - 1) % 2;
            year = (this.beginHalfYear + curGroup - 1) / 2 + this.beginYear;
            if (num == 0) {
                num = 2;
                --year;
            }
            suffix = suffix + year + "_" + num + "_" + "HALFYEAR";
        }
        return suffix;
    }

    private void initTableColumn() {
        IColumn col = null;
        col = this.kdtPerson.addColumn();
        col.getStyleAttributes().setHided(true);
        col.setKey("FAdminOrgID");
        col = this.kdtPerson.addColumn();
        col.setKey("FName");
        col.setWidth(200);
        String colNameSuffix = null;
        String frmStr = this.getPercentFmtStr();
        for (int i = 1; i <= this.groupCount; ++i) {
            colNameSuffix = this.getColNameSuffix(i);
            col = this.kdtPerson.addColumn();
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey("COUNT" + colNameSuffix);
            col.setWidth(50);
            if (this.filterInfo.isCaculatePercent) {
                col = this.kdtPerson.addColumn();
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                col.setKey("PERSENT" + colNameSuffix);
                col.setWidth(70);
                if (this.queryInfo.objType == 0 || this.queryInfo.objType == 2) {
                    col.getStyleAttributes().setHided(false);
                } else {
                    col.getStyleAttributes().setHided(true);
                    col.getStyleAttributes().setLocked(true);
                    col.setWidth(0);
                }
                col.getStyleAttributes().setNumberFormat(frmStr);
            }
            if (this.filterInfo.isAnalyse) {
                col = this.kdtPerson.addColumn();
                col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
                col.setKey(this.getCalCuColumnKey(colNameSuffix));
                col.setWidth(70);
                col = this.kdtPerson.addColumn();
                col.setKey("RATE" + colNameSuffix);
                col.setWidth(50);
                col.getStyleAttributes().setNumberFormat(frmStr);
            }
            col = this.kdtPerson.addColumn();
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey("PARTIMECOUNT" + colNameSuffix);
            col.setWidth(50);
            col = this.kdtPerson.addColumn();
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey("ONSTRCOUNT" + colNameSuffix);
            col.setWidth(50);
            col = this.kdtPerson.addColumn();
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
            col.setKey("OFFSTRCOUNT" + colNameSuffix);
            col.setWidth(50);
        }
    }

    private String getHeaderCellAlias(String cellName, int index) {
        if (cellName.equals("FAdminOrgID")) {
            return "FAdminOrgID";
        }
        if (cellName.equals("FName")) {
            if (this.queryInfo.objType == 0 || this.queryInfo.objType == 2) {
                return EmployeeClientUtils.getAlias("ORGNAME");
            }
            return EmployeeClientUtils.getAlias("POSITIONNAME");
        }
        String[] strArry = StringUtils.split((String)cellName, (String)"_");
        if (index == 0) {
            if (strArry.length == 2) {
                return strArry[1] + EmployeeClientUtils.ALIAS_YEAR;
            }
            if (this.filterInfo.intervalType.equals("HALFYEAR")) {
                return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + EmployeeClientUtils.getAlias("HALFYEAR_" + strArry[2]) + EmployeeClientUtils.getAlias(strArry[3]) + EmployeeClientUtils.ALIAS_COUNTUNIT;
            }
            return strArry[1] + EmployeeClientUtils.ALIAS_YEAR + strArry[2] + EmployeeClientUtils.getAlias(strArry[3]) + EmployeeClientUtils.ALIAS_COUNTUNIT;
        }
        return EmployeeClientUtils.getAlias(strArry[0]);
    }

    private void initTableHeader() {
        IRow row = null;
        String key = null;
        row = this.kdtPerson.addHeadRow();
        int size = this.kdtPerson.getColumnCount();
        for (int i = 0; i < size; ++i) {
            key = this.kdtPerson.getColumnKey(i);
            row.getCell(key).setValue((Object)this.getHeaderCellAlias(key, 0));
        }
        row = this.kdtPerson.addHeadRow();
        String value = null;
        int size2 = this.kdtPerson.getColumnCount();
        for (int i = 0; i < size2; ++i) {
            key = this.kdtPerson.getColumnKey(i);
            value = key.indexOf("LASTYEARSCOUNT") >= 0 ? this.filterInfo.numberOfYears + this.getHeaderCellAlias(key, 1) : this.getHeaderCellAlias(key, 1);
            row.getCell(key).setValue((Object)value);
        }
        KDTMergeManager merger = this.kdtPerson.getHeadMergeManager();
        merger.mergeBlock(0, 0, 1, 0, 3);
        merger.mergeBlock(0, 1, 1, 1, 3);
        for (int i = 0; i < this.groupCount; ++i) {
            merger.mergeBlock(0, 2 + i * this.groupColCount, 0, 2 + (i + 1) * this.groupColCount - 1, 3);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getTableForOA() {
        return this.kdtPerson;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        HRSchemeUtils.checkInit();
        this.kdtPerson.checkParsed();
        this.tHelper.getDisabledTables().add(this.kdtPerson);
        this.initParam();
        HRTreeTable.setHRTreeTable(this.kdtPerson, "FName");
        this.loadFilterUI(false);
        this.kdtPerson.getStyleAttributes().setLocked(true);
        this.kdtPerson.getSelectManager().setSelectMode(10);
        this.enableExportExcel(this.kdtPerson);
        HRUtil.removePastmenu((KDTable)this.kdtPerson, (KDTMenuManager)this.getMenuManager(this.kdtPerson));
    }

    protected Object getLastEntityViewInfo() {
        HashMap<String, Serializable> lastFilterMap = new HashMap<String, Serializable>();
        lastFilterMap.put("filterInfo", this.filterInfo);
        lastFilterMap.put("queryInfo", this.queryInfo);
        return lastFilterMap;
    }

    private void setTableStyle() {
        this.kdtPerson.getSelectManager().setSelectMode(10);
        this.kdtPerson.getColumn("FAdminOrgID").getStyleAttributes().setHided(true);
        this.kdtPerson.getStyleAttributes().setLocked(true);
    }

    private void clearTable() {
        this.kdtPerson.removeRows();
        this.kdtPerson.removeColumns();
    }

    private void initUI() throws Exception {
        this.initInnerFilter();
        this.clearTable();
        this.initTableColumn();
        this.initTableHeader();
        this.noSelectedColumns = this.setNoSelectedColumns();
        this.setColumnVisibility(this.noSelectedColumns);
        this.loadTableData();
        this.setZeroCell();
        this.setTableStyle();
        int colIndex = this.kdtPerson.getColumnIndex("FName");
        this.kdtPerson.getViewManager().setFreezeView(0, colIndex);
    }

    private void setZeroCell() {
        int rowCount = this.kdtPerson.getRowCount();
        int colCount = this.kdtPerson.getColumnCount();
        IRow row = null;
        Object value = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtPerson.getRow(i);
            for (int j = 2; j < colCount; ++j) {
                value = row.getCell(j).getValue();
                if (value == null || !(value instanceof Integer && (Integer)value == 0 || value instanceof Double && (Double)value == 0.0) && (!(value instanceof String) || !((String)value).trim().equals("0"))) continue;
                row.getCell(j).setValue(null);
            }
        }
    }

    @Override
    protected void kdtPerson_tableClicked(KDTMouseEvent e) throws Exception {
    }

    private void setColumnVisibility(ArrayList list) {
        if (list == null) {
            return;
        }
        IColumn col = null;
        String colName = null;
        boolean isVisible = true;
        int size1 = this.kdtPerson.getColumnCount();
        for (int i = 0; i < size1; ++i) {
            col = this.kdtPerson.getColumn(i);
            isVisible = true;
            int size2 = list.size();
            for (int j = 0; j < size2; ++j) {
                colName = (String)list.get(j);
                if (col.getKey().indexOf(colName) != 0) continue;
                isVisible = false;
                break;
            }
            if (!isVisible) {
                col.getStyleAttributes().setHided(true);
                continue;
            }
            if (col.getKey().equals("FAdminOrgID")) continue;
            col.getStyleAttributes().setHided(false);
        }
    }

    @Override
    public void actionSetting_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"filterInfo", (Object)this.filterInfo);
        uiContext.put((Object)"queryInfo", (Object)this.queryInfo);
        uiContext.put((Object)"noSelectedColumns", (Object)this.noSelectedColumns);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpCollectSettingUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        EmpCollectSettingUI settingUI = (EmpCollectSettingUI)uiWindow.getUIObject();
        if (!settingUI.isCancel) {
            this.noSelectedColumns = settingUI.noSelectedColumns;
            this.setColumnVisibility(this.noSelectedColumns);
        }
    }

    public static QueryInfo getQueryInfo(IMetaDataPK queryPK) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        return loader.getQuery(queryPK);
    }

    public void loadFilterUI(boolean loaded) throws Exception {
        EmployeeCollectFilterNewUI filterUI = new EmployeeCollectFilterNewUI();
        EmployeeCollectFilterQueryUI queryUI = new EmployeeCollectFilterQueryUI();
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String queryName = EmployeeCollectUI.getQueryInfo(this.mainQueryPK).getFullName();
        if (this.isFirstDefaultQuery && this.getUIContext().get("RPTFilter") != null && this.getUIContext().get("RPTFilter") instanceof Map) {
            Map lastFilterMap = (Map)this.getUIContext().get("RPTFilter");
            this.queryInfo = (EmpCollQueryFilterInfo)lastFilterMap.get("queryInfo");
            this.filterInfo = (EmpCollNewFilterInfo)lastFilterMap.get("filterInfo");
            if (this.filterInfo != null && this.queryInfo != null) {
                this.initUI();
            }
            this.isFirstDefaultQuery = false;
        } else if (this.isFirstDefaultQuery && iQuery.hasDefaultSolution(this.getMetaDataPK().getFullName(), queryName)) {
            CustomerParams params;
            QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), queryName);
            QueryPanelInfo queryPanelInfo = this.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)queryUI)).getClass());
            if (queryPanelInfo != null && (params = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams())) != null) {
                queryUI.setCustomerParams(params);
            }
            this.queryInfo = queryUI.getQryFilter();
            queryPanelInfo = this.getQueryPanelInfo(solution.getQueryPanelInfo(), ((Object)((Object)filterUI)).getClass());
            if (queryPanelInfo != null && (params = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams())) != null) {
                filterUI.setCustomerParams(params);
            }
            this.filterInfo = filterUI.getQryFilter();
            if (this.filterInfo != null && this.queryInfo != null) {
                if (loaded) {
                    this.initUIWithPreSetting();
                } else {
                    this.initUI();
                }
            }
            this.isFirstDefaultQuery = false;
        } else {
            if (this.dialog == null) {
                this.dialog = new CommonQueryDialog();
                if (this.getUIWindow() == null) {
                    this.dialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
                } else {
                    this.dialog.setOwner((Component)((Object)this));
                }
                filterUI.getUIContext().put("filterInfo", this.filterInfo);
                this.dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
                this.dialog.setShowFilter(false);
                this.dialog.setShowSorter(false);
                this.dialog.setQueryObjectPK(this.mainQueryPK);
                queryUI.setPanelName(EmployeeClientUtils.getAlias("QUERY_RANG"));
                this.dialog.addUserPanel((KDPanel)queryUI);
                this.dialog.addUserPanel((KDPanel)filterUI);
                this.dialog.setMaxReturnCountVisible(false);
            }
            if (this.dialog.show()) {
                this.queryInfo = ((EmployeeCollectFilterQueryUI)this.dialog.getUserPanel(EmployeeCollectFilterQueryUI.class.getName())).getQryFilter();
                this.filterInfo = ((EmployeeCollectFilterNewUI)this.dialog.getUserPanel(EmployeeCollectFilterNewUI.class.getName())).getQryFilter();
                if (this.filterInfo != null && this.queryInfo != null) {
                    if (this.isPrepareCreateAdminTreeNode()) {
                        this.prepareCreateAdminTreeNode().callHandler();
                    }
                    if (loaded) {
                        this.initUIWithPreSetting();
                    } else {
                        this.initUI();
                    }
                }
            } else {
                SysUtil.abort();
            }
        }
    }

    private QueryPanelInfo getQueryPanelInfo(QueryPanelCollection panelCollection, Class panelClass) {
        if (panelCollection != null) {
            int size = panelCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!panelClass.getName().equals(panelCollection.get(i).getPanelClassName())) continue;
                return panelCollection.get(i);
            }
        }
        return null;
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        if (this.dialog != null && this.getUIContext() != null && "report".equals(this.getUIContext().get("UIClassParam"))) {
            this.dialog.changeOwner((Component)((Object)this));
        }
        this.loadFilterUI(true);
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        super.actionExport_actionPerformed(e);
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.initUIWithPreSetting();
    }

    private void initUIWithPreSetting() throws Exception {
        this.initInnerFilter();
        this.clearTable();
        this.initTableColumn();
        this.initTableHeader();
        this.setColumnVisibility(this.noSelectedColumns);
        this.loadTableData();
        this.setZeroCell();
        this.setTableStyle();
        int colIndex = this.kdtPerson.getColumnIndex("FName");
        this.kdtPerson.getViewManager().setFreezeView(0, colIndex);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected KDTable getTableForCommon() {
        return this.kdtPerson;
    }

    protected KDTable getTableForPrintSetting() {
        return this.kdtPerson;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = (RequestContext)handler.getRequestContext();
        request.put("className", (Object)this.getMetaDataPK().getFullName());
        return handler;
    }

    public boolean isPrepareCreateAdminTreeNode() {
        return true;
    }

    public IUIActionPostman prepareCreateAdminTreeNode() {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handlerCreateAdminTreeNode");
        request.put("classname", (Object)this.getMetaDataPK().getFullName());
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

