/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.hraux.util.HRMulCUChangeUtil;
import com.kingdee.eas.basedata.org.HROrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.util.HROrgContextManageUtil;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.EmployeeClassifyFactory;
import com.kingdee.eas.hr.base.EmployeeClassifyInfo;
import com.kingdee.eas.hr.base.client.EmployeeClassifyPromptBox;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.IHRPanelListener;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.ContractTempletCollection;
import com.kingdee.eas.hr.emp.ContractTempletFactory;
import com.kingdee.eas.hr.emp.ContractTempletInfo;
import com.kingdee.eas.hr.emp.ContractTypeFactory;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IContractTemplet;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeContractCustFilterPanel;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class EmployeeContractCustFilterPanel
extends AbstractEmployeeContractCustFilterPanel
implements IHRPanelListener {
    private static Logger logger = Logger.getLogger(EmployeeContractCustFilterPanel.class);
    boolean isZTCustomer = false;
    private String hrOrgUnitId = null;
    private Set cuSet = null;
    private boolean isContractAllHR = false;

    public void setIsZTCustomer(boolean flag) throws Exception {
        this.isZTCustomer = flag;
    }

    public void onLoad() throws Exception {
        super.onLoad();
    }

    public void initLayout() {
        super.initLayout();
        this.initPrompBox();
        this.btnRadioAll.setSelected(true);
    }

    void initPrompBox() {
        if (this.isZTCustomer) {
            EmployeeMultiF7PromptBox personPrmt = new EmployeeMultiF7PromptBox();
            personPrmt.showNoPositionPerson(true);
            personPrmt.setIsSingleSelect(true);
            personPrmt.setIsShowAllAdmin(true);
            this.PromptBoxEmployee.setSelector((KDPromptSelector)personPrmt);
            this.PromptBoxEmployee.setEditFormat("$number$");
            this.PromptBoxEmployee.setCommitFormat("$number$");
            this.PromptBoxEmployee.setDisplayFormat("$name$");
            this.PromptBoxEmployee.setHistoryRecordEnabled(false);
            this.PromptBoxEmployee.setQuickQueryEnable(false);
        }
        this.setContractNOFilter();
        this.promptContractType.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent eventObj) {
                try {
                    EmployeeContractCustFilterPanel.this.chkContractTemp_stateChanged(null);
                }
                catch (Exception e1) {
                    ExceptionHandler.handle((Throwable)e1);
                }
            }
        });
        HashSet cuSet = new HashSet();
        this.setClassifyPromptBoxF7(cuSet);
    }

    private void setClassifyPromptBoxF7(Set cuSet) {
        EmployeeClassifyPromptBox classifyPromptBox = new EmployeeClassifyPromptBox((IUIObject)this);
        classifyPromptBox.changeContextByCUSet(cuSet);
        classifyPromptBox.setIsSingleSelected(true);
        this.promptEmployeeClassify.setSelector((KDPromptSelector)classifyPromptBox);
        if (this.chkEmployeeClassify.isSelected()) {
            this.promptEmployeeClassify.setEditable(false);
            this.promptEmployeeClassify.setEnabled(true);
        } else {
            this.promptEmployeeClassify.setEditable(false);
            this.promptEmployeeClassify.setEnabled(false);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    void loadContractTemplet() throws BOSException, EASBizException {
        if (this.chkContractTemp.isSelected()) {
            this.cboContractTemp.setEnabled(true);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if (this.promptContractType.getData() != null) {
                ContractTypeInfo selectType = (ContractTypeInfo)this.promptContractType.getData();
                filter.getFilterItems().add(new FilterItemInfo("contractType.id", (Object)selectType.getId().toString()));
            } else {
                IQueryExecutor iQe = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.emp.app.ContractTypeQuery"));
                EntityViewInfo typeView = new EntityViewInfo();
                typeView.getSelector().add(new SelectorItemInfo("id"));
                FilterInfo typeFilter = new FilterInfo();
                typeFilter.getFilterItems().add(new FilterItemInfo("CU.number", (Object)HRMulCUChangeUtil.getParentCU((Set)this.cuSet), CompareType.INCLUDE));
                typeView.setFilter(typeFilter);
                iQe.setObjectView(typeView);
                String sql = iQe.getSQL();
                sql = sql.replaceAll("\"CONTRACTTYPE\".FLongNumber ASC", "");
                sql = sql.replaceAll("ORDER BY", "");
                filter.getFilterItems().add(new FilterItemInfo("contractType.id", (Object)sql, CompareType.INNER));
            }
            filter = HRUtil.customMergeFilter((FilterInfo)filter, (FilterInfo)this.getD1FilterOfCT(), (String)"AND");
            view.setFilter(filter);
            this.initContractTempletComboxBox(view);
        } else {
            this.cboContractTemp.setEnabled(false);
            this.cboContractTemp.setModel(new DefaultComboBoxModel());
        }
    }

    private FilterInfo getD1FilterOfCT() throws EASBizException, BOSException {
        FilterInfo retFilter = null;
        return retFilter;
    }

    private void initContractTempletComboxBox(EntityViewInfo view) throws BOSException {
        IContractTemplet iTemp = ContractTempletFactory.getRemoteInstance();
        ContractTempletCollection tempCols = null;
        tempCols = view == null ? iTemp.getContractTempletCollection() : iTemp.getContractTempletCollection(view);
        if (tempCols == null) {
            return;
        }
        Iterator ter = tempCols.iterator();
        DefaultComboBoxModel<ContractTempletInfo> model = new DefaultComboBoxModel<ContractTempletInfo>();
        ContractTempletInfo tempInfo = null;
        while (ter.hasNext()) {
            tempInfo = (ContractTempletInfo)ter.next();
            model.addElement(tempInfo);
        }
        this.cboContractTemp.setModel(model);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo filterItemInfo1;
        FilterItemInfo filterItemInfo;
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo fInfo = new FilterInfo();
        String strMask = "";
        int iFCounts = 0;
        int curFormulaCount = 0;
        if (this.chkPerson.isSelected() && this.PromptBoxEmployee.getData() != null) {
            filterItemInfo = new FilterItemInfo("employee.id", (Object)((PersonInfo)this.PromptBoxEmployee.getData()).getId().toString());
            fInfo.getFilterItems().add(filterItemInfo);
            sbFormula.append("( #" + iFCounts + " )");
            ++curFormulaCount;
        }
        if (this.chkContractType.isSelected() && this.promptContractType.getData() != null) {
            filterItemInfo = new FilterItemInfo("contractType.id", (Object)((ContractTypeInfo)this.promptContractType.getData()).getId().toString());
            fInfo.getFilterItems().add(filterItemInfo);
            if (sbFormula.toString().indexOf("#" + iFCounts) > 0) {
                if (sbFormula.toString().indexOf("#" + (iFCounts + 1)) > 0) {
                    sbFormula.append(" and ( #" + (iFCounts + 2) + " ) ");
                } else {
                    sbFormula.append(" and ( #" + (iFCounts + 1) + " ) ");
                }
            } else {
                sbFormula.append(" ( #" + iFCounts + " ) ");
            }
            ++curFormulaCount;
        }
        if (this.chkContractTemp.isSelected() && this.cboContractTemp.getSelectedItem() != null) {
            filterItemInfo1 = new FilterItemInfo("contractTemplet.id", (Object)((ContractTempletInfo)this.cboContractTemp.getSelectedItem()).getId().toString());
            fInfo.getFilterItems().add(filterItemInfo1);
            if (sbFormula.toString().indexOf("#" + iFCounts) > 0) {
                if (sbFormula.toString().indexOf("#" + (iFCounts + 1)) > 0) {
                    if (sbFormula.toString().indexOf("#" + (iFCounts + 2)) > 0) {
                        sbFormula.append(" and ( #" + (iFCounts + 3) + " ) ");
                    } else {
                        sbFormula.append(" and ( #" + (iFCounts + 2) + " ) ");
                    }
                } else {
                    sbFormula.append(" and ( #" + (iFCounts + 1) + " ) ");
                }
            } else {
                sbFormula.append(" ( #" + iFCounts + " ) ");
            }
            ++curFormulaCount;
        }
        if (this.chkContractNO.isSelected() && this.pmtContractNoFrom.getData() != null && this.pmtContractNoTo.getData() != null) {
            filterItemInfo1 = new FilterItemInfo("contractNo", (Object)((EmployeeContractInfo)this.pmtContractNoFrom.getData()).getContractNo(), CompareType.GREATER_EQUALS);
            FilterItemInfo filterItemInfo2 = new FilterItemInfo("contractNo", (Object)((EmployeeContractInfo)this.pmtContractNoTo.getData()).getContractNo(), CompareType.LESS_EQUALS);
            fInfo.getFilterItems().add(filterItemInfo1);
            fInfo.getFilterItems().add(filterItemInfo2);
            if (sbFormula.toString().indexOf("#" + iFCounts) > 0) {
                if (sbFormula.toString().indexOf("#" + (iFCounts + 1)) > 0) {
                    if (sbFormula.toString().indexOf("#" + (iFCounts + 2)) > 0) {
                        if (sbFormula.toString().indexOf("#" + (iFCounts + 3)) > 0) {
                            sbFormula.append(" and ( #" + (iFCounts + 4) + " and #" + (iFCounts + 5) + " ) ");
                        } else {
                            sbFormula.append(" and ( #" + (iFCounts + 3) + " and #" + (iFCounts + 4) + " ) ");
                        }
                    } else {
                        sbFormula.append(" and (#" + (iFCounts + 2) + " and #" + (iFCounts + 3) + ") ");
                    }
                } else {
                    sbFormula.append(" and (#" + (iFCounts + 1) + " and #" + (iFCounts + 2) + " ) ");
                }
            } else {
                sbFormula.append(" ( #" + iFCounts + " and #" + (iFCounts + 1) + ") ");
            }
            curFormulaCount += 2;
        }
        if (this.chkEmployeeClassify.isSelected() && this.promptEmployeeClassify.getData() != null) {
            filterItemInfo = new FilterItemInfo("employee.employeeClassify.id", (Object)((EmployeeClassifyInfo)this.promptEmployeeClassify.getData()).getId().toString());
            fInfo.getFilterItems().add(filterItemInfo);
            if (curFormulaCount == 0) {
                sbFormula.append(" ( #" + curFormulaCount + " ) ");
            } else {
                sbFormula.append(" and ( #" + curFormulaCount + " ) ");
            }
        }
        Date now = new Date();
        SimpleDateFormat sf = new SimpleDateFormat(CtrlFormatUtilities.getDateFormatString());
        String nowStr = sf.format(now);
        Calendar cal = Calendar.getInstance();
        cal.setTime(now);
        cal.add(5, -1);
        Date nextDate = cal.getTime();
        String yesStr = sf.format(nextDate);
        if (this.btnRadioHistory.isSelected()) {
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)4));
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)5));
            fInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)yesStr, CompareType.LESS_EQUALS));
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.NOTEQUALS));
            this.contractStateMaskString(sbFormula, true);
        }
        if (this.btnRadioNowContract.isSelected()) {
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)4, CompareType.NOTEQUALS));
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)5, CompareType.NOTEQUALS));
            fInfo.getFilterItems().add(new FilterItemInfo("state", (Object)0, CompareType.NOTEQUALS));
            fInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)nowStr, CompareType.GREATER_EQUALS));
            fInfo.getFilterItems().add(new FilterItemInfo("endDate", null));
            fInfo.getFilterItems().add(new FilterItemInfo("effectDate", (Object)nowStr, CompareType.LESS_EQUALS));
            this.contractStateMaskString(sbFormula, false);
        }
        if (!strMask.equals("")) {
            if (sbFormula.toString().equals("")) {
                fInfo.setMaskString(strMask);
            } else {
                fInfo.setMaskString(strMask + " and " + sbFormula.toString());
            }
        } else {
            fInfo.setMaskString(sbFormula.toString());
        }
        return fInfo;
    }

    private void contractStateMaskString(StringBuffer sbFormula, boolean isHistory) {
        String[] maskList = sbFormula.toString().split("#");
        int size = maskList.length - 1;
        if (!sbFormula.toString().equals("")) {
            sbFormula.append(" and");
        }
        if (isHistory) {
            sbFormula.append(" (( #" + size + " or #" + (size + 1) + ") or (#" + (size + 2) + " and #" + (size + 3) + ")) ");
        } else {
            sbFormula.append(" (#" + size + " and #" + (size + 1) + " and #" + (size + 2) + " and (#" + (size + 3) + " or #" + (size + 4) + ") and #" + (size + 5) + ") ");
        }
    }

    private void setContractNOFilter() {
        try {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)this.hrOrgUnitId));
            viewInfo.setFilter(filterInfo);
            this.pmtContractNoFrom.setEntityViewInfo(viewInfo);
            this.pmtContractNoTo.setEntityViewInfo(viewInfo);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public SorterItemCollection getSorterItems() {
        return super.getSorterItems();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }

    @Override
    protected void chkContractNO_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkContractNO.isSelected()) {
            this.pmtContractNoFrom.setEnabled(true);
            this.pmtContractNoTo.setEnabled(true);
        } else {
            this.pmtContractNoFrom.setEnabled(false);
            this.pmtContractNoTo.setEnabled(false);
            this.pmtContractNoFrom.setData(null);
            this.pmtContractNoTo.setData(null);
        }
    }

    @Override
    protected void chkEmployeeClassify_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkEmployeeClassify.isSelected()) {
            this.promptEmployeeClassify.setEnabled(true);
        } else {
            this.promptEmployeeClassify.setEnabled(false);
            this.promptEmployeeClassify.setData(null);
        }
    }

    @Override
    protected void chkContractTemp_stateChanged(ChangeEvent e) throws Exception {
        this.loadContractTemplet();
    }

    @Override
    protected void chkContractType_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkContractType.isSelected()) {
            this.promptContractType.setEnabled(true);
        } else {
            this.promptContractType.setEnabled(false);
            this.promptContractType.setData(null);
        }
    }

    @Override
    protected void chkPerson_stateChanged(ChangeEvent e) throws Exception {
        if (this.chkPerson.isSelected()) {
            this.PromptBoxEmployee.setEnabled(true);
        } else {
            this.PromptBoxEmployee.setEnabled(false);
            this.PromptBoxEmployee.setData(null);
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        cp.putBoolean("IsSelectPerson", this.chkPerson.isSelected());
        cp.putBoolean("IsSelectContractType", this.chkContractType.isSelected());
        cp.putBoolean("IsSelectContractTemp", this.chkContractTemp.isSelected());
        cp.putBoolean("IsSelectContractNo", this.chkContractNO.isSelected());
        cp.putBoolean("IsSelectEmployeeClassify", this.chkEmployeeClassify.isSelected());
        if (this.PromptBoxEmployee.getData() != null) {
            cp.addCustomerParam("PersonInfo", ((PersonInfo)this.PromptBoxEmployee.getData()).getId().toString());
        }
        if (this.promptContractType.getData() != null) {
            cp.addCustomerParam("ContractType", ((ContractTypeInfo)this.promptContractType.getData()).getId().toString());
        }
        if (this.cboContractTemp.getSelectedIndex() != -1) {
            cp.addCustomerParam("ContractTemp", ((ContractTempletInfo)this.cboContractTemp.getSelectedItem()).getId().toString());
        }
        if (this.pmtContractNoFrom.getData() != null) {
            cp.addCustomerParam("ContractFrom", ((EmployeeContractInfo)this.pmtContractNoFrom.getData()).getId().toString());
        }
        if (this.pmtContractNoTo.getData() != null) {
            cp.addCustomerParam("ContractTo", ((EmployeeContractInfo)this.pmtContractNoTo.getData()).getId().toString());
        }
        if (this.promptEmployeeClassify.getData() != null) {
            cp.addCustomerParam("EmployeeClassify", ((EmployeeClassifyInfo)this.promptEmployeeClassify.getData()).getId().toString());
        }
        cp.putBoolean("RadioNow", this.btnRadioNowContract.isSelected());
        cp.putBoolean("RadioHistory", this.btnRadioHistory.isSelected());
        cp.putBoolean("RadioAll", this.btnRadioAll.isSelected());
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.chkPerson.setSelected(cp.getBoolean("IsSelectPerson"));
        this.chkContractType.setSelected(cp.getBoolean("IsSelectContractType"));
        this.chkContractTemp.setSelected(cp.getBoolean("IsSelectContractTemp"));
        this.chkContractNO.setSelected(cp.getBoolean("IsSelectContractNo"));
        this.chkEmployeeClassify.setSelected(cp.getBoolean("IsSelectEmployeeClassify"));
        this.btnRadioNowContract.setSelected(cp.getBoolean("RadioNow"));
        this.btnRadioHistory.setSelected(cp.getBoolean("RadioHistory"));
        this.btnRadioAll.setSelected(cp.getBoolean("RadioAll"));
        try {
            if (cp.getCustomerParam("PersonInfo") != null) {
                PersonInfo perInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("PersonInfo")));
                this.PromptBoxEmployee.setData((Object)perInfo);
            } else {
                this.PromptBoxEmployee.setData(null);
            }
            if (cp.getCustomerParam("ContractFrom") != null) {
                EmployeeContractInfo contFromInfo = EmployeeContractFactory.getRemoteInstance().getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("ContractFrom")));
                this.pmtContractNoFrom.setData((Object)contFromInfo);
            } else {
                this.pmtContractNoFrom.setData(null);
            }
            if (cp.getCustomerParam("ContractTo") != null) {
                EmployeeContractInfo contToInfo = EmployeeContractFactory.getRemoteInstance().getEmployeeContractInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("ContractTo")));
                this.pmtContractNoTo.setData((Object)contToInfo);
            } else {
                this.pmtContractNoTo.setData(null);
            }
            if (cp.getCustomerParam("ContractType") != null) {
                ContractTypeInfo contTypeInfo = ContractTypeFactory.getRemoteInstance().getContractTypeInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("ContractType")));
                this.promptContractType.setData((Object)contTypeInfo);
            } else {
                this.promptContractType.setData(null);
            }
            if (cp.getCustomerParam("ContractTemp") != null) {
                ContractTempletInfo contTempletInfo = ContractTempletFactory.getRemoteInstance().getContractTempletInfo((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("ContractTemp")));
                this.cboContractTemp.setSelectedItem((Object)contTempletInfo);
            } else {
                this.cboContractTemp.setSelectedIndex(-1);
            }
            if (cp.getCustomerParam("EmployeeClassify") != null) {
                this.promptEmployeeClassify.setData((Object)EmployeeClassifyFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(cp.getCustomerParam("EmployeeClassify"))));
            } else {
                this.promptEmployeeClassify.setData(null);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage());
        }
    }

    public void clear() {
        this.chkPerson.setSelected(false);
        this.chkContractType.setSelected(false);
        this.chkContractTemp.setSelected(false);
        this.chkContractNO.setSelected(false);
        this.chkEmployeeClassify.setSelected(false);
        this.PromptBoxEmployee.setData(null);
        this.pmtContractNoFrom.setData(null);
        this.pmtContractNoTo.setData(null);
        this.promptContractType.setData(null);
        this.cboContractTemp.setSelectedItem(null);
        this.promptEmployeeClassify.setData(null);
        this.btnRadioNowContract.setSelected(false);
        this.btnRadioHistory.setSelected(false);
        this.btnRadioAll.setSelected(true);
    }

    public void registerF7(IHRF7CommonRegister register) {
        if (this.isContractAllHR) {
            EmployeeMultiF7PromptBox promptBox = new EmployeeMultiF7PromptBox((IUIObject)this);
            promptBox.setIsShowAllAdmin(true);
            promptBox.showNoPositionPerson(true);
            this.PromptBoxEmployee.setSelector((KDPromptSelector)promptBox);
            this.PromptBoxEmployee.setEditable(false);
        } else {
            register.registerEmployeeMultiF7PromptBox(this.PromptBoxEmployee, true);
        }
        this.PromptBoxEmployee.setHistoryRecordEnabled(false);
        this.PromptBoxEmployee.setQuickQueryEnable(false);
        register.registerContractTypePromptBox(this.promptContractType);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        HROrgUnitInfo hrOrgUnitInfo = (HROrgUnitInfo)chgVo.getNewOrg();
        if (hrOrgUnitInfo != null) {
            this.hrOrgUnitId = hrOrgUnitInfo.getId().toString();
            HROrgUnitCollection collection = new HROrgUnitCollection();
            collection.add(hrOrgUnitInfo);
            this.cuSet = HROrgContextManageUtil.convertHROrgsToCUs((HROrgUnitCollection)collection);
            this.setClassifyPromptBoxF7(this.cuSet);
        }
        this.cboContractTemp.removeAllItems();
        this.pmtContractNoFrom.setValue(null);
        this.pmtContractNoTo.setValue(null);
        try {
            this.loadContractTemplet();
            this.setContractNOFilter();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean isContractAllHR() {
        return this.isContractAllHR;
    }

    public void setContractAllHR(boolean isContractAllHR) {
        this.isContractAllHR = isContractAllHR;
    }

    public boolean verify() {
        Object contractNoFrom = this.pmtContractNoFrom.getData();
        Object contractNoTo = this.pmtContractNoTo.getData();
        if (contractNoFrom != null && contractNoTo != null && ((EmployeeContractInfo)contractNoFrom).getContractNo().compareTo(((EmployeeContractInfo)contractNoTo).getContractNo()) > 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource", (String)"BEFORE_LESS_ERROR"));
            this.pmtContractNoFrom.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

