/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.ContractTypeInfo;
import com.kingdee.eas.hr.emp.EmployeeContractCollection;
import com.kingdee.eas.hr.emp.EmployeeContractFactory;
import com.kingdee.eas.hr.emp.EmployeeContractInfo;
import com.kingdee.eas.hr.emp.IEmployeeContract;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeContractUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class EmployeeContractUI
extends AbstractEmployeeContractUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();
    protected KDComboBox cboType = new KDComboBox();
    protected KDComboBox cboContract = new KDComboBox();
    GregorianCalendar cal = new GregorianCalendar(2199, 11, 31);

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        super.actionInsert_actionPerformed(e);
        IRow curRow = EmployeeClientUtils.addNewKDTableRow(this.kdtQueryEmployeeContractQuery);
        curRow.getCell("startDate").setValue((Object)new Date());
        curRow.getCell("effectDate").setValue((Object)new Date());
        curRow.getCell("toDate").setValue((Object)this.cal.getTime());
        curRow.getCell("endDate").setValue((Object)this.cal.getTime());
        curRow.getCell("contractNo").setValue((Object)this.getCodingRuleNumber());
    }

    @Override
    public void actionDelete_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelete_actionPerformed(e);
        EmployeeClientUtils.deleteKDTableRow(this.kdtQueryEmployeeContractQuery, this.delList);
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    void initCboTypeEvent() {
        this.cboType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                try {
                    EmployeeContractUI.this.cboContractType_itemStateChanged(e);
                }
                catch (Exception exc) {
                    EmployeeContractUI.this.handUIException(exc);
                }
            }
        });
    }

    void cboContractType_itemStateChanged(ItemEvent e) throws BOSException {
        ContractTypeInfo selectType = (ContractTypeInfo)this.cboType.getSelectedItem();
        if (selectType == null) {
            return;
        }
        DefaultComboBoxModel model = EmployeeClientUtils.getContractModelByType(selectType);
        this.cboContract.setModel((ComboBoxModel)model);
    }

    private void loadEmployeeContract() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        EmployeeContractCollection c = this.getPLColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.kdtQueryEmployeeContractQuery.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    private EmployeeContractCollection getPLColl(String empId) throws BOSException {
        IEmployeeContract ipl = EmployeeContractFactory.getRemoteInstance();
        String oql = "select id,contractNo,recordDate,effectDate,freeDate,endDate,toUnit,contractTemplet.id, contractTemplet.contractType.id";
        oql = oql + " where employee.id = '" + empId + "'";
        return ipl.getEmployeeContractCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtQueryEmployeeContractQuery.removeRows();
        this.loadEmployeeContract();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnInsert, (JButton)this.btnDelete);
        this.kdtQueryEmployeeContractQuery.checkParsed();
        this.kdtQueryEmployeeContractQuery.getStyleAttributes().setWrapText(true);
        this.setTableCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtQueryEmployeeContractQuery);
            this.btnInsert.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
        this.initCboTypeEvent();
        DefaultComboBoxModel model = EmployeeClientUtils.getLoadContractTypeModel();
        this.cboType.setModel((ComboBoxModel)model);
        this.cboContractType_itemStateChanged(null);
        if (this.isUsingCodingRule()) {
            this.kdtQueryEmployeeContractQuery.getColumn("contractNo").getStyleAttributes().setLocked(true);
        } else {
            this.kdtQueryEmployeeContractQuery.getColumn("contractNo").getStyleAttributes().setLocked(false);
        }
        this.loadFields();
    }

    private String getCodingRuleNumber() {
        String curCodingRuleNumber = null;
        try {
            EmployeeContractInfo newInfo = new EmployeeContractInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String appOUID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)newInfo);
            if (iCodingRuleManager.isExist((IObjectValue)newInfo, appOUID)) {
                curCodingRuleNumber = iCodingRuleManager.isUseIntermitNumber((IObjectValue)newInfo, appOUID) ? iCodingRuleManager.readNumber((IObjectValue)newInfo, appOUID) : iCodingRuleManager.getNumber((IObjectValue)newInfo, appOUID);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return curCodingRuleNumber;
    }

    private boolean isUsingCodingRule() {
        try {
            EmployeeContractInfo newInfo = new EmployeeContractInfo();
            ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            String appOUID = iCodingRuleManager.getCurrentAppOUID((IObjectValue)newInfo);
            if (iCodingRuleManager.isExist((IObjectValue)newInfo, appOUID)) {
                return true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return false;
    }

    void setTableCellEditor() {
        this.kdtQueryEmployeeContractQuery.getColumn("contractType").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboType));
        this.kdtQueryEmployeeContractQuery.getColumn("contractTemplet").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)this.cboContract));
        KDBizPromptBox prmtToUnit = new KDBizPromptBox();
        prmtToUnit.setSelector((KDPromptSelector)new AdminByCurrentHROF7WithOrgRangeFilter());
        this.kdtQueryEmployeeContractQuery.getColumn("toUnit").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtToUnit));
        this.kdtQueryEmployeeContractQuery.getColumn("startDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtQueryEmployeeContractQuery.getColumn("startDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtQueryEmployeeContractQuery.getColumn("effectDate").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtQueryEmployeeContractQuery.getColumn("effectDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtQueryEmployeeContractQuery.getColumn("toDate").setEditor(EmployeeClientUtils.getEndDateCellEditor());
        this.kdtQueryEmployeeContractQuery.getColumn("toDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
        this.kdtQueryEmployeeContractQuery.getColumn("endDate").setEditor(EmployeeClientUtils.getEndDateCellEditor());
        this.kdtQueryEmployeeContractQuery.getColumn("endDate").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("IdCardNO"));
        sic.add(new SelectorItemInfo("PassportNO"));
        sic.add(new SelectorItemInfo("Address"));
        PersonInfo empInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(this.empId), sic);
        IEmployeeContract ipl = EmployeeContractFactory.getRemoteInstance();
        ipl.saveAll(EmployeeClientUtils.getEmployeeContractCollectionByKDTable(this.kdtQueryEmployeeContractQuery, empInfo), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "contractNo");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "contractType");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "contractTemplet");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "toUnit");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "startDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "effectDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "toDate");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryEmployeeContractQuery, "endDate");
        EmployeeClientUtils.checkHasInputRows(this.kdtQueryEmployeeContractQuery, this.delList);
        EmployeeClientUtils.checkTableCellDup(this.kdtQueryEmployeeContractQuery, "contractNo");
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        this.kdtQueryEmployeeContractQuery.setEnabled(false);
        this.btnInsert.setEnabled(false);
        this.btnDelete.setEnabled(false);
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

