/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.OrgInnerUtils;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeEditUI2;
import com.kingdee.eas.hr.emp.client.EmpInfoTypeInfo;
import com.kingdee.eas.hr.emp.client.EmployeeBaseInfoUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.EmployeePositionUI;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;

public class EmployeeEditUI2
extends AbstractEmployeeEditUI2 {
    protected String empId = null;
    protected CoreUIObject uiObj = null;
    private PositionInfo postInfo = null;

    private void loadNameAndNumber(String empId) throws Exception {
        if (empId == null) {
            return;
        }
        String[] values = EmployeeClientUtils.getNameAndNumber(empId);
        this.txtName2.setText(values[0]);
        this.txtNumber2.setText(values[1]);
    }

    private void loadPosition(String empId) throws Exception {
        if (empId == null) {
            return;
        }
        this.txtPosition.setText(EmployeeClientUtils.getPosition(empId));
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        this.postInfo = (PositionInfo)this.getUIContext().get("PositionNode");
        this.loadNameAndNumber(this.empId);
        this.loadPosition(this.empId);
        OrgInnerUtils.initWorkButton((KDWorkButton)this.btnAddNew, (KDWorkButton)this.btnSave, (KDWorkButton)this.btnSubmit, (KDWorkButton)this.btnCopy, (KDWorkButton)this.btnCancelCancel, (KDWorkButton)this.btnCancel, (KDWorkButton)this.btnFirst, (KDWorkButton)this.btnPre, (KDWorkButton)this.btnNext, (KDWorkButton)this.btnLast, (KDWorkButton)this.btnPrint, (KDWorkButton)this.btnPrintPreview);
        EmployeeClientUtils.initEmpInfoTypeTree(this.treeTypeInfo);
    }

    protected IObjectValue createNewData() {
        return new PersonInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstance();
    }

    protected void loadUiObj(EmpInfoTypeInfo info) throws Exception {
        if (this.pnlInfo.getViewport().getComponents().length > 0) {
            this.pnlInfo.getViewport().removeAll();
        }
        this.uiObj = (CoreUIObject)UIFactoryHelper.initUIObject((String)info.getEditUI(), (Map)this.getUIContext(), null, (String)this.getOprtState());
        if (this.uiObj.getPreferredSize().width == 0 || this.uiObj.getPreferredSize().height == 0) {
            if (this.uiObj.getLayout() == null) {
                this.uiObj.setBounds(0, 0, 780, 600);
            } else if (this.uiObj.getLayout() instanceof KDLayout) {
                this.uiObj.setSize(780, 600);
            }
        } else {
            this.uiObj.setBounds(0, 0, this.uiObj.getPreferredSize().width, this.uiObj.getPreferredSize().height);
        }
        this.pnlInfo.getViewport().add((Component)this.uiObj);
    }

    @Override
    protected void treeTypeInfo_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeTypeInfo_valueChanged(e);
        KDTreeNode selectedNode = (KDTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
        if (!(selectedNode.getUserObject() instanceof EmpInfoTypeInfo)) {
            return;
        }
        EmpInfoTypeInfo selectedType = (EmpInfoTypeInfo)selectedNode.getUserObject();
        if (selectedType.getId() != 0 && this.empId == null) {
            this.treeTypeInfo.setSelectionPath(e.getOldLeadSelectionPath());
            throw new EmployeeException(EmployeeException.EMPLOYEE_NEED_SAVE_BASEINFO_FIRST);
        }
        this.loadUiObj(selectedType);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        KDTreeNode selectedNode = (KDTreeNode)this.treeTypeInfo.getSelectionPath().getLastPathComponent();
        if (!(selectedNode.getUserObject() instanceof EmpInfoTypeInfo)) {
            return;
        }
        if (this.uiObj instanceof IEmpInfoUI) {
            if (this.uiObj instanceof EmployeeBaseInfoUI) {
                String empId = null;
                EmployeeClientUtils.savePM(this.postInfo, EmployeeClientUtils.getPersonInfo(empId));
                this.oprtState = OprtState.EDIT;
                this.getUIContext().put("ID", empId);
                this.loadNameAndNumber(empId);
                if (this.txtPosition.getText() != null || this.txtPosition.getText().trim().length() == 0) {
                    this.loadPosition(empId);
                }
            } else {
                ((IEmpInfoUI)this.uiObj).submit();
                if (this.uiObj instanceof EmployeePositionUI) {
                    this.loadPosition(this.getUIContext().get("ID").toString());
                }
            }
        }
    }
}

