/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.hraux.PoliticalFaceFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.RelationFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonFamily;
import com.kingdee.eas.hr.emp.PersonFamilyCollection;
import com.kingdee.eas.hr.emp.PersonFamilyFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeFamilyUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JButton;

public class EmployeeFamilyUI
extends AbstractEmployeeFamilyUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkHasInputRows(this.kdtFamily, this.delList);
        EmployeeClientUtils.checkTableCellIsNull(this.kdtFamily, "name");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtFamily, "relation");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtFamily, "workUnit");
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonFamily ipf = PersonFamilyFactory.getRemoteInstance();
        ipf.saveAll(EmployeeClientUtils.getFamilyCollectionByKDTable(this.kdtFamily, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    private void setF7CellEditor() throws BOSException {
        this.kdtFamily.getColumn("relation").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)RelationFactory.getRemoteInstance()));
        this.kdtFamily.getColumn("politicalFace").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)PoliticalFaceFactory.getRemoteInstance()));
    }

    private void setDateEditor() {
        this.kdtFamily.getColumn("birthday").setEditor(EmployeeClientUtils.getStartDateCellEditor());
        this.kdtFamily.getColumn("birthday").getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateFormatString());
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    private PersonFamilyCollection getFamilyColl(String empId) throws BOSException {
        IPersonFamily ipf = PersonFamilyFactory.getRemoteInstance();
        String oql = "select *, relation.id, relation.name, relation.number, politicalFace.id, politicalFace.name, politicalFace.number,degree.name,degree.number where person.id = '" + empId + "'";
        return ipf.getPersonFamilyCollection(oql);
    }

    private void refresh() throws Exception {
        this.kdtFamily.removeRows();
        this.loadRecords();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnFamilyAddNew, (JButton)this.btnFamilyDelete);
        this.kdtFamily.checkParsed();
        this.setF7CellEditor();
        this.setDateEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtFamily);
            this.btnFamilyAddNew.setEnabled(false);
            this.btnFamilyDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtFamily, "name");
        EmployeeClientUtils.setColumnBackColor(this.kdtFamily, "relation");
        EmployeeClientUtils.setColumnBackColor(this.kdtFamily, "workUnit");
        this.kdtFamily.getStyleAttributes().setWrapText(true);
        this.firstOnLoad();
        this.initCellEditLength();
    }

    void initCellEditLength() {
        EmployeeClientUtils.setCellEditor(this.kdtFamily, "name");
        EmployeeClientUtils.setCellEditor(this.kdtFamily, "workUnit");
        EmployeeClientUtils.setCellEditor(this.kdtFamily, "homeAddress");
        this.kdtFamily.getColumn("homePhone").setEditor(EmployeeClientUtils.getFilterTextFieldCellEditor(25, 20));
        this.kdtFamily.getColumn("officePhone").setEditor(EmployeeClientUtils.getFilterTextFieldCellEditor(25, 20));
        this.kdtFamily.getColumn("idCardNO").setEditor(EmployeeClientUtils.getFilterTextFieldCellEditor(25, 18));
    }

    private void loadRecords() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonFamilyCollection c = this.getFamilyColl(this.empId);
        Object row = null;
        for (int i = 0; i < c.size(); ++i) {
            EmployeeClientUtils.setTableCellValueByInfo(this.kdtFamily.addRow(), c.get(i));
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionFamilyAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtFamily);
    }

    @Override
    public void actionFamilyDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtFamily, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.kdtFamily.setEnabled(false);
            this.btnFamilyAddNew.setEnabled(false);
            this.btnFamilyDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

