/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.emp.EmpHisCompareEnum;
import com.kingdee.eas.hr.emp.EmployeeHisSettingCollection;
import com.kingdee.eas.hr.emp.EmployeeHisSettingFactory;
import com.kingdee.eas.hr.emp.EmployeeHisSettingInfo;
import com.kingdee.eas.hr.emp.EmployeeHistoryUtils;
import com.kingdee.eas.hr.emp.LeftBracketEnum;
import com.kingdee.eas.hr.emp.LogicSignEnum;
import com.kingdee.eas.hr.emp.RightBracketEnum;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeHistoryFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class EmployeeHistoryFilterUI
extends AbstractEmployeeHistoryFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeHistoryFilterUI.class);
    private static final String COLUMN_LEFT = "left";
    private static final String COLUMN_RIGHT = "right";
    private static final String COLUMN_PROPERTY = "property";
    private static final String COLUMN_CONDITION = "condition";
    private static final String COLUMN_VALUE = "value";
    private static final String COLUMN_BEGINDATE = "beginDate";
    private static final String COLUMN_ENDDATE = "endDate";
    private static final String COLUMN_LOGIC = "logic";
    private static final String SEPERATOR_CLAUSE = "!";
    private static final String SEPERATOR_LINE = "~";
    private int personCount = 0;
    private HashSet personIdSet = null;
    private String fullStr = null;
    private String fullSql = null;
    private boolean hasQuery = false;
    private EmployeeHisSettingCollection ehsColl = null;

    public EmployeeHistoryFilterUI() throws Exception {
        this.tblFilter.checkParsed();
        this.tblFilter.getColumn(COLUMN_BEGINDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
        this.tblFilter.getColumn(COLUMN_ENDDATE).getStyleAttributes().setNumberFormat(CtrlFormatUtilities.getDateTimeFormatString());
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private IRow addRow() throws Exception {
        IRow row = this.tblFilter.addRow();
        row.getCell(COLUMN_LEFT).setEditor(this.getLeftBracketCellEditor());
        row.getCell(COLUMN_RIGHT).setEditor(this.getRightBracketCellEditor());
        row.getCell(COLUMN_LOGIC).setEditor(this.getLogicCellEditor());
        row.getCell(COLUMN_PROPERTY).setEditor(this.getPropertyCellEditor());
        row.getCell(COLUMN_BEGINDATE).setEditor(this.getDateCellEditor());
        row.getCell(COLUMN_ENDDATE).setEditor(this.getDateCellEditor());
        return row;
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow();
    }

    @Override
    public void actionDeleteRow_actionPerformed(ActionEvent e) throws Exception {
        int index = this.tblFilter.getSelectManager().getActiveRowIndex();
        if (index != -1) {
            this.tblFilter.removeRow(index);
        }
    }

    public ICellEditor getDateCellEditor() {
        KDDatePicker dp = new KDDatePicker();
        dp.setTimeEnabled(true);
        return new KDTDefaultCellEditor(dp);
    }

    public ICellEditor getLogicCellEditor() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        KDComboBox combo = new KDComboBox(model);
        model.addElement(null);
        Iterator iter = LogicSignEnum.iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    public ICellEditor getPropertyCellEditor() throws Exception {
        DefaultComboBoxModel<EmployeeHisSettingInfo> model = new DefaultComboBoxModel<EmployeeHisSettingInfo>();
        KDComboBox combo = new KDComboBox(model);
        model.addElement(null);
        if (this.ehsColl == null) {
            this.ehsColl = EmployeeHisSettingFactory.getRemoteInstance().getEmployeeHisSettingCollection();
        }
        int size = this.ehsColl.size();
        for (int i = 0; i < size; ++i) {
            model.addElement(this.ehsColl.get(i));
        }
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    public ICellEditor getLeftBracketCellEditor() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        KDComboBox combo = new KDComboBox(model);
        model.addElement(null);
        Iterator iter = LeftBracketEnum.iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    public ICellEditor getRightBracketCellEditor() {
        DefaultComboBoxModel model = new DefaultComboBoxModel();
        KDComboBox combo = new KDComboBox(model);
        model.addElement(null);
        Iterator iter = RightBracketEnum.iterator();
        while (iter.hasNext()) {
            model.addElement(iter.next());
        }
        return new KDTDefaultCellEditor((JComboBox)combo);
    }

    public ICellEditor getEmptyCellEditor() {
        return new KDTDefaultCellEditor((JTextField)new KDTextField());
    }

    @Override
    protected void tblFilter_editStopped(KDTEditEvent e) throws Exception {
        if (e.getOldValue() == null && e.getValue() == null || e.getOldValue() != null && e.getValue() != null && e.getOldValue().equals(e.getValue())) {
            return;
        }
        EmployeeHisSettingInfo info = null;
        IRow row = null;
        row = this.tblFilter.getRow(e.getRowIndex());
        if (e.getColIndex() == this.tblFilter.getColumnIndex(COLUMN_PROPERTY)) {
            info = (EmployeeHisSettingInfo)e.getValue();
            if (info == null) {
                row.getCell(COLUMN_CONDITION).setValue(null);
                row.getCell(COLUMN_VALUE).setValue(null);
                row.getCell(COLUMN_CONDITION).setEditor(null);
                row.getCell(COLUMN_VALUE).setEditor(null);
            } else {
                row.getCell(COLUMN_CONDITION).setEditor(EmployeeHistoryUtils.getCompareCellEditorByType(info.getType()));
                row.getCell(COLUMN_VALUE).setEditor(EmployeeHistoryUtils.getCellEditorByPropertyInfo(info));
                row.getCell(COLUMN_CONDITION).setValue(null);
                row.getCell(COLUMN_VALUE).setValue(null);
            }
        }
        EmpHisCompareEnum condition = null;
        if (e.getColIndex() == this.tblFilter.getColumnIndex(COLUMN_CONDITION) && ((condition = (EmpHisCompareEnum)((Object)e.getValue())).getValue() == 10 || condition.getValue() == 11)) {
            row.getCell(COLUMN_VALUE).setValue(null);
        }
    }

    protected String getBracketNotMatchingWarning() {
        String bracketNotMatchingWarning = null;
        int rowCount = this.tblFilter.getRowCount();
        int balance = 0;
        for (int i = 0; i < rowCount; ++i) {
            RightBracketEnum rightBracketSignEnum;
            int j;
            String bracketValue;
            LeftBracketEnum leftBracketSignEnum;
            int brackAmount = 0;
            Object object = null;
            object = this.tblFilter.getRow(i).getCell(COLUMN_LEFT).getValue();
            if (object != null && object.toString() != null && !object.toString().equalsIgnoreCase("") && (leftBracketSignEnum = (LeftBracketEnum)((Object)object)) != null && (bracketValue = leftBracketSignEnum.getValue()) != null) {
                brackAmount = bracketValue.length();
                for (j = 0; j < brackAmount; ++j) {
                    ++balance;
                }
            }
            if ((object = this.tblFilter.getRow(i).getCell(COLUMN_RIGHT).getValue()) == null || object.toString() == null || object.toString().equalsIgnoreCase("") || (rightBracketSignEnum = (RightBracketEnum)((Object)object)) == null || (bracketValue = rightBracketSignEnum.getValue()) == null) continue;
            brackAmount = bracketValue.length();
            for (j = 0; j < brackAmount; ++j) {
                --balance;
            }
        }
        if (balance != 0) {
            bracketNotMatchingWarning = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"bracketWarning");
        }
        return bracketNotMatchingWarning;
    }

    protected String getExistBlankColumnWarning() {
        String customerFilterWarning = null;
        if (this.checkInvaildFilter()) {
            customerFilterWarning = EASResource.getString((String)"com.kingdee.eas.base.commonquery.client.CommonFilterPanel", (String)"blankRowWarning");
        }
        return customerFilterWarning;
    }

    protected boolean isBlankRow(int rowIndex) {
        int columnSize = this.tblFilter.getColumnCount();
        for (int i = 0; i < columnSize; ++i) {
            if (Util.getValue((Object)this.tblFilter.getRow(rowIndex).getCell(i).getValue()).toString().trim().equalsIgnoreCase("")) continue;
            return false;
        }
        return true;
    }

    protected boolean isBlankCell(ICell cell) {
        if (cell.getValue() == null) {
            return true;
        }
        return cell.getValue().toString().equalsIgnoreCase("");
    }

    private boolean checkInvaildFilter() {
        int rowCount = this.tblFilter.getRowCount();
        EmpHisCompareEnum condition = null;
        Object obj = null;
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            if (this.isBlankRow(i)) continue;
            row = this.tblFilter.getRow(i);
            obj = row.getCell(COLUMN_CONDITION).getValue();
            if (obj != null && !obj.toString().equals("")) {
                condition = (EmpHisCompareEnum)((Object)obj);
                if (!(condition.getValue() == 10 || condition.getValue() == 11 ? this.isBlankCell(row.getCell(COLUMN_PROPERTY)) || this.isBlankCell(row.getCell(COLUMN_BEGINDATE)) && this.isBlankCell(row.getCell(COLUMN_ENDDATE)) : this.isBlankCell(row.getCell(COLUMN_PROPERTY)) || this.isBlankCell(row.getCell(COLUMN_VALUE)) || this.isBlankCell(row.getCell(COLUMN_BEGINDATE)) && this.isBlankCell(row.getCell(COLUMN_ENDDATE)))) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private String getCellStr(ICell cell) {
        if (cell.getValue() == null) {
            return "";
        }
        return cell.getValue().toString();
    }

    private String getValueStrByType(String type, ICell cell) {
        if (cell.getValue() == null) {
            return "";
        }
        Object obj = null;
        if (type.equals("BOOLEAN")) {
            obj = cell.getValue();
            return (Boolean)obj != false ? "1" : "0";
        }
        if (type.equals("DATE")) {
            return String.valueOf(((Date)cell.getValue()).getTime());
        }
        if (type.equals("DECIMAL") || type.equals("DOUBLE") || type.equals("INT") || type.equals("STRING") || type.equals("FLOAT")) {
            return cell.getValue().toString();
        }
        if (type.equals("ENUM")) {
            obj = cell.getValue();
            if (obj instanceof IntEnum) {
                return String.valueOf(((IntEnum)obj).getValue());
            }
            if (obj instanceof StringEnum) {
                return ((StringEnum)obj).getValue();
            }
        } else {
            if (type.equals("REF")) {
                return ((IObjectValue)cell.getValue()).get("id").toString();
            }
            if (type.equals("TIMESTAMP")) {
                return String.valueOf(((KDDatePicker)cell.getEditor().getComponent()).getTimestamp().getTime());
            }
        }
        return cell.getValue().toString();
    }

    protected String getRowStr(IRow row) throws BOSException {
        StringBuffer sb = new StringBuffer();
        EmployeeHisSettingInfo info = (EmployeeHisSettingInfo)row.getCell(COLUMN_PROPERTY).getValue();
        if (info == null) {
            throw new BOSException("propertyInfo is error");
        }
        sb.append(info.getId().toString());
        sb.append(SEPERATOR_CLAUSE);
        sb.append(info.getType());
        sb.append(SEPERATOR_CLAUSE);
        LeftBracketEnum left = (LeftBracketEnum)((Object)row.getCell(COLUMN_LEFT).getValue());
        if (left != null) {
            sb.append(left.getValue());
        } else {
            sb.append("");
        }
        sb.append(SEPERATOR_CLAUSE);
        sb.append(info.getEntity());
        sb.append(SEPERATOR_CLAUSE);
        sb.append(info.getProperty());
        sb.append(SEPERATOR_CLAUSE);
        EmpHisCompareEnum conditionEnum = (EmpHisCompareEnum)((Object)row.getCell(COLUMN_CONDITION).getValue());
        if (conditionEnum != null) {
            sb.append(conditionEnum.getValue());
        } else {
            sb.append("");
        }
        sb.append(SEPERATOR_CLAUSE);
        sb.append(this.getValueStrByType(info.getType(), row.getCell(COLUMN_VALUE)));
        sb.append(SEPERATOR_CLAUSE);
        if (row.getCell(COLUMN_BEGINDATE).getValue() != null && !row.getCell(COLUMN_BEGINDATE).getValue().toString().equals("")) {
            sb.append(String.valueOf(((Date)row.getCell(COLUMN_BEGINDATE).getValue()).getTime()));
        }
        sb.append(SEPERATOR_CLAUSE);
        if (row.getCell(COLUMN_ENDDATE).getValue() != null && !row.getCell(COLUMN_ENDDATE).getValue().toString().equals("")) {
            sb.append(String.valueOf(((Date)row.getCell(COLUMN_ENDDATE).getValue()).getTime()));
        }
        sb.append(SEPERATOR_CLAUSE);
        RightBracketEnum right = (RightBracketEnum)((Object)row.getCell(COLUMN_RIGHT).getValue());
        if (right != null) {
            sb.append(right.getValue());
        } else {
            sb.append("");
        }
        sb.append(SEPERATOR_CLAUSE);
        LogicSignEnum logic = (LogicSignEnum)((Object)row.getCell(COLUMN_LOGIC).getValue());
        if (logic != null) {
            sb.append(logic.getValue());
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    protected String buildFullStr() throws BOSException {
        StringBuffer sb = new StringBuffer();
        int size = this.tblFilter.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                sb.append(SEPERATOR_LINE);
            }
            sb.append(this.getRowStr(this.tblFilter.getRow(i)));
        }
        return sb.toString();
    }

    protected String getValueSqlClause(String condition, String value) {
        int intValue = Integer.parseInt(condition);
        String parsedCondi = EmployeeHistoryUtils.getConditionSignByEnumValue(intValue);
        StringBuffer sb = new StringBuffer();
        sb.append(" FValueString ");
        if (parsedCondi.equals("=")) {
            sb.append("=");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals("=")) {
            sb.append("=");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals(">")) {
            sb.append(">");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals("%LIKE")) {
            sb.append("LIKE");
            sb.append(" '");
            sb.append(value);
            sb.append("%'");
        } else if (parsedCondi.equals("<=")) {
            sb.append("<=");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals("<")) {
            sb.append("<");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals("LIKE")) {
            sb.append("LIKE");
            sb.append(" '%");
            sb.append(value);
            sb.append("%'");
        } else if (parsedCondi.equals("<>")) {
            sb.append("<>");
            sb.append(" '");
            sb.append(value);
            sb.append("'");
        } else if (parsedCondi.equals("NOT LIKE")) {
            sb.append("=");
            sb.append(" '%");
            sb.append(value);
            sb.append("%'");
        } else if (parsedCondi.equals("IS NOT NULL")) {
            sb.append("=");
        } else if (parsedCondi.equals("")) {
            sb.append("");
        } else if (parsedCondi.equals("IS NULL")) {
            sb.append("IS NULL");
        } else if (parsedCondi.equals("LIKE%")) {
            sb.append("LIKE");
            sb.append(" '%");
            sb.append(value);
            sb.append("'");
        }
        sb.append(" ");
        return sb.toString();
    }

    protected String getParseSql(String fullStr) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT DISTINCT FPersonId  \n");
        sb.append("FROM T_HR_EmployeeHistory \n");
        sb.append("WHERE ");
        String[] lines = StringUtils.split((String)fullStr, (String)SEPERATOR_LINE);
        if (lines.length == 1 && lines[0].equals("")) {
            return null;
        }
        for (int i = 0; i < lines.length; ++i) {
            if (i == lines.length - 1) {
                sb.append(this.getParseLineSql(lines[i], true));
                continue;
            }
            sb.append(this.getParseLineSql(lines[i], false));
        }
        return sb.toString();
    }

    private String getKSQLDateStrByLongStr(String longStr) {
        Date date = new Date();
        date.setTime(Long.valueOf(longStr));
        StringBuffer sb = new StringBuffer();
        sb.append("{ts'");
        sb.append(new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(date));
        sb.append("'}");
        return sb.toString();
    }

    protected String getParseLineSql(String lineStr, boolean isLastLine) throws EASBizException, BOSException, UuidException {
        String[] clauseStr = StringUtils.split((String)lineStr, (String)SEPERATOR_CLAUSE);
        String empHisSettingId = clauseStr[0];
        String leftBracket = clauseStr[2];
        String condition = clauseStr[5];
        String value = clauseStr[6];
        String beginDate = clauseStr[7];
        String endDate = clauseStr[8];
        String rightBracket = clauseStr[9];
        String logicSign = clauseStr[10];
        EmployeeHisSettingInfo ehsInfo = this.getEmpHisSettingInfo(empHisSettingId);
        StringBuffer sb = new StringBuffer();
        sb.append(leftBracket);
        sb.append("FPersonID IN \n (SELECT FPersonId FROM T_HR_EmployeeHistory WHERE ");
        sb.append("FEntity = '");
        sb.append(ehsInfo.getEntity());
        sb.append("' AND FProperty = '");
        sb.append(ehsInfo.getProperty());
        sb.append("' AND ");
        sb.append(this.getValueSqlClause(condition, value));
        if (!beginDate.equals("")) {
            sb.append(" AND ");
            sb.append("FBeginTime >= ");
            sb.append(this.getKSQLDateStrByLongStr(beginDate));
        }
        if (!endDate.equals("")) {
            sb.append(" AND ");
            sb.append("FEndTime < ");
            sb.append(this.getKSQLDateStrByLongStr(endDate));
        }
        sb.append(") ");
        sb.append(rightBracket);
        if (!isLastLine) {
            if (!logicSign.equals("")) {
                sb.append(" ");
                sb.append(logicSign);
                sb.append(" ");
            } else {
                sb.append(" ");
                sb.append("and");
                sb.append(" ");
            }
        }
        sb.append(" \n");
        return sb.toString();
    }

    protected void setRowByStr(IRow row, String lineStr) throws Exception {
        Date date;
        String[] clauseStr = StringUtils.split((String)lineStr, (String)SEPERATOR_CLAUSE);
        String empHisSettingId = clauseStr[0];
        String type = clauseStr[1];
        String leftBracket = clauseStr[2];
        String condition = clauseStr[5];
        String value = clauseStr[6];
        String beginDate = clauseStr[7];
        String endDate = clauseStr[8];
        String rightBracket = clauseStr[9];
        String logicSign = clauseStr[10];
        EmployeeHisSettingInfo info = this.getEmpHisSettingInfo(empHisSettingId);
        if (empHisSettingId != null) {
            row.getCell(COLUMN_CONDITION).setEditor(EmployeeHistoryUtils.getCompareCellEditorByType(info.getType()));
            row.getCell(COLUMN_VALUE).setEditor(EmployeeHistoryUtils.getCellEditorByPropertyInfo(info));
        }
        row.getCell(COLUMN_PROPERTY).setValue((Object)info);
        if (!leftBracket.equals("")) {
            LeftBracketEnum leftEnum = LeftBracketEnum.getEnum(leftBracket);
            row.getCell(COLUMN_LEFT).setValue((Object)leftEnum);
        }
        if (!condition.equals("")) {
            EmpHisCompareEnum conditionEnum = EmpHisCompareEnum.getEnum(Integer.parseInt(condition));
            row.getCell(COLUMN_CONDITION).setValue((Object)conditionEnum);
        }
        if (!value.equals("")) {
            if (type.equals("BOOLEAN")) {
                if (value.equals("0")) {
                    row.getCell(COLUMN_VALUE).setValue((Object)Boolean.FALSE);
                } else if (value.equals("1")) {
                    row.getCell(COLUMN_VALUE).setValue((Object)Boolean.TRUE);
                }
            } else if (type.equals("DATE") || type.equals("TIMESTAMP")) {
                Long time = Long.valueOf(value);
                Date date2 = new Date();
                date2.setTime(time);
                row.getCell(COLUMN_VALUE).setValue((Object)date2);
            } else if (type.equals("DECIMAL") || type.equals("DOUBLE") || type.equals("FLOAT") || type.equals("STRING") || type.equals("INT")) {
                row.getCell(COLUMN_VALUE).setValue((Object)value);
            } else if (type.equals("ENUM")) {
                Class<?> eClass = Class.forName(info.getFullEnum());
                Iterator iter = EnumUtils.iterator(eClass);
                IntEnum enum0 = null;
                Object obj = null;
                if (iter.hasNext()) {
                    obj = iter.next();
                    if (obj instanceof IntEnum) {
                        enum0 = EnumUtils.getEnum(eClass, (int)Integer.parseInt(value));
                    } else if (obj instanceof StringEnum) {
                        enum0 = EnumUtils.getEnum(eClass, (String)value);
                    }
                    row.getCell(COLUMN_VALUE).setValue((Object)enum0);
                }
            } else if (type.equals("REF")) {
                row.getCell(COLUMN_VALUE).setValue((Object)this.getOvById(value));
            }
        }
        if (!beginDate.equals("")) {
            date = new Date();
            date.setTime(Long.valueOf(beginDate));
            row.getCell(COLUMN_BEGINDATE).setValue((Object)date);
        }
        if (!endDate.equals("")) {
            date = new Date();
            date.setTime(Long.valueOf(endDate));
            row.getCell(COLUMN_ENDDATE).setValue((Object)date);
        }
        if (!rightBracket.equals("")) {
            RightBracketEnum rightEnum = RightBracketEnum.getEnum(rightBracket);
            row.getCell(COLUMN_RIGHT).setValue((Object)rightEnum);
        }
        if (!logicSign.equals("")) {
            LogicSignEnum logicEnum = LogicSignEnum.getEnum(logicSign);
            row.getCell(COLUMN_LOGIC).setValue((Object)logicEnum);
        }
    }

    protected EmployeeHisSettingInfo getEmpHisSettingInfo(String id) throws EASBizException, BOSException, UuidException {
        return EmployeeHisSettingFactory.getRemoteInstance().getEmployeeHisSettingInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
    }

    protected IObjectValue getOvById(String id) throws BOSException {
        BOSUuid bosId = BOSUuid.read((String)id);
        return DynamicObjectFactory.getRemoteInstance().getValue(bosId.getType(), (IObjectPK)new ObjectUuidPK(bosId));
    }

    protected void setTableRowByFullStr(String fullString) throws Exception {
        if (fullString == null || fullString.equals("")) {
            return;
        }
        this.tblFilter.removeRows();
        String[] rowStrs = StringUtils.split((String)fullString, (String)SEPERATOR_LINE);
        for (int i = 0; i < rowStrs.length; ++i) {
            this.setRowByStr(this.addRow(), rowStrs[i]);
        }
    }

    public void clear() {
        super.clear();
        this.tblFilter.removeRows();
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = new CustomerParams();
        try {
            cp.addCustomerParam("fullStr", this.buildFullStr());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return cp;
    }

    public FilterInfo getFilterInfo() {
        if (this.fullSql != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.fullSql, CompareType.INNER));
            return filter;
        }
        return new FilterInfo();
    }

    public void setCustomerParams(CustomerParams cp) {
        if (cp == null) {
            return;
        }
        this.fullStr = cp.getCustomerParam("fullStr");
        try {
            this.setTableRowByFullStr(this.fullStr);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        String existBlankColumnWarning = this.getExistBlankColumnWarning();
        if (existBlankColumnWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)existBlankColumnWarning);
            return false;
        }
        String bracketNotMatchingWarning = this.getBracketNotMatchingWarning();
        if (bracketNotMatchingWarning != null) {
            MsgBox.showWarning((Component)((Object)this), (String)bracketNotMatchingWarning);
            return false;
        }
        try {
            this.fullStr = this.buildFullStr();
            this.fullSql = this.getParseSql(this.fullStr);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        EmployeeClientUtils.initTableBtn((JButton)this.btnAddRow, (JButton)this.btnDeleteRow);
    }
}

