/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.LanguageCollection;
import com.kingdee.eas.basedata.assistant.LanguageInfo;
import com.kingdee.eas.basedata.hraux.IBasicItem;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.LangGradeFactory;
import com.kingdee.eas.hr.base.client.ListEditUI;
import com.kingdee.eas.hr.emp.IPersonLanguage;
import com.kingdee.eas.hr.emp.PersonLanguageCollection;
import com.kingdee.eas.hr.emp.PersonLanguageFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeLanguageUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.emp.client.IEmpInfoUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;

public class EmployeeLanguageUI
extends AbstractEmployeeLanguageUI
implements IEmpInfoUI {
    private String empId = null;
    private PersonInfo pInfo = null;
    private ArrayList delList = new ArrayList();

    private void checkInput() throws Exception {
        EmployeeClientUtils.checkHasInputRows(this.kdtQueryPersonLangQuery, this.delList);
        EmployeeClientUtils.checkTableCellDup(this.kdtQueryPersonLangQuery, "language");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryPersonLangQuery, "language");
        EmployeeClientUtils.checkTableCellIsNull(this.kdtQueryPersonLangQuery, "grade");
    }

    @Override
    public void submit() throws Exception {
        this.checkInput();
        IObjectPK[] delArray = new IObjectPK[this.delList.size()];
        for (int i = 0; i < this.delList.size(); ++i) {
            delArray[i] = new ObjectUuidPK((BOSUuid)this.delList.get(i));
        }
        IPersonLanguage ipl = PersonLanguageFactory.getRemoteInstance();
        ipl.saveAll(EmployeeClientUtils.getLangCollectionByKDTable(this.kdtQueryPersonLangQuery, EmployeeClientUtils.getPersonInfo(this.empId)), delArray);
        ListEditUI listEditUI = (ListEditUI)this.getUIContext().get("ListEditUI");
        listEditUI.setStatusBarMessage();
        this.refresh();
    }

    @Override
    public void actionLangSave_actionPerformed(ActionEvent e) throws Exception {
        this.submitAssignment();
    }

    private void setTableCellEditor() throws Exception {
        this.setLanguageEditor();
        this.setGradeEditor();
    }

    public void firstOnLoad() throws Exception {
        this.refresh();
    }

    @Override
    public void secondLoad() throws Exception {
        this.firstOnLoad();
    }

    public void onLoad() throws Exception {
        this.empId = (String)this.getUIContext().get("ID");
        super.onLoad();
        EmployeeClientUtils.initTableBtn((JButton)this.btnLangAddNew, (JButton)this.btnLangDelete);
        this.kdtQueryPersonLangQuery.checkParsed();
        this.setTableCellEditor();
        if (this.getOprtState().equals(OprtState.VIEW)) {
            EmployeeClientUtils.setKDTableViewState(this.kdtQueryPersonLangQuery);
            this.btnLangAddNew.setEnabled(false);
            this.btnLangDelete.setEnabled(false);
        }
        EmployeeClientUtils.setColumnBackColor(this.kdtQueryPersonLangQuery, "grade");
        EmployeeClientUtils.setColumnBackColor(this.kdtQueryPersonLangQuery, "language");
        this.kdtQueryPersonLangQuery.getStyleAttributes().setWrapText(true);
        EmployeeClientUtils.setCellEditor(this.kdtQueryPersonLangQuery, "level");
        EmployeeClientUtils.setCellEditor(this.kdtQueryPersonLangQuery, "certifyName");
        EmployeeClientUtils.setCellEditor(this.kdtQueryPersonLangQuery, "certifyNumber");
        this.loadFields();
    }

    private void setLanguageEditor() throws Exception {
        LanguageCollection c = new LanguageCollection();
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.LanguageQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        IRowSet rows = queryExcu.executeQuery();
        LanguageInfo info = null;
        while (rows.next()) {
            info = new LanguageInfo();
            info.setId(BOSUuid.read((String)rows.getString("id")));
            info.setName(rows.getString("name"));
            c.add(info);
        }
        DefaultComboBoxModel<LanguageInfo> model = new DefaultComboBoxModel<LanguageInfo>();
        for (int i = 0; i < c.size(); ++i) {
            model.addElement(c.get(i));
        }
        if (c.size() != 0) {
            model.setSelectedItem(c.get(0));
        }
        this.kdtQueryPersonLangQuery.getColumn("language").setEditor(EmployeeClientUtils.getComboBoxCellEditor(model));
    }

    private void setGradeEditor() throws Exception {
        this.kdtQueryPersonLangQuery.getColumn("grade").setEditor(EmployeeClientUtils.getComboBoxCellEditor((IBasicItem)LangGradeFactory.getRemoteInstance()));
    }

    private PersonLanguageCollection getPLColl(String empId) throws BOSException {
        IPersonLanguage ipl = PersonLanguageFactory.getRemoteInstance();
        String oql = "select id, language.id, language.name, language.number, grade.id, grade.name, grade.number,level,certifyName,certifyNumber ";
        oql = oql + " where person.id = '" + empId + "'";
        return ipl.getPersonLanguageCollection(oql);
    }

    private void loadLangs() throws Exception {
        if (this.getUIContext().get("ID") != null) {
            this.empId = this.getUIContext().get("ID").toString();
        }
        PersonLanguageCollection c = this.getPLColl(this.empId);
        IRow row = null;
        for (int i = 0; i < c.size(); ++i) {
            row = this.kdtQueryPersonLangQuery.addRow();
            EmployeeClientUtils.setTableCellValueByInfo(row, c.get(i));
        }
    }

    private void refresh() throws Exception {
        this.kdtQueryPersonLangQuery.removeRows();
        this.loadLangs();
    }

    @Override
    protected void kdtQueryPersonLangQuery_editStopped(KDTEditEvent e) throws Exception {
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            this.refresh();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)e);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionLangAddNew_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.addNewKDTableRow(this.kdtQueryPersonLangQuery);
    }

    @Override
    public void actionLangDelete_actionPerformed(ActionEvent e) throws Exception {
        EmployeeClientUtils.deleteKDTableRow(this.kdtQueryPersonLangQuery, this.delList);
    }

    @Override
    public void setAddNewState() throws Exception {
        EmployeeClientUtils.setAddNewState((CoreUI)this);
        this.refresh();
    }

    @Override
    public void setEmpID(String empId) {
        this.empId = empId;
    }

    @Override
    public void setEnabled(boolean isArchives) {
        if (!isArchives) {
            this.kdtQueryPersonLangQuery.setEnabled(false);
            this.btnLangAddNew.setEnabled(false);
            this.btnLangDelete.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.submit();
    }

    protected void inOnload() throws Exception {
    }
}

