/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IPromptBoxFactory;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.hr.base.client.f7.HRPromptBoxFactory;
import com.kingdee.eas.hr.emp.EmployeeManageFacadeFactory;
import com.kingdee.eas.hr.emp.IEmployeeManageFacade;
import com.kingdee.eas.hr.emp.IPositionSortFacade;
import com.kingdee.eas.hr.emp.PositionSortFacadeFactory;
import com.kingdee.eas.hr.emp.client.AbstractEmployeeSortUI;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.emp.client.EmployeeSortFilterUI;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmployeeSortUI
extends AbstractEmployeeSortUI {
    private static final Logger logger = CoreUIObject.getLogger(EmployeeSortUI.class);
    private String strResource = "com.kingdee.eas.basedata.org.client.OUResource";
    private HashMap indexMap = null;
    private Map positionMap = new HashMap();
    private boolean isFirstLoad = true;
    private boolean showLongName = false;
    static final String RESOURCE = "com.kingdee.eas.hr.emp.PositionSortResource";

    protected String getEditUIName() {
        return EmployeeTreeEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PersonFactory.getRemoteInstance();
    }

    @Override
    public void actionBtnOK_actionPerformed(ActionEvent e) throws Exception {
        super.actionBtnOK_actionPerformed(e);
        HashMap personMap = new HashMap();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            personMap.put(this.indexMap.get(i), this.tblMain.getRow(i).getCell("id").getValue());
        }
        if (personMap.size() == 0) {
            return;
        }
        IPersonFacade iPF = PersonFacadeFactory.getRemoteInstance();
        iPF.updatePersonIndex(personMap);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"229_EmployeeSortUI"));
    }

    @Override
    public void actionMoveBottom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveBottom_actionPerformed(e);
        this.checkSelect();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            int rowCount = this.tblMain.getRowCount();
            if (endIndex == this.tblMain.getRowCount() - 1) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = rowCount - (endIndex - beginIndex) - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(rowCount - (endIndex - beginIndex) - 1, 0, index, 1, 2));
            this.tblMain.scrollToVisible(rowCount - (endIndex - beginIndex) - 1, index);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveDown_actionPerformed(e);
        this.checkSelect();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            if (endIndex == this.tblMain.getRowCount() - 1) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = beginIndex + 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex + 1, 0, endIndex + 1, 1, 2));
            this.tblMain.scrollToVisible(beginIndex + 1, endIndex + 1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionMoveTo_actionPerformed(ActionEvent e) throws Exception {
        int toIndex;
        super.actionMoveTo_actionPerformed(e);
        if (this.txtNum.getIntegerValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"230_EmployeeSortUI"));
            SysUtil.abort();
        }
        if ((toIndex = this.txtNum.getIntegerValue() - 1) + 1 > this.tblMain.getRowCount()) {
            return;
        }
        this.checkSelect();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            if (toIndex >= beginIndex && toIndex <= endIndex) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = 0;
            index = toIndex > endIndex ? toIndex - (endIndex - beginIndex) : toIndex;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            if (toIndex > endIndex) {
                this.tblMain.getSelectManager().select(new KDTSelectBlock(toIndex - (endIndex - beginIndex), 0, toIndex, 0, 2));
            } else {
                this.tblMain.getSelectManager().select(new KDTSelectBlock(toIndex, 0, toIndex + (endIndex - beginIndex), 0, 2));
            }
            this.tblMain.scrollToVisible(toIndex, endIndex - beginIndex);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveTop_actionPerformed(e);
        this.checkSelect();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            int endIndex;
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            if (beginIndex == 0) {
                return;
            }
            for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = 0;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(0, 0, endIndex - beginIndex, 1, 2));
            this.tblMain.scrollToVisible(0, endIndex - beginIndex);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveUp_actionPerformed(e);
        this.checkSelect();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            int endIndex;
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            if (beginIndex == 0) {
                return;
            }
            for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = beginIndex - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex - 1, 0, endIndex - 1, 1, 2));
            this.tblMain.scrollToVisible(beginIndex - 1, endIndex - 1);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.strResource, (String)"PLEASE_SELECT_ROW"));
        }
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelect();
        EmployeeMultiF7PromptBox f7 = new EmployeeMultiF7PromptBox();
        f7.setModal(true);
        f7.setIsSingleSelect(false);
        f7.setReturnPositionAndUnit(false);
        f7.setIsShowAllAdmin(true);
        f7.show();
        if (!f7.isCanceled() && f7.getData() instanceof Object[]) {
            Object[] obj = (Object[])f7.getData();
            this.insertPersonsToTable(obj);
            this.refreshList();
        }
    }

    private void insertPersonsToTable(Object[] obj) throws BOSException {
        if (obj == null) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        String indexObj = (String)this.tblMain.getCell(block.getBeginRow(), "index").getValue();
        int index = 0;
        if (indexObj != null) {
            index = Integer.valueOf(indexObj);
        }
        int personSize = obj.length;
        String[] persons = new String[personSize];
        for (int i = 0; i < personSize; ++i) {
            persons[i] = ((PersonInfo)obj[i]).getId().toString();
        }
        PersonFactory.getRemoteInstance().insertPersons(index, persons);
    }

    private void checkSelect() throws Exception {
        ArrayList blocks;
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((blocks = this.tblMain.getSelectManager().getBlocks()) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (blocks.size() > 1) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"231_EmployeeSortUI"));
            SysUtil.abort();
        }
    }

    public void onLoad() throws Exception {
        CustomerParams params;
        QueryPanelInfo panelInfo;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String cureQueryName = EmployeeSortUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo querySolution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        if (querySolution != null && (panelInfo = this.getQueryPanelInfo(querySolution.getQueryPanelInfo(), EmployeeSortFilterUI.class)) != null && panelInfo.getCustomerParams() != null && (params = CustomerParams.getCustomerParams2((String)panelInfo.getCustomerParams())) != null) {
            this.showLongName = params.getBoolean("SHOW_DISPLAYNAME");
        }
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.checkInitIndex();
        if (querySolution == null) {
            this.refresh(null);
        }
        this.isFirstLoad = false;
    }

    private QueryPanelInfo getQueryPanelInfo(QueryPanelCollection panelCollection, Class panelClass) {
        if (panelCollection != null) {
            int size = panelCollection.size();
            for (int i = 0; i < size; ++i) {
                if (!panelClass.getName().equals(panelCollection.get(i).getPanelClassName())) continue;
                return panelCollection.get(i);
            }
        }
        return null;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            if (!this.isFirstLoad && this.getDialog() != null && this.getDialog().getUserPanels().size() > 0) {
                EmployeeSortFilterUI filterUI = (EmployeeSortFilterUI)this.getDialog().getUserPanel(0);
                this.showLongName = filterUI.chkDisplayName.isSelected();
            }
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
            if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0 && !this.mainQuery.getFilter().toString().equals("")) {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                this.mainQuery.setFilter(filterInfo);
            }
            IEmployeeManageFacade emFacade = EmployeeManageFacadeFactory.getRemoteInstance();
            IRowSet rowSet = emFacade.getQueryRowSet(this.mainQueryPK, this.mainQuery);
            this.fillTableData(rowSet);
            this.txtNum.setMaximumValue((Comparable)Integer.valueOf(rowSet.size()));
            this.txtNum.setMinimumValue((Comparable)Integer.valueOf(1));
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    public void checkInitIndex() throws Exception {
        StringBuffer sql = new StringBuffer("SELECT MAX(FIndex) AS FIndex ");
        sql.append("FROM T_BD_Person  ");
        ISQLExecutor iSQL = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = iSQL.executeSQL();
        while (rows.next()) {
            if (rows.getInt(1) != 0) continue;
            IPersonFacade iPF = PersonFacadeFactory.getRemoteInstance();
            iPF.initPersonIndex();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain_doRequestRowSet(null);
    }

    public void fillTableData(IRowSet rowSet) throws Exception {
        this.tblMain.removeRows();
        String id = null;
        String index = null;
        String number = null;
        String name = null;
        String admin = null;
        String position = null;
        String positionSortCode = null;
        IRow row = null;
        this.indexMap = new HashMap();
        if (this.positionMap != null) {
            this.positionMap.clear();
        }
        while (rowSet.next()) {
            id = rowSet.getString("id");
            index = rowSet.getString("indexOf");
            number = rowSet.getString("number");
            name = rowSet.getString("name");
            admin = this.showLongName ? rowSet.getString("AdminUnit.displayName") : rowSet.getString("AdminUnit.name");
            position = rowSet.getString("Position.name");
            positionSortCode = rowSet.getString("Position.sortCode");
            row = this.tblMain.addRow();
            if (index == null) {
                index = "0";
            }
            if (positionSortCode != null) {
                this.positionMap.put(id, positionSortCode);
            }
            this.indexMap.put(row.getRowIndex(), index);
            row.getCell("id").setValue((Object)id);
            row.getCell("index").setValue((Object)index);
            row.getCell("number").setValue((Object)number);
            row.getCell("name").setValue((Object)name);
            row.getCell("admin").setValue((Object)admin);
            row.getCell("position").setValue((Object)position);
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            EmployeeSortFilterUI filterUI = new EmployeeSortFilterUI();
            dialog.addUserPanel((KDPanel)filterUI);
            dialog.setMaxReturnCountVisible(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dialog;
    }

    protected IPromptBoxFactory getPromptBoxFactory() {
        try {
            return HRPromptBoxFactory.getUserOrgRangerInstance();
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        int rowcount = this.tblMain.getRowCount();
        if (this.txtNum.getIntegerValue() != null && this.txtNum.getIntegerValue() > rowcount) {
            this.txtNum.setMaximumValue((Comparable)Integer.valueOf(rowcount));
            this.txtNum.setMinimumValue((Comparable)Integer.valueOf(1));
            this.txtNum.setValue((Object)rowcount);
        }
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (uiContext.get((Object)"ID") != null) {
            RealModeIDList idList = new RealModeIDList();
            idList.add(uiContext.get((Object)"ID").toString());
            uiContext.put((Object)"IDList", (Object)idList);
        }
    }

    @Override
    public void actionInit_actionPerformed(ActionEvent e) throws Exception {
        int msg = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"positionSort_22"));
        if (msg == 0) {
            IPositionSortFacade ps = PositionSortFacadeFactory.getRemoteInstance();
            ps.initEmployeeIndex(this.positionMap);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.emp.PersonalResource.init_success"));
            this.refreshList();
        }
    }
}

