/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.client.UIActionPostman;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.client.AbstractHRAdminQueryPanelUI;
import com.kingdee.eas.hr.emp.client.EmployeeClientUtils;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import org.apache.log4j.Logger;

public class HRAdminQueryPanelUI
extends AbstractHRAdminQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(HRAdminQueryPanelUI.class);
    public static final String ORG_ID = "id";
    public static final String ORG_LONGNUMBER = "longNumber";
    public static final String ORG_LEVEL = "level";
    public static final String ORG_ISSEALUP = "isSealUp";
    private Map orgProperties = null;

    public void onLoad() throws Exception {
        this.orgProperties = this.getOrgProperties();
        super.onLoad();
    }

    public CustomerParams getCustomerParams() {
        Object[] objects;
        CustomerParams params = super.getCustomerParams();
        if (params == null) {
            params = new CustomerParams();
        }
        if ((objects = this.getObjectArray(this.prmtOrg.getValue())) != null && objects.length > 0) {
            params.addCustomerParam(this.prmtOrg.getName(), this.getIdString(objects, null));
            params.putBoolean(this.rdDisplaySelf.getName(), this.rdDisplaySelf.isSelected());
            params.putBoolean(this.rdDisplaySub.getName(), this.rdDisplaySub.isSelected());
            params.putBoolean(this.rdDisplayAll.getName(), this.rdDisplayAll.isSelected());
            params.putInt(this.comboOrgLevel.getName(), this.comboOrgLevel.getSelectedIndex());
            int maxValue = Integer.parseInt(this.comboOrgLevel.getItemAt(this.comboOrgLevel.getItemCount() - 1).toString());
            params.putInt(this.comboOrgLevel.getName() + "maxLevel", maxValue);
        }
        params.putBoolean(this.chkShowSealUp.getName(), this.chkShowSealUp.isSelected());
        return params;
    }

    private String getIdString(Object[] objects, String split) {
        StringBuffer sb = new StringBuffer();
        OrgUnitInfo orgUnitInfo = null;
        int length = objects.length;
        for (int i = 0; i < length; ++i) {
            orgUnitInfo = (OrgUnitInfo)objects[i];
            if (orgUnitInfo == null) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (split != null) {
                sb.append(split);
            }
            sb.append(orgUnitInfo.getId().toString());
            if (split == null) continue;
            sb.append(split);
        }
        return sb.toString();
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        try {
            if (cp != null && cp.getCustomerParam(this.prmtOrg.getName()) != null) {
                int index;
                String idString = cp.getCustomerParam(this.prmtOrg.getName());
                StringTokenizer tokenizer = new StringTokenizer(idString, ",");
                HashSet<String> ids = new HashSet<String>();
                while (tokenizer.hasMoreTokens()) {
                    ids.add(tokenizer.nextToken());
                }
                OrgUnitCollection orgUnitCollection = this.getAdminOrgUnitCollection(ids);
                this.prmtOrg.setValue((Object)orgUnitCollection.toArray());
                this.rdDisplaySelf.setSelected(cp.getBoolean(this.rdDisplaySelf.getName()));
                this.rdDisplaySub.setSelected(cp.getBoolean(this.rdDisplaySub.getName()));
                this.rdDisplayAll.setSelected(cp.getBoolean(this.rdDisplayAll.getName()));
                this.chkShowSealUp.setSelected(cp.getBoolean(this.chkShowSealUp.getName()));
                int maxLevel = cp.getInt(this.comboOrgLevel.getName() + "maxLevel");
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
                for (int i = 1; i <= maxLevel; ++i) {
                    model.addElement(i);
                }
                this.comboOrgLevel.setModel(model);
                if (cp.getCustomerParam(this.comboOrgLevel.getName()) != null && (index = cp.getInt(this.comboOrgLevel.getName())) < this.comboOrgLevel.getItemCount()) {
                    this.comboOrgLevel.setSelectedIndex(cp.getInt(this.comboOrgLevel.getName()));
                }
                this.setComponentState(true);
            } else {
                this.prmtOrg.setValue(null);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public FilterInfo getFilterInfo() {
        this.orgProperties = this.getOrgProperties();
        FilterInfo filterInfo = null;
        Object[] orgUnitInfos = this.getObjectArray(this.prmtOrg.getValue());
        if (orgUnitInfos != null) {
            filterInfo = this.assembleFilterInfo(orgUnitInfos);
        }
        return filterInfo;
    }

    private FilterInfo assembleFilterInfo(Object[] orgUnitInfos) {
        if (orgUnitInfos == null || orgUnitInfos.length == 0) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        FilterInfo subFilterInfo = new FilterInfo();
        int length = orgUnitInfos.length;
        for (int i = 0; i < length; ++i) {
            this.assembleFilterInfo(subFilterInfo, (OrgUnitInfo)orgUnitInfos[i]);
            this.mergeFilter(filterInfo, subFilterInfo);
        }
        return filterInfo;
    }

    private void assembleFilterInfo(FilterInfo subFilterInfo, OrgUnitInfo orgUnitInfo) {
        subFilterInfo.getFilterItems().clear();
        StringBuffer maskString = new StringBuffer();
        if (this.rdDisplaySelf.isSelected()) {
            subFilterInfo.getFilterItems().add(new FilterItemInfo((String)this.orgProperties.get(ORG_ID), (Object)orgUnitInfo.getId().toString()));
            maskString.append("$");
        } else {
            subFilterInfo.getFilterItems().add(new FilterItemInfo((String)this.orgProperties.get(ORG_ID), (Object)orgUnitInfo.getId().toString()));
            subFilterInfo.getFilterItems().add(new FilterItemInfo((String)this.orgProperties.get(ORG_LONGNUMBER), (Object)(orgUnitInfo.getLongNumber() + "!%"), CompareType.LIKE));
            maskString.append("($ or $)");
            if (this.rdDisplaySub.isSelected() && this.comboOrgLevel.getSelectedIndex() >= 0) {
                int level = orgUnitInfo.getLevel();
                subFilterInfo.getFilterItems().add(new FilterItemInfo((String)this.orgProperties.get(ORG_LEVEL), (Object)(level += this.comboOrgLevel.getSelectedIndex()), CompareType.LESS_EQUALS));
                maskString.append(" and $");
            }
        }
        subFilterInfo.setMaskString(maskString.toString());
    }

    private void mergeFilter(FilterInfo filterInfo, FilterInfo subFilterInfo) {
        StringBuffer maskString = new StringBuffer();
        if (filterInfo.getMaskString() != null) {
            maskString.append(filterInfo.getMaskString());
        }
        int itemCount = filterInfo.getFilterItems().size();
        FilterItemCollection subFilterItems = subFilterInfo.getFilterItems();
        StringBuffer subMaskString = new StringBuffer(subFilterInfo.getMaskString());
        int index = subMaskString.indexOf("$");
        int size = subFilterItems.size();
        for (int i = 0; i < size; ++i) {
            filterInfo.getFilterItems().add(subFilterItems.get(i));
            subMaskString.replace(index, index + 1, "#" + (itemCount + i));
            index = subMaskString.indexOf("$");
        }
        if (maskString.length() > 0) {
            maskString.append(" or ");
        }
        maskString.append("(");
        maskString.append(subMaskString);
        maskString.append(")");
        filterInfo.setMaskString(maskString.toString());
    }

    protected Map getOrgProperties() {
        return null;
    }

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        if (this.isRegisterAdminOrgF7()) {
            register.registerAdminByOrgRangePromptBox(this.prmtOrg, this.isPrmtOrgMultiSelect(), this.isIncludeSealUp());
            AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)this.prmtOrg.getSelector();
            admin.setIncludeSealUp("true");
        }
        this.afterInitF7Context();
        this.clear();
    }

    protected void afterInitF7Context() {
    }

    protected boolean isRegisterAdminOrgF7() {
        return true;
    }

    protected boolean isIncludeSealUp() {
        return false;
    }

    protected boolean isPrmtOrgMultiSelect() {
        return false;
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
    }

    @Override
    protected void prmtOrg_preChange(PreChangeEvent e) throws Exception {
        Object[] newOrgUnitInfos = this.getObjectArray(e.getData());
        int max = 200;
        if (newOrgUnitInfos != null && newOrgUnitInfos.length > max) {
            String message = EASResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeResource.ADMINORG_MANY");
            MsgBox.showInfo((Component)((Object)this), (String)MessageFormat.format(message, String.valueOf(max)));
            e.setResult(0);
            return;
        }
        Object[] oldObjs = this.getObjectArray(e.getOldData());
        if (newOrgUnitInfos == null || oldObjs == null || !this.objectEquals(newOrgUnitInfos, oldObjs)) {
            this.setComboBoxLevel(newOrgUnitInfos, e, this.comboOrgLevel);
            this.setComponentState(e.getData() != null);
        } else {
            e.setResult(0);
        }
    }

    private void setComboBoxLevel(Object[] newOrgUnitInfos, PreChangeEvent e, KDComboBox comboBox) throws Exception {
        comboBox.removeAllItems();
        if (newOrgUnitInfos != null && newOrgUnitInfos.length > 0) {
            OrgUnitCollection orgUnitCollection = this.getAdminOrgUnitCollection(newOrgUnitInfos);
            if (orgUnitCollection == null || orgUnitCollection.isEmpty()) {
                return;
            }
            newOrgUnitInfos = new Object[orgUnitCollection.size()];
            HashSet<String> longNumbers = new HashSet<String>();
            OrgUnitInfo orgUnitInfo = null;
            int size = orgUnitCollection.size();
            for (int i = 0; i < size; ++i) {
                orgUnitInfo = orgUnitCollection.get(i);
                newOrgUnitInfos[i] = orgUnitInfo;
                longNumbers.add(orgUnitInfo.getLongNumber());
            }
            e.setData((Object)newOrgUnitInfos);
            if (!longNumbers.isEmpty()) {
                int[] datas = this.getLevelByLongNumber(longNumbers);
                int level = datas[0] - datas[1] + 1;
                DefaultComboBoxModel<Integer> model = new DefaultComboBoxModel<Integer>();
                for (int i = 1; i <= level; ++i) {
                    model.addElement(i);
                }
                comboBox.setModel(model);
            }
        }
    }

    private Object[] getObjectArray(Object obj) {
        Object[] orgUnitInfos = null;
        if (obj instanceof OrgUnitInfo) {
            orgUnitInfos = new Object[]{obj};
        } else if (obj instanceof Object[]) {
            orgUnitInfos = (Object[])obj;
        }
        return orgUnitInfos;
    }

    private boolean objectEquals(Object[] objs1, Object[] objs2) {
        Collection ids1 = EmployeeClientUtils.transInfoArrayToIdCollection(objs1);
        Collection ids2 = EmployeeClientUtils.transInfoArrayToIdCollection(objs2);
        if (ids1 == null && ids2 == null) {
            return true;
        }
        boolean equals = false;
        if (ids1 != null && ids2 != null && ids1.size() == ids2.size()) {
            equals = true;
            Iterator it = ids1.iterator();
            String id = null;
            while (it.hasNext()) {
                id = (String)it.next();
                if (ids2.contains(id)) continue;
                equals = false;
                break;
            }
        }
        return equals;
    }

    private OrgUnitCollection getAdminOrgUnitCollection(Object[] orgUnitInfos) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        OrgUnitInfo orgUnitInfo = null;
        int length = orgUnitInfos.length;
        for (int i = 0; i < length; ++i) {
            orgUnitInfo = (OrgUnitInfo)orgUnitInfos[i];
            if (orgUnitInfo == null) continue;
            ids.add(orgUnitInfo.getId().toString());
        }
        return this.getAdminOrgUnitCollection(ids);
    }

    private OrgUnitCollection getAdminOrgUnitCollection(Set ids) throws BOSException {
        if (ids.isEmpty()) {
            return null;
        }
        if (this.isPrepareGetAdminOrgUnitCollection()) {
            try {
                this.prepareGetAdminOrgUnitCollection(ids).callHandler();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo(ORG_ID, (Object)ids, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo(ORG_ID));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("number"));
        viewInfo.getSelector().add(new SelectorItemInfo(ORG_LONGNUMBER));
        viewInfo.getSelector().add(new SelectorItemInfo(ORG_LEVEL));
        return AdminOrgUnitFactory.getRemoteInstance().getOrgUnitCollection(viewInfo);
    }

    private int[] getLevelByLongNumber(Set longNumbers) throws Exception {
        int[] datas = new int[2];
        StringBuffer sql = new StringBuffer();
        if (this.isRegisterAdminOrgF7()) {
            String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
            sql.append("SELECT MAX(admin.FLevel) AS MAX0, MIN(admin.FLevel) AS MIN0 FROM T_ORG_ADMIN admin");
            sql.append(" inner join T_ORG_UnitRelation rel on rel.FFromUnitID = admin.FID");
            sql.append(" inner join T_PM_OrgRange rang on rang.FOrgID = rel.FFromUnitID");
            sql.append(" where ");
            sql.append(" rel.FTypeRelationID = '00000000-0000-0000-0000-0000000000100FE9F8B5' ");
            sql.append(" and rang.FUserID = ");
            sql.append("'");
            sql.append(userID);
            sql.append("'");
            sql.append(" and rang.FType = ");
            sql.append(20);
            sql.append(" and ");
            sql.append(this.getConditionString(longNumbers));
            Object[] hrOrgUnits = this.getObjectArray(this.prmtHROrg.getValue());
            if (hrOrgUnits != null && hrOrgUnits.length > 0) {
                String hrOrgUnitIds = this.getIdString(hrOrgUnits, "'");
                sql.append(" and rel.FToUnitID in (");
                sql.append(hrOrgUnitIds);
                sql.append(" )");
            }
        } else {
            sql.append("SELECT MAX(admin.FLevel) AS MAX0, MIN(admin.FLevel) AS MIN0 From ");
            sql.append("T_ORG_Admin admin");
            sql.append(" Where ");
            sql.append(this.getConditionString(longNumbers));
        }
        ISQLExecutor isql = SQLExecutorFactory.getRemoteInstance((String)sql.toString());
        IRowSet rows = isql.executeSQL();
        if (rows.next()) {
            datas[0] = rows.getInt("MAX0");
            datas[1] = rows.getInt("MIN0");
        }
        return datas;
    }

    private String getConditionString(Set longNumbers) {
        StringBuffer sb = new StringBuffer();
        Iterator it = longNumbers.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(" or ");
            }
            sb.append(" admin.FLongNumber || '!' like ");
            sb.append("'");
            sb.append(it.next());
            sb.append("!%'");
        }
        return sb.toString();
    }

    private void setComponentState(boolean enabled) {
        this.rdDisplaySelf.setEnabled(enabled);
        this.rdDisplaySub.setEnabled(enabled);
        this.rdDisplayAll.setEnabled(enabled);
        this.comboOrgLevel.setEnabled(enabled);
    }

    public void clear() {
        super.clear();
        this.setComponentState(false);
        this.prmtOrg.setValue(null);
        this.rdDisplaySelf.setSelected(true);
        this.comboOrgLevel.removeAllItems();
        this.chkShowSealUp.setSelected(false);
    }

    public boolean isPrepareGetAdminOrgUnitCollection() {
        return false;
    }

    public IUIActionPostman prepareGetAdminOrgUnitCollection(Set ids) {
        IUIActionPostman handler = UIActionPostman.getInstance((IUIObject)this);
        RequestContext request = new RequestContext();
        request.setClassName(this.getUIHandlerClassName());
        request.setMethodName("_handleGetAdminOrgUnitCollection");
        request.put("ids", (Object)ids);
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

