/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.client.IEmployeeUI;
import com.kingdee.eas.hr.emp.PersonSASACollection;
import com.kingdee.eas.hr.emp.PersonSASAFactory;
import com.kingdee.eas.hr.emp.PersonSASAInfo;
import com.kingdee.eas.hr.emp.client.AbstractPersonSASAEditUI;
import com.kingdee.eas.util.client.ExceptionHandler;
import org.apache.log4j.Logger;

public class PersonSASAEditUI
extends AbstractPersonSASAEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonSASAEditUI.class);
    private IEmployeeUI treeEditUI = null;

    @Override
    public void loadFields() {
        try {
            this.getValue(null);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        super.loadFields();
    }

    protected void afterOnLoad() throws Exception {
        super.afterOnLoad();
    }

    protected void beforeOnLoad() throws Exception {
        super.beforeOnLoad();
        this.treeEditUI = (IEmployeeUI)this.getUIContext().get("GroupListEditUI");
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        String recordId = null;
        if (this.getUIContext().get("CUR_OBJ_ID") != null) {
            recordId = this.getUIContext().get("CUR_OBJ_ID").toString();
        }
        if (recordId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)recordId));
            view.put("selector", (Object)this.getMergedSelector());
            view.setFilter(filter);
            PersonSASACollection subCol = PersonSASAFactory.getRemoteInstance().getPersonSASACollection(view);
            this.editData = subCol.size() <= 0 ? (PersonSASAInfo)this.createNewData() : subCol.get(0);
            this.setDataObject((IObjectValue)this.editData);
        }
        this.editData.copyNewToOld();
        return this.editData;
    }

    private CtrlUnitInfo getCurrentCU() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo().getCU();
        }
        return SysContext.getSysContext().getCurrentCtrlUnit();
    }

    private HROrgUnitInfo getCurrentHRO() {
        if (this.treeEditUI != null && this.treeEditUI.getMainBizOrgInfo() != null) {
            return this.treeEditUI.getMainBizOrgInfo();
        }
        return SysContext.getSysContext().getCurrentHRUnit();
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        return new ObjectUuidPK(this.getCurrentHRO().getId());
    }

    @Override
    protected IObjectValue createNewData() {
        PersonSASAInfo objectValue = new PersonSASAInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        PersonInfo pInfo = new PersonInfo();
        pInfo.setId(BOSUuid.read((String)this.getUIContext().get("CUR_OBJ_ID").toString()));
        objectValue.setPerson(pInfo);
        return objectValue;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PersonSASAFactory.getRemoteInstance();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (this.getUIContext() == null || this.getUIContext().get("NO_PERMISSION") == null) {
            super.handlePermissionForItemAction(action);
        }
    }
}

