/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.emp.client.AbstractPositionSortFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.event.ItemEvent;
import org.apache.log4j.Logger;

public class PositionSortFilterUI
extends AbstractPositionSortFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionSortFilterUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void chkInclude_itemStateChanged(ItemEvent e) throws Exception {
        if (this.chkInclude.isSelected()) {
            this.cboLevel.setEnabled(true);
        } else {
            this.cboLevel.setEnabled(false);
        }
    }

    public FilterInfo getFilterInfo() {
        if (this.prmtAdmin.getData() != null) {
            FilterInfo filterInfo = new FilterInfo();
            String pk = ((AdminOrgUnitInfo)this.prmtAdmin.getData()).getId().toString();
            filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)pk));
            if (this.chkInclude.isSelected()) {
                AdminOrgUnitInfo adminInfo = null;
                try {
                    adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(pk));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longNumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.level", (Object)adminInfo.getLevel(), CompareType.GREATER_EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.level", (Object)(adminInfo.getLevel() + this.cboLevel.getSelectedIndex()), CompareType.LESS_EQUALS));
                filterInfo.setMaskString("(#0 or #1) and #2 and #3");
            }
            return filterInfo;
        }
        return null;
    }

    public void clear() {
        super.clear();
        this.prmtAdmin.setData(null);
        this.chkInclude.setSelected(false);
        this.cboLevel.removeAllItems();
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.prmtAdmin.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdmin.setCommitFormat("$number$");
        this.prmtAdmin.setEditFormat("$number$");
        this.prmtAdmin.setDisplayFormat("$name$");
        this.prmtAdmin.setEditable(false);
        this.prmtAdmin.setSelector((KDPromptSelector)new AdminByOrgRangePromptBox());
        this.prmtAdmin.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                try {
                    PositionSortFilterUI.this.cboLevel.removeAllItems();
                    if (PositionSortFilterUI.this.prmtAdmin.getData() == null) {
                        return;
                    }
                    int level = HRUtil.getAdminOrgLevelCount((AdminOrgUnitInfo)((AdminOrgUnitInfo)PositionSortFilterUI.this.prmtAdmin.getData()));
                    PositionSortFilterUI.this.initComBox(level + 1);
                }
                catch (Exception e) {
                    PositionSortFilterUI.this.handUIException(e);
                }
            }
        });
    }

    private void initComBox(int level) {
        this.cboLevel.removeAllItems();
        for (int i = 1; i <= level; ++i) {
            this.cboLevel.addItem((Object)i);
        }
        if (level >= 1) {
            this.cboLevel.setSelectedIndex(0);
        }
    }

    public void setCustomerParams(CustomerParams param) {
        super.setCustomerParams(param);
        if (param == null) {
            return;
        }
        if (param.getCustomerParam("ADMIN_ID") != null) {
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(BOSUuid.read((String)param.getCustomerParam("ADMIN_ID")));
            AdminOrgUnitInfo adminInfo = null;
            try {
                adminInfo = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)pk);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.prmtAdmin.setData((Object)adminInfo);
        } else {
            this.prmtAdmin.setData(null);
        }
        this.chkInclude.setSelected(param.getBoolean("IS_INCLUDE"));
        if (this.chkInclude.isSelected()) {
            this.cboLevel.setVisible(true);
            if (param.getCustomerParam("ItemCount") != null && param.getInt("ItemCount") != 0) {
                this.initComBox(param.getInt("ItemCount"));
                if (param.getCustomerParam("ItemIndex") != null && param.getInt("ItemIndex") < param.getInt("ItemCount")) {
                    this.cboLevel.setSelectedIndex(param.getInt("ItemIndex"));
                }
            }
        }
    }

    public CustomerParams getCustomerParams() {
        CustomerParams params = new CustomerParams();
        if (this.prmtAdmin.getData() != null) {
            params.addCustomerParam("ADMIN_ID", ((AdminOrgUnitInfo)this.prmtAdmin.getData()).getId().toString());
        }
        params.putBoolean("IS_INCLUDE", this.chkInclude.isSelected());
        if (this.chkInclude.isSelected()) {
            params.putInt("ItemCount", this.cboLevel.getItemCount());
            params.putInt("ItemIndex", this.cboLevel.getSelectedIndex());
        }
        return params;
    }
}

