/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.emp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.PositionFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.emp.IPositionSortFacade;
import com.kingdee.eas.hr.emp.PositionSortFacadeFactory;
import com.kingdee.eas.hr.emp.client.AbstractPositionSortUI;
import com.kingdee.eas.hr.emp.client.PositionSortFilterUI;
import com.kingdee.eas.hr.org.client.HRPositionEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PositionSortUI
extends AbstractPositionSortUI {
    private static final Logger logger = CoreUIObject.getLogger(PositionSortUI.class);
    private Map indexMap = null;
    static final String RESOURCE = "com.kingdee.eas.hr.emp.PositionSortResource";

    public PositionSortUI() throws Exception {
        if (this.indexMap == null) {
            this.indexMap = new HashMap();
        }
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        try {
            FilterInfo filterInfo = new FilterInfo();
            if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems().size() > 0 && !this.mainQuery.getFilter().toString().equals("")) {
                this.mainQuery.getFilter().mergeFilter(filterInfo, "AND");
            } else {
                this.mainQuery.setFilter(filterInfo);
            }
            IPositionSortFacade emFacade = PositionSortFacadeFactory.getRemoteInstance();
            IRowSet rowSet = emFacade.getRowSet(this.mainQueryPK, this.mainQuery);
            this.fillTableData(rowSet);
            this.txtNum.setMaximumValue((Comparable)Integer.valueOf(rowSet.size()));
            this.txtNum.setMinimumValue((Comparable)Integer.valueOf(1));
        }
        catch (Exception ee) {
            this.handUIException(ee);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.tblMain_doRequestRowSet(null);
    }

    private void fillTableData(IRowSet rowSet) throws Exception {
        this.tblMain.removeRows(false);
        String id = null;
        String index = null;
        String number = null;
        String name = null;
        String admin = null;
        Object position = null;
        IRow row = null;
        boolean i = false;
        while (rowSet.next()) {
            id = rowSet.getString("id");
            index = rowSet.getString("sortCode");
            number = rowSet.getString("number");
            name = rowSet.getString("name");
            admin = rowSet.getString("adminOrgUnit.name");
            row = this.tblMain.addRow();
            if (index == null) {
                index = "0";
            }
            this.indexMap.put(row.getRowIndex(), index);
            row.getCell("id").setValue((Object)id);
            row.getCell("sortCode").setValue((Object)index);
            row.getCell("number").setValue((Object)number);
            row.getCell("name").setValue((Object)name);
            row.getCell("adminOrgUnit.name").setValue((Object)admin);
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        HashMap positionMap = new HashMap();
        int size = this.tblMain.getRowCount();
        for (int i = 0; i < size; ++i) {
            positionMap.put(this.indexMap.get(new Integer(i)), this.tblMain.getRow(i).getCell("id").getValue());
        }
        if (positionMap.size() == 0) {
            return;
        }
        IPositionSortFacade facade = PositionSortFacadeFactory.getRemoteInstance();
        facade.saveIndex(positionMap);
        MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"update_success"));
        this.refreshList();
    }

    @Override
    public void actionInit_actionPerformed(ActionEvent e) throws Exception {
        int msg = MsgBox.showConfirm2((String)EASResource.getString((String)RESOURCE, (String)"positionSort_11"));
        if (msg == 0) {
            this.initPosition();
            MsgBox.showInfo((String)EASResource.getString((String)RESOURCE, (String)"init_success"));
            this.refreshList();
            this.initIndexMap();
        }
    }

    private void initPosition() throws Exception {
        PositionSortFacadeFactory.getRemoteInstance().initPositionIndex();
    }

    private void insertPositionToTable(Object[] obj) throws BOSException {
        if (obj == null) {
            return;
        }
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        String indexObj = this.tblMain.getCell(block.getBeginRow(), "sortCode").getValue().toString();
        int index = 0;
        if (indexObj != null) {
            index = new Integer(indexObj);
        }
        int positionSize = obj.length;
        String[] positionIds = new String[positionSize];
        for (int i = 0; i < positionSize; ++i) {
            positionIds[i] = ((PositionInfo)obj[i]).getId().toString();
        }
        PositionSortFacadeFactory.getRemoteInstance().insertPositions(index, positionIds);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.checkInit();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected boolean isAllowDefaultSolutionNull() {
        return true;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (uiContext.get((Object)"FromChart") == null) {
            uiContext.put((Object)"FromChart", (Object)"true");
        }
    }

    @Override
    public void actionInsert_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("MULTI_SELECT", Boolean.TRUE);
        Frame frame = (Frame)this.getUIContext().get("OwnerWindow");
        PositionPromptBox2 f7 = new PositionPromptBox2(frame, map);
        f7.setEnabledMultiSelection(true);
        f7.show();
        if (!f7.isCanceled() && f7.getData() instanceof Object[]) {
            Object[] obj = (Object[])f7.getData();
            this.insertPositionToTable(obj);
            this.refreshList();
        }
    }

    @Override
    public void actionMoveTo_actionPerformed(ActionEvent e) throws Exception {
        int toIndex;
        if (this.txtNum.getIntegerValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.emp.EMPAutoGenerateResource", (String)"230_EmployeeSortUI"));
            SysUtil.abort();
        }
        if ((toIndex = this.txtNum.getIntegerValue() - 1) + 1 > this.tblMain.getRowCount()) {
            return;
        }
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        ArrayList<IRow> rowList = new ArrayList<IRow>();
        int beginIndex = block.getBeginRow();
        int endIndex = block.getEndRow();
        if (toIndex >= beginIndex && toIndex <= endIndex) {
            return;
        }
        for (int i = endIndex; i >= beginIndex; --i) {
            rowList.add(this.tblMain.getRow(i));
            this.tblMain.removeRow(i);
        }
        int index = 0;
        index = toIndex > endIndex ? toIndex - (endIndex - beginIndex) : toIndex;
        for (int i = rowList.size() - 1; i >= 0; --i) {
            this.tblMain.addRow(index, (IRow)rowList.get(i));
            ++index;
        }
        if (toIndex > endIndex) {
            this.tblMain.getSelectManager().select(new KDTSelectBlock(toIndex - (endIndex - beginIndex), 0, toIndex, 0, 2));
        } else {
            this.tblMain.getSelectManager().select(new KDTSelectBlock(toIndex, 0, toIndex + (endIndex - beginIndex), 0, 2));
        }
        this.tblMain.scrollToVisible(toIndex, endIndex - beginIndex);
    }

    @Override
    public void actionMoveTop_actionPerformed(ActionEvent e) throws Exception {
        int endIndex;
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        ArrayList<IRow> rowList = new ArrayList<IRow>();
        int beginIndex = block.getBeginRow();
        for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
            rowList.add(this.tblMain.getRow(i));
            this.tblMain.removeRow(i);
        }
        int index = 0;
        for (int i = rowList.size() - 1; i >= 0; --i) {
            this.tblMain.addRow(index, (IRow)rowList.get(i));
            ++index;
        }
        this.tblMain.getSelectManager().select(new KDTSelectBlock(0, 0, endIndex - beginIndex, 1, 2));
        this.tblMain.scrollToVisible(0, endIndex - beginIndex);
    }

    @Override
    public void actionMoveUp_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            int endIndex;
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            if (beginIndex == 0) {
                return;
            }
            for (int i = endIndex = block.getEndRow(); i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = beginIndex - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex - 1, 0, endIndex - 1, 1, 2));
            this.tblMain.scrollToVisible(beginIndex - 1, endIndex - 1);
        }
    }

    @Override
    public void actionMoveDown_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        ArrayList<IRow> rowList = new ArrayList<IRow>();
        int beginIndex = block.getBeginRow();
        int endIndex = block.getEndRow();
        if (endIndex == this.tblMain.getRowCount() - 1) {
            return;
        }
        for (int i = endIndex; i >= beginIndex; --i) {
            rowList.add(this.tblMain.getRow(i));
            this.tblMain.removeRow(i);
        }
        int index = beginIndex + 1;
        for (int i = rowList.size() - 1; i >= 0; --i) {
            this.tblMain.addRow(index, (IRow)rowList.get(i));
            ++index;
        }
        this.tblMain.getSelectManager().select(new KDTSelectBlock(beginIndex + 1, 0, endIndex + 1, 1, 2));
        this.tblMain.scrollToVisible(beginIndex + 1, endIndex + 1);
    }

    @Override
    public void actionMoveButtom_actionPerformed(ActionEvent e) throws Exception {
        super.actionMoveButtom_actionPerformed(e);
        this.checkSelected();
        KDTSelectBlock block = this.tblMain.getSelectManager().get();
        if (block != null) {
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            int beginIndex = block.getBeginRow();
            int endIndex = block.getEndRow();
            int rowCount = this.tblMain.getRowCount();
            if (endIndex == this.tblMain.getRowCount() - 1) {
                return;
            }
            for (int i = endIndex; i >= beginIndex; --i) {
                rowList.add(this.tblMain.getRow(i));
                this.tblMain.removeRow(i);
            }
            int index = rowCount - (endIndex - beginIndex) - 1;
            for (int i = rowList.size() - 1; i >= 0; --i) {
                this.tblMain.addRow(index, (IRow)rowList.get(i));
                ++index;
            }
            this.tblMain.getSelectManager().select(new KDTSelectBlock(rowCount - (endIndex - beginIndex) - 1, 0, index, 1, 2));
            this.tblMain.scrollToVisible(rowCount - (endIndex - beginIndex) - 1, index);
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PositionFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return HRPositionEditUI.class.getName();
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    private void initIndexMap() {
        this.indexMap.clear();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            ICell cell = this.tblMain.getRow(i).getCell("sortCode");
            Object index = null;
            if (cell != null) {
                index = cell.getValue();
            }
            this.indexMap.put(new Integer(i), index);
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        int rowcount = this.tblMain.getRowCount();
        if (this.txtNum.getIntegerValue() != null && this.txtNum.getIntegerValue() > rowcount) {
            this.txtNum.setMaximumValue((Comparable)new Integer(rowcount));
            this.txtNum.setMinimumValue((Comparable)new Integer(1));
            this.txtNum.setValue((Object)new Integer(rowcount));
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("OrgRange.type", (Object)new Integer(20)));
        filter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.IsSealUp", (Object)new Integer(0)));
        StringBuffer hrRangeSql = new StringBuffer("SELECT T_ORG_UnitRelation.FFromUnitID  FROM T_ORG_UnitRelation ");
        hrRangeSql.append("INNER JOIN T_ORG_TypeRelation ON T_ORG_UnitRelation.FTypeRelationId =T_ORG_TypeRelation.FID ");
        hrRangeSql.append("WHERE T_ORG_TypeRelation.FID='00000000-0000-0000-0000-0000000000100FE9F8B5' ");
        filter.getFilterItems().add(new FilterItemInfo("ADMINORGUNIT.id", (Object)hrRangeSql.toString(), CompareType.INNER));
        try {
            FilterInfo isVirtualFilter = new FilterInfo("ADMINORGUNIT.isVirtual = 0");
            filter.mergeFilter(isVirtualFilter, "and");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog dialog = super.initCommonQueryDialog();
        try {
            PositionSortFilterUI filterUI = new PositionSortFilterUI();
            dialog.addUserPanel((KDPanel)filterUI);
            dialog.setMaxReturnCountVisible(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return dialog;
    }

    private void checkInit() throws Exception {
        String sql = "select fid from t_org_position where FSortCode is null";
        ISQLExecutor sqlExecutor = SQLExecutorFactory.getRemoteInstance((String)sql);
        IRowSet rowSet = sqlExecutor.executeSQL();
        if (rowSet.next()) {
            this.initPosition();
            this.refreshList();
        }
        this.initIndexMap();
    }
}

