/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.kt.AuditCauseFactory;
import com.kingdee.eas.hr.kt.AuditCauseInfo;
import com.kingdee.eas.hr.kt.client.AbstractAuditCauseEditUI;
import com.kingdee.eas.hr.kt.util.CadreManagerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;

public class AuditCauseEditUI
extends AbstractAuditCauseEditUI {
    private boolean isIntermit = false;
    private boolean isModifiable = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AuditCauseFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        CadreManagerUtil.validateNumberAndName(this.txtNumber, this.txtName);
    }

    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopy_actionPerformed(e);
        this.txtNumber.setText(null);
    }

    protected IObjectValue createNewData() {
        AuditCauseInfo objectValue = new AuditCauseInfo();
        objectValue.setCreator((UserInfo)SysContext.getSysContext().getCurrentUser());
        return objectValue;
    }

    @Override
    public void loadFields() {
        this.setAutoNumberByOrg("HRO");
        super.loadFields();
    }

    protected void setAutoNumberByOrg(String orgType) {
        if (this.editData == null) {
            return;
        }
        if (this.editData.getNumber() == null) {
            try {
                String companyID = null;
                if (!StringUtils.isEmpty((String)orgType) && !"NONE".equalsIgnoreCase(orgType) && SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)) != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit(OrgType.getEnum((String)orgType)).getString("id");
                } else if (SysContext.getSysContext().getCurrentOrgUnit() != null) {
                    companyID = SysContext.getSysContext().getCurrentOrgUnit().getString("id");
                }
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (iCodingRuleManager.isExist((IObjectValue)this.editData, companyID)) {
                    if (iCodingRuleManager.isAddView((IObjectValue)this.editData, companyID)) {
                        this.editData.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.editData, companyID));
                    }
                    this.txtNumber.setEnabled(false);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
                this.oldData = this.editData;
                SysUtil.abort();
            }
        } else if (this.editData.getNumber().trim().length() > 0) {
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                this.isModifiable = codingRuleManager.checkModifiedNumber((IObjectValue)this.editData, SysContext.getSysContext().getCurrentHRUnit().getId().toString(), this.editData.getNumber());
                this.txtNumber.setText(this.editData.getNumber());
                if (!this.isModifiable) {
                    this.txtNumber.setEditable(false);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
        }
    }

    public IObjectPK runSubmit() throws Exception {
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
            if (result && OprtState.ADDNEW.equals(this.getOprtState())) {
                this.isIntermit = codingRuleManager.isUseIntermitNumber((IObjectValue)this.editData, orgUnitId);
                if (this.isIntermit) {
                    this.editData.setNumber(codingRuleManager.getNumber((IObjectValue)this.editData, orgUnitId));
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        return super.runSubmit();
    }
}

