/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.base.client.HRCommonBillEditUIBiz;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.PersonPositionMatchingUI;
import com.kingdee.eas.hr.kt.CadreAppointmentBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreBillBizException;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryCollection;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryInfo;
import com.kingdee.eas.hr.kt.client.CadreSelectF7UI;
import com.kingdee.eas.hr.kt.client.PersonPerfSelectListUI;
import com.kingdee.eas.hr.kt.util.CadreManagerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import javax.swing.JComboBox;

public class CadreAppointmentBizBillEditUIBiz
extends HRCommonBillEditUIBiz {
    protected void initEditor() throws Exception {
        StyleAttributes cellAttribute = this.kdtEntrys.getColumn("isCadre").getStyleAttributes();
        cellAttribute.setLocked(true);
        cellAttribute.setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("bizDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("bizDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kdtEntrys.getColumn("endDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("endDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kdtEntrys.getColumn("tryOutStartDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("tryOutStartDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kdtEntrys.getColumn("tryOutEndDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("tryOutEndDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kdtEntrys.getColumn("oldAdminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.getColumn("adminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.getColumn("dismissAdminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                CadreAppointmentBizBillEditUIBiz.this.kdtEntrys_SelectChanged(e);
            }
        });
    }

    protected IObjectValue createNewDetailData(PersonInfo info) {
        PersonPositionInfo ppInfo;
        CadreAppointmentBizBillEntryInfo entry = new CadreAppointmentBizBillEntryInfo();
        entry.setPerson(info);
        if (info.isIsStandbyCadre()) {
            entry.setIsCadre(true);
        }
        if ((ppInfo = (PersonPositionInfo)info.get("personPosition")) != null) {
            PositionInfo position = ppInfo.getPrimaryPosition();
            entry.setOldPosition(position);
            entry.setOldPosition(ppInfo.getPrimaryPosition());
            entry.setOldAdminOrg(ppInfo.getPersonDep());
            entry.setAdminOrg(ppInfo.getPersonDep());
            entry.setPosition(ppInfo.getPrimaryPosition());
        }
        return entry;
    }

    protected void kdtEntrys_SelectChanged(KDTSelectEvent e) {
        int beginCol = e.getSelectBlock().getBeginCol();
        int endCol = e.getSelectBlock().getEndCol();
        int beginRow = e.getSelectBlock().getBeginRow();
        int endRow = e.getSelectBlock().getEndRow();
        int col = this.kdtEntrys.getColumnIndex("dismissPosition");
        for (int i = beginRow; i <= endRow; ++i) {
            if (i == -1) continue;
            PersonInfo person = (PersonInfo)this.kdtEntrys.getRow(i).getCell("person").getValue();
            if (col > endCol || col < beginCol || !CadreManagerUtil.isComboxEmptyInKDT(this.kdtEntrys, i, "dismissPosition")) continue;
            KDComboBox cbo = EditorCreator.getPersonPositionsCboEditor((String)person.getId().toString(), null);
            this.kdtEntrys.getRow(i).getCell(col).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)cbo));
        }
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        Integer outLength;
        Date startDate;
        PositionInfo pInfo;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("position").getColumnIndex() && (pInfo = (PositionInfo)e.getValue()) != null && !pInfo.equals(e.getOldValue())) {
            CadreManagerUtil.positionChanged(row, pInfo, "adminOrg");
        }
        if (colIndex == this.kdtEntrys.getColumn("dismissPosition").getColumnIndex() && (pInfo = (PositionInfo)e.getValue()) != null && !pInfo.equals(e.getOldValue())) {
            CadreManagerUtil.positionChanged(row, pInfo, "dismissAdminOrg");
            row.getCell("dismissJob").setValue((Object)pInfo.getJob());
        }
        this.calculateTenureLength(e, row);
        if (colIndex == this.kdtEntrys.getColumn("tryOutLength").getColumnIndex() && (startDate = (Date)row.getCell("tryOutStartDate").getValue()) != null && (outLength = (Integer)e.getValue()) != null) {
            Date outEndDate = DateTimeUtils.addMonth((Date)startDate, (int)outLength);
            row.getCell("tryOutEndDate").setValue((Object)outEndDate);
        }
        Date changeDate = null;
        Integer tryOutLength = null;
        if (row.getCell("tryOutLength").getValue() instanceof Integer) {
            tryOutLength = (Integer)row.getCell("tryOutLength").getValue();
        }
        if (colIndex == this.kdtEntrys.getColumn("tryOutStartDate").getColumnIndex() && tryOutLength != null) {
            Date startDate2 = (Date)row.getCell("tryOutStartDate").getValue();
            if (startDate2 != null) {
                if (e.getValue() instanceof Date) {
                    changeDate = (Date)e.getValue();
                }
                if (changeDate != null) {
                    Date outEndDate = DateTimeUtils.addMonth((Date)changeDate, (int)tryOutLength);
                    row.getCell("tryOutEndDate").setValue((Object)outEndDate);
                }
            } else {
                row.getCell("tryOutEndDate").setValue(null);
            }
        }
        Date changeDateend = null;
        Integer tryOutLengthend = null;
        if (row.getCell("tryOutLength").getValue() instanceof Integer) {
            tryOutLengthend = (Integer)row.getCell("tryOutLength").getValue();
        }
        if (colIndex == this.kdtEntrys.getColumn("tryOutEndDate").getColumnIndex() && tryOutLengthend != null) {
            Date startDate3 = (Date)row.getCell("tryOutEndDate").getValue();
            if (startDate3 != null) {
                if (e.getValue() instanceof Date) {
                    changeDateend = (Date)e.getValue();
                }
                if (changeDateend != null) {
                    Date outEndDate = DateTimeUtils.addMonth((Date)changeDateend, (int)(-tryOutLengthend.intValue()));
                    row.getCell("tryOutStartDate").setValue((Object)outEndDate);
                }
            } else {
                row.getCell("tryOutStartDate").setValue(null);
            }
        }
    }

    private void calculateTenureLength(KDTEditEvent e, IRow row) {
        int colIndex = e.getColIndex();
        if (colIndex == this.kdtEntrys.getColumn("tenureLength").getColumnIndex()) {
            Float oldTenLength = new Float(0.0);
            if (e.getOldValue() instanceof Float) {
                oldTenLength = (Float)e.getOldValue();
            } else if (e.getOldValue() instanceof BigDecimal) {
                oldTenLength = Float.valueOf(((BigDecimal)e.getOldValue()).floatValue());
            }
            if (0.0 == (double)oldTenLength.floatValue() || row.getCell("bizDate").getValue() == null || row.getCell("endDate").getValue() == null) {
                Date startDate = (Date)row.getCell("bizDate").getValue();
                BigDecimal tenLength = (BigDecimal)e.getValue();
                if (tenLength != null) {
                    float year = (float)Math.round(tenLength.floatValue() * 2.0f) / 2.0f;
                    if (startDate != null) {
                        Date endDate = DateTimeUtils.addMonth((Date)startDate, (int)((int)(year * 12.0f)));
                        row.getCell("endDate").setValue((Object)endDate);
                    }
                    row.getCell("tenureLength").setValue((Object)new Float(year));
                }
            }
        }
        Date changeDate = null;
        Float tenLength = null;
        if (row.getCell("tenureLength").getValue() instanceof Float) {
            tenLength = (Float)row.getCell("tenureLength").getValue();
        }
        if (colIndex == this.kdtEntrys.getColumn("bizDate").getColumnIndex() && tenLength != null && row.getCell("endDate").getValue() == null) {
            Date startDate = (Date)row.getCell("bizDate").getValue();
            if (startDate != null) {
                if (e.getValue() instanceof Date) {
                    changeDate = (Date)e.getValue();
                }
                if (changeDate != null) {
                    Date outEndDate = DateTimeUtils.addYear((Date)changeDate, (int)tenLength.intValue());
                    row.getCell("endDate").setValue((Object)outEndDate);
                }
            } else {
                row.getCell("endDate").setValue(null);
            }
        }
        Float tenLengthend = null;
        if (row.getCell("tenureLength").getValue() instanceof Float) {
            tenLengthend = (Float)row.getCell("tenureLength").getValue();
        } else if (row.getCell("tenureLength").getValue() == null) {
            tenLengthend = Float.valueOf(0.0f);
            row.getCell("tenureLength").setValue((Object)tenLengthend);
        }
        if (colIndex == this.kdtEntrys.getColumn("endDate").getColumnIndex() && tenLengthend != null && row.getCell("bizDate").getValue() == null) {
            Date startDate = (Date)row.getCell("endDate").getValue();
            if (startDate != null) {
                if (e.getValue() instanceof Date) {
                    changeDate = (Date)e.getValue();
                }
                if (changeDate != null) {
                    Calendar cal = Calendar.getInstance();
                    Date outEndDate = DateTimeUtils.addYear((Date)changeDate, (int)(-tenLengthend.intValue()));
                    row.getCell("bizDate").setValue((Object)outEndDate);
                }
            } else {
                row.getCell("bizDate").setValue(null);
            }
        }
    }

    public void actionSelectCadre_actionPerformed(ActionEvent e) throws Exception {
        CadreSelectBizBillEntryCollection entrys;
        UIContext ctx = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CadreSelectF7UI.class.getName(), (Map)ctx);
        uiWindow.show();
        CadreSelectF7UI f7UI = (CadreSelectF7UI)uiWindow.getUIObject();
        if (!f7UI.isCanceled() && (entrys = f7UI.entryCol) != null && entrys.size() > 0) {
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                this.addDataByEntry(entrys.get(i));
            }
        }
    }

    public void beforeStoreField(ActionEvent e) throws Exception {
        CadreManagerUtil.validateDate(this.kdtEntrys, "bizDate", "endDate");
        Date startDate = null;
        Date endDate = null;
        int n = this.kdtEntrys.getRowCount();
        for (int i = 0; i < n; ++i) {
            startDate = (Date)this.kdtEntrys.getRow(i).getCell("tryOutStartDate").getValue();
            endDate = (Date)this.kdtEntrys.getRow(i).getCell("tryOutEndDate").getValue();
            if (startDate == null || endDate == null || !DateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) continue;
            throw new CadreBillBizException(CadreBillBizException.VALIDATE_DATE, new Object[]{i + 1});
        }
    }

    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        ICell cell = row.getCell("position");
        int colIndex = cell.getColumnIndex();
        Float tenLength = null;
        if (colIndex == copyCol) {
            this.copyPosition(row, cell, value);
            return;
        }
        super.fillRow(row, value, dataRow, copyCol);
        int tenureCol = row.getCell("tenureLength").getColumnIndex();
        if (tenureCol == copyCol) {
            Date startDate = (Date)row.getCell("bizDate").getValue();
            if (startDate != null) {
                if (value instanceof Float) {
                    tenLength = (Float)value;
                }
                if (tenLength != null) {
                    Date endDate = DateTimeUtils.addMonth((Date)startDate, (int)tenLength.intValue());
                    row.getCell("endDate").setValue((Object)endDate);
                }
            } else {
                row.getCell("endDate").setValue(null);
            }
        }
        this.copyLength(row, value, copyCol, "tryOutStartDate", "tryOutEndDate", "tryOutLength");
        this.copyDate(row, value, copyCol, "tryOutStartDate", "tryOutEndDate", "tryOutLength");
        this.copyEndDate(row, value, copyCol, "tryOutEndDate", "tryOutStartDate", "tryOutLength");
        this.copyLength(row, value, copyCol, "bizDate", "endDate", "tenureLength");
        this.copyDate(row, value, copyCol, "bizDate", "endDate", "tenureLength");
        this.copyEndDate(row, value, copyCol, "endDate", "bizDate", "tenureLength");
    }

    private void copyPosition(IRow row, ICell cell, Object value) throws Exception {
        if (cell == null) {
            return;
        }
        if (!cell.getStyleAttributes().isLocked()) {
            cell.setValue(value);
            CadreManagerUtil.positionChanged(row, (PositionInfo)value, "adminOrg");
        }
    }

    public void actionCadrePerformance_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 0 && KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            String personId = KDTableUtil.getSelectedRow((KDTable)this.kdtEntrys).getCell("personId").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"personId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonPerfSelectListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"PleaseSelectPerson"));
        }
    }

    public void actionPerosnMatch_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 0 && KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            String personId = KDTableUtil.getSelectedRow((KDTable)this.kdtEntrys).getCell("personId").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"selectId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonPositionMatchingUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"PleaseSelectPerson"));
        }
    }

    private void addDataByEntry(CadreSelectBizBillEntryInfo c) throws EASBizException, BOSException {
        IRow row = this.kdtEntrys.addRow();
        PersonInfo pIn = c.getPerson();
        row.getCell("person").setValue((Object)pIn);
        row.getCell("personId").setValue((Object)pIn.getId());
        row.getCell("empNumber").setValue((Object)pIn.getNumber());
        if (pIn.isIsStandbyCadre()) {
            row.getCell("isCadre").setValue((Object)Boolean.TRUE);
        } else {
            row.getCell("isCadre").setValue((Object)Boolean.FALSE);
        }
        row.getCell("empName").setValue((Object)pIn.getName());
        row.getCell("oldPosition").setValue((Object)c.getPosition());
        row.getCell("oldAdminOrg").setValue((Object)c.getAdminOrg());
        row.getCell("position").setValue((Object)c.getTargetPosition());
        row.getCell("isPrimaryPosi").setValue((Object)true);
        StyleAttributes cellStyle = row.getCell("position").getStyleAttributes();
        cellStyle.setLocked(true);
        cellStyle.setBackground(new Color(208, 208, 208));
        row.getCell("adminOrg").setValue((Object)c.getTargetAdmin());
    }

    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        register.registerPositionPromptBox2(prmtPosition, this.kdtEntrys.getColumn("position"));
        PositionPromptBox2 position = (PositionPromptBox2)prmtPosition.getSelector();
        position.setSealUp("true");
    }

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showOnlyCadre(false);
    }

    protected String[] getNotDupColumn() {
        return super.getNotDupColumn();
    }

    protected String[] getNotNullColumn() {
        return new String[]{"cadreType", "position", "appointmentCaus", "bizDate"};
    }

    protected String getPrintQuery(String dsName) {
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.kt.app.CadreAppointmentBizBillPrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "HR/KT/CadreAppoint";
    }

    private void copyDate(IRow row, Object value, int copyCol, String sDate, String eDate, String copyLength) {
        int startIndex = row.getCell(sDate).getColumnIndex();
        Integer integerlength = null;
        Float floatlength = null;
        if (row.getCell(copyLength).getValue() instanceof Integer) {
            integerlength = (Integer)row.getCell(copyLength).getValue();
        } else if (row.getCell(copyLength).getValue() instanceof Float) {
            floatlength = (Float)row.getCell(copyLength).getValue();
        }
        if (startIndex == copyCol) {
            Date startDate = (Date)row.getCell(sDate).getValue();
            if (startDate != null) {
                if (integerlength != null) {
                    Date endDate = null;
                    endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)startDate, (int)integerlength) : DateTimeUtils.addYear((Date)startDate, (int)integerlength);
                    row.getCell(eDate).setValue((Object)endDate);
                } else if (floatlength != null) {
                    Date endDate = null;
                    endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)startDate, (int)floatlength.intValue()) : DateTimeUtils.addYear((Date)startDate, (int)floatlength.intValue());
                    row.getCell(eDate).setValue((Object)endDate);
                }
            } else {
                row.getCell(eDate).setValue(null);
            }
        }
    }

    private void copyLength(IRow row, Object value, int copyCol, String sDate, String eDate, String copyLength) {
        Date changeDate;
        int copylen = row.getCell(copyLength).getColumnIndex();
        Integer integerlength = null;
        Float floatlength = null;
        if (copylen == copyCol && (changeDate = (Date)row.getCell(sDate).getValue()) != null) {
            Date endDate;
            if (value instanceof Float && (floatlength = (Float)value) != null) {
                endDate = null;
                endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)changeDate, (int)floatlength.intValue()) : DateTimeUtils.addYear((Date)changeDate, (int)floatlength.intValue());
                row.getCell(eDate).setValue((Object)endDate);
            }
            if (value instanceof Integer && (integerlength = (Integer)value) != null) {
                endDate = null;
                endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)changeDate, (int)integerlength) : DateTimeUtils.addYear((Date)changeDate, (int)integerlength);
                row.getCell(eDate).setValue((Object)endDate);
            }
        }
    }

    private void copyEndDate(IRow row, Object value, int copyCol, String sDate, String eDate, String copyLength) {
        if (!"tryOutEndDate".equals(sDate) && !"endDate".equals(sDate)) {
            return;
        }
        int startIndex = row.getCell(sDate).getColumnIndex();
        Integer integerlength = null;
        Float floatlength = null;
        if (row.getCell(copyLength).getValue() instanceof Integer) {
            integerlength = (Integer)row.getCell(copyLength).getValue();
        } else if (row.getCell(copyLength).getValue() instanceof Float) {
            floatlength = (Float)row.getCell(copyLength).getValue();
        }
        if (startIndex == copyCol) {
            Date startDate = (Date)row.getCell(sDate).getValue();
            if (startDate != null) {
                if (integerlength != null) {
                    Date endDate = null;
                    endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)startDate, (int)(-integerlength.intValue())) : DateTimeUtils.addYear((Date)startDate, (int)(-integerlength.intValue()));
                    row.getCell(eDate).setValue((Object)endDate);
                } else if (floatlength != null) {
                    Date endDate = null;
                    endDate = "tryOutLength".equals(copyLength) ? DateTimeUtils.addMonth((Date)startDate, (int)(-floatlength.intValue())) : DateTimeUtils.addYear((Date)startDate, (int)(-floatlength.intValue()));
                    row.getCell(eDate).setValue((Object)endDate);
                }
            } else {
                row.getCell(eDate).setValue(null);
            }
        }
    }
}

