/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.client.FilterUIUtil;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.kt.client.AbstractCadreFilterUI;
import com.kingdee.eas.hr.org.client.AdminByOrgRangePromptBox;
import org.apache.log4j.Logger;

public class CadreFilterUI
extends AbstractCadreFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CadreFilterUI.class);

    protected void initF7Context(IHRF7CommonRegister register) {
        super.initF7Context(register);
        register.registerAdminByOrgRangePromptBox(this.prmtOrg);
        AdminByOrgRangePromptBox admin = (AdminByOrgRangePromptBox)this.prmtOrg.getSelector();
        admin.setIncludeSealUp("true");
        admin.showChkSealUp(true);
        register.registerPositionPromptBox2(this.prmtPosition, true);
        PositionPromptBox2 position = (PositionPromptBox2)this.prmtPosition.getSelector();
        position.showChkSealUp(true);
        position.setSealUp("true");
        register.registerEmployeeMultiF7PromptBox(this.prmtName, true);
    }

    public void clear() {
        super.clear();
        this.prmtOrg.setValue(null);
        this.prmtPosition.setValue(null);
        this.prmtName.setValue(null);
        this.chkIsInclude.setSelected(false);
    }

    public CustomerParams getCustomerParams() {
        CustomerParams cp = super.getCustomerParams();
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.saveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
        return cp;
    }

    public void setCustomerParams(CustomerParams cp) {
        super.setCustomerParams(cp);
        String[] ctrls = new String[]{this.prmtHROrg.getName()};
        FilterUIUtil.retriveAllData((CustomerParams)cp, (CustomerQueryPanel)this, (String[])ctrls, (boolean)false);
    }

    public FilterInfo getFilterInfo() {
        FilterInfo filter = new FilterInfo();
        AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
        if (orgUnit != null) {
            if (this.chkIsInclude.isSelected()) {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                filter.setMaskString(" #0 or #1 ");
            } else {
                filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
            }
        }
        if (this.prmtPosition.getValue() != null) {
            PositionInfo positionInfo = (PositionInfo)this.prmtPosition.getData();
            filter.getFilterItems().add(new FilterItemInfo("targetPosition.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.prmtName.getValue() != null) {
            PersonInfo pInfo = (PersonInfo)this.prmtName.getData();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
        }
        return filter;
    }

    public KDBizPromptBox getMainBizOrgF7() {
        return this.getMainOrg();
    }
}

