/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.client.HRCommonBillEditUIBiz;
import com.kingdee.eas.hr.base.client.f7.EditorCreator;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.kt.CadreCollection;
import com.kingdee.eas.hr.kt.CadreFactory;
import com.kingdee.eas.hr.kt.CadreInfo;
import com.kingdee.eas.hr.kt.CadrePatronageTypeFactory;
import com.kingdee.eas.hr.kt.CadrePatronageTypeInfo;
import com.kingdee.eas.hr.kt.CadreResignBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreTypeFactory;
import com.kingdee.eas.hr.kt.CadreTypeInfo;
import com.kingdee.eas.hr.kt.ICadre;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Color;

public class CadreResignBizBillEditUIBiz
extends HRCommonBillEditUIBiz {
    protected void initEditor() throws Exception {
        super.initEditor();
        this.kdtEntrys.getColumn("bizDate").setEditor(EditorCreator.getDateCellEditor());
        this.kdtEntrys.getColumn("bizDate").getStyleAttributes().setNumberFormat("yyyy-MM-dd");
        this.kdtEntrys.getColumn("cadreType").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("cadreType").getStyleAttributes().setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("appointmentType").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("appointmentType").getStyleAttributes().setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("cadreState").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("cadreState").getStyleAttributes().setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("personClassify").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("personClassify").getStyleAttributes().setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("personFenLei").getStyleAttributes().setLocked(true);
        this.kdtEntrys.getColumn("personFenLei").getStyleAttributes().setBackground(new Color(208, 208, 208));
    }

    protected IObjectValue createNewDetailData(PersonInfo info) {
        CadreInfo cadreInfo;
        CadreResignBizBillEntryInfo entry = new CadreResignBizBillEntryInfo();
        entry.setPerson(info);
        entry.setSavaCadre(true);
        EmployeeTypeInfo empType = info.getEmployeeType();
        entry.setCadreState(empType);
        entry.setPersonClassify(info.getEmployeeClassify());
        entry.setPersonFenLei(empType.getEmployeeFenLei());
        PersonPositionInfo ppInfo = (PersonPositionInfo)info.get("personPosition");
        if (ppInfo != null) {
            entry.setPosition(ppInfo.getPrimaryPosition());
            entry.setAdminOrg(ppInfo.getPersonDep());
        }
        if ((cadreInfo = this.getCadreInfo(info)) != null) {
            entry.setCadreType(cadreInfo.getCadreType());
            entry.setAppointmentType(cadreInfo.getAppointType());
        }
        return entry;
    }

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showOnlyCadre(true);
        this.empF7.setUITitle(EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"CADRE"));
    }

    protected String[] getNotDupColumn() {
        return super.getNotDupColumn();
    }

    protected String[] getNotNullColumn() {
        return new String[]{"bizDate", "savaCadre"};
    }

    private CadreInfo getCadreInfo(PersonInfo pInfo) {
        CadreInfo cadreInfo = null;
        CadreTypeInfo typeInfo = null;
        CadrePatronageTypeInfo appointType = null;
        try {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            ICadre icadre = CadreFactory.getRemoteInstance();
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId(), CompareType.EQUALS));
            if (icadre.exists(filter)) {
                evi.setFilter(filter);
                CadreCollection cadreCol = icadre.getCadreCollection(evi);
                if (cadreCol.size() > 0) {
                    cadreInfo = cadreCol.get(0);
                    String cadreTypeId = null;
                    String appointTypeId = null;
                    if (cadreInfo.getAppointType() != null) {
                        appointTypeId = cadreInfo.getAppointType().getId().toString();
                        appointType = CadrePatronageTypeFactory.getRemoteInstance().getCadrePatronageTypeInfo((IObjectPK)new ObjectUuidPK(appointTypeId));
                    }
                    if (cadreInfo.getCadreType() != null) {
                        cadreTypeId = cadreInfo.getCadreType().getId().toString();
                        typeInfo = CadreTypeFactory.getRemoteInstance().getCadreTypeInfo((IObjectPK)new ObjectUuidPK(cadreTypeId));
                    }
                    cadreInfo.setCadreType(typeInfo);
                    cadreInfo.setAppointType(appointType);
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        return cadreInfo;
    }

    protected String getPrintQuery(String dsName) {
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.kt.app.CadreResignBizBillPrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "HR/KT/CadreResign";
    }
}

