/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.affair.client.OrgFullNameRender;
import com.kingdee.eas.hr.base.client.HRCommonBillEditUIBiz;
import com.kingdee.eas.hr.base.client.IHRF7CommonRegister;
import com.kingdee.eas.hr.emp.PersonPositionInfo;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.emp.client.PersonPositionMatchingUI;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryCollection;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreSelectBizBillFactory;
import com.kingdee.eas.hr.kt.ICadreSelectBizBill;
import com.kingdee.eas.hr.kt.client.PersonPerfSelectListUI;
import com.kingdee.eas.hr.kt.util.CadreManagerUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class CadreSelectBizBillEditUIBiz
extends HRCommonBillEditUIBiz {
    private EmployeeMultiF7PromptBox personBox = null;

    protected void initEditor() throws Exception {
        super.initEditor();
        StyleAttributes cellStyle = this.kdtEntrys.getColumn("targetAdmin").getStyleAttributes();
        cellStyle.setLocked(true);
        cellStyle.setBackground(new Color(208, 208, 208));
        StyleAttributes cadreCellStyle = this.kdtEntrys.getColumn("isCadre").getStyleAttributes();
        cadreCellStyle.setLocked(true);
        cadreCellStyle.setBackground(new Color(208, 208, 208));
        this.kdtEntrys.getColumn("adminOrg").setRenderer((IBasicRender)new OrgFullNameRender());
        this.kdtEntrys.getColumn("targetAdmin").setRenderer((IBasicRender)new OrgFullNameRender());
    }

    protected IObjectValue createNewDetailData(PersonInfo info) {
        CadreSelectBizBillEntryInfo entry = new CadreSelectBizBillEntryInfo();
        entry.setPerson(info);
        PersonPositionInfo ppInfo = (PersonPositionInfo)info.get("personPosition");
        if (info.isIsStandbyCadre()) {
            entry.setIsCadre(true);
        }
        if (ppInfo != null) {
            entry.setPosition(ppInfo.getPrimaryPosition());
            entry.setAdminOrg(ppInfo.getPersonDep());
            entry.setTargetPosition(ppInfo.getPrimaryPosition());
            entry.setTargetAdmin(ppInfo.getPersonDep());
        }
        return entry;
    }

    public void registerContextChangeF7(IHRF7CommonRegister register) {
        super.registerContextChangeF7(register);
        KDBizPromptBox prmtPerson = new KDBizPromptBox();
        register.registerEmployeeMultiF7PromptBox(prmtPerson, this.kdtEntrys.getColumn("personF7"));
        this.personBox = (EmployeeMultiF7PromptBox)prmtPerson.getSelector();
        this.personBox.setIsShowAllAdmin(true);
        this.personBox.setIsSingleSelect(false);
        KDBizPromptBox prmtPosition = new KDBizPromptBox();
        register.registerPositionPromptBox2(prmtPosition, this.kdtEntrys.getColumn("targetPosition"));
        PositionPromptBox2 position = (PositionPromptBox2)prmtPosition.getSelector();
        position.setSealUp("true");
    }

    public void entryEditStopped(KDTEditEvent e) throws Exception {
        PositionInfo pInfo;
        int colIndex = e.getColIndex();
        int rowIndex = e.getRowIndex();
        StringBuffer personCol = new StringBuffer();
        String personName = null;
        IRow row = this.kdtEntrys.getRow(rowIndex);
        if (colIndex == this.kdtEntrys.getColumn("personF7").getColumnIndex()) {
            if (row.getCell("personF7").getValue() == null) {
                return;
            }
            Object[] obj = (Object[])this.personBox.getData();
            if (obj == null || obj.length <= 0) {
                return;
            }
            int n = obj.length;
            for (int i = 0; i < n; ++i) {
                PersonInfo pInfo2 = (PersonInfo)obj[i];
                String pName = pInfo2.getName();
                PositionInfo ppInfo = (PositionInfo)pInfo2.get("primaryposition");
                String pPos = ppInfo.getName();
                if (i < n - 1) {
                    personCol.append(pName).append("(").append(pPos).append(")").append("; ");
                    continue;
                }
                personCol.append(pName).append("(").append(pPos).append(")");
            }
            if (personCol.toString().length() > 200) {
                personName = personCol.toString().substring(0, 199);
                personName = personName.substring(0, personName.lastIndexOf(")") + 1);
            } else {
                personName = personCol.toString();
            }
            row.getCell("recPerson").setValue((Object)personName);
            row.getCell("personF7").setValue(null);
        }
        if (colIndex == this.kdtEntrys.getColumn("targetPosition").getColumnIndex() && (pInfo = (PositionInfo)e.getValue()) != null && !pInfo.equals(e.getOldValue())) {
            CadreManagerUtil.positionChanged(row, pInfo, "targetAdmin");
        }
    }

    protected void fillRow(IRow row, Object value, IRow dataRow, int copyCol) throws Exception {
        ICell cell = row.getCell("targetPosition");
        int colIndex = cell.getColumnIndex();
        if (colIndex == copyCol) {
            this.copyPosition(row, cell, value);
            return;
        }
        super.fillRow(row, value, dataRow, copyCol);
    }

    private void copyPosition(IRow row, ICell cell, Object value) throws Exception {
        if (cell == null) {
            return;
        }
        if (!cell.getStyleAttributes().isLocked()) {
            cell.setValue(value);
            CadreManagerUtil.positionChanged(row, (PositionInfo)value, "targetAdmin");
        }
    }

    public void actionSeePerformance_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 0 && KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            String personId = KDTableUtil.getSelectedRow((KDTable)this.kdtEntrys).getCell("personId").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"personId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonPerfSelectListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"PleaseSelectPerson"));
        }
    }

    public void actionPerosnMatch_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtEntrys.getRowCount() > 0 && KDTableUtil.getSelectedRowCount((KDTable)this.kdtEntrys) > 0) {
            String personId = KDTableUtil.getSelectedRow((KDTable)this.kdtEntrys).getCell("personId").getValue().toString();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"selectId", (Object)personId);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PersonPositionMatchingUI.class.getName(), (Map)uiContext);
            uiWindow.show();
        } else {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"PleaseSelectPerson"));
        }
    }

    protected void initEmpF7() {
        super.initEmpF7();
        this.empF7.showOnlyCadre(false);
    }

    protected String[] getNotDupColumn() {
        return super.getNotDupColumn();
    }

    protected String[] getNotNullColumn() {
        return new String[]{"targetPosition", "targetAdmin", "selectSource"};
    }

    protected String getPrintQuery(String dsName) {
        if ("baseInfo".equals(dsName)) {
            return "com.kingdee.eas.hr.kt.app.CadreSelectPrintQuery";
        }
        return null;
    }

    protected String getPrintPath() {
        return "HR/KT/CadreSelect";
    }

    protected String getPrintQueryBillID(String dsName) {
        ((Object)((Object)this)).getClass();
        if ("baseInfo".equals(dsName)) {
            return "id";
        }
        ((Object)((Object)this)).getClass();
        if ("approveInfo".equals(dsName)) {
            return "CadreSelectBizBillEntry.id";
        }
        return null;
    }

    public void beforeStoreField(ActionEvent e) throws Exception {
        super.beforeStoreField(e);
        this.verifyCadreSelectByInfo();
    }

    private void verifyCadreSelectByInfo() throws BOSException, EASBizException {
        ICadreSelectBizBill iCadreSelectBizBill = CadreSelectBizBillFactory.getRemoteInstance();
        CadreSelectBizBillEntryCollection collection = new CadreSelectBizBillEntryCollection();
        IRow row = null;
        CadreSelectBizBillEntryInfo info = null;
        int size = this.kdtEntrys.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtEntrys.getRow(i);
            info = new CadreSelectBizBillEntryInfo();
            info.setPerson((PersonInfo)row.getCell("person").getValue());
            collection.add(info);
        }
        HashMap<String, IObjectValue> paramMap = new HashMap<String, IObjectValue>();
        paramMap.put("currentBill", this.ctx.getEditData());
        iCadreSelectBizBill.verifyCadreSelectByInfo((IObjectCollection)collection, paramMap);
    }
}

