/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.kt.CadreBillBizException;
import com.kingdee.eas.hr.kt.CadreSelectBizBillEntryInfo;
import com.kingdee.eas.hr.kt.CadreShowFactory;
import com.kingdee.eas.hr.kt.CadreShowInfo;
import com.kingdee.eas.hr.kt.ShowStateEnum;
import com.kingdee.eas.hr.kt.client.AbstractCadreShowEditUI;
import com.kingdee.eas.hr.kt.util.CadreManagerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class CadreShowEditUI
extends AbstractCadreShowEditUI {
    private static Logger logger = Logger.getLogger(CadreShowEditUI.class);
    private List list = null;
    private boolean isShow = false;

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.btnSub.setEnabled(false);
                this.btnRemove.setEnabled(false);
            } else if (OprtState.EDIT.equals(this.getOprtState())) {
                this.btnRemove.setEnabled(true);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.list = (List)this.getUIContext().get("list");
        CadreShowFactory.getRemoteInstance().savaList(this.list);
        CadreSelectBizBillEntryInfo entryInfo = null;
        PersonInfo pInfo = null;
        StringBuffer personNumbers = new StringBuffer();
        StringBuffer personNames = new StringBuffer();
        if (this.list != null && this.list.size() > 0) {
            int n = this.list.size();
            for (int i = 0; i < n; ++i) {
                entryInfo = (CadreSelectBizBillEntryInfo)this.list.get(i);
                String personId = entryInfo.getPerson().getId().toString();
                pInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                if (i < n - 1) {
                    personNumbers.append(pInfo.getNumber()).append(",");
                    personNames.append(pInfo.getName()).append(",");
                    continue;
                }
                personNumbers.append(pInfo.getNumber());
                personNames.append(pInfo.getName());
            }
        }
        this.txtPersonNumber.setText(personNumbers.toString());
        this.txtPersonName.setText(personNames.toString());
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = new Dimension();
        size.setSize(screenSize.getWidth() * 2.0 / 3.0, screenSize.getHeight() / 2.0);
        this.setPreferredSize(size);
    }

    @Override
    protected void btnSub_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"PleaseSave"));
        } else {
            this.validateData();
            this.editData.setStartDate((Date)this.pkstartDate.getValue());
            this.editData.setEndDate((Date)this.pkendDate.getValue());
            this.editData.setTitle(this.txttitle.getText().toString());
            this.editData.setContent(this.txtcontent.getSelectedItemData().toString());
            CadreShowFactory.getRemoteInstance().submitShow(this.editData);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"ShowOK"));
        }
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return CadreShowFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        CadreShowInfo objectValue = new CadreShowInfo();
        objectValue.setPass(false);
        objectValue.setShowState(ShowStateEnum.UnShow);
        return objectValue;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        this.validateData();
    }

    public boolean isModify() {
        if (this.editData.getId() == null && !StringUtils.isEmpty((String)this.txttitle.getText())) {
            return true;
        }
        if (this.editData.getId() != null) {
            String id = this.editData.getId().toString();
            try {
                CadreShowInfo showInfo = CadreShowFactory.getRemoteInstance().getCadreShowInfo((IObjectPK)new ObjectUuidPK(id));
                if (!showInfo.getMoreContext().equals(this.txtcontent.getSelectedItemData().toString()) || !showInfo.getTitle().equals(this.txttitle.getText().toString())) {
                    return true;
                }
            }
            catch (EASBizException e) {
                logger.error((Object)e.getMessage());
            }
            catch (BOSException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return false;
    }

    private void validateData() throws CadreBillBizException {
        if (this.pkstartDate.getValue() == null || this.pkendDate.getValue() == null) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"DATE_NOT_NULL"));
            this.pkendDate.requestFocus();
            SysUtil.abort();
        }
        CadreManagerUtil.validateEditUI(this.pkstartDate, this.pkendDate);
        if (StringUtils.isEmpty((String)this.txttitle.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"TITLE_NOT_NULL"));
            this.txttitle.requestFocus();
            SysUtil.abort();
        }
        if (this.txtcontent.getSelectedItemData() == null || this.txtcontent.getSelectedItemData().equals("")) {
            this.txtcontent.grabFocus();
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.hr.kt.client.KtResource", (String)"CONTENT_NOT_NULL"));
            SysUtil.abort();
        }
    }
}

