/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.event.PreChangeEvent;
import com.kingdee.bos.ctrl.swing.event.PreChangeListener;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.base.HRInitFactory;
import com.kingdee.eas.hr.kt.client.AbstractCadreShowFilterUI;
import com.kingdee.eas.hr.kt.client.CadreSelectListUI;
import com.kingdee.eas.hr.kt.client.CadreShowListUI;
import org.apache.log4j.Logger;

public class CadreShowFilterUI
extends AbstractCadreShowFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(CadreShowFilterUI.class);
    private CadreSelectListUI cadreSelectListUI = null;
    private CadreShowListUI cadreShowListUI = null;

    public CadreShowFilterUI() throws Exception {
    }

    public CadreShowFilterUI(CadreSelectListUI listUI) throws Exception {
        this.cadreSelectListUI = listUI;
        this.initBizOrgPreChange();
    }

    public CadreShowFilterUI(CadreShowListUI listUI) throws Exception {
        this.cadreShowListUI = listUI;
        this.initBizOrgPreChange();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public FilterInfo getFilterInfo() {
        PositionInfo positionInfo;
        FilterInfo filter = new FilterInfo();
        if (this.kdRadioPosition.isSelected() && (positionInfo = (PositionInfo)this.prmtPosition.getData()) != null) {
            filter.getFilterItems().add(new FilterItemInfo("position.id", (Object)positionInfo.getId().toString(), CompareType.EQUALS));
        }
        if (this.kdRadioEmp.isSelected()) {
            if (this.chkIsSearch.isSelected()) {
                String personNumberOrName = this.txFiledPerson.getText();
                if (personNumberOrName != null) {
                    filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.getFilterItems().add(new FilterItemInfo("person.name", (Object)("%" + personNumberOrName + "%"), CompareType.LIKE));
                    filter.setMaskString("#0 or #1");
                }
            } else {
                PersonInfo pInfo = (PersonInfo)this.prmtEmp.getData();
                if (pInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                }
            }
        }
        if (this.kdradioOrg.isSelected()) {
            AdminOrgUnitInfo orgUnit = (AdminOrgUnitInfo)this.prmtOrg.getData();
            if (orgUnit != null) {
                if (this.chkIsIncludeOrg.isSelected()) {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.longNumber", (Object)(orgUnit.getLongNumber() + "!%"), CompareType.LIKE));
                    filter.setMaskString(" #0 or #1 ");
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("adminOrg.number", (Object)orgUnit.getNumber(), CompareType.EQUALS));
                }
            }
            if (!this.chkShowSealUp.isSelected()) {
                FilterInfo sealUpFi = new FilterInfo();
                sealUpFi.getFilterItems().add(new FilterItemInfo("adminOrg.isSealUp", (Object)Boolean.FALSE));
                try {
                    filter.mergeFilter(sealUpFi, "and");
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        return filter;
    }

    private void initBizOrgPreChange() {
        this.prmtHROrg.addPreChangeListener(new PreChangeListener(){

            public void preChange(PreChangeEvent e) {
                if (e.getData() != null && e.getData() instanceof HROrgUnitInfo) {
                    try {
                        HRInitFactory.getRemoteInstance().isInitFinish((HROrgUnitInfo)e.getData());
                        if (e.getOldData() != null && e.getData() != null && !e.getOldData().equals(e.getData())) {
                            KDTable selfDefTbl = null;
                            if (CadreShowFilterUI.this.cadreSelectListUI != null && CadreShowFilterUI.this.cadreSelectListUI.getDialog() != null) {
                                selfDefTbl = CadreShowFilterUI.this.cadreSelectListUI.getDialog().getCommonFilterPanel().getKdtTable();
                            } else if (CadreShowFilterUI.this.cadreShowListUI != null && CadreShowFilterUI.this.cadreShowListUI.getDialog() != null) {
                                selfDefTbl = CadreShowFilterUI.this.cadreShowListUI.getDialog().getCommonFilterPanel().getKdtTable();
                            } else {
                                return;
                            }
                            boolean hasFilterVal = false;
                            if (selfDefTbl.getRowCount() > 0) {
                                int i;
                                int size = selfDefTbl.getRowCount();
                                for (i = 0; i < size; ++i) {
                                    if (selfDefTbl.getRow(i).getCell(1).getValue() == null) continue;
                                    hasFilterVal = true;
                                    break;
                                }
                                if (hasFilterVal) {
                                    selfDefTbl.removeRows();
                                    for (i = 0; i < 10; ++i) {
                                        selfDefTbl.addRow();
                                    }
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception ex) {
                        CadreShowFilterUI.this.handUIException(ex);
                    }
                }
            }
        });
    }
}

