/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.client.GetDataDialog;
import com.kingdee.eas.base.core.client.GetDataTaskAdapter;
import com.kingdee.eas.base.permission.OrgRangeType;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.hr.base.EmployeeFenLeiInfo;
import com.kingdee.eas.hr.base.EmployeeTypeInfo;
import com.kingdee.eas.hr.base.util.PerHRAndCUUtil;
import com.kingdee.eas.hr.emp.EmpInnerFacadeFactory;
import com.kingdee.eas.hr.emp.EmployeeException;
import com.kingdee.eas.hr.emp.EmployeeTypeEnum;
import com.kingdee.eas.hr.emp.IEmpInnerFacade;
import com.kingdee.eas.hr.emp.client.EmpInServiceType;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmpTypeConvertHisListUI;
import com.kingdee.eas.hr.emp.client.EmployeeBatchEditUI;
import com.kingdee.eas.hr.emp.client.EmployeeDetailNoteDataProvider;
import com.kingdee.eas.hr.emp.client.EmployeeTreeEditUI;
import com.kingdee.eas.hr.kt.client.AbstractRetireeCadreUI;
import com.kingdee.eas.hr.org.OrgHRCommonFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class RetireeCadreUI
extends AbstractRetireeCadreUI {
    private static final Logger logger = CoreUIObject.getLogger(RetireeCadreUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.kt.client.KtResource";
    private DefaultKingdeeTreeNode selectNode = null;
    private IObjectPK currentOrgPK = null;
    private Set cuSet = null;
    private Set hrSet = null;
    private HashSet permissionHROrg = null;
    private static Map positionHROCache = new HashMap();
    private boolean isRefresh = false;
    protected String resClass = "com.kingdee.eas.basedata.person.client.PersonResource.";
    private final String PRINT_CADRE_PATH = "HR/KT/CadreDetail";
    private HashMap map = new HashMap();

    protected boolean isSupportDynQuery() {
        return true;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBatch.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.btnEmpTypeConvert.setIcon(EASResource.getIcon((String)"imgTbtn_switchorganise"));
        this.btnEmpTypeConvertAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnEmpTypeConvertHis.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.menuItemBatch.setIcon(EASResource.getIcon((String)"imgTbtn_stafferbatch"));
        this.menuItemEmpTypeConvert.setIcon(EASResource.getIcon((String)"imgTbtn_switchorganise"));
        this.menuItemEmpTypeConvertAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemEmpTypeConvertHis.setIcon(EASResource.getIcon((String)"imgTbtn_showlist"));
        this.btnEdit.setToolTipText(EASResource.getString((String)RESOURCE, (String)"UPDATE"));
        this.menuItemEdit.setText(EASResource.getString((String)RESOURCE, (String)"UPDATE"));
        this.actionAssignPosition.setVisible(false);
        this.actionBatch.setVisible(false);
    }

    private void initTopTools() {
        KDMenuItem printCadreInfo = new KDMenuItem(this.resHelper.getString("menuItemPrintCadreInfo.text"));
        printCadreInfo.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionPrintCadreInfo), (Class[])new Class[]{ItemAction.class}, (Map)this.getServiceContext())));
        printCadreInfo.setText(this.resHelper.getString("menuItemPrintCadreInfo.text"));
        KDMenuItem printCadreInfoAll = new KDMenuItem(this.resHelper.getString("menuItemPrintCadreInfoAll.text"));
        printCadreInfoAll.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionPrintCadreInfoAll), (Class[])new Class[]{ItemAction.class}, (Map)this.getServiceContext())));
        printCadreInfoAll.setText(this.resHelper.getString("menuItemPrintCadreInfoAll.text"));
        printCadreInfo.setEnabled(true);
        printCadreInfoAll.setEnabled(true);
        this.btnPrintCadreInfo.addAssistMenuItem((JMenuItem)printCadreInfo);
        this.btnPrintCadreInfo.addAssistMenuItem((JMenuItem)printCadreInfoAll);
        this.menuPrintCadreInfo.setVisible(false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.checkEmployeeType();
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        try {
            HashSet<String> personIdSet = new HashSet<String>();
            while (rowSet.next()) {
                personIdSet.add(rowSet.getString("id"));
            }
            if (personIdSet.size() > 0) {
                Map personHroMap = OrgHRCommonFactory.getRemoteInstance().getPersonHROBatch(personIdSet);
                for (Map.Entry entry : personHroMap.entrySet()) {
                    positionHROCache.put(entry.getKey(), entry.getValue());
                }
            }
            rowSet.beforeFirst();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void checkEmployeeType() throws EmployeeException {
        TreePath path = this.treeMain.getSelectionPath();
        if (path != null) {
            DefaultKingdeeTreeNode selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
            if (selectNode.getUserObject() instanceof EmpInServiceType) {
                throw new EmployeeException(EmployeeException.MUST_SELECT_EMPTYPESTATE);
            }
        } else {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    protected String getEditUIName() {
        return EmployeeTreeEditUI.class.getName();
    }

    public void onLoad() throws Exception {
        this.initTopTools();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.kt.app", "RetireeCadreQuery");
        this.permissionHROrg = this.getHROrgUnitIds();
        if (this.permissionHROrg == null || this.permissionHROrg.size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "HR_EMPLOYEESTATE_VIEW")));
            SysUtil.abort();
        }
        super.onLoad();
        this.menuBiz.setVisible(true);
        this.btnAssignPosition.setVisible(false);
        this.menuItemImportData.setVisible(false);
        this.buildEmployeeFenLeiTree();
        this.btnLocate.setVisible(true);
        this.btnNoPositionEmpImport.setVisible(false);
        this.menuItemNoPositionEmpImport.setVisible(false);
        this.actionBatch.setEnabled(true);
        this.mainQuery.setIngorePreOrders(true);
    }

    private void buildEmployeeFenLeiTree() throws Exception {
        DefaultKingdeeTreeNode rootNode = this.createEmployeeFenLeiTreeNode(true);
        DefaultTreeModel model = new DefaultTreeModel((TreeNode)rootNode);
        this.treeMain.setModel((TreeModel)model);
        this.treeMain.expandAllNodes(true, (TreeNode)rootNode);
        if (this.getDefaultEntityViewInfo() == null) {
            if (rootNode.getChildCount() > 0) {
                this.treeMain.setSelectionNode((DefaultKingdeeTreeNode)rootNode.getChildAt(0));
            } else {
                this.treeMain.setSelectionNode(rootNode);
            }
        } else {
            this.actionEmpTypeConvent.setEnabled(false);
        }
        this.treeMain.setShowsRootHandles(true);
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.tblMain.removeRows();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"name", "number"};
        return locateNames;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return;
        }
        this.actionBatch.setEnabled(false);
        this.actionEmpTypeConvent.setEnabled(false);
        this.actionAddNew.setEnabled(false);
        this.selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.hr.kt.app", "RetireeCadreQuery");
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        } else if (this.mainQuery.getFilter() != null) {
            this.mainQuery.setFilter(new FilterInfo());
        }
        if (!(this.selectNode.getUserObject() instanceof EmployeeFenLeiInfo) && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            this.actionBatch.setEnabled(true);
            this.actionEmpTypeConvent.setEnabled(true);
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            if (typeInfo.getInService().getValue() == 1 || typeInfo.getInService().getValue() == 4) {
                this.actionAddNew.setEnabled(false);
            } else {
                this.actionAddNew.setEnabled(true);
            }
        }
        this.mainQuery.setFilter(this.getDefaultFilterForQuery());
        this.tblMain.removeRows();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        uiContext.put((Object)"uiTitle", (Object)EASResource.getString((String)RESOURCE, (String)"CADRE_TREE_EDITUI_TITLE"));
        super.prepareUIContext(uiContext, e);
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            uiContext.put((Object)"employeeType", (Object)typeInfo);
            if (typeInfo != null && !typeInfo.getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3")) {
                if (typeInfo.getInService().getValue() != 1 && typeInfo.getInService().getValue() != 4) {
                    uiContext.put((Object)"NO_Position", (Object)Boolean.TRUE);
                } else {
                    uiContext.put((Object)"NO_Position", (Object)Boolean.FALSE);
                }
            }
        }
        int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        HashMap<Object, String> personDepMap = new HashMap<Object, String>();
        HashMap<Object, PositionInfo> personPositionMap = new HashMap<Object, PositionInfo>();
        HashMap<Object, PersonInfo> personInfoMap = new HashMap<Object, PersonInfo>();
        for (int i = 0; i < rowID.length; ++i) {
            IRow row = this.tblMain.getRow(rowID[i]);
            if (row == null) continue;
            String adminOrgUnitId = "";
            if (row.getCell("AdminOrgUnit.id") != null && row.getCell("AdminOrgUnit.id").getValue() != null) {
                adminOrgUnitId = row.getCell("AdminOrgUnit.id").getValue().toString();
                personDepMap.put(row.getCell("id").getValue(), adminOrgUnitId);
            }
            if (row.getCell("Position.id") != null && row.getCell("Position.id").getValue() != null) {
                PositionInfo position = new PositionInfo();
                position.setId(BOSUuid.read((String)((String)row.getCell("Position.id").getValue())));
                position.setName((String)row.getCell("Position.name").getValue());
                personPositionMap.put(row.getCell("id").getValue(), position);
            }
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
            person.setNumber((String)row.getCell("person.number").getValue());
            person.setName((String)row.getCell("person.name").getValue());
            personInfoMap.put(row.getCell("id").getValue(), person);
        }
        uiContext.put((Object)"personInfoMap", personInfoMap);
        uiContext.put((Object)"personPositionMap", personPositionMap);
        uiContext.put((Object)"personDepMap", personDepMap);
        uiContext.put((Object)"positionHROCache", (Object)positionHROCache);
        uiContext.put((Object)"FROM_EmployeeType", (Object)"OK");
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        if (this.confirmRemove()) {
            try {
                IEmpInnerFacade iEmp = EmpInnerFacadeFactory.getRemoteInstance();
                iEmp.personDelete((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
            }
            catch (ObjectNotFoundException onfe) {
                logger.error((Object)onfe.getMessage());
                this.refreshList();
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
            this.refresh(e);
        }
    }

    private PersonCollection getSelectedPersons() {
        PersonCollection pInfos = new PersonCollection();
        PersonInfo pInfo = null;
        super.checkSelected();
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resClass, (String)"SELECT_NOT_SUPPORT_VIRTUAL"));
            SysUtil.abort();
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            pInfo = new PersonInfo();
            pInfo.setId(BOSUuid.read((String)this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString()));
            if (this.tblMain.getRow(indexs[i]).getCell("name").getValue() == null) {
                pInfo.setName(null);
            } else {
                pInfo.setName(this.tblMain.getRow(indexs[i]).getCell("name").getValue().toString());
            }
            pInfo.setNumber(this.tblMain.getRow(indexs[i]).getCell("number").getValue().toString());
            pInfos.add(pInfo);
        }
        return pInfos;
    }

    private Set getSelectedPersonSet() {
        HashSet<String> perSet = new HashSet<String>();
        super.checkSelected();
        if (this.tblMain.getSelectManager().get().getMode() == 8) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u865a\u6a21\u5f0f\u4e0d\u652f\u6301\u8868\u9009\u62e9");
            SysUtil.abort();
        }
        int[] indexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        for (int i = 0; i < indexs.length; ++i) {
            perSet.add(this.tblMain.getRow(indexs[i]).getCell("id").getValue().toString());
        }
        return perSet;
    }

    @Override
    public void actionBatch_actionPerformed(ActionEvent e) throws Exception {
        EmployeeTypeInfo typeInfo;
        this.checkManyHR();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"personInfos", (Object)this.getSelectedPersons());
        uiContext.put((Object)"editType", (Object)Boolean.FALSE);
        uiContext.put((Object)"cuSet", (Object)this.cuSet);
        uiContext.put((Object)"hrSet", (Object)this.hrSet);
        uiContext.put((Object)"cadre", (Object)"cadre");
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo && (typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject()) != null && !typeInfo.getId().toString().equals("00000000-0000-0000-0000-000000000001A29E85B3")) {
            uiContext.put((Object)"employeeType", (Object)typeInfo);
            if (typeInfo.getInService().getValue() != 1 && typeInfo.getInService().getValue() != 4) {
                uiContext.put((Object)"NO_POSITION", (Object)Boolean.TRUE);
            } else {
                uiContext.put((Object)"NO_POSITION", (Object)Boolean.FALSE);
            }
        }
        IUIFactory uiFactory = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
            IUIWindow curDialog = uiFactory.create(EmployeeBatchEditUI.class.getName(), (Map)uiContext);
            curDialog.show();
        }
        catch (UIException ex1) {
            ExceptionHandler.handle((Component)((Object)this), (Throwable)ex1);
        }
    }

    @Override
    public void actionEmpTypeConvent_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkManyHR();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"Owner", (Object)this);
        uiContext.put((Object)"personInfos", (Object)this.getSelectedPersons());
        uiContext.put((Object)"cuSet", (Object)this.cuSet);
        uiContext.put((Object)"hrSet", (Object)this.hrSet);
        uiContext.put((Object)"cadre", (Object)"cadre");
        uiContext.put((Object)"isAudit", (Object)Boolean.FALSE);
        if (this.selectNode != null && this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            uiContext.put((Object)"employeeType", (Object)typeInfo);
        }
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertBatchEditUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        curDialog.show();
    }

    private void checkManyHR() throws BOSException, EmployeeException {
        Set hrNowSet;
        HashSet perSet = new HashSet();
        ArrayList perIdList = this.getSelectedIdValues();
        int size = perIdList.size();
        for (int i = 0; i < size; ++i) {
            perSet.add(perIdList.get(i));
        }
        this.hrSet = hrNowSet = PerHRAndCUUtil.getHRsFromPerSet(null, perSet);
        this.cuSet = PerHRAndCUUtil.getCUsFromPerSet(null, perSet);
        if (hrNowSet.size() > 1) {
            throw new EmployeeException(EmployeeException.MANYHR_NOT_SUPPORT, new Object[]{PerHRAndCUUtil.getHRsName(null, (Set)hrNowSet)});
        }
        if (this.hrSet.size() == 0) {
            throw new EmployeeException(EmployeeException.PERSON_NOT_HAVE_HRORG);
        }
        this.currentOrgPK = new ObjectUuidPK((String)this.hrSet.toArray()[0]);
    }

    protected HashSet getHROrgUnitIds() throws BOSException, EASBizException {
        FullOrgUnitCollection orgCollection = PermissionFactory.getRemoteInstance().getAuthorizedOrg((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), OrgType.HRO, null, "noposition_view");
        HashSet<String> ids = new HashSet<String>();
        if (orgCollection != null) {
            int n = orgCollection.size();
            for (int i = 0; i < n; ++i) {
                ids.add(orgCollection.get(i).getId().toString());
            }
        }
        return ids;
    }

    protected IObjectPK getOrgPK(ItemAction action) {
        if (action == null) {
            return null;
        }
        String actionName = action.getClass().getName();
        if (actionName.indexOf("$") >= 0) {
            actionName = actionName.substring(actionName.indexOf("$") + 1);
        }
        if ("ActionBatch".equalsIgnoreCase(actionName) || "ActionEmpTypeConvert".equalsIgnoreCase(actionName) || "ActionEdit".equalsIgnoreCase(actionName)) {
            this.checkSelected();
            String selectedId = null;
            selectedId = this.getCurRowAdminOrgUnitId();
            if (selectedId != null) {
                ObjectUuidPK pk = null;
                HROrgUnitInfo hrOrgUnitInfo = this.getMyOrgPK(selectedId);
                if (hrOrgUnitInfo != null) {
                    pk = new ObjectUuidPK(hrOrgUnitInfo.getId());
                }
                return pk;
            }
            return super.getOrgPK(action);
        }
        return super.getOrgPK(action);
    }

    protected HROrgUnitInfo getMyOrgPK(String selectedId) {
        if (selectedId == null) {
            return null;
        }
        HROrgUnitInfo info = null;
        if (positionHROCache.containsKey(selectedId)) {
            info = positionHROCache.get(selectedId) instanceof Object[] ? (HROrgUnitInfo)((Object[])positionHROCache.get(selectedId))[0] : (HROrgUnitInfo)positionHROCache.get(selectedId);
        } else {
            try {
                info = BOSUuid.read((String)selectedId).getType().toString().equals("74AE612E") ? OrgHRCommonFactory.getRemoteInstance().getPositionOrgHRO(selectedId) : OrgHRCommonFactory.getRemoteInstance().getAdminOrgHRO(selectedId);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        positionHROCache.put(selectedId, info);
        return info;
    }

    @Override
    public void actionEmpTypeConventAudit_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"cadre", (Object)"cadre");
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertHisListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        EmpTypeConvertHisListUI ui = (EmpTypeConvertHisListUI)curDialog.getUIObject();
        ui.setUITitle(EASResource.getString((String)RESOURCE, (String)"CADRE_AUDIT"));
        curDialog.show();
        this.isRefresh = ((EmpTypeConvertHisListUI)curDialog.getUIObject()).isRefreshParent();
        if (this.isRefresh) {
            this.tblMain.removeRows();
        }
    }

    @Override
    public void actionEmpTypeConventHis_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"PersonID", (Object)this.getSelectedPersonSet());
        uiContext.put((Object)"isOnePerson", (Object)"1");
        uiContext.put((Object)"cadre", (Object)"cadre");
        IUIWindow curDialog = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EmpTypeConvertHisListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        curDialog.show();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.PEOPLE_ORGANIZATION;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("PMUser.id", (Object)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("OrgRange.type", (Object)OrgRangeType.ADMIN_ORG_TYPE.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("ToUnit.id", (Object)this.permissionHROrg, CompareType.INCLUDE));
        TreePath path = this.treeMain.getSelectionPath();
        if (path == null) {
            return filter;
        }
        this.selectNode = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (this.selectNode.getUserObject() instanceof EmployeeFenLeiInfo) {
            EmployeeFenLeiInfo fenLeiInfo = (EmployeeFenLeiInfo)this.selectNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("EmpFenLei.longNumber", (Object)fenLeiInfo.getLongNumber()));
            filter.getFilterItems().add(new FilterItemInfo("EmpFenLei.longNumber", (Object)(fenLeiInfo.getLongNumber() + "!%"), CompareType.LIKE));
            filter.setMaskString("#0 and #1 and #2 and (#3 or #4)");
        } else if (this.selectNode.getUserObject() instanceof EmployeeTypeInfo) {
            EmployeeTypeInfo typeInfo = (EmployeeTypeInfo)this.selectNode.getUserObject();
            filter.getFilterItems().add(new FilterItemInfo("employeeType.id", (Object)typeInfo.getId().toString()));
            filter.setMaskString("#0 and #1 and #2 and #3");
        }
        try {
            FilterInfo otherFilter = new FilterInfo("AdminOrgUnit.isSealUp = 0 and employeeType.inService<>1");
            filter.mergeFilter(otherFilter, "and");
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return filter;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    private void displayAllName() {
        boolean isSelected = this.chkDisplayName.isSelected();
        if (!this.tblMain.getColumn("oldPersonDep.name").getStyleAttributes().isHided() || !this.tblMain.getColumn("oldPersonDep.displayName").getStyleAttributes().isHided()) {
            this.tblMain.getColumn("oldPersonDep.name").getStyleAttributes().setHided(isSelected);
            this.tblMain.getColumn("oldPersonDep.displayName").getStyleAttributes().setHided(!isSelected);
            if (isSelected) {
                this.tblMain.getColumn("oldPersonDep.name").setWidth(-1);
            } else {
                this.tblMain.getColumn("oldPersonDep.displayName").setWidth(-1);
            }
        }
        if (!this.tblMain.getColumn("admin").getStyleAttributes().isHided() || !this.tblMain.getColumn("admin.displayName").getStyleAttributes().isHided()) {
            this.tblMain.getColumn("admin").getStyleAttributes().setHided(isSelected);
            this.tblMain.getColumn("admin.displayName").getStyleAttributes().setHided(!isSelected);
            if (isSelected) {
                this.tblMain.getColumn("admin").setWidth(-1);
            } else {
                this.tblMain.getColumn("admin.displayName").setWidth(-1);
            }
        }
    }

    @Override
    public void actionDisplayName_actionPerformed(ActionEvent e) throws Exception {
        this.displayAllName();
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        super.tblMain_doRequestRowSet(e);
        this.displayAllName();
    }

    protected void doFieldPermission() {
    }

    @Override
    public void actionPrintCadreInfo_actionPerformed(ActionEvent e) throws Exception {
        this.handleDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                RetireeCadreUI.this.execPrintSelectCadreInfo();
                return null;
            }
        });
    }

    @Override
    public void actionPrintCadreInfoAll_actionPerformed(ActionEvent e) throws Exception {
        this.handleDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                RetireeCadreUI.this.execPrintAllCadreInfo();
                return null;
            }
        });
    }

    private void execPrintSelectCadreInfo() throws Exception {
        int[] selectRowIndexs = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int size = selectRowIndexs.length;
        if (size <= 0) {
            throw new EmployeeException(EmployeeException.TDALL_NODATA);
        }
        HashSet<String> personIdSet = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            IRow row = this.tblMain.getRow(selectRowIndexs[i]);
            String personId = row.getCell("id").getValue().toString();
            personIdSet.add(personId);
        }
        FilterInfo filter = new FilterInfo();
        if (personIdSet != null && personIdSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", personIdSet, CompareType.INCLUDE));
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        EmployeeDetailNoteDataProvider data = new EmployeeDetailNoteDataProvider(filter, (Map)this.map);
        appHlp.printPreview("HR/KT/CadreDetail", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private void execPrintAllCadreInfo() throws Exception {
        if (this.tblMain.getRowCount() <= 0) {
            throw new EmployeeException(EmployeeException.TDALL_NODATA);
        }
        KDNoteHelper appHlp = new KDNoteHelper();
        EmployeeDetailNoteDataProvider data = new EmployeeDetailNoteDataProvider(this.getPrintFilter(), (Map)this.map);
        appHlp.printPreview("HR/KT/CadreDetail", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private FilterInfo getPrintFilter() throws Exception {
        FilterInfo filter = new FilterInfo();
        String sqlId = this.getQueryExecutor(this.mainQueryPK, this.mainQuery).getSQL();
        StringBuffer sql = new StringBuffer();
        sql.append("select tt.id  from ");
        sql.append("(");
        sql.append(sqlId);
        sql.append(") tt ");
        String sqlPersonId = KSqlUtil.optimize((String)sql.toString());
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sqlPersonId, CompareType.INNER));
        return filter;
    }

    private void handleDataTask(GetDataTaskAdapter dataTaskAdapter) {
        GetDataDialog dlg = null;
        Window owner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        Window ownerWindow = ComponentUtil.getOwnerWindow((Component)owner);
        dlg = ownerWindow instanceof Frame ? new GetDataDialog((Frame)ownerWindow) : (ownerWindow instanceof Dialog ? new GetDataDialog((Dialog)ownerWindow) : new GetDataDialog((Frame)null));
        dlg.setGetDataTask(dataTaskAdapter);
        dlg.show();
    }

    private DefaultKingdeeTreeNode createEmployeeFenLeiTreeNode(boolean includeEmployeeType) throws Exception {
        IRowSet rows = this.getEmployeeFenLeiRowSet();
        if (rows == null) {
            return null;
        }
        DefaultKingdeeTreeNode rootTreeNode = new DefaultKingdeeTreeNode((Object)EASResource.getString((String)RESOURCE, (String)"empType"));
        DefaultKingdeeTreeNode subTreeNode = null;
        HashMap<String, DefaultKingdeeTreeNode> nodeMap = new HashMap<String, DefaultKingdeeTreeNode>();
        EmployeeFenLeiInfo employeeFenLeiInfo = null;
        while (rows.next()) {
            employeeFenLeiInfo = this.createEmployeeFenLeiInfo(rows);
            subTreeNode = new DefaultKingdeeTreeNode((Object)employeeFenLeiInfo);
            if (employeeFenLeiInfo.getParent() != null && nodeMap.containsKey(employeeFenLeiInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(employeeFenLeiInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            } else if (!employeeFenLeiInfo.getName().equals(EASResource.getString((String)RESOURCE, (String)"onPosition"))) {
                rootTreeNode.add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(employeeFenLeiInfo.getId().toString(), subTreeNode);
        }
        if (includeEmployeeType) {
            MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.EmployeeTypeFenLeiQuery");
            IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
            IRowSet empTypeRows = queryExcu.executeQuery();
            String empFenLeiId = null;
            EmployeeTypeInfo empTypeInfo = null;
            DefaultKingdeeTreeNode empTypeTreeNode = null;
            DefaultKingdeeTreeNode parentNode = null;
            while (empTypeRows.next()) {
                empFenLeiId = empTypeRows.getString("EmpLoyeeFenLei.id");
                if (!nodeMap.containsKey(empFenLeiId)) continue;
                empTypeInfo = this.createEmployeeTypeInfo(empTypeRows);
                empTypeTreeNode = new DefaultKingdeeTreeNode((Object)empTypeInfo);
                parentNode = (DefaultKingdeeTreeNode)nodeMap.get(empFenLeiId);
                parentNode.add((MutableTreeNode)empTypeTreeNode);
            }
        }
        nodeMap = null;
        return rootTreeNode;
    }

    private EmployeeTypeInfo createEmployeeTypeInfo(IRowSet row) throws Exception {
        EmployeeTypeInfo empTypeInfo = new EmployeeTypeInfo();
        empTypeInfo.setId(BOSUuid.read((String)row.getString("id")));
        empTypeInfo.setNumber(row.getString("number"));
        empTypeInfo.setName(row.getString("name"));
        empTypeInfo.setInService(EmployeeTypeEnum.getEnum((int)row.getInt("inService")));
        return empTypeInfo;
    }

    private IRowSet getEmployeeFenLeiRowSet() throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.base.app.EmployeeFenLeiLisQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        IRowSet rows = queryExcu.executeQuery();
        return rows;
    }

    private EmployeeFenLeiInfo createEmployeeFenLeiInfo(IRowSet row) throws Exception {
        EmployeeFenLeiInfo employeeFenLeiInfo = new EmployeeFenLeiInfo();
        employeeFenLeiInfo.setId(BOSUuid.read((String)row.getString("id")));
        employeeFenLeiInfo.setName(row.getString("name"));
        employeeFenLeiInfo.setNumber(row.getString("number"));
        employeeFenLeiInfo.setLongNumber(row.getString("longNumber"));
        employeeFenLeiInfo.setLevel(row.getInt("level"));
        employeeFenLeiInfo.setIsLeaf(row.getBoolean("isLeaf"));
        EmployeeFenLeiInfo parentInfo = new EmployeeFenLeiInfo();
        if (row.getString("Parent.id") == null || row.getString("Parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("Parent.id")));
        }
        employeeFenLeiInfo.setParent(parentInfo);
        return employeeFenLeiInfo;
    }
}

