/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.kt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.StringUtils;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.base.PositionRelatedInfo;
import com.kingdee.eas.hr.base.RelatedInfoGetFacadeFactory;
import com.kingdee.eas.hr.kt.CadreBillBizException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.util.Date;

public class CadreManagerUtil {
    public static final String RESOURCE = "com.kingdee.eas.hr.kt.client.KtResource";

    public static void validateDate(KDTable table, String startDateColumnName, String endDateColumnName) throws Exception {
        if (table.getRowCount() > 0) {
            Date startDate = null;
            Date endDate = null;
            int n = table.getRowCount();
            for (int i = 0; i < n; ++i) {
                startDate = (Date)table.getRow(i).getCell(startDateColumnName).getValue();
                endDate = (Date)table.getRow(i).getCell(endDateColumnName).getValue();
                if (startDate == null || endDate == null || !DateTimeUtils.dayBefore((Date)endDate, (Date)startDate)) continue;
                throw new CadreBillBizException(CadreBillBizException.END_DATE_ERROR, new Object[]{i + 1});
            }
        }
    }

    public static void validateEditUI(KDDatePicker startdate, KDDatePicker endDate) throws CadreBillBizException {
        if (startdate.getValue() != null && endDate.getValue() != null && DateTimeUtils.dayBefore((Date)((Date)endDate.getValue()), (Date)((Date)startdate.getValue()))) {
            throw new CadreBillBizException(CadreBillBizException.DATE_VALIDATE);
        }
    }

    public static void validateNumberAndName(KDTextField txtNumber, KDBizMultiLangBox txtName) {
        if (txtNumber.isEnabled() && txtNumber != null && StringUtils.isEmpty((String)txtNumber.getText())) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"NUMBER_NOT_NULL"));
            txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (txtName != null && StringUtils.isEmpty((String)txtName.getSelectedItemData().toString())) {
            MsgBox.showWarning((String)EASResource.getString((String)RESOURCE, (String)"NAME_NOT_NULL"));
            txtName.requestFocus();
            SysUtil.abort();
        }
    }

    public static void positionChanged(IRow row, PositionInfo pInfo, String columnName) throws Exception {
        if (pInfo != null) {
            String pId = pInfo.getId().toString();
            PositionRelatedInfo pRelatedInfo = RelatedInfoGetFacadeFactory.getRemoteInstance().getPositionRelatedInfo(pId);
            if (pRelatedInfo == null) {
                return;
            }
            if (pRelatedInfo.getPosition().getAdminOrgUnit() != null) {
                row.getCell(columnName).setValue((Object)pRelatedInfo.getPosition().getAdminOrgUnit());
            }
            if (pRelatedInfo.getPosition().getAdminOrgUnit() != null) {
                pInfo.setJob(pRelatedInfo.getJob());
            }
        }
    }

    public static KDWorkButton addButton(DetailPanel panel) {
        if (panel == null) {
            return null;
        }
        Component com = null;
        int count = panel.getComponentCount();
        for (int i = 0; i < count && !"controlPanel".equals((com = panel.getComponent(i)).getName()); ++i) {
            com = null;
        }
        if (com != null) {
            KDPanel detailPanel = (KDPanel)com;
            KDWorkButton btnSelect = new KDWorkButton();
            detailPanel.add((Component)btnSelect, (Object)new KDLayout.Constraints(880, 5, 22, 19, 9));
            return btnSelect;
        }
        return null;
    }

    public static boolean isComboxEmptyInKDT(KDTable kdtEntrys, int rowIndex, String colName) {
        boolean isEmpty = true;
        ICellEditor editor = kdtEntrys.getRow(rowIndex).getCell(colName).getEditor();
        if (editor != null && editor.getComponent() != null && editor.getComponent() instanceof KDComboBox && ((KDComboBox)editor.getComponent()).getModel() != null && ((KDComboBox)editor.getComponent()).getModel().getSize() > 0) {
            isEmpty = false;
        }
        return isEmpty;
    }

    public static PositionMemberInfo getPMInfo(BOSUuid personId, BOSUuid positionId) {
        StringBuffer ksql = new StringBuffer("select id,beginDate,endDate ");
        ksql.append(" where person.id='" + personId + "' and position.id='" + positionId + "'");
        PositionMemberCollection pmCol = null;
        try {
            pmCol = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(ksql.toString());
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
        if (pmCol.size() > 0) {
            return pmCol.get(0);
        }
        return null;
    }
}

