/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.base.BlackListReasonFactory;
import com.kingdee.eas.hr.base.BlackListReasonInfo;
import com.kingdee.eas.hr.base.IBlackListReason;
import com.kingdee.eas.hr.base.IPersonBlackList;
import com.kingdee.eas.hr.base.PersonBlackListFactory;
import com.kingdee.eas.hr.base.PersonBlackListInfo;
import com.kingdee.eas.hr.base.SourceEnum;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.shr.recuritment.EnterpriseArchivesCollection;
import com.kingdee.shr.recuritment.EnterpriseArchivesFactory;
import com.kingdee.shr.recuritment.EnterpriseArchivesInfo;
import com.kingdee.shr.recuritment.IEnterpriseArchives;
import com.kingdee.util.StringUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class BlackListMoveHandler
implements ISHRMoveDataHandler {
    static final String INTEGRITY = "wSDFygTCTFqyaEMrCwEs/vay2f0=";
    static final String REFUSEOFFER = "/e3K49pFRaiPpYT0w6zka/ay2f0=";
    static final String INTERVIEWABSENT = "DA3LkSa9QI671vb8Q9jA/fay2f0=";
    static final String ELSEREASON = "fxYBywUYSY6C3xghu93vtvay2f0=";

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        try {
            IEnterpriseArchives iEnArchives = EnterpriseArchivesFactory.getLocalInstance((Context)ctx);
            IPersonBlackList ipBlackList = PersonBlackListFactory.getLocalInstance((Context)ctx);
            EnterpriseArchivesCollection enArchivesCollection = iEnArchives.getEnterpriseArchivesCollection(" where isblacklist='1'");
            int size = enArchivesCollection.size();
            for (int i = 0; i < size; ++i) {
                EnterpriseArchivesInfo enInfo = enArchivesCollection.get(i);
                PersonBlackListInfo personBlackInfo = new PersonBlackListInfo();
                personBlackInfo.setIdCardNO(enInfo.getIdentityCardNo());
                personBlackInfo.setPassportNO(enInfo.getPassportNo());
                personBlackInfo.setSource(SourceEnum.USER_ADD);
                personBlackInfo.setPersonName(enInfo.getName());
                personBlackInfo.setJoinReason(new BlackListMoveHandler().convertBlackReason(enInfo.getToBlackListReason().getId().toString(), ctx));
                personBlackInfo.setAddPersonName(enInfo.getAddPersonName());
                personBlackInfo.setJoinDate(enInfo.getJoinBlackDate());
                personBlackInfo.setRema(enInfo.getJoinBlackListRema());
                if (!StringUtils.isEmpty((String)enInfo.getIdentityCardNo())) {
                    if (ipBlackList.exists(" where idCardNO='" + enInfo.getIdentityCardNo() + "'")) continue;
                    ipBlackList.addnew((CoreBaseInfo)personBlackInfo);
                    continue;
                }
                if (StringUtils.isEmpty((String)enInfo.getPassportNo()) || ipBlackList.exists(" where passportNO='" + enInfo.getPassportNo() + "'")) continue;
                ipBlackList.addnew((CoreBaseInfo)personBlackInfo);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    BlackListReasonInfo convertBlackReason(String reasonId, Context ctx) {
        try {
            IBlackListReason iBlackReason = BlackListReasonFactory.getLocalInstance((Context)ctx);
            if (reasonId.equals(INTEGRITY)) {
                return iBlackReason.getBlackListReasonInfo("where id='wSDFygTCTFqyaEMrCwEs/vay2f0='");
            }
            if (reasonId.equals(REFUSEOFFER)) {
                return iBlackReason.getBlackListReasonInfo("where id='/e3K49pFRaiPpYT0w6zka/ay2f0='");
            }
            if (reasonId.equals(INTERVIEWABSENT)) {
                return iBlackReason.getBlackListReasonInfo("where id='DA3LkSa9QI671vb8Q9jA/fay2f0='");
            }
            if (reasonId.equals(ELSEREASON)) {
                return iBlackReason.getBlackListReasonInfo("where id='fxYBywUYSY6C3xghu93vtvay2f0='");
            }
            return null;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return null;
    }
}

