/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.shr.baseconfig.ConfigSchemePermissionCollection;
import com.kingdee.shr.baseconfig.ConfigSchemePermissionFactory;
import com.kingdee.shr.baseconfig.ConfigSchemePermissionInfo;
import com.kingdee.shr.baseconfig.IConfigSchemePermission;
import com.kingdee.shr.baseconfig.StructureConfigSchemeInfo;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class ConfigSchemePermissionMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(ConfigSchemePermissionMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5f00\u59cb\u6570\u636e\u8fc1\u79fb\u3010\u4fe1\u606f\u96c6\u6743\u9650\u5206\u914d\u3011----------------------------------------------------------------------------");
        ConfigSchemePermissionCollection shr_collection = new ConfigSchemePermissionCollection();
        ConfigSchemePermissionCollection eas_collection = new ConfigSchemePermissionCollection();
        shr_collection = this.getSHRData(shrConn, ctx);
        eas_collection = ConfigSchemePermissionFactory.getRemoteInstance().getConfigSchemePermissionCollection();
        ConfigSchemePermissionCollection diffQCollectionSHR = null;
        if (eas_collection.isEmpty()) {
            this.addSHRDataToEAS(ctx, shr_collection);
        } else {
            diffQCollectionSHR = this.compareData(ctx, eas_collection, shr_collection);
            if (diffQCollectionSHR.size() > 0) {
                this.addSHRDataToEAS(ctx, diffQCollectionSHR);
            }
        }
        logger.info((Object)"-------------------------------------------------------\u7ed3\u675f\u6570\u636e\u8fc1\u79fb\u3010\u4fe1\u606f\u96c6\u6743\u9650\u5206\u914d\u3011----------------------------------------------------------------------------");
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0id\u3010\u4fe1\u606f\u96c6\u6743\u9650\u5206\u914d\u3011----------------------------------------------------------------------------");
        this.do_moveAfter(ctx);
        return null;
    }

    private void do_moveAfter(Context ctx) throws EASBizException, BOSException, SQLException {
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_HR_ConfigSchemePermission", "FUserId");
    }

    public ConfigSchemePermissionCollection compareData(Context ctx, ConfigSchemePermissionCollection eas_collection, ConfigSchemePermissionCollection shr_collection) {
        ConfigSchemePermissionInfo infoEAS = null;
        ConfigSchemePermissionInfo infoSHR = null;
        ConfigSchemePermissionCollection diffCollectionSHR = new ConfigSchemePermissionCollection();
        boolean match = false;
        for (int i = 0; i < shr_collection.size(); ++i) {
            infoSHR = shr_collection.get(i);
            for (int j = 0; j < eas_collection.size(); ++j) {
                infoEAS = eas_collection.get(j);
                if (infoEAS.getId().toString().equals(infoSHR.getId().toString())) {
                    match = true;
                    break;
                }
                if (!infoEAS.getUser().getId().toString().equals(infoSHR.getUser().getId().toString()) || !infoEAS.getScheme().getId().toString().equals(infoSHR.getScheme().getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS(Context ctx, ConfigSchemePermissionCollection shr_collection) throws EASBizException, BOSException {
        ConfigSchemePermissionInfo info = null;
        IConfigSchemePermission ConfigScheme = ConfigSchemePermissionFactory.getRemoteInstance();
        for (int i = 0; i < shr_collection.size(); ++i) {
            info = shr_collection.get(i);
            ConfigScheme.addnew(info);
        }
    }

    public ConfigSchemePermissionCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_HR_ConfigSchemePermission";
        ConfigSchemePermissionCollection shrCollection = new ConfigSchemePermissionCollection();
        ConfigSchemePermissionInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_HR_ConfigSchemePermission".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fschemeid = colummnsmap.containsKey("fschemeid".toUpperCase()) ? rs.getString("fschemeid") : "";
                String fuserid = colummnsmap.containsKey("fuserid".toUpperCase()) ? rs.getString("fuserid") : "";
                String froleid = colummnsmap.containsKey("froleid".toUpperCase()) ? rs.getString("froleid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new ConfigSchemePermissionInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                if (fschemeid != null && !fschemeid.isEmpty()) {
                    StructureConfigSchemeInfo scheme = new StructureConfigSchemeInfo();
                    scheme.setId(BOSUuid.read((String)fschemeid));
                    shrInfo.setScheme(scheme);
                }
                if (fuserid != null && !fuserid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fuserid));
                    shrInfo.setUser(user);
                }
                if (froleid != null && !froleid.isEmpty()) {
                    RoleInfo role = new RoleInfo();
                    role.setId(BOSUuid.read((String)fuserid));
                    shrInfo.setRole(role);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

