/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.JobCollection;
import com.kingdee.eas.basedata.org.JobFactory;
import com.kingdee.eas.basedata.org.JobInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.JobCategoryMoveHandler;
import com.kingdee.eas.hr.mvdt.util.BaseDataUpdateTool;
import com.kingdee.eas.hr.mvdt.util.WriteExcelDataTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class JobMoveHandler
implements ISHRMoveDataHandler {
    public static final String BOSTYPE = "75702498";
    public static List<String> excelHead = new ArrayList<String>();

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        JobCategoryMoveHandler categoryHandler = new JobCategoryMoveHandler();
        ArrayList<List<String>> categoryDatas = new ArrayList<List<String>>();
        ArrayList<List<String>> jobDatas = new ArrayList<List<String>>();
        categoryHandler.verifyData(shrConn, ctx, categoryDatas);
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet1 = workbook.createSheet("\u804c\u4f4d\u7c7b\u6570\u636e\u5bf9\u6bd4");
        WriteExcelDataTool.writeDataByRowList(workbook, sheet1, 2, JobCategoryMoveHandler.excelHead, categoryDatas);
        this.doSelfVerifyData(shrConn, ctx, jobDatas);
        HSSFSheet sheet2 = workbook.createSheet("\u804c\u4f4d\u6570\u636e\u5bf9\u6bd4");
        WriteExcelDataTool.writeDataByRowList(workbook, sheet2, 2, excelHead, jobDatas);
        File dir = new File("c://\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u804c\u4f4d.xls");
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(dir);
            workbook.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void doSelfVerifyData(Connection shrConn, Context ctx, List<List<String>> jobDatas) throws BOSException, EASBizException {
        String oql = "select id,number,name,jobCategory.id,jobCategory.name,jobCategory.number,jobFamily.name";
        JobCollection JobCollectionEAS = JobFactory.getLocalInstance((Context)ctx).getJobCollection(oql);
        JobCollection JobCollectionSHR = this.querySHRData(shrConn, ctx);
        JobCollection diffCollectionSHR = this.compareData(ctx, JobCollectionEAS, JobCollectionSHR, jobDatas);
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        JobCategoryMoveHandler categoryHandler = new JobCategoryMoveHandler();
        categoryHandler.moveData(shrConn, ctx);
        String tableName = "T_ORG_Job";
        String compareKey = "FNUMBER";
        BaseDataUpdateTool.commonUpdate(shrConn, tableName, "", ctx, 0);
        return null;
    }

    private JobCollection compareData(Context ctx, JobCollection JobCollectionEAS, JobCollection JobCollectionSHR, List<List<String>> list) throws BOSException, EASBizException {
        int j;
        int i;
        JobInfo infoEAS = null;
        JobInfo infoSHR = null;
        JobCollection diffCollectionSHR = new JobCollection();
        boolean match = false;
        String oql = "where bosType ='75702498'";
        SynIdMappingFactory.getLocalInstance(ctx).delete(oql);
        for (i = 0; i < JobCollectionSHR.size(); ++i) {
            infoSHR = JobCollectionSHR.get(i);
            for (j = 0; j < JobCollectionEAS.size(); ++j) {
                infoEAS = JobCollectionEAS.get(j);
                if (!infoEAS.getNumber().equals(infoSHR.getNumber())) continue;
                this.generateMappingTable(ctx, infoSHR, infoEAS);
                this.generateMappingTrueExcelData(ctx, infoSHR, infoEAS, list);
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInEASMappingExcelData(ctx, infoSHR, infoEAS, list);
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        match = true;
        for (i = 0; i < JobCollectionEAS.size(); ++i) {
            infoEAS = JobCollectionEAS.get(i);
            for (j = 0; j < JobCollectionSHR.size(); ++j) {
                infoSHR = JobCollectionSHR.get(j);
                if (infoEAS.getNumber().equals(infoSHR.getNumber())) continue;
                match = false;
                break;
            }
            if (match) continue;
            this.generateNotFoundInSHRMappingExcelData(ctx, infoSHR, infoEAS, list);
            match = true;
        }
        return diffCollectionSHR;
    }

    private void generateMappingTable(Context ctx, JobInfo infoSHR, JobInfo infoEAS) throws EASBizException, BOSException {
        String infoSHRId = infoSHR.getId().toString();
        String infoEASId = infoEAS.getId().toString();
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    private void generateMappingTrueExcelData(Context ctx, JobInfo infoSHR, JobInfo infoEAS, List<List<String>> list) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("subCategoryName")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("categoryNumber")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("categoryName")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("jobfamilyName")));
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        resultRow.add(infoEAS.getJobCategory().getNumber());
        resultRow.add(infoEAS.getJobCategory().getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(true));
        boolean categoryMatching = StringUtil.equals((String)((String)infoSHR.get("categoryNumber")), (String)infoEAS.getNumber());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(categoryMatching));
        resultRow.add("");
        list.add(resultRow);
    }

    private void generateNotFoundInEASMappingExcelData(Context ctx, JobInfo infoSHR, JobInfo infoEAS, List<List<String>> list) throws EASBizException, BOSException {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("subCategoryName")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("categoryNumber")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("categoryName")));
        resultRow.add(WriteExcelDataTool.transNULLToQuotation((String)infoSHR.get("jobfamilyName")));
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        if (JobFactory.getLocalInstance((Context)ctx).exists("where number ='" + infoSHR.getNumber() + "'")) {
            resultRow.add(WriteExcelDataTool.transBooleanToChinese(true));
        } else {
            resultRow.add("");
        }
        list.add(resultRow);
    }

    private void generateNotFoundInSHRMappingExcelData(Context ctx, JobInfo infoSHR, JobInfo infoEAS, List<List<String>> list) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        resultRow.add(infoEAS.getJobCategory().getNumber());
        resultRow.add(infoEAS.getJobCategory().getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(false));
        resultRow.add("");
        list.add(resultRow);
    }

    public JobCollection querySHRData(Connection shrConn, Context ctx) throws BOSException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select joba.fid as jobid,joba.fnumber as jobnumber,joba.fname_l2 as jobName,  category.fnumber as categoryNumber,category.fname_l2 as categoryName,subCategory.fname_l2 as subCategoryName,jobfamily.fname_l2 as jobfamilyName  from T_ORG_Job joba  left join t_org_jobcategory category on joba.FJobCategoryID = category.fid  left join t_hr_jobSubCategory subCategory on joba.FJobSubCategoryID = subCategory.fid  left join t_hr_jobFamily jobfamily on joba.fjobFamilyid = jobfamily.fid ";
        JobCollection shrCollection = new JobCollection();
        JobInfo shrInfo = null;
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String jobid = rs.getString("jobid");
                String jobnumber = rs.getString("jobnumber");
                String jobName = rs.getString("jobName");
                String categoryNumber = rs.getString("categoryNumber");
                String categoryName = rs.getString("categoryName");
                String subCategoryName = rs.getString("subCategoryName");
                String jobfamilyName = rs.getString("jobfamilyName");
                shrInfo = new JobInfo();
                shrInfo.setId(BOSUuid.read((String)jobid));
                shrInfo.setNumber(jobnumber);
                shrInfo.setName(jobName);
                shrInfo.put("categoryNumber", (Object)categoryNumber);
                shrInfo.put("categoryName", (Object)categoryName);
                shrInfo.put("subCategoryName", (Object)subCategoryName);
                shrInfo.put("jobfamilyName", (Object)jobfamilyName);
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    static {
        excelHead.add("\u804c\u4f4d\u7f16\u7801");
        excelHead.add("\u804c\u4f4d\u540d\u79f0");
        excelHead.add("\u804c\u4f4d\u5b50\u7c7b");
        excelHead.add("\u804c\u4f4d\u7c7b\u7f16\u7801");
        excelHead.add("\u804c\u4f4d\u7c7b\u540d\u79f0");
        excelHead.add("\u804c\u4f4d\u65cf");
        excelHead.add("\u804c\u52a1\u7f16\u7801");
        excelHead.add("\u804c\u52a1\u540d\u79f0");
        excelHead.add("\u804c\u52a1\u7c7b\u578b\u7f16\u7801");
        excelHead.add("\u804c\u52a1\u7c7b\u578b\u540d\u79f0");
        excelHead.add("\u662f\u5426\u5339\u914d");
        excelHead.add("\u804c\u4f4d\u7c7b\u662f\u5426\u5339\u914d");
        excelHead.add("\u7f16\u7801\u91cd\u590d");
    }
}

