/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.basedata.org.IOrgUnitLayerAdminRelation;
import com.kingdee.eas.basedata.org.OrgUnitLayerAdminRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitLayerAdminRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitLayerAdminRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitLayerTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.SynIdMappingCollection;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SynIdMappingUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;

public class OrgUnitLayerAdminRelaMoveHandler
implements ISHRMoveDataHandler {
    public static final String BOSTYPE = "5D659FDD";

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionEAS = OrgUnitLayerAdminRelationFactory.getLocalInstance((Context)ctx).getOrgUnitLayerAdminRelationCollection();
        OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionSHR = this.querySHRData(shrConn, ctx);
        OrgUnitLayerAdminRelationCollection diffCollectionSHR = null;
        if (OrgUnitLayerAdminRelationCollectionEAS.isEmpty()) {
            this.addSHRDataToEAS(ctx, OrgUnitLayerAdminRelationCollectionSHR);
        } else {
            diffCollectionSHR = this.compareData(ctx, OrgUnitLayerAdminRelationCollectionEAS, OrgUnitLayerAdminRelationCollectionSHR);
            if (diffCollectionSHR.size() > 0) {
                this.addSHRDataToEAS(ctx, diffCollectionSHR);
            }
        }
        this.refreshLinkProperties(shrConn, ctx);
        return null;
    }

    private void refreshLinkProperties(Connection shrConn, Context ctx) throws BOSException {
        String oql = "where bosType ='62824988';";
        SynIdMappingCollection mappingCollection = SynIdMappingFactory.getLocalInstance(ctx).getSynIdMappingCollection(oql);
        OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionEASTotal = OrgUnitLayerAdminRelationFactory.getLocalInstance((Context)ctx).getOrgUnitLayerAdminRelationCollection();
        ArrayList<String> listSQL = new ArrayList<String>();
        String updateSQL = "update T_BD_OrgUnitLayerAdminRelation set FUnitLayer = ";
        for (int i = 0; i < OrgUnitLayerAdminRelationCollectionEASTotal.size(); ++i) {
            OrgUnitLayerAdminRelationInfo info = OrgUnitLayerAdminRelationCollectionEASTotal.get(i);
            String linkIdSHR = info.getUnitLayer().getId().toString();
            String linkIdEAS = SynIdMappingUtil.findEASIdBySHRIdInCollection(mappingCollection, linkIdSHR);
            if (StringUtils.isEmpty((CharSequence)linkIdEAS)) continue;
            updateSQL = "update T_BD_OrgUnitLayerAdminRelation set FUnitLayer = ";
            updateSQL = updateSQL + "'" + linkIdEAS + "' where fid ='" + info.getId().toString() + "'";
            listSQL.add(updateSQL);
        }
        DbUtil.executeBatch((Context)ctx, listSQL);
    }

    private OrgUnitLayerAdminRelationCollection compareData(Context ctx, OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionEAS, OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionSHR) throws BOSException, EASBizException {
        OrgUnitLayerAdminRelationInfo infoEAS = null;
        OrgUnitLayerAdminRelationInfo infoSHR = null;
        OrgUnitLayerAdminRelationCollection diffCollectionSHR = new OrgUnitLayerAdminRelationCollection();
        boolean match = false;
        String oql = "where bosType ='5D659FDD'";
        SynIdMappingFactory.getLocalInstance(ctx).delete(oql);
        for (int i = 0; i < OrgUnitLayerAdminRelationCollectionSHR.size(); ++i) {
            infoSHR = OrgUnitLayerAdminRelationCollectionSHR.get(i);
            for (int j = 0; j < OrgUnitLayerAdminRelationCollectionEAS.size(); ++j) {
                infoEAS = OrgUnitLayerAdminRelationCollectionEAS.get(j);
                if (!infoEAS.getAdminUnit().equals(infoSHR.getAdminUnit())) continue;
                this.generateMappingTable(ctx, infoSHR, infoEAS);
                this.syncSHRFieldValueToEAS(ctx, infoSHR, infoEAS);
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private void generateMappingTable(Context ctx, OrgUnitLayerAdminRelationInfo infoSHR, OrgUnitLayerAdminRelationInfo infoEAS) throws EASBizException, BOSException {
        String infoSHRId = infoSHR.getId().toString();
        String infoEASId = infoEAS.getId().toString();
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    public void syncSHRFieldValueToEAS(Context ctx, OrgUnitLayerAdminRelationInfo infoSHR, OrgUnitLayerAdminRelationInfo infoEAS) throws EASBizException, BOSException {
        infoEAS.setUnitLayer(infoSHR.getUnitLayer());
        infoEAS.setDescription(infoSHR.getDescription());
        SelectorItemCollection items = new SelectorItemCollection();
        items.add(new SelectorItemInfo("unitLayer"));
        items.add(new SelectorItemInfo("description"));
        OrgUnitLayerAdminRelationFactory.getLocalInstance((Context)ctx).updatePartial(infoEAS, items);
    }

    public OrgUnitLayerAdminRelationCollection querySHRData(Connection shrConn, Context ctx) throws BOSException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BD_OrgUnitLayerAdminRelation";
        OrgUnitLayerAdminRelationCollection shrCollection = new OrgUnitLayerAdminRelationCollection();
        OrgUnitLayerAdminRelationInfo shrInfo = null;
        OrgUnitLayerTypeInfo linkInfo = null;
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = rs.getString("fid");
                String FAdminUnit = rs.getString("FAdminUnit");
                String desc = rs.getString("FDescription_l2");
                String FUnitLayer = rs.getString("FUnitLayer");
                linkInfo = new OrgUnitLayerTypeInfo();
                linkInfo.setId(BOSUuid.read((String)FUnitLayer));
                shrInfo = new OrgUnitLayerAdminRelationInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setAdminUnit(FAdminUnit);
                shrInfo.setDescription(desc);
                shrInfo.setUnitLayer(linkInfo);
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public void addSHRDataToEAS(Context ctx, OrgUnitLayerAdminRelationCollection OrgUnitLayerAdminRelationCollectionSHR) throws BOSException, EASBizException {
        OrgUnitLayerAdminRelationInfo info = null;
        IOrgUnitLayerAdminRelation OrgUnitLayerAdminRelation = OrgUnitLayerAdminRelationFactory.getLocalInstance((Context)ctx);
        for (int i = 0; i < OrgUnitLayerAdminRelationCollectionSHR.size(); ++i) {
            info = OrgUnitLayerAdminRelationCollectionSHR.get(i);
            OrgUnitLayerAdminRelation.addnew(info);
        }
    }
}

