/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.handler.AdminMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PersonMoveDataHandler
implements ISHRMoveDataHandler {
    private String personBossType = "80EF7DED";

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        this.movePersonAction(shrConn, ctx);
        this.movePersonHisAction(shrConn, ctx);
        this.movePersonPositionAction(shrConn, ctx);
        this.movePersonPositionHISAction(shrConn, ctx);
        this.movePositionMemberAction(shrConn, ctx);
        try {
            String sql = "SELECT FMVTABLENAME FROM T_HR_SHRMvTableList WHERE FBIZTYPE IN ('PERSON','ADMIN','JOB')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String tableNames = executeQuery.getString("FMVTABLENAME");
                UpdateTool.autoUpdateTablesByTableNames(ctx, tableNames);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_HR_HRInit WHERE FKEY = 'IS_BASEDATA_UPDATE_TO600'");
        AdminMoveDataHandler AdminMoveDataHandler2 = new AdminMoveDataHandler();
        AdminMoveDataHandler2.updateWhenEasRootMore(shrConn, ctx);
        DbUtil.execute((Context)ctx, (String)"UPDATE T_BD_PERSONHIS SET FHISTORYRELATEID = (select top 1 FID from T_BD_PERSON where T_BD_PERSONHIS.FNUMBER = T_BD_PERSON.FNUMBER)");
        DbUtil.execute((Context)ctx, (String)"UPDATE T_HR_PERSONPOSITIONHIS SET FHISTORYRELATEID = (select top 1 FID from T_HR_PERSONPOSITION where T_HR_PERSONPOSITIONHIS.FPERSONID = T_HR_PERSONPOSITION.FPERSONID)");
        return null;
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String shrNumber;
        String tableName = "T_BD_PERSON";
        String oql = "where bosType ='" + this.personBossType + "'";
        SynIdMappingFactory.getRemoteInstance().delete(oql);
        List<Map<String, String>> shrPersonResultList = PersonMoveDataHandler.getShrPersonList(shrConn, ctx);
        List<Map<String, String>> easPersonResultList = PersonMoveDataHandler.getEasPersonList(shrConn, ctx);
        for (int i = 0; i < shrPersonResultList.size(); ++i) {
            Map<Object, Object> shrMap = new HashMap();
            shrMap = shrPersonResultList.get(i);
            String shrName = shrMap.get("shrName") == null ? "" : (String)shrMap.get("shrName");
            shrNumber = shrMap.get("shrNumber") == null ? "" : (String)shrMap.get("shrNumber");
            for (int j = 0; j < easPersonResultList.size(); ++j) {
                String easNumber;
                Map<Object, Object> easMap = new HashMap();
                easMap = easPersonResultList.get(j);
                String easName = easMap.get("easName") == null ? "" : (String)easMap.get("easName");
                String string = easNumber = easMap.get("easNumber") == null ? "" : (String)easMap.get("easNumber");
                if (!shrName.equals(easName) || !shrNumber.equals(easNumber)) continue;
                SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                synIdMappingInfo.setBosType(this.personBossType);
                synIdMappingInfo.setShrId((String)shrMap.get("shrId"));
                synIdMappingInfo.setEasId((String)easMap.get("easId"));
                synIdMappingInfo.setMapWay("normal");
                SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
            }
        }
        try {
            String shrSql = "SELECT FID,FNUMBER FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrSql);
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FID");
                shrNumber = executeQuery.getString("FNUMBER");
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FNUMBER = '" + shrNumber + "' AND  FID NOT IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery2.next()) {
                    String easId = executeQuery2.getString("FID");
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.personBossType);
                    synIdMappingInfo.setShrId(shrId);
                    synIdMappingInfo.setEasId(easId);
                    synIdMappingInfo.setMapWay("number");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void movePersonAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_BD_PERSON";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName));
                UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            } else {
                ArrayList<String> columnList = new ArrayList<String>();
                Map<Object, Object> columnMap = new HashMap();
                columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
                Iterator<Object> iterator = columnMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String columnName = key = (String)iterator.next();
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName.toUpperCase(), columnName) || columnName.toUpperCase().equals("FID") || columnName.toUpperCase().equals("FNUMBER") || columnName.toUpperCase().equals("FDELETEDSTATUS") || columnName.toUpperCase().equals("FKACLASSFICATIONID") || columnName.toUpperCase().equals("FHRORGUNITID")) continue;
                    columnList.add(columnName);
                }
                SHRMoveDataHelpUtil.updateMapTableValue(shrConn, ctx, columnList, tableName + "_SHR_TEMP", tableName, this.personBossType, 10);
                String filterRepetitionId = "'ID\u91cd\u590d\u7684'";
                HashMap<String, String> idMap = new HashMap<String, String>();
                String sql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FID IN (" + sql + ")";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    BOSObjectType T = BOSObjectType.create((String)this.personBossType);
                    String newId = BOSUuid.create((BOSObjectType)T).toString();
                    filterRepetitionId = filterRepetitionId + ",'" + id + "'";
                    idMap.put(id, newId);
                }
                String filterAddnewId = "'\u53ef\u4ee5\u76f4\u63a5\u65b0\u589e\u7684'";
                String getAddnewSql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (" + filterRepetitionId + ") AND FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAddnewSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    filterAddnewId = filterAddnewId + ",'" + (String)id + "'";
                }
                if (filterAddnewId.contains(",")) {
                    UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddnewId + ") ", ctx, 100);
                }
                for (String key : idMap.keySet()) {
                    String updateSql = "UPDATE " + tableName + "_SHR_TEMP SET FID = '" + (String)idMap.get(key) + "' WHERE FID = '" + key + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.personBossType);
                    synIdMappingInfo.setShrId(key);
                    synIdMappingInfo.setEasId((String)idMap.get(key));
                    synIdMappingInfo.setMapWay("ID\u91cd\u590d");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
                if (idMap.size() > 0) {
                    String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
                    String insertSql = "INSERT INTO " + tableName + "(" + column + ") SELECT " + column + " FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePersonHisAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_BD_PERSONHIS";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String deleteSql = "DELETE FROM " + tableName;
            DbUtil.execute((Context)ctx, (String)deleteSql);
            UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePersonPositionAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_HR_PERSONPOSITION";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName));
                UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            } else {
                String deleteSql = "DELETE FROM " + tableName + " WHERE FPERSONID IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '80EF7DED')";
                DbUtil.execute((Context)ctx, (String)deleteSql);
                UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
                String sql = "SELECT FPERSONID,FID,FGKAdminID FROM " + tableName + "_EAS_TEMP";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                ArrayList<String> sqlList = new ArrayList<String>();
                while (executeQuery.next()) {
                    String personId = executeQuery.getString("FPERSONID");
                    String id = executeQuery.getString("FID");
                    String gkAdminId = "";
                    if (executeQuery.getString("FGKAdminID") != null) {
                        gkAdminId = executeQuery.getString("FGKAdminID");
                    }
                    String updateSql = "UPDATE " + tableName + " SET FGKAdminID = '" + gkAdminId + "',FID = '" + id + "' WHERE FPERSONID = '" + personId + "'";
                    sqlList.add(updateSql);
                }
                if (sqlList.size() > 0) {
                    SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 10);
                }
            }
            DbUtil.execute((Context)ctx, (String)"update T_HR_PERSONPOSITION set FEFFDT  = (select FEFFDT from T_HR_PERSONPOSITION_shr_temp where T_HR_PERSONPOSITION.FPERSONID =T_HR_PERSONPOSITION_shr_temp.FPERSONID) where FEFFDT is null");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePersonPositionHISAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_HR_PERSONPOSITIONHIS";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String deleteSql = "DELETE FROM " + tableName;
            DbUtil.execute((Context)ctx, (String)deleteSql);
            UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePositionMemberAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITIONMEMBER";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String deleteSql = "DELETE FROM " + tableName + " WHERE FPERSONID IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.personBossType + "')";
            DbUtil.execute((Context)ctx, (String)deleteSql);
            String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
            String insertSql = "INSERT INTO " + tableName + "(" + column + ") SELECT " + column + " FROM " + tableName + "_SHR_TEMP";
            DbUtil.execute((Context)ctx, (String)insertSql);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<Map<String, String>> getShrPersonList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> shrPersonResultList = new ArrayList<Map<String, String>>();
        Statement state = null;
        ResultSet rs = null;
        try {
            String dbName = shrConn.getMetaData().getDatabaseProductName();
            String shrSql = "select person.fnumber as easNumber,person.fname_l2 as easName,person.FIDCardNO as easIdCard,adminOrg.FDISPLAYNAME_L2 as easAdminOrgUnit,position.fname_l2 as easPosition,person.FID as personId from t_bd_person person left join T_HR_PersonPosition pp on person.fid = pp.FPersonID left join T_ORG_Admin adminOrg on pp.FPersonDep = adminOrg.fid left join T_ORG_POSITION position on pp.FPrimaryPositionID = position.fid";
            shrSql = "Oracle".equals(dbName) ? shrSql + " where pp.FLEFFDT = {ts'2199-12-31'}" : shrSql + " where pp.FLEFFDT = '2199-12-31'";
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", rs.getString(1));
                map.put("shrName", rs.getString(2));
                if (rs.getString(3) == null) {
                    map.put("shrIdCard", "");
                } else {
                    map.put("shrIdCard", rs.getString(3));
                }
                map.put("shrPosition", rs.getString(5));
                map.put("shrAdminOrgUnit", rs.getString(4));
                map.put("shrId", rs.getString(6));
                shrPersonResultList.add(map);
            }
            state.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return shrPersonResultList;
    }

    public static List<Map<String, String>> getEasPersonList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> easPersonResultList = new ArrayList<Map<String, String>>();
        try {
            int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
            String sql = "select person.fnumber as easNumber,person.fname_l2 as easName,person.FIDCardNO as easIdCard,adminOrg.FDISPLAYNAME_L2 as easAdminOrgUnit,position.fname_l2 as easPosition,person.FID as personId from t_bd_person person left join T_HR_PersonPosition pp on person.fid = pp.FPersonID left join T_ORG_Admin adminOrg on pp.FPersonDep = adminOrg.fid left join T_ORG_POSITION position on pp.FPrimaryPositionID = position.fid where person.FLEFFDT = {ts'2199-12-31'}";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easNumber", executeQuery.getString("easNumber"));
                map.put("easName", executeQuery.getString("easName"));
                map.put("easId", executeQuery.getString("personId"));
                if (executeQuery.getString("easIdCard") == null) {
                    map.put("easIdCard", "");
                } else {
                    map.put("easIdCard", executeQuery.getString("easIdCard"));
                }
                if (executeQuery.getString("easPosition") == null) {
                    map.put("easPosition", "");
                } else {
                    map.put("easPosition", executeQuery.getString("easPosition"));
                }
                if (executeQuery.getString("easAdminOrgUnit") == null) {
                    map.put("easAdminOrgUnit", "");
                } else if (level > 0) {
                    if (executeQuery.getString("easAdminOrgUnit").length() > level) {
                        map.put("easAdminOrgUnit", executeQuery.getString("easAdminOrgUnit").substring(level + 1));
                    }
                } else {
                    map.put("easAdminOrgUnit", executeQuery.getString("easAdminOrgUnit"));
                }
                easPersonResultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        return easPersonResultList;
    }
}

