/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PositionMoveDataHandler
implements ISHRMoveDataHandler {
    private String positionBossType = "74AE612E";
    private boolean positionIsAllMap = true;

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        this.movePositionAction(shrConn, ctx);
        this.movePositionHisAction(shrConn, ctx);
        this.moveHierarchyAction(shrConn, ctx);
        this.movePositionHierarchyAction(shrConn, ctx);
        try {
            String sql = "SELECT FMVTABLENAME FROM T_HR_SHRMvTableList WHERE FBIZTYPE IN ('POSITION')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String tableNames = executeQuery.getString("FMVTABLENAME");
                UpdateTool.autoUpdateTablesByTableNames(ctx, tableNames);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.refreshHierarchyTreeAction(shrConn, ctx);
        return null;
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITION";
        Object state = null;
        Object rs = null;
        int level = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        int startNumber = SHRMoveDataHelpUtil.getFilterDisplayName(ctx);
        String oql = "where bosType ='" + this.positionBossType + "'";
        SynIdMappingFactory.getRemoteInstance().delete(oql);
        List<Map<String, String>> shrPositionResultList = PositionMoveDataHandler.getShrPositionList(shrConn, ctx);
        List<Map<String, String>> easPositionResultList = PositionMoveDataHandler.getEasPositionList(shrConn, ctx);
        try {
            String shrSql = "SELECT FID,FNUMBER FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.positionBossType + "')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrSql);
            while (executeQuery.next()) {
                String shrId = executeQuery.getString("FID");
                String shrNumber = executeQuery.getString("FNUMBER");
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FNUMBER = '" + shrNumber + "' AND  FID NOT IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.positionBossType + "')";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery2.next()) {
                    String easId = executeQuery2.getString("FID");
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.positionBossType);
                    synIdMappingInfo.setShrId(shrId);
                    synIdMappingInfo.setEasId(easId);
                    synIdMappingInfo.setMapWay("number");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
            }
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void movePositionAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITION";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            if (SHRMoveDataHelpUtil.checkEasDBifEmpty()) {
                DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName));
                UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
            } else {
                String updateSql;
                ArrayList<String> columnList = new ArrayList<String>();
                Map<Object, Object> columnMap = new HashMap();
                columnMap = TableColumnSyncTool.getTableColumnMap(shrConn, tableName);
                Iterator<Object> iterator = columnMap.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String columnName = key = (String)iterator.next();
                    if (!SHRMoveDataHelpUtil.IfColumnExist(shrConn, ctx, tableName.toUpperCase(), columnName) || columnName.toUpperCase().equals("FID")) continue;
                    columnList.add(columnName);
                }
                SHRMoveDataHelpUtil.updateMapTableValue(shrConn, ctx, columnList, tableName + "_SHR_TEMP", tableName, this.positionBossType, 10);
                String filterRepetitionId = "'ID\u91cd\u590d\u7684'";
                HashMap<String, String> idMap = new HashMap<String, String>();
                String sql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.positionBossType + "')";
                String checkSql = "SELECT FID FROM " + tableName + " WHERE FID IN (" + sql + ")";
                IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    BOSObjectType T = BOSObjectType.create((String)this.positionBossType);
                    String newId = BOSUuid.create((BOSObjectType)T).toString();
                    filterRepetitionId = filterRepetitionId + ",'" + id + "'";
                    idMap.put(id, newId);
                }
                String filterAddnewId = "'\u53ef\u4ee5\u76f4\u63a5\u65b0\u589e\u7684'";
                String getAddnewSql = "SELECT FID FROM " + tableName + "_SHR_TEMP WHERE FID NOT IN (" + filterRepetitionId + ") AND FID NOT IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.positionBossType + "')";
                executeQuery = DbUtil.executeQuery((Context)ctx, (String)getAddnewSql);
                while (executeQuery.next()) {
                    String id = executeQuery.getString("FID");
                    filterAddnewId = filterAddnewId + ",'" + (String)id + "'";
                }
                if (filterAddnewId.contains(",")) {
                    UpdateTool.commonUpdate(shrConn, tableName, " WHERE FID IN (" + filterAddnewId + ") ", ctx, 100);
                }
                for (String key : idMap.keySet()) {
                    updateSql = "UPDATE " + tableName + "_SHR_TEMP SET FID = '" + (String)idMap.get(key) + "' WHERE FID = '" + key + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                    SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
                    synIdMappingInfo.setBosType(this.positionBossType);
                    synIdMappingInfo.setShrId(key);
                    synIdMappingInfo.setEasId((String)idMap.get(key));
                    synIdMappingInfo.setMapWay("ID\u91cd\u590d");
                    SynIdMappingFactory.getRemoteInstance().addnew(synIdMappingInfo);
                }
                if (idMap.size() > 0) {
                    String column = SHRMoveDataHelpUtil.getColumnAllSql(shrConn, ctx, tableName);
                    String insertSql = "INSERT INTO " + tableName + "(" + column + ") SELECT " + column + " FROM " + tableName + "_SHR_TEMP WHERE FID IN (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '" + this.positionBossType + "' AND FMapWay = 'ID\u91cd\u590d') AND FID NOT IN (SELECT FID FROM " + tableName + ")";
                    DbUtil.execute((Context)ctx, (String)insertSql);
                }
                for (String key : idMap.keySet()) {
                    updateSql = "UPDATE " + tableName + "_SHR_TEMP SET FID = '" + key + "' WHERE FID = '" + (String)idMap.get(key) + "'";
                    DbUtil.execute((Context)ctx, (String)updateSql);
                }
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePositionHisAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITIONHIS";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
        String deleteSql = "DELETE FROM " + tableName;
        DbUtil.execute((Context)ctx, (String)deleteSql);
        UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
    }

    public void moveHierarchyAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_HIERARCHY";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
        UpdateTool.commonUpdate(shrConn, tableName, "", ctx, 100);
        this.updateHierarchyAddShrAction(shrConn, ctx);
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
    }

    public void updateHierarchyAddShrAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        Statement state = null;
        ResultSet rs = null;
        try {
            String filterId = "'1'";
            String shrSql = "SELECT FID FROM T_ORG_HIERARCHY";
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                filterId = filterId + ",'" + rs.getString(1) + "'";
            }
            String easSql = "SELECT FID,FNAME_L2 FROM T_ORG_HIERARCHY WHERE FID IN (" + filterId + ") AND FID NOT IN ('00000000-0000-0000-0000-000000000001396FCAD0')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)easSql);
            while (executeQuery.next()) {
                String id = executeQuery.getString("FID");
                String name = executeQuery.getString("FNAME_L2");
                name = name + "_shr";
                String updateSql = "UPDATE T_ORG_HIERARCHY SET FNAME_L2 = '" + name + "' WHERE FID = '" + id + "'";
                DbUtil.execute((Context)ctx, (String)updateSql);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void movePositionHierarchyAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITIONHIERARCHY";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName)) {
            return;
        }
        Statement state = null;
        ResultSet rs = null;
        try {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String shrSql = "SELECT FID FROM T_ORG_HIERARCHY WHERE FID NOT IN ('00000000-0000-0000-0000-000000000001396FCAD0')";
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            String filterId = "'shr\u7684\u6c47\u62a5\u5173\u7cfb'";
            while (rs.next()) {
                filterId = filterId + ",'" + rs.getString(1) + "'";
            }
            DbUtil.execute((Context)ctx, (String)("DELETE FROM " + tableName + " WHERE FHierarchyID IN (" + filterId + ")"));
            UpdateTool.commonUpdate(shrConn, tableName, "WHERE FHierarchyID <> '00000000-0000-0000-0000-000000000001396FCAD0'", ctx, 100);
            String positionAddnewId = "'\u65b0\u589e\u8fc7\u6765\u7684\u5c97\u4f4d'";
            String getPositionMapSql = "SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '" + this.positionBossType + "' AND FMAPWAY  <> 'ID\u91cd\u590d'";
            String sql = "SELECT FID FROM T_ORG_POSITION_SHR_TEMP WHERE FID NOT IN (" + getPositionMapSql + ")";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            int count = 0;
            while (executeQuery.next()) {
                positionAddnewId = positionAddnewId + ",'" + executeQuery.getString("FID") + "'";
                if (++count <= 800) continue;
                UpdateTool.commonUpdate(shrConn, tableName, "WHERE FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' AND FCHILDID IN (" + positionAddnewId + ")", ctx, 100);
                count = 0;
                positionAddnewId = "'\u65b0\u589e\u8fc7\u6765\u7684\u5c97\u4f4d'";
            }
            UpdateTool.commonUpdate(shrConn, tableName, "WHERE FHierarchyID = '00000000-0000-0000-0000-000000000001396FCAD0' AND FCHILDID IN (" + positionAddnewId + ")", ctx, 100);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "finished");
        }
        catch (Exception e) {
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, tableName, "\u51fa\u9519\u8fc1\u79fb\u8868\uff1a" + tableName + "\uff1b\u51fa\u9519\u4fe1\u606f" + e.toString());
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public void refreshHierarchyTreeAction(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        String tableName = "T_ORG_POSITIONHIERARCHY";
        try {
            String getHierarchySql = "SELECT FID FROM T_ORG_HIERARCHY";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)getHierarchySql);
            ArrayList<String> sqlList = new ArrayList<String>();
            while (executeQuery.next()) {
                String hierarchyId = executeQuery.getString("FID");
                String getPositionHierarchySql = "SELECT hierarchy.FID AS oldFid,hierarchy.FLONGNUMBER AS oldLongNumber,hierarchy.FLEVEL AS oldLevel,hierarchy.FPARENTID AS oldParentId,hierarchy.FCHILDID AS oldChildId,hierarchy.FISLEAF AS oldIsLeaf,parentPosition.FNUMBER AS parentNumber,childPosition.FNUMBER AS childNumber FROM " + tableName + " hierarchy LEFT JOIN T_ORG_POSITION parentPosition ON hierarchy.FPARENTID = parentPosition.FID  LEFT JOIN T_ORG_POSITION childPosition ON hierarchy.FCHILDID = childPosition.FID  WHERE hierarchy.FHierarchyID = '" + hierarchyId + "' ORDER BY hierarchy.FLEVEL";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)getPositionHierarchySql);
                while (executeQuery2.next()) {
                    String oldFid = executeQuery2.getString("oldFid");
                    String oldLongNumber = executeQuery2.getString("oldLongNumber");
                    String oldLevel = executeQuery2.getString("oldLevel");
                    String oldParentId = executeQuery2.getString("oldParentId");
                    String oldChildId = executeQuery2.getString("oldChildId");
                    String oldIsLeaf = executeQuery2.getString("oldIsLeaf");
                    String parentNumber = executeQuery2.getString("parentNumber");
                    String childNumber = executeQuery2.getString("childNumber");
                    if (oldChildId.equals(oldParentId)) {
                        String updateSql = "UPDATE " + tableName + " SET FLONGNUMBER = '" + parentNumber + "',FLEVEL=0,FISLEAF=0 WHERE FID = '" + oldFid + "'";
                        sqlList.add(updateSql);
                        continue;
                    }
                    String newLongNumber = childNumber;
                    int newLevel = 0;
                    int newLeaf = 1;
                    for (int i = 0; i < 100; ++i) {
                        String sql = "SELECT hierarchy.FID AS oldFid,hierarchy.FLONGNUMBER AS oldLongNumber,hierarchy.FLEVEL AS oldLevel,hierarchy.FPARENTID AS oldParentId,hierarchy.FCHILDID AS oldChildId,hierarchy.FISLEAF AS oldIsLeaf,parentPosition.FNUMBER AS parentNumber,childPosition.FNUMBER AS childNumber FROM " + tableName + " hierarchy LEFT JOIN T_ORG_POSITION parentPosition ON hierarchy.FPARENTID = parentPosition.FID  LEFT JOIN T_ORG_POSITION childPosition ON hierarchy.FCHILDID = childPosition.FID  WHERE hierarchy.FHierarchyID = '" + hierarchyId + "' AND childPosition.FNUMBER = '" + parentNumber + "'";
                        IRowSet executeQuery3 = DbUtil.executeQuery((Context)ctx, (String)sql);
                        while (executeQuery3.next()) {
                            newLongNumber = executeQuery3.getString("childNumber") + "!" + newLongNumber;
                            ++newLevel;
                            if (executeQuery3.getString("parentNumber").equals(executeQuery3.getString("childNumber"))) {
                                i = 100;
                            }
                            parentNumber = executeQuery3.getString("parentNumber");
                        }
                    }
                    String getIsLeafSql = "SELECT * FROM " + tableName + " WHERE FPARENTID = '" + oldChildId + "'";
                    IRowSet executeQuery4 = DbUtil.executeQuery((Context)ctx, (String)getIsLeafSql);
                    if (executeQuery4.size() > 0) {
                        newLeaf = 0;
                    }
                    String updateSql = "UPDATE " + tableName + " SET FLONGNUMBER = '" + newLongNumber + "',FLEVEL=" + newLevel + ",FISLEAF=" + newLeaf + " WHERE FID = '" + oldFid + "'";
                    sqlList.add(updateSql);
                }
            }
            boolean i = false;
            if (sqlList.size() > 0) {
                SHRMoveDataHelpUtil.insertByBatch(ctx, sqlList, 10);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static List<Map<String, String>> getShrPositionList(Connection shrConn, Context ctx) {
        String tableName = "T_ORG_POSITION";
        String adminTableName = "T_ORG_ADMIN";
        Statement state = null;
        ResultSet rs = null;
        ArrayList<Map<String, String>> shrPositionResultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "select position.FNUMBER as positionNumber,position.FNAME_L2 as positionName,\tadminOrg.FID as adminId,adminOrg.FDISPLAYNAME_L2 as adminDisplayName,parentPosition.FID as parentPositionId, parentPosition.FNAME_L2 as parentPositionName,parentPositionAdmin.FDISPLAYNAME_L2 as pPositionAdminDisplayName, case when position.FIsRespPosition = 1 then '\u662f' else '\u5426' end as FIsRespPosition, case when position.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as FDeletedStatus, position.FID as positionId,parentPositionAdmin.FID as parentAdminId from " + tableName + " position left join " + adminTableName + " adminOrg ON position.FAdminOrgUnitID = adminOrg.FID left join T_ORG_Position  parentPosition ON position.FParentID = parentPosition.FID left join " + adminTableName + " parentPositionAdmin ON parentPosition.FAdminOrgUnitID = parentPositionAdmin.FID order by position.FNUMBER";
            state = shrConn.createStatement();
            rs = state.executeQuery(sql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", rs.getString(1));
                map.put("shrName", rs.getString(2));
                map.put("shrAdminId", rs.getString(3));
                map.put("shrAdminOrgUnit", rs.getString(4));
                map.put("shrParentId", rs.getString(5));
                map.put("shrParent", rs.getString(6));
                map.put("shrIsRespPosition", rs.getString(8));
                map.put("shrPpAdminDisplayName", rs.getString(7));
                map.put("shrState", rs.getString(9));
                map.put("shrId", rs.getString(10));
                map.put("shrParentAdminId", rs.getString(11));
                shrPositionResultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return shrPositionResultList;
    }

    public static List<Map<String, String>> getEasPositionList(Connection shrConn, Context ctx) {
        String tableName = "T_ORG_POSITION";
        String adminTableName = "T_ORG_ADMIN";
        ArrayList<Map<String, String>> easAdminResultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "select position.FNUMBER as positionNumber,position.FNAME_L2 as positionName,\tadminOrg.FID as adminId,adminOrg.FDISPLAYNAME_L2 as adminDisplayName,parentPosition.FID as parentPositionId, parentPosition.FNAME_L2 as parentPositionName,parentPositionAdmin.FDISPLAYNAME_L2 as pPositionAdminDisplayName, case when position.FIsRespPosition = 1 then '\u662f' else '\u5426' end as FIsRespPosition, case when position.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as FDeletedStatus, position.FID as positionId,parentPositionAdmin.FID as parentAdminId ,adminMap.FSHRID as adminShrId ,parentAdminMap.FSHRID parentAdminShrId from " + tableName + " position left join " + adminTableName + " adminOrg ON position.FAdminOrgUnitID = adminOrg.FID left join T_ORG_Position  parentPosition ON position.FParentID = parentPosition.FID left join " + adminTableName + " parentPositionAdmin ON parentPosition.FAdminOrgUnitID = parentPositionAdmin.FID left join T_HR_SynIdMapping adminMap ON adminOrg.FID = adminMap.FEASID left join T_HR_SynIdMapping parentAdminMap ON parentPositionAdmin.FID = parentAdminMap.FEASID order by position.FNUMBER";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easNumber", executeQuery.getString("positionNumber"));
                map.put("easName", executeQuery.getString("positionName"));
                map.put("easAdminId", executeQuery.getString("adminId"));
                map.put("easAdminOrgUnit", executeQuery.getString("adminDisplayName"));
                map.put("easParentId", executeQuery.getString("parentPositionId"));
                map.put("easParent", executeQuery.getString("parentPositionName"));
                map.put("easIsRespPosition", executeQuery.getString("FIsRespPosition"));
                map.put("easPpAdminDisplayName", executeQuery.getString("pPositionAdminDisplayName"));
                map.put("easState", executeQuery.getString("FDeletedStatus"));
                map.put("easId", executeQuery.getString("positionId"));
                map.put("easParentAdminId", executeQuery.getString("parentAdminId"));
                map.put("adminShrId", executeQuery.getString("adminShrId"));
                map.put("parentAdminShrId", executeQuery.getString("parentAdminShrId"));
                easAdminResultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return easAdminResultList;
    }
}

