/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.rpts.ctrlsqldesign.IKSQLReport;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportCollection;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportFactory;
import com.kingdee.eas.rpts.ctrlsqldesign.KSQLReportInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.ExportBoidCollection;
import com.kingdee.shr.base.syssetting.ExportBoidFactory;
import com.kingdee.shr.base.syssetting.ExportBoidInfo;
import com.kingdee.shr.base.syssetting.IExportBoid;
import com.kingdee.shr.report.BusinessTypeInfo;
import com.kingdee.shr.report.IPersonDataSourceDef;
import com.kingdee.shr.report.IReportDatas;
import com.kingdee.shr.report.IReportDef;
import com.kingdee.shr.report.IReportDeploy;
import com.kingdee.shr.report.PersonDataSourceDefCollection;
import com.kingdee.shr.report.PersonDataSourceDefFactory;
import com.kingdee.shr.report.PersonDataSourceDefInfo;
import com.kingdee.shr.report.ReportDatasCollection;
import com.kingdee.shr.report.ReportDatasFactory;
import com.kingdee.shr.report.ReportDatasInfo;
import com.kingdee.shr.report.ReportDefCollection;
import com.kingdee.shr.report.ReportDefFactory;
import com.kingdee.shr.report.ReportDefInfo;
import com.kingdee.shr.report.ReportDeployCollection;
import com.kingdee.shr.report.ReportDeployFactory;
import com.kingdee.shr.report.ReportDeployInfo;
import com.kingdee.shr.report.app.DataSourceTypeEnum;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Map;
import org.apache.log4j.Logger;

public class ReportDefMoveHandler
implements ISHRMoveDataHandler {
    private static Logger logger = Logger.getLogger(ReportDefMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveReportdef(shrConn, ctx);
        this.moveReportDeploy(shrConn, ctx);
        this.moveExportBoid(shrConn, ctx);
        this.moveReportDatas(shrConn, ctx);
        this.moveKsqlReport(shrConn, ctx);
        this.movePersonData(shrConn, ctx);
        UpdateTool.commonUpdate(shrConn, "T_SHR_PermissionAssignment", "", ctx, 200);
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_PermissionAssignment", "FUserID");
        return null;
    }

    private void movePersonData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_SHR_PersonDataSourceDef";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete from T_SHR_PersonDataSourceDef";
            DbUtil.execute((Context)ctx, (String)delSql);
            PersonDataSourceDefCollection shr_PersonData_collection = new PersonDataSourceDefCollection();
            PersonDataSourceDefCollection eas_PersonData_collection = new PersonDataSourceDefCollection();
            eas_PersonData_collection = PersonDataSourceDefFactory.getRemoteInstance().getPersonDataSourceDefCollection();
            shr_PersonData_collection = this.getSHRData_PersonData(shrConn, ctx);
            PersonDataSourceDefCollection diffCollectionSHR_personData = null;
            if (eas_PersonData_collection.isEmpty()) {
                this.addSHRDataToEAS_personData(ctx, shr_PersonData_collection);
            } else {
                diffCollectionSHR_personData = this.compareData_personData(ctx, eas_PersonData_collection, shr_PersonData_collection);
                if (diffCollectionSHR_personData.size() > 0) {
                    this.addSHRDataToEAS_personData(ctx, diffCollectionSHR_personData);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_PersonDataSourceDef", "FCREATORID");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_PersonDataSourceDef", "FADMINORG");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_SHR_PersonDataSourceDef".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_SHR_PersonDataSourceDef".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveKsqlReport(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BAS_KSQLReport";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            KSQLReportCollection shr_KsqlReport_collection = new KSQLReportCollection();
            KSQLReportCollection eas_KsqlReport_collection = new KSQLReportCollection();
            eas_KsqlReport_collection = KSQLReportFactory.getRemoteInstance().getKSQLReportCollection(null);
            shr_KsqlReport_collection = this.getSHRData_KsqlReport(shrConn, ctx);
            KSQLReportCollection diffCollectionSHR_ksqlReport = null;
            if (eas_KsqlReport_collection.isEmpty()) {
                this.addSHRDataToEAS_ksqlReport(ctx, shr_KsqlReport_collection);
            } else {
                diffCollectionSHR_ksqlReport = this.compareData_ksqlReport(ctx, eas_KsqlReport_collection, shr_KsqlReport_collection);
                if (diffCollectionSHR_ksqlReport.size() > 0) {
                    this.addSHRDataToEAS_ksqlReport(ctx, diffCollectionSHR_ksqlReport);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BAS_KSQLReport", "FCREATORID");
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BAS_KSQLReport", "FORGID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BAS_KSQLReport".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BAS_KSQLReport".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveReportDatas(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_SHR_ReportDatas";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete from T_SHR_ReportDatas";
            DbUtil.execute((Context)ctx, (String)delSql);
            ReportDatasCollection shr_Datas_collection = new ReportDatasCollection();
            ReportDatasCollection eas_Datas_collection = new ReportDatasCollection();
            eas_Datas_collection = ReportDatasFactory.getRemoteInstance().getReportDatasCollection();
            shr_Datas_collection = this.getSHRData_Datas(shrConn, ctx);
            ReportDatasCollection diffCollectionSHR_reportDatas = null;
            if (eas_Datas_collection.isEmpty()) {
                this.addSHRDataToEAS_reportDatas(ctx, shr_Datas_collection);
            } else {
                diffCollectionSHR_reportDatas = this.compareData_reportDatas(ctx, eas_Datas_collection, shr_Datas_collection);
                if (diffCollectionSHR_reportDatas.size() > 0) {
                    this.addSHRDataToEAS_reportDatas(ctx, diffCollectionSHR_reportDatas);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_ReportDatas", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_SHR_ReportDatas".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_SHR_ReportDatas".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveExportBoid(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_BS_ExportBoid";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            ExportBoidCollection shr_ExportBoid_collection = new ExportBoidCollection();
            ExportBoidCollection eas_ExportBoid_collection = new ExportBoidCollection();
            eas_ExportBoid_collection = ExportBoidFactory.getRemoteInstance().getExportBoidCollection();
            shr_ExportBoid_collection = this.getSHRData_ExportBoid(shrConn, ctx);
            ExportBoidCollection diffCollectionSHR_exportBoid = null;
            if (eas_ExportBoid_collection.isEmpty()) {
                this.addSHRDataToEAS_exportBoid(ctx, shr_ExportBoid_collection);
            } else {
                diffCollectionSHR_exportBoid = this.compareData_exportBoid(ctx, eas_ExportBoid_collection, shr_ExportBoid_collection);
                if (diffCollectionSHR_exportBoid.size() > 0) {
                    this.addSHRDataToEAS_exportBoid(ctx, diffCollectionSHR_exportBoid);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_BS_ExportBoid", "FUserID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_BS_ExportBoid".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_BS_ExportBoid".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveReportDeploy(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_SHR_ReportDeploy";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete from T_SHR_ReportDeploy";
            DbUtil.execute((Context)ctx, (String)delSql);
            ReportDeployCollection shr_ReportDeploy_collection = new ReportDeployCollection();
            ReportDeployCollection eas_ReportDeploy_collection = new ReportDeployCollection();
            eas_ReportDeploy_collection = ReportDeployFactory.getRemoteInstance().getReportDeployCollection();
            shr_ReportDeploy_collection = this.getSHRData_ReportDeploy(shrConn, ctx);
            ReportDeployCollection diffCollectionSHR_reportDeploy = null;
            if (eas_ReportDeploy_collection.isEmpty()) {
                this.addSHRDataToEAS_reportDeploy(ctx, shr_ReportDeploy_collection);
            } else {
                diffCollectionSHR_reportDeploy = this.compareData_reportDeploy(ctx, eas_ReportDeploy_collection, shr_ReportDeploy_collection);
                if (diffCollectionSHR_reportDeploy.size() > 0) {
                    this.addSHRDataToEAS_reportDeploy(ctx, diffCollectionSHR_reportDeploy);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_ReportDeploy", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_SHR_ReportDeploy".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_SHR_ReportDeploy".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveReportdef(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "T_SHR_ReportDef";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete from T_SHR_ReportDef";
            DbUtil.execute((Context)ctx, (String)delSql);
            ReportDefCollection shr_Reportdef_collection = new ReportDefCollection();
            ReportDefCollection eas_Reportdef_collection = new ReportDefCollection();
            eas_Reportdef_collection = ReportDefFactory.getRemoteInstance().getReportDefCollection();
            shr_Reportdef_collection = this.getSHRData_Reportdef(shrConn, ctx);
            ReportDefCollection diffCollectionSHR_reportDef = null;
            if (eas_Reportdef_collection.isEmpty()) {
                this.addSHRDataToEAS_reportDef(ctx, shr_Reportdef_collection);
            } else {
                diffCollectionSHR_reportDef = this.compareData_reportdDef(ctx, eas_Reportdef_collection, shr_Reportdef_collection);
                if (diffCollectionSHR_reportDef.size() > 0) {
                    this.addSHRDataToEAS_reportDef(ctx, diffCollectionSHR_reportDef);
                }
            }
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_SHR_ReportDef", "FCREATORID");
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_SHR_ReportDef".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_SHR_ReportDef".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public PersonDataSourceDefCollection compareData_personData(Context ctx, PersonDataSourceDefCollection eas_PersonData_collection, PersonDataSourceDefCollection shr_PersonData_collection) {
        PersonDataSourceDefInfo infoEAS = null;
        PersonDataSourceDefInfo infoSHR = null;
        PersonDataSourceDefCollection diffCollectionSHR = new PersonDataSourceDefCollection();
        boolean match = false;
        for (int i = 0; i < shr_PersonData_collection.size(); ++i) {
            infoSHR = shr_PersonData_collection.get(i);
            for (int j = 0; j < eas_PersonData_collection.size(); ++j) {
                infoEAS = eas_PersonData_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_personData(Context ctx, PersonDataSourceDefCollection eas_PersonData_collection) throws EASBizException, BOSException {
        PersonDataSourceDefInfo info = null;
        IPersonDataSourceDef PersonDataSourceDef = PersonDataSourceDefFactory.getRemoteInstance();
        for (int i = 0; i < eas_PersonData_collection.size(); ++i) {
            info = eas_PersonData_collection.get(i);
            PersonDataSourceDef.addnew(info);
        }
    }

    public KSQLReportCollection compareData_ksqlReport(Context ctx, KSQLReportCollection eas_KsqlReport_collection, KSQLReportCollection shr_KsqlReport_collection) {
        KSQLReportInfo infoEAS = null;
        KSQLReportInfo infoSHR = null;
        KSQLReportCollection diffCollectionSHR = new KSQLReportCollection();
        boolean match = false;
        for (int i = 0; i < shr_KsqlReport_collection.size(); ++i) {
            infoSHR = shr_KsqlReport_collection.get(i);
            for (int j = 0; j < eas_KsqlReport_collection.size(); ++j) {
                infoEAS = eas_KsqlReport_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_ksqlReport(Context ctx, KSQLReportCollection shr_KsqlReport_collection) throws EASBizException, BOSException {
        KSQLReportInfo info = null;
        IKSQLReport KSQLReport = KSQLReportFactory.getRemoteInstance();
        for (int i = 0; i < shr_KsqlReport_collection.size(); ++i) {
            info = shr_KsqlReport_collection.get(i);
            KSQLReport.addnew(info);
        }
    }

    public ReportDatasCollection compareData_reportDatas(Context ctx, ReportDatasCollection eas_Datas_collection, ReportDatasCollection shr_Datas_collection) {
        ReportDatasInfo infoEAS = null;
        ReportDatasInfo infoSHR = null;
        ReportDatasCollection diffCollectionSHR = new ReportDatasCollection();
        boolean match = false;
        for (int i = 0; i < shr_Datas_collection.size(); ++i) {
            infoSHR = shr_Datas_collection.get(i);
            for (int j = 0; j < eas_Datas_collection.size(); ++j) {
                infoEAS = eas_Datas_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_reportDatas(Context ctx, ReportDatasCollection shr_Datas_collection) throws EASBizException, BOSException {
        ReportDatasInfo info = null;
        IReportDatas ReportDatas = ReportDatasFactory.getRemoteInstance();
        for (int i = 0; i < shr_Datas_collection.size(); ++i) {
            info = shr_Datas_collection.get(i);
            ReportDatas.addnew(info);
        }
    }

    public ExportBoidCollection compareData_exportBoid(Context ctx, ExportBoidCollection eas_ExportBoid_collection, ExportBoidCollection shr_ExportBoid_collection) {
        ExportBoidInfo infoEAS = null;
        ExportBoidInfo infoSHR = null;
        ExportBoidCollection diffCollectionSHR = new ExportBoidCollection();
        boolean match = false;
        for (int i = 0; i < shr_ExportBoid_collection.size(); ++i) {
            infoSHR = shr_ExportBoid_collection.get(i);
            for (int j = 0; j < eas_ExportBoid_collection.size(); ++j) {
                infoEAS = eas_ExportBoid_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_exportBoid(Context ctx, ExportBoidCollection shr_ExportBoid_collection) throws EASBizException, BOSException {
        ExportBoidInfo info = null;
        IExportBoid ExportBoid = ExportBoidFactory.getRemoteInstance();
        for (int i = 0; i < shr_ExportBoid_collection.size(); ++i) {
            info = shr_ExportBoid_collection.get(i);
            ExportBoid.addnew(info);
        }
    }

    public ReportDeployCollection compareData_reportDeploy(Context ctx, ReportDeployCollection eas_ReportDeploy_collection, ReportDeployCollection shr_ReportDeploy_collection) {
        ReportDeployInfo infoEAS = null;
        ReportDeployInfo infoSHR = null;
        ReportDeployCollection diffCollectionSHR = new ReportDeployCollection();
        boolean match = false;
        for (int i = 0; i < shr_ReportDeploy_collection.size(); ++i) {
            infoSHR = shr_ReportDeploy_collection.get(i);
            for (int j = 0; j < eas_ReportDeploy_collection.size(); ++j) {
                infoEAS = eas_ReportDeploy_collection.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHRDataToEAS_reportDeploy(Context ctx, ReportDeployCollection shr_ReportDeploy_collection) throws BOSException, EASBizException {
        ReportDeployInfo info = null;
        IReportDeploy ReportDeploy = ReportDeployFactory.getRemoteInstance();
        for (int i = 0; i < shr_ReportDeploy_collection.size(); ++i) {
            info = shr_ReportDeploy_collection.get(i);
            ReportDeploy.addnew(info);
        }
    }

    public ReportDefCollection compareData_reportdDef(Context ctx, ReportDefCollection eas_Reportdef_collection, ReportDefCollection shr_Reportdef_collection) throws EASBizException, BOSException {
        ReportDefInfo infoEAS = null;
        ReportDefInfo infoSHR = null;
        ReportDefCollection diffCollectionSHR = new ReportDefCollection();
        boolean match = false;
        for (int i = 0; i < shr_Reportdef_collection.size(); ++i) {
            infoSHR = shr_Reportdef_collection.get(i);
            for (int j = 0; j < eas_Reportdef_collection.size(); ++j) {
                infoEAS = eas_Reportdef_collection.get(j);
                if (infoEAS.getId().toString().equals(infoSHR.getId().toString())) {
                    match = true;
                    break;
                }
                if (!infoEAS.getName().equals(infoSHR.getName())) continue;
                String newname = this.getNewNameForReport(infoSHR.getName());
                infoSHR.setName(newname);
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public String getNewNameForReport(String oldname) throws EASBizException, BOSException {
        int point_index = oldname.lastIndexOf("V");
        String newname = "";
        if (point_index == -1) {
            oldname = oldname + "V" + 1.0;
            point_index = oldname.lastIndexOf("V");
        }
        float version = Float.parseFloat(oldname.substring(point_index + 1, oldname.length() - 1));
        String name = oldname.substring(0, point_index);
        DecimalFormat fnum = new DecimalFormat("##0.0");
        while (true) {
            newname = name + "V" + fnum.format(version);
            if (!ReportDefFactory.getRemoteInstance().exists("select * where name = '" + newname + "'")) break;
            version += 0.1f;
        }
        return newname;
    }

    public void addSHRDataToEAS_reportDef(Context ctx, ReportDefCollection shr_Reportdef_collection) throws BOSException, EASBizException {
        ReportDefInfo info = null;
        IReportDef IreportDef = ReportDefFactory.getRemoteInstance();
        for (int i = 0; i < shr_Reportdef_collection.size(); ++i) {
            info = shr_Reportdef_collection.get(i);
            ReportDefCollection IsExist = IreportDef.getReportDefCollection("where id='" + info.getId().toString() + "'");
            if (IsExist == null || IsExist.size() != 0) continue;
            IreportDef.addnew(info);
        }
    }

    public PersonDataSourceDefCollection getSHRData_PersonData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select fcontent,fcontrolconfig,fnumber,fdescription_l2,fsimplename,fcreatorid,fcreatetime,flastupdateuserid,flastupdatetime,fcontrolunitid,fid,fsheetname,fadminorg,fparammapping,fselector,ffilter,fparam,fname_l2 from T_SHR_PersonDataSourceDef";
        PersonDataSourceDefCollection shrCollection = new PersonDataSourceDefCollection();
        PersonDataSourceDefInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_SHR_PersonDataSourceDef".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fcontent = colummnsmap.containsKey("fcontent".toUpperCase()) ? rs.getString("fcontent") : "";
                String fcontrolconfig = colummnsmap.containsKey("fcontrolconfig".toUpperCase()) ? rs.getString("fcontrolconfig") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fsimplename = colummnsmap.containsKey("fsimplename".toUpperCase()) ? rs.getString("fsimplename") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fsheetname = colummnsmap.containsKey("fsheetname".toUpperCase()) ? rs.getString("fsheetname") : "";
                String fadminorg = colummnsmap.containsKey("fadminorg".toUpperCase()) ? rs.getString("fadminorg") : "";
                String fparammapping = colummnsmap.containsKey("fparammapping".toUpperCase()) ? rs.getString("fparammapping") : "";
                String fselector = colummnsmap.containsKey("fselector".toUpperCase()) ? rs.getString("fselector") : "";
                String ffilter = colummnsmap.containsKey("ffilter".toUpperCase()) ? rs.getString("ffilter") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                shrInfo = new PersonDataSourceDefInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setControlConfig(fcontrolconfig);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                shrInfo.setSimpleName(fsimplename);
                shrInfo.setSheetName(fsheetname);
                shrInfo.setParamMapping(fparammapping);
                shrInfo.setSelector(fselector);
                shrInfo.setFilter(ffilter);
                shrInfo.setParam(fparam);
                if (fadminorg != null && !fadminorg.isEmpty()) {
                    AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                    admin.setId(BOSUuid.read((String)fadminorg));
                    shrInfo.setAdminOrg(admin);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public KSQLReportCollection getSHRData_KsqlReport(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BAS_KSQLReport where fsystemid='com.kingdee.eas.hr.affair.affair'";
        KSQLReportCollection shrCollection = new KSQLReportCollection();
        KSQLReportInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BAS_KSQLReport".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fsystemid = colummnsmap.containsKey("fsystemid".toUpperCase()) ? rs.getString("fsystemid") : "";
                byte[] fcontent = colummnsmap.containsKey("fcontent".toUpperCase()) ? rs.getBytes("fcontent") : "".getBytes();
                String flength = colummnsmap.containsKey("flength".toUpperCase()) ? rs.getString("flength") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String forgid = colummnsmap.containsKey("forgid".toUpperCase()) ? rs.getString("forgid") : "";
                String fisdynamicsql = colummnsmap.containsKey("fisdynamicsql".toUpperCase()) ? rs.getString("fisdynamicsql") : "";
                String fcustomtype = colummnsmap.containsKey("fcustomtype".toUpperCase()) ? rs.getString("fcustomtype") : "";
                shrInfo = new KSQLReportInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setSystemID(fsystemid);
                if (fcustomtype != null && !fcustomtype.isEmpty()) {
                    shrInfo.setCustomType(Integer.parseInt(fcustomtype));
                }
                if (fisdynamicsql != null && !fisdynamicsql.isEmpty()) {
                    boolean isdynamicsql = fisdynamicsql.equals("1");
                    shrInfo.setIsDynamicSQL(isdynamicsql);
                }
                if (forgid != null && !forgid.isEmpty()) {
                    shrInfo.setOrgID(BOSUuid.read((String)forgid));
                }
                shrInfo.setContent(fcontent);
                if (flength != null && !flength.isEmpty()) {
                    shrInfo.setLength(Integer.parseInt(flength));
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ExportBoidCollection getSHRData_ExportBoid(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_BS_ExportBoid";
        ExportBoidCollection shrCollection = new ExportBoidCollection();
        ExportBoidInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_BS_ExportBoid".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                String fuserid = colummnsmap.containsKey("fuserid".toUpperCase()) ? rs.getString("fuserid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fschemeid = colummnsmap.containsKey("fschemeid".toUpperCase()) ? rs.getString("fschemeid") : "";
                shrInfo = new ExportBoidInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setUipk(fuipk);
                shrInfo.setUserID(fuserid);
                shrInfo.setSchemeID(fschemeid);
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ReportDatasCollection getSHRData_Datas(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_SHR_ReportDatas";
        ReportDatasCollection shrCollection = new ReportDatasCollection();
        ReportDatasInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_SHR_ReportDatas".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                PersonDataSourceDefInfo info;
                String freportdefid = colummnsmap.containsKey("freportdefid".toUpperCase()) ? rs.getString("freportdefid") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fdatasourcesid = colummnsmap.containsKey("fdatasourcesid".toUpperCase()) ? rs.getString("fdatasourcesid") : "";
                String fdstype = colummnsmap.containsKey("fdstype".toUpperCase()) ? rs.getString("fdstype") : "";
                String fpersondsid = colummnsmap.containsKey("fpersondsid".toUpperCase()) ? rs.getString("fpersondsid") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                shrInfo = new ReportDatasInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setParam(fparam);
                if (fdstype != null && !fdstype.isEmpty()) {
                    shrInfo.setDsType(DataSourceTypeEnum.getEnum((int)Integer.parseInt(fdstype)));
                }
                if (fpersondsid != null && !fpersondsid.isEmpty()) {
                    info = new PersonDataSourceDefInfo();
                    info.setId(BOSUuid.read((String)fpersondsid));
                    shrInfo.setPersonalDS(info);
                }
                if (fdatasourcesid != null && !fdatasourcesid.isEmpty()) {
                    info = new KSQLReportInfo();
                    info.setId(BOSUuid.read((String)fdatasourcesid));
                    shrInfo.setDataSources((KSQLReportInfo)info);
                }
                if (fdatasourcesid != null && !fdatasourcesid.isEmpty()) {
                    info = new KSQLReportInfo();
                    info.setId(BOSUuid.read((String)fdatasourcesid));
                    shrInfo.setDataSources((KSQLReportInfo)info);
                }
                if (freportdefid != null && !freportdefid.isEmpty()) {
                    info = new ReportDefInfo();
                    info.setId(BOSUuid.read((String)freportdefid));
                    shrInfo.setReportDef((ReportDefInfo)info);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ReportDeployCollection getSHRData_ReportDeploy(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_SHR_ReportDeploy";
        ReportDeployCollection shrCollection = new ReportDeployCollection();
        ReportDeployInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_SHR_ReportDeploy".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                ReportDefInfo info;
                String fbusinesstypeid = colummnsmap.containsKey("fbusinesstypeid".toUpperCase()) ? rs.getString("fbusinesstypeid") : "";
                String freportdefid = colummnsmap.containsKey("freportdefid".toUpperCase()) ? rs.getString("freportdefid") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new ReportDeployInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                if (freportdefid != null && !freportdefid.isEmpty()) {
                    info = new ReportDefInfo();
                    info.setId(BOSUuid.read((String)freportdefid));
                    shrInfo.setReportdef(info);
                }
                if (fbusinesstypeid != null && !fbusinesstypeid.isEmpty()) {
                    info = new BusinessTypeInfo();
                    info.setId(BOSUuid.read((String)fbusinesstypeid));
                    shrInfo.setBusinessType((BusinessTypeInfo)info);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    public ReportDefCollection getSHRData_Reportdef(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_SHR_ReportDef";
        ReportDefCollection shrCollection = new ReportDefCollection();
        ReportDefInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_SHR_ReportDef".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
                String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
                String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                String fadminorgid = colummnsmap.containsKey("fadminorg".toUpperCase()) ? rs.getString("fadminorg") : "";
                String fparam = colummnsmap.containsKey("fparam".toUpperCase()) ? rs.getString("fparam") : "";
                String freporttype = colummnsmap.containsKey("freporttype".toUpperCase()) ? rs.getString("freporttype") : "";
                String fbusinesstypeid = colummnsmap.containsKey("fbusinesstypeid".toUpperCase()) ? rs.getString("fbusinesstypeid") : "";
                shrInfo = new ReportDefInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setName(fname);
                shrInfo.setNumber(fnumber);
                shrInfo.setDescription(fdescription);
                shrInfo.setParam(fparam);
                shrInfo.setReporttype(freporttype);
                if (fadminorgid != null && !fcreatorid.isEmpty()) {
                    AdminOrgUnitInfo admin = new AdminOrgUnitInfo();
                    admin.setId(BOSUuid.read((String)fadminorgid));
                    shrInfo.setAdminOrg(admin);
                }
                if (fbusinesstypeid != null && !fbusinesstypeid.isEmpty()) {
                    BusinessTypeInfo info = new BusinessTypeInfo();
                    info.setId(BOSUuid.read((String)fbusinesstypeid));
                    shrInfo.setBusinesstype(info);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }
}

