/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.IRolePerm;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermType;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.eas.base.permission.RolePermCollection;
import com.kingdee.eas.base.permission.RolePermFactory;
import com.kingdee.eas.base.permission.RolePermInfo;
import com.kingdee.eas.base.permission.RoleType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.hr.mvdt.util.WriteExcelDataTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class RoleMoveHandler {
    public static final String BOSTYPE = "13B6732A";
    public static List<String> excelHead = new ArrayList<String>();

    public String verifyData(Connection shrConn, Context ctx, List<List<String>> roleDatas) throws BOSException, SQLException, EASBizException {
        RoleCollection roleCollection_EAS = RoleFactory.getRemoteInstance().getRoleCollection();
        RoleCollection roleCollection_SHR = this.getSHRData(shrConn, ctx);
        this.compareData(ctx, roleCollection_EAS, roleCollection_SHR, roleDatas);
        return null;
    }

    private RoleCollection compareData(Context ctx, RoleCollection roleCollection_EAS, RoleCollection roleCollection_SHR, List<List<String>> roleDatas) throws EASBizException, BOSException {
        int j;
        int i;
        RoleInfo infoEAS = new RoleInfo();
        RoleInfo infoSHR = new RoleInfo();
        RoleCollection diffCollectionSHR = new RoleCollection();
        boolean match = false;
        for (i = 0; i < roleCollection_SHR.size(); ++i) {
            infoSHR = roleCollection_SHR.get(i);
            for (j = 0; j < roleCollection_EAS.size(); ++j) {
                infoEAS = roleCollection_EAS.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                this.generateMappingTrueExcelData(ctx, infoSHR, infoEAS, roleDatas);
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInEASMappingExcelData(ctx, infoSHR, infoEAS, roleDatas);
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        match = false;
        for (i = 0; i < roleCollection_EAS.size(); ++i) {
            infoEAS = roleCollection_EAS.get(i);
            for (j = 0; j < roleCollection_SHR.size(); ++j) {
                infoSHR = roleCollection_SHR.get(j);
                if (!infoEAS.getNumber().equals(infoSHR.getNumber())) continue;
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInSHRMappingExcelData(ctx, infoSHR, infoEAS, roleDatas);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private void generateNotFoundInSHRMappingExcelData(Context ctx, RoleInfo infoSHR, RoleInfo infoEAS, List<List<String>> roleDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsDefRole()));
        resultRow.add(infoEAS.getDescription());
        resultRow.add(infoEAS.getId().toString());
        roleDatas.add(resultRow);
    }

    private void generateNotFoundInEASMappingExcelData(Context ctx, RoleInfo infoSHR, RoleInfo infoEAS, List<List<String>> roleDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsDefRole()));
        resultRow.add(infoSHR.getDescription());
        resultRow.add(infoSHR.getId().toString());
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        roleDatas.add(resultRow);
    }

    private void generateMappingTrueExcelData(Context ctx, RoleInfo infoSHR, RoleInfo infoEAS, List<List<String>> roleDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getNumber());
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsDefRole()));
        resultRow.add(infoSHR.getDescription());
        resultRow.add(infoSHR.getId().toString());
        resultRow.add(infoEAS.getNumber());
        resultRow.add(infoEAS.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsDefRole()));
        resultRow.add(infoEAS.getDescription());
        resultRow.add(infoEAS.getId().toString());
        roleDatas.add(resultRow);
    }

    private void generateMappingTable(Context ctx, RoleInfo infoSHR, RoleInfo infoEAS) throws EASBizException, BOSException {
        String infoSHRId = infoSHR.getId().toString();
        String infoEASId = infoEAS.getId().toString();
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    private RoleCollection getSHRData(Connection shrConn, Context ctx) throws InterfaceDataBaseException, BOSException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_Role";
        RoleCollection shrCollection = new RoleCollection();
        RoleInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_Role".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
            String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
            String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
            String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
            String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
            String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
            String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
            String ftype = colummnsmap.containsKey("ftype".toUpperCase()) ? rs.getString("ftype") : "";
            String fisdefrole = colummnsmap.containsKey("fisdefrole".toUpperCase()) ? rs.getString("fisdefrole") : "";
            shrInfo = new RoleInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            shrInfo.setName(fname);
            shrInfo.setNumber(fnumber);
            shrInfo.setDescription(fdescription);
            if (fisdefrole != null) {
                boolean isdefrole = fisdefrole.equals("1");
                shrInfo.setIsDefRole(isdefrole);
            }
            if (ftype != null) {
                shrInfo.setType(RoleType.getEnum((String)ftype));
            }
            if (fcreatorid != null && !fcreatorid.isEmpty()) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)fcreatorid));
                shrInfo.setCreator(user);
            }
            if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                shrInfo.setCU(ctrinfo);
            }
            shrCollection.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return shrCollection;
    }

    public void moveData(Connection shrConn, Context ctx) throws BOSException, SQLException, EASBizException {
        String tableName = "T_PM_Role";
        if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            RoleCollection roleCollection_EAS = RoleFactory.getRemoteInstance().getRoleCollection();
            try {
                RoleCollection roleCollection_SHR = this.getSHRData(shrConn, ctx);
                RoleCollection diffCollectionSHR = null;
                if (roleCollection_EAS.isEmpty()) {
                    this.addSHRDataToEAS(ctx, roleCollection_SHR);
                } else {
                    diffCollectionSHR = this.compareData(ctx, roleCollection_EAS, roleCollection_SHR);
                    if (diffCollectionSHR.size() > 0) {
                        this.addSHRDataToEAS(ctx, diffCollectionSHR);
                    }
                }
                UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_Role", "FCREATORID");
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_Role".toUpperCase(), "finished");
            }
            catch (Exception e) {
                e.printStackTrace();
                SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_Role".toUpperCase(), e.toString());
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, (tableName = "T_PM_UserRoleOrg").toUpperCase())) {
            try {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
                UpdateTool.commonUpdate(shrConn, "T_PM_UserRoleOrg", "", ctx, 300);
                this.refreshID(ctx);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_UserRoleOrg".toUpperCase(), "finished");
            }
            catch (Exception e) {
                e.printStackTrace();
                SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_UserRoleOrg".toUpperCase(), e.toString());
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
        if (!SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, (tableName = "T_PM_RolePerm").toUpperCase())) {
            try {
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
                this.MoveRolePerm(shrConn, ctx);
                this.clearData(ctx);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_RolePerm".toUpperCase(), "finished");
            }
            catch (Exception e) {
                e.printStackTrace();
                SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_RolePerm".toUpperCase(), e.toString());
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void clearData(Context ctx) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"update T_PM_RolePerm set FRuleExpr=null where to_char(substring(FRuleExpr,1,100))='null'");
        DbUtil.execute((Context)ctx, (String)"update T_PM_RolePerm set FRuleStructure=null where to_char(substring(FRuleStructure,1,100))='null'");
    }

    private RolePermCollection getEASData_RolePerm(Context ctx) throws InterfaceDataBaseException, BOSException, UuidException, SQLException {
        Object stmt = null;
        IRowSet rs = null;
        String sql = "select * from T_PM_RolePerm";
        RolePermCollection shrCollection = new RolePermCollection();
        RolePermInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_RolePerm".toUpperCase());
        rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        while (rs.next()) {
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String froleid = colummnsmap.containsKey("froleid".toUpperCase()) ? rs.getString("froleid") : "";
            String fpermitemid = colummnsmap.containsKey("fpermitemid".toUpperCase()) ? rs.getString("fpermitemid") : "";
            String fpermtype = colummnsmap.containsKey("fpermtype".toUpperCase()) ? rs.getString("fpermtype") : "";
            String frulestructure = colummnsmap.containsKey("frulestructure".toUpperCase()) ? rs.getString("frulestructure") : "";
            String fruleexpr = colummnsmap.containsKey("fruleexpr".toUpperCase()) ? rs.getString("fruleexpr") : "";
            shrInfo = new RolePermInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            if (froleid != null) {
                RoleInfo role = new RoleInfo();
                role.setId(BOSUuid.read((String)froleid));
                shrInfo.setRole(role);
            }
            if (fpermitemid != null) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)fpermitemid));
                shrInfo.setPermItem(info);
            }
            if (fpermtype != null) {
                shrInfo.setPermType(PermType.getEnum((String)fpermtype));
            }
            shrInfo.setRuleStructure(frulestructure);
            shrInfo.setRuleExpr(fruleexpr);
            shrCollection.add(shrInfo);
        }
        rs.close();
        return shrCollection;
    }

    public void MoveRolePerm(Connection shrConn, Context ctx) throws SQLException, InterfaceDataBaseException, BOSException {
        Long start = System.currentTimeMillis();
        Statement state = null;
        Object rs = null;
        state = shrConn.createStatement();
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_RolePerm".toUpperCase());
        ResultSet res_shr = state.executeQuery("select Fid from T_PM_RolePerm");
        HashSet<String> orgPerSet_shr = new HashSet<String>();
        while (res_shr.next()) {
            orgPerSet_shr.add(res_shr.getString(1));
        }
        Long end1 = System.currentTimeMillis();
        HashSet<String> orgPerSet_eas = new HashSet<String>();
        String sql12 = "select Fid from T_PM_RolePerm";
        IRowSet res_eas = DbUtil.executeQuery((Context)ctx, (String)sql12);
        while (res_eas.next()) {
            orgPerSet_eas.add(res_eas.getString(1));
        }
        orgPerSet_shr.removeAll(orgPerSet_eas);
        Long start_detil = System.currentTimeMillis();
        Statement state2 = null;
        Iterator iterator = orgPerSet_shr.iterator();
        HashSet<String> dif_set = new HashSet<String>();
        int COUNT_SIZE = 10000;
        int CUNRRENT_COUNT = 0;
        StringBuffer values = new StringBuffer("in(");
        String fid = "";
        String froleid = "";
        String fpermitemid = "";
        String fpermtype = "";
        String frulestructure = "";
        String fruleexpr = "";
        String id = "";
        while (iterator.hasNext()) {
            if (CUNRRENT_COUNT < COUNT_SIZE) {
                id = (String)iterator.next();
                if (values.length() + id.length() > 1000) {
                    values = new StringBuffer(values.substring(0, values.length() - 1)).append(")");
                    values.append(" or fid in(");
                    values.append("'" + id + "',");
                } else {
                    values.append("'" + id + "',");
                }
                ++CUNRRENT_COUNT;
                continue;
            }
            values = new StringBuffer(values.substring(0, values.length() - 1)).append(")");
            state2 = shrConn.createStatement();
            res_shr = state2.executeQuery("select * from T_PM_RolePerm where fid " + values);
            while (res_shr.next()) {
                fid = colummnsmap.containsKey("fid".toUpperCase()) ? res_shr.getString("fid") : "";
                froleid = colummnsmap.containsKey("froleid".toUpperCase()) ? res_shr.getString("froleid") : "";
                fpermitemid = colummnsmap.containsKey("fpermitemid".toUpperCase()) ? res_shr.getString("fpermitemid") : "";
                fpermtype = colummnsmap.containsKey("fpermtype".toUpperCase()) ? res_shr.getString("fpermtype") : "";
                frulestructure = colummnsmap.containsKey("frulestructure".toUpperCase()) ? res_shr.getString("frulestructure") : "";
                fruleexpr = colummnsmap.containsKey("fruleexpr".toUpperCase()) ? res_shr.getString("fruleexpr") : "";
                StringBuffer value = new StringBuffer();
                value.append("'").append(fid).append("','").append(froleid).append("','").append(fpermitemid).append("','").append(fpermtype).append("','").append(frulestructure).append("','").append(fruleexpr).append("'");
                dif_set.add(value.toString());
            }
            this.ImportData(ctx, dif_set);
            values = new StringBuffer("in(");
            CUNRRENT_COUNT = 0;
            state2.close();
        }
        if (CUNRRENT_COUNT > 0 && values.length() > 0) {
            values = new StringBuffer(values.substring(0, values.length() - 1)).append(")");
            Connection conn = EJBFactory.getConnection((Context)ctx);
            state2 = shrConn.createStatement();
            res_shr = state2.executeQuery("select * from T_PM_RolePerm where fid " + values);
            while (res_shr.next()) {
                fid = colummnsmap.containsKey("fid".toUpperCase()) ? res_shr.getString("fid") : "";
                froleid = colummnsmap.containsKey("froleid".toUpperCase()) ? res_shr.getString("froleid") : "";
                fpermitemid = colummnsmap.containsKey("fpermitemid".toUpperCase()) ? res_shr.getString("fpermitemid") : "";
                fpermtype = colummnsmap.containsKey("fpermtype".toUpperCase()) ? res_shr.getString("fpermtype") : "";
                frulestructure = colummnsmap.containsKey("frulestructure".toUpperCase()) ? res_shr.getString("frulestructure") : "";
                fruleexpr = colummnsmap.containsKey("fruleexpr".toUpperCase()) ? res_shr.getString("fruleexpr") : "";
                StringBuffer value = new StringBuffer();
                value.append("'").append(fid).append("','").append(froleid).append("','").append(fpermitemid).append("','").append(fpermtype).append("','").append(frulestructure).append("','").append(fruleexpr).append("'");
                dif_set.add(value.toString());
            }
            values = new StringBuffer();
            Iterator<String> itor = dif_set.iterator();
            Connection conn2 = EJBFactory.getConnection((Context)ctx);
            Statement ste = conn2.createStatement();
            while (itor.hasNext()) {
                StringBuffer insertSql = new StringBuffer("insert into T_PM_RolePerm(fid,froleid,fpermitemid,fpermtype,frulestructure,fruleexpr) values(");
                insertSql.append(itor.next());
                insertSql.append(")");
                ste.addBatch(insertSql.toString());
            }
            ste.executeBatch();
            ste.close();
            dif_set.clear();
        }
    }

    private void ImportData(Context ctx, HashSet<String> dif_set) throws SQLException {
        Iterator<String> itor = dif_set.iterator();
        Connection conn = EJBFactory.getConnection((Context)ctx);
        Statement ste = conn.createStatement();
        while (itor.hasNext()) {
            String insertSql = "insert into T_PM_RolePerm(fid,froleid,fpermitemid,fpermtype,frulestructure,fruleexpr) values(" + itor.next() + ")";
            ste.addBatch(insertSql);
        }
        ste.executeBatch();
        dif_set.clear();
        ste.close();
        conn.close();
    }

    private RolePermCollection compareData_RolePerm(Context ctx, RolePermCollection rolePermCollection_EAS, RolePermCollection rolePermCollection_SHR) {
        RolePermInfo infoEAS = new RolePermInfo();
        RolePermInfo infoSHR = new RolePermInfo();
        RolePermCollection diffCollectionSHR = new RolePermCollection();
        boolean match = false;
        for (int i = 0; i < rolePermCollection_SHR.size(); ++i) {
            infoSHR = rolePermCollection_SHR.get(i);
            for (int j = 0; j < rolePermCollection_EAS.size(); ++j) {
                infoEAS = rolePermCollection_EAS.get(j);
                if (!infoEAS.getId().toString().equals(infoSHR.getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private void addSHRDataToEAS_RolePerm(Context ctx, RolePermCollection rolePermCollection_SHR) throws BOSException, EASBizException {
        RolePermInfo info = null;
        IRolePerm RolePerm = RolePermFactory.getRemoteInstance();
        for (int i = 0; i < rolePermCollection_SHR.size(); ++i) {
            info = rolePermCollection_SHR.get(i);
            RolePerm.addnew((CoreBaseInfo)info);
        }
    }

    private RolePermCollection getSHRData_RolePerm(Connection shrConn, Context ctx) throws InterfaceDataBaseException, BOSException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_RolePerm";
        RolePermCollection shrCollection = new RolePermCollection();
        RolePermInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_RolePerm".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String froleid = colummnsmap.containsKey("froleid".toUpperCase()) ? rs.getString("froleid") : "";
            String fpermitemid = colummnsmap.containsKey("fpermitemid".toUpperCase()) ? rs.getString("fpermitemid") : "";
            String fpermtype = colummnsmap.containsKey("fpermtype".toUpperCase()) ? rs.getString("fpermtype") : "";
            String frulestructure = colummnsmap.containsKey("frulestructure".toUpperCase()) ? rs.getString("frulestructure") : "";
            String fruleexpr = colummnsmap.containsKey("fruleexpr".toUpperCase()) ? rs.getString("fruleexpr") : "";
            shrInfo = new RolePermInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            if (froleid != null) {
                RoleInfo role = new RoleInfo();
                role.setId(BOSUuid.read((String)froleid));
                shrInfo.setRole(role);
            }
            if (fpermitemid != null) {
                PermItemInfo info = new PermItemInfo();
                info.setId(BOSUuid.read((String)fpermitemid));
                shrInfo.setPermItem(info);
            }
            if (fpermtype != null) {
                shrInfo.setPermType(PermType.getEnum((String)fpermtype));
            }
            shrInfo.setRuleStructure(frulestructure);
            shrInfo.setRuleExpr(fruleexpr);
            shrCollection.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return shrCollection;
    }

    private void addSHRDataToEAS(Context ctx, RoleCollection roleCollection_SHR) throws BOSException, EASBizException {
        RoleInfo info = null;
        IRole Role = RoleFactory.getRemoteInstance();
        for (int i = 0; i < roleCollection_SHR.size(); ++i) {
            info = roleCollection_SHR.get(i);
            info.setNumber(info.getNumber() + "_shr");
            info.setName(info.getName() + "_shr");
            Role.addnew((CoreBaseInfo)info);
        }
    }

    private boolean checkExist(String id) throws EASBizException, BOSException {
        if (id == null || id.isEmpty()) {
            return true;
        }
        return RoleFactory.getRemoteInstance().exists("where id='" + id + "'");
    }

    private RoleCollection compareData(Context ctx, RoleCollection roleCollection_EAS, RoleCollection roleCollection_SHR) throws EASBizException, BOSException {
        ArrayList<List<String>> roleDatas = new ArrayList<List<String>>();
        return this.compareData(ctx, roleCollection_EAS, roleCollection_SHR, roleDatas);
    }

    public void exportRoleExcle(Connection shrConn, Context ctx, HSSFWorkbook workbook, HSSFSheet roleSheet) throws EASBizException, BOSException, SQLException {
        ArrayList<List<String>> roleDatas = new ArrayList<List<String>>();
        this.VerifyRoleData(shrConn, ctx, roleDatas);
        HSSFCellStyle stringValueStyle = workbook.createCellStyle();
        stringValueStyle.setAlignment(HorizontalAlignment.LEFT);
        stringValueStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"@"));
        HSSFRow row = roleSheet.createRow(3);
        int size = roleDatas.size();
        for (int i = 0; i < size; ++i) {
            row = roleSheet.createRow(3 + i);
            List rowVal = (List)roleDatas.get(i);
            int num = rowVal.size();
            for (int j = 0; j < num; ++j) {
                Cell cell = row.createCell(j);
                cell.setCellValue((String)rowVal.get(j));
            }
        }
    }

    private void VerifyRoleData(Connection shrConn, Context ctx, List<List<String>> roleDatas) throws BOSException, SQLException, EASBizException {
        RoleCollection roleCollection_EAS = RoleFactory.getRemoteInstance().getRoleCollection();
        RoleCollection roleCollection_SHR = this.getSHRData(shrConn, ctx);
        this.compareData(ctx, roleCollection_EAS, roleCollection_SHR, roleDatas);
    }

    public void refreshID(Context ctx) throws BOSException {
        DbUtil.execute((Context)ctx, (String)"If exists (select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PM_UserRoleOrg_replace') drop table T_PM_UserRoleOrg_replace;");
        DbUtil.execute((Context)ctx, (String)"select * into T_PM_UserRoleOrg_replace from T_PM_UserRoleOrg where fuserid in(select FSHRID from T_HR_SynIdMapping)");
        DbUtil.execute((Context)ctx, (String)"UPDATE T_PM_UserRoleOrg_replace SET FUSERID=(SELECT FEASID FROM T_HR_SynIdMapping WHERE T_PM_UserRoleOrg_replace.FUSERID= T_HR_SynIdMapping.FSHRID) WHERE FUSERID IN (SELECT FSHRID FROM T_HR_SynIdMapping WHERE fSHRID<>'00000000-0000-0000-0000-000000000000CCE7AED4')");
        StringBuffer sql = new StringBuffer();
        sql.append("insert into  T_PM_UserRoleOrg(FUSERID,FROLEID,FORGID) ").append(" select T_PM_UserRoleOrg_replace.FUSERID,T_PM_UserRoleOrg_replace.FROLEID,T_PM_UserRoleOrg_replace.FORGID ").append("from T_PM_UserRoleOrg_replace ").append("where not exists(select 1 from T_PM_UserRoleOrg where T_PM_UserRoleOrg.FUSERID = T_PM_UserRoleOrg_replace.FUSERID and T_PM_UserRoleOrg.FROLEID = T_PM_UserRoleOrg_replace.FROLEID and T_PM_UserRoleOrg.FORGID = T_PM_UserRoleOrg_replace.FORGID )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        DbUtil.execute((Context)ctx, (String)"DELETE FROM T_PM_UserRoleOrg WHERE fuserid not in(select FID  from T_PM_USER )");
    }

    static {
        excelHead.add("\u89d2\u8272\u7f16\u7801 ");
        excelHead.add("\u89d2\u8272\u540d\u79f0");
        excelHead.add("\u9ed8\u8ba4\u89d2\u8272");
        excelHead.add("\u63cf\u8ff0");
        excelHead.add("\u89d2\u8272ID");
        excelHead.add("\u89d2\u8272\u7f16\u7801");
        excelHead.add("\u89d2\u8272\u540d\u79f0");
        excelHead.add("\u9ed8\u8ba4\u89d2\u8272");
        excelHead.add("\u63cf\u8ff0");
        excelHead.add("\u89d2\u8272ID");
    }
}

