/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SHRMvTableListFactory;
import com.kingdee.eas.hr.mvdt.SHRMvTableListInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.handler.SHRAutoUpdateTableColumnsMultiThreads;
import com.kingdee.eas.hr.mvdt.handler.SHRMoveOriginalDataMultiThreads;
import com.kingdee.eas.hr.mvdt.handler.SHRPostSQLExecutor;
import com.kingdee.eas.hr.mvdt.util.InsertTool;
import com.kingdee.eas.hr.mvdt.util.SHRDataMoveConstant;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.ui.ModelMap;

public class SHRMoveOriginalDataHandler
implements ISHRMoveDataHandler {
    public void initialization() throws BOSException, EASBizException, SQLException {
        Context ctx = SHRContext.getInstance().getContext();
        Connection con = SHRDbConnectionTool.getSHRDBConnection(ctx);
        this.moveData(con, ctx);
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return "";
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        return this.moveData(shrConn, ctx, "", true);
    }

    public void moveDataAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws Exception {
        String idString = request.getParameter("billId");
        String filterString = "'" + idString.replace(",", "','") + "'";
        String condition = "WHERE FID IN (" + filterString + ") AND FDATATYPE != 1";
        Context ctx = SHRContext.getInstance().getContext();
        Connection con = null;
        boolean isDbConnError = false;
        try {
            con = SHRDbConnectionTool.getSHRDBConnection(ctx);
        }
        catch (Exception e) {
            isDbConnError = true;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("err_message", "\u83b7\u53d6\u6570\u636e\u8fde\u63a5\u51fa\u9519");
            JSONUtils.writeJson((HttpServletResponse)response, map);
        }
        if (!isDbConnError) {
            this.moveData(con, ctx, condition, false);
        }
    }

    public String moveData(Connection shrConn, Context ctx, String condition, boolean isContinued) throws BOSException, EASBizException, SQLException {
        String[][] tableArray = this.moveOriginalDataPreparation(ctx, condition, isContinued);
        if (tableArray != null && tableArray.length > 0) {
            this.moveOriginalDataMultiThreadsdAction(ctx, shrConn, tableArray);
            this.afterMovingData(ctx, tableArray);
        }
        return "";
    }

    public String[][] moveOriginalDataPreparation(Context ctx, String condition, boolean isContinued) throws BOSException, SQLException {
        IRowSet iRowSet;
        String sql = "select * from T_HR_SHRMVTABLELIST ";
        sql = condition != null && !"".equals(condition) ? sql + condition : sql + " WHERE FDATATYPE = 2 AND UPPER(FbizType) IN ('ATS','ATSC','CMP','REC','PER','TRA','DEP','PAD','SOC','CB','COS') ";
        if (isContinued) {
            sql = sql + " AND FmvSatus in ('not begin','moving') ";
        }
        if ((iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql)).size() > 0) {
            String[][] resTableArray = new String[iRowSet.size()][3];
            int tempIndex = 0;
            while (iRowSet.next()) {
                resTableArray[tempIndex][0] = iRowSet.getString("fmvTableName");
                resTableArray[tempIndex][1] = iRowSet.getString("fid");
                resTableArray[tempIndex++][2] = iRowSet.getString("FIsBigTable");
            }
            return resTableArray;
        }
        return null;
    }

    public void moveOriginalDataAction(Context ctx, Connection shrConn, String[][] tableArray) throws BOSException, EASBizException, SQLException {
        for (int i = 0; i < tableArray.length; ++i) {
            String fid = tableArray[i][1];
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_SHRMvTableList SET FmvSatus = 'moving' WHERE FID = '" + fid + "'"));
            InsertTool.commonInsert(shrConn, tableArray[i][0], "", ctx, 1000);
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_SHRMvTableList SET FmvSatus = 'finished' WHERE FID = '" + fid + "'"));
        }
    }

    public void moveOriginalDataMultiThreadsdAction(Context ctx, Connection shrConn, String[][] tableArray) {
        int threadNum = this.multiThreadsStrategy(tableArray.length);
        ArrayList<SHRMoveOriginalDataMultiThreads> tasks = new ArrayList<SHRMoveOriginalDataMultiThreads>();
        for (int i = 0; i < threadNum; ++i) {
            tasks.add(new SHRMoveOriginalDataMultiThreads(ctx, shrConn, this.splitTableArray(tableArray, threadNum, i)));
        }
        ExecutorService excutePool = Executors.newFixedThreadPool(threadNum);
        StringBuffer sBuffer = new StringBuffer();
        try {
            List taskResults = excutePool.invokeAll(tasks);
            for (Future future : taskResults) {
                String tempString = "MOVEING THREADSPOOL: " + (String)future.get() + ", is cancelled:" + future.isCancelled() + ", is done:" + future.isDone();
                sBuffer.append(tempString).append("\n");
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        long l = System.currentTimeMillis();
        Date date = new Date(l);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SHRMvTableListInfo mvtli = new SHRMvTableListInfo();
        mvtli.setBizType("TEST");
        mvtli.setMvSatus("not begin");
        mvtli.setMvTableName("NOT TABLE NAME:FOR RECORED MOVE TIME");
        mvtli.setMvTableAlias("TEST FOR TOTAL TIME:" + dateFormat.format(date));
        mvtli.setDataType(0);
        mvtli.setMvException(sBuffer.toString());
        mvtli.setRefreshIdStatus(false);
        try {
            SHRMvTableListFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)mvtli);
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void afterMovingData(Context ctx, String[][] tableArray) throws EASBizException, BOSException, SQLException {
        this.autoUpdateTablesMultiThreadsAction(ctx, tableArray);
        this.setDefaultKeyForNewColumns(ctx);
    }

    public void autoUpdateTables(Context ctx, String[][] tableArray) throws EASBizException, BOSException, SQLException {
        for (int i = 0; i < tableArray.length; ++i) {
            String fid = tableArray[i][1];
            UpdateTool.autoUpdateTablesByTableNames(ctx, tableArray[i][0]);
            DbUtil.execute((Context)ctx, (String)("UPDATE T_HR_SHRMvTableList SET frefreshIdStatus = 1 WHERE FID = '" + fid + "'"));
        }
    }

    public void autoUpdateTablesMultiThreadsAction(Context ctx, String[][] tableArray) throws EASBizException, BOSException, SQLException {
        int threadNum = this.multiThreadsStrategy(tableArray.length);
        ArrayList<SHRAutoUpdateTableColumnsMultiThreads> tasks = new ArrayList<SHRAutoUpdateTableColumnsMultiThreads>();
        for (int i = 0; i < threadNum; ++i) {
            tasks.add(new SHRAutoUpdateTableColumnsMultiThreads(ctx, this.splitTableArray(tableArray, threadNum, i)));
        }
        ExecutorService excutePool = Executors.newFixedThreadPool(threadNum);
        try {
            List list = excutePool.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setDefaultKeyForNewColumns(Context ctx) {
        SHRPostSQLExecutor executor = new SHRPostSQLExecutor();
        SHRPostSQLExecutor.setScriptFilePath(SHRDataMoveConstant.POST_SQL_FILEPATH);
        SHRPostSQLExecutor.setExecuteDataBaseTag(1);
        try {
            executor.execute(ctx);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String[][] splitTableArray(String[][] originalTableArray, int totalPart, int indexOfPart) {
        int restPart = originalTableArray.length % totalPart;
        int betweenPart = originalTableArray.length / totalPart;
        int beginIndex = indexOfPart * betweenPart;
        int endIndex = indexOfPart * betweenPart + (totalPart == indexOfPart + 1 ? betweenPart + restPart : betweenPart) - 1;
        String[][] resTableArray = new String[endIndex - beginIndex + 1][3];
        int tempIndex = 0;
        for (int i = beginIndex; i <= endIndex; ++i) {
            resTableArray[tempIndex][0] = originalTableArray[i][0];
            resTableArray[tempIndex][1] = originalTableArray[i][1];
            resTableArray[tempIndex++][2] = originalTableArray[i][2];
        }
        return resTableArray;
    }

    private int multiThreadsStrategy(int length) {
        int threadNum = 1;
        threadNum = length <= 10 ? 1 : (length <= 20 ? 2 : (length <= 50 ? 3 : (length <= 80 ? 4 : 5)));
        return threadNum;
    }
}

