/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class SHRWorkFlowDataMoveHandler
implements ISHRMoveDataHandler {
    public void initialization() throws BOSException, EASBizException, SQLException {
        Context ctx = SHRContext.getInstance().getContext();
        Connection con = SHRDbConnectionTool.getSHRDBConnection(ctx);
        this.moveData(con, ctx);
    }

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        boolean flag = this.beforeMovingData(shrConn, ctx);
        String[] tables = new String[]{"T_WFD_PROCESSDEF", "T_WFR_PROCDEF", "T_WFR_PROCINST", "T_WFR_PROCINSTHST", "T_WFR_PROCINSTDATA", "T_WFR_PROCINSTBIZOBJ", "T_WFR_ACTINST", "T_WFR_ACTINSTHST", "T_BAS_ASSIGNREAD", "T_WFR_ASSIGN", "T_WFR_ASSIGNHST", "T_WFR_ASSIGNDETAIL", "T_WFR_BIZPROC", "T_WFR_BIZEVENT", "T_WFR_TRANSQUEQUE", "T_WFR_TRANSBOX", "T_WFR_TEMPBIZPROCRELATION", "T_WFR_ENGINELOG", "T_WFR_QUEUELOG", "T_WFR_PROCESSINSTLOG", "T_WFR_PROCESSDEFLOG", "T_WFR_ANALYSISDATA", "T_WFR_MUTEX", "T_WFR_EVENTPROCMETA", "T_WFD_PROCIMPORTDEF", "T_WFR_PROCIMPORTOBJ", "T_WFR_PROCCREQ", "T_WFR_CORRMATCHDATAFIELD", "T_WFR_CORRELATIONMATCH", "T_QTZ_TRIGGERS", "T_QTZ_JOBS", "T_QTZ_CALENDARS", "T_BAS_MULTIAPPROVE", "T_BAS_MULTIAPPROVEHST", "T_WFR_PERFORMERTEMPLETE", "T_BAS_MESSAGE", "T_BAS_MESSAGECATEGORY", "T_BAS_MESSAGESUBSCRIPTION", "T_JOB_DEF", "T_JOB_TRIGGER"};
        String[] conditions = new String[tables.length];
        conditions[0] = " WHERE FPACKAGENAME LIKE '%hr%'";
        conditions[1] = " WHERE FPACKAGENAME LIKE '%hr%'";
        int[] strategies = new int[]{50, 50, 50, 50, 100, 1000, 50, 50, 1000, 50, 50, 50, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 100, 500, 500, 500, 500, 500, 1000, 1000, 1000, 1000, 50, 100, 500, 500, 1000, 500, 500};
        for (int i = 0; i < tables.length; ++i) {
            try {
                String sqlString = "SELECT FMVSATUS FROM T_HR_SHRMvTableList WHERE FMVTABLENAME = '" + tables[i] + "'";
                IRowSet ir = DbUtil.executeQuery((Context)ctx, (String)sqlString);
                String satus = "";
                while (ir.next()) {
                    satus = ir.getString(1);
                }
                if ("finished".equalsIgnoreCase(satus)) continue;
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "moving");
                UpdateTool.commonUpdate(shrConn, tables[i], conditions[i], ctx, strategies[i], 250);
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "finished");
                continue;
            }
            catch (BOSException e) {
                e.printStackTrace();
                SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tables[i], "failed");
                SHRMoveDataHelpUtil.logExceptionInfo(ctx, tables[i], (Exception)((Object)e));
            }
        }
        try {
            this.afterMovingData(shrConn, ctx);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return null;
    }

    public boolean beforeMovingData(Connection shrConn, Context ctx) throws SQLException {
        boolean flag = false;
        String shrDbType = shrConn.getMetaData().getDatabaseProductName();
        if ("Microsoft SQL Server".equals(shrDbType)) {
            flag = true;
            String updateColumnString = "update T_BAS_MESSAGECATEGORY set FBehaviorDescript=' ' where len(cast(FBehaviorDescript as nvarchar))=0 OR FBehaviorDescript IS NULL";
            Statement state = shrConn.createStatement();
            state.execute(updateColumnString);
            state.close();
        }
        return flag;
    }

    public void afterMovingData(Connection shrConn, Context ctx) throws UnknownHostException, BOSException {
        String ip = "";
        InetAddress addr = InetAddress.getLocalHost();
        ip = addr.getHostAddress();
        String updateColumnString = "update T_JOB_TRIGGER set fisolationBoundary='" + ip.trim() + "',fholderId='' where fisValid = 'Y' ";
        DbUtil.execute((Context)ctx, (String)updateColumnString);
    }
}

