/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.handler.ISHRMoveDataHandler;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.shr.base.syssetting.IUIView;
import com.kingdee.shr.base.syssetting.IUIViewExt;
import com.kingdee.shr.base.syssetting.UIType;
import com.kingdee.shr.base.syssetting.UIViewCollection;
import com.kingdee.shr.base.syssetting.UIViewExtCollection;
import com.kingdee.shr.base.syssetting.UIViewExtFactory;
import com.kingdee.shr.base.syssetting.UIViewExtInfo;
import com.kingdee.shr.base.syssetting.UIViewFactory;
import com.kingdee.shr.base.syssetting.UIViewInfo;
import com.kingdee.shr.base.syssetting.UIViewTreeInfo;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.apache.log4j.Logger;

public class UIViewMoveHandler
implements ISHRMoveDataHandler {
    public static final String BOSTYPE = "1472A672";
    private static Logger logger = Logger.getLogger(UIViewMoveHandler.class);

    @Override
    public String verifyData(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        return null;
    }

    @Override
    public String moveData(Connection shrConn, Context ctx) throws BOSException, EASBizException, SQLException {
        this.moveUIView(shrConn, ctx);
        this.moveUIViewExt(shrConn, ctx);
        this.do_moveAfter(shrConn, ctx);
        return null;
    }

    private void moveUIViewExt(Connection shrConn, Context ctx) throws BOSException, EASBizException {
        try {
            String tableName = "S_BS_UIViewExt";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            String delSql = "delete  from S_BS_UIViewExt";
            DbUtil.execute((Context)ctx, (String)delSql);
            UIViewExtCollection shr_ext_collection = new UIViewExtCollection();
            UIViewExtCollection eas_ext_collection = new UIViewExtCollection();
            shr_ext_collection = this.getSHRDataExt(shrConn, ctx);
            eas_ext_collection = UIViewExtFactory.getRemoteInstance().getUIViewExtCollection();
            UIViewExtCollection diffCollectionSHR_ext = null;
            if (eas_ext_collection.isEmpty()) {
                this.addSHREXTDataToEAS(ctx, shr_ext_collection);
            } else {
                diffCollectionSHR_ext = this.compareData_ext(ctx, eas_ext_collection, shr_ext_collection);
                if (diffCollectionSHR_ext.size() > 0) {
                    this.addSHREXTDataToEAS(ctx, diffCollectionSHR_ext);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "S_BS_UIViewExt".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void moveUIView(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException, SQLException, EASBizException {
        String tableName = "S_BS_UIView";
        if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
            return;
        }
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
        UIViewCollection shr_collection = new UIViewCollection();
        UIViewCollection eas_collection = new UIViewCollection();
        shr_collection = this.getSHRData(shrConn, ctx);
        eas_collection = UIViewFactory.getRemoteInstance().getUIViewCollection();
        try {
            UIViewCollection diffCollectionSHR = null;
            if (eas_collection.isEmpty()) {
                this.addSHRDataToEAS(ctx, shr_collection);
            } else {
                diffCollectionSHR = this.compareData(ctx, eas_collection, shr_collection);
                if (diffCollectionSHR.size() > 0) {
                    this.addSHRDataToEAS(ctx, diffCollectionSHR);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "S_BS_UIView".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void do_moveAfter(Connection shrConn, Context ctx) throws EASBizException, BOSException, SQLException {
        logger.info((Object)"-------------------------------------------------------\u5237\u65b0ID\u3010\u89c6\u56fe\u8fc1\u79fb\u3011----------------------------------------------------------------------------");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "S_BS_UIView", "FCREATORID");
        UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "S_BS_UIViewExt", "FCREATORID");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "S_BS_UIView".toUpperCase(), "finished");
        SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "S_BS_UIViewExt".toUpperCase(), "finished");
    }

    private UIViewExtCollection compareData_ext(Context ctx, UIViewExtCollection eas_ext_collection, UIViewExtCollection shr_ext_collection) {
        UIViewExtInfo infoEAS = null;
        UIViewExtInfo infoSHR = null;
        UIViewExtCollection diffCollectionSHR = new UIViewExtCollection();
        boolean match = false;
        for (int i = 0; i < shr_ext_collection.size(); ++i) {
            infoSHR = shr_ext_collection.get(i);
            for (int j = 0; j < eas_ext_collection.size(); ++j) {
                infoEAS = eas_ext_collection.get(j);
                if (infoEAS.getParent() == null || infoSHR.getParent() == null || !infoEAS.getParent().getId().toString().equals(infoSHR.getParent().getId().toString())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    public void addSHREXTDataToEAS(Context ctx, UIViewExtCollection shr_ext_collection) throws BOSException, EASBizException {
        UIViewExtInfo info = null;
        IUIViewExt UIViewExt = UIViewExtFactory.getRemoteInstance();
        for (int i = 0; i < shr_ext_collection.size(); ++i) {
            info = shr_ext_collection.get(i);
            UIViewExt.addnew((CoreBaseInfo)info);
        }
    }

    public UIViewExtCollection getSHRDataExt(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from S_BS_UIViewExt";
        UIViewExtCollection shrCollection = new UIViewExtCollection();
        UIViewExtInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "S_BS_UIViewExt".toUpperCase());
        try {
            stmt = shrConn.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
                String fcontent = colummnsmap.containsKey("fcontent".toUpperCase()) ? this.getTextContent(rs, "fcontent") : "";
                String fparentid = colummnsmap.containsKey("fparentid".toUpperCase()) ? rs.getString("fparentid") : "";
                String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
                String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
                String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
                String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
                String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
                String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
                shrInfo = new UIViewExtInfo();
                shrInfo.setId(BOSUuid.read((String)fid));
                shrInfo.setContent(fcontent);
                if (fparentid != null && !fparentid.isEmpty()) {
                    UIViewInfo uiview = new UIViewInfo();
                    uiview.setId(BOSUuid.read((String)fparentid));
                    shrInfo.setParent(uiview);
                }
                if (fcreatorid != null && !fcreatorid.isEmpty()) {
                    UserInfo user = new UserInfo();
                    user.setId(BOSUuid.read((String)fcreatorid));
                    shrInfo.setCreator(user);
                }
                if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                    CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                    ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                    shrInfo.setCU(ctrinfo);
                }
                shrInfo.setUipk(fuipk);
                shrCollection.add(shrInfo);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return shrCollection;
    }

    private String getTextContent(ResultSet rs, String columnName) {
        try {
            Reader reader = rs.getCharacterStream(columnName);
            if (reader != null) {
                StringBuffer sb = new StringBuffer();
                char[] charbuf = new char[4096];
                int i = reader.read(charbuf);
                while (i > 0) {
                    sb.append(charbuf, 0, i);
                    i = reader.read(charbuf);
                }
                return sb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public UIViewCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, InterfaceDataBaseException, SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from S_BS_UIView";
        UIViewCollection shrCollection = new UIViewCollection();
        UIViewInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "S_BS_UIView".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String fname = colummnsmap.containsKey("fname".toUpperCase()) ? rs.getString("fname") : "";
            String fmodel = colummnsmap.containsKey("fmodel".toUpperCase()) ? rs.getString("fmodel") : "";
            String ftype = colummnsmap.containsKey("ftype".toUpperCase()) ? rs.getString("ftype") : "";
            String fcontent = colummnsmap.containsKey("fcontent".toUpperCase()) ? rs.getString("fcontent") : "";
            String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
            String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
            String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
            String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
            String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String furi = colummnsmap.containsKey("furi".toUpperCase()) ? rs.getString("furi") : "";
            String fuipk = colummnsmap.containsKey("fuipk".toUpperCase()) ? rs.getString("fuipk") : "";
            String finner = colummnsmap.containsKey("finner".toUpperCase()) ? rs.getString("finner") : "";
            String ftreeid = colummnsmap.containsKey("ftreeid".toUpperCase()) ? rs.getString("ftreeid") : "";
            String fvardefine = colummnsmap.containsKey("fvardefine".toUpperCase()) ? rs.getString("fvardefine") : "";
            shrInfo = new UIViewInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            shrInfo.setName(fname);
            shrInfo.setModel(fmodel);
            shrInfo.setType(UIType.getEnum((String)ftype));
            shrInfo.setContent(fcontent);
            if (fcreatorid != null && !fcreatorid.isEmpty()) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)fcreatorid));
                shrInfo.setCreator(user);
            }
            if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                shrInfo.setCU(ctrinfo);
            }
            shrInfo.setUri(furi);
            shrInfo.setUipk(fuipk);
            if (finner != null) {
                boolean isinner = finner.equals("1");
                shrInfo.setInner(isinner);
            }
            if (ftreeid != null && !ftreeid.isEmpty()) {
                UIViewTreeInfo treeinfo = new UIViewTreeInfo();
                treeinfo.setId(BOSUuid.read((String)ftreeid));
                shrInfo.setTree(treeinfo);
            }
            shrInfo.setVarDefine(fvardefine);
            shrCollection.add(shrInfo);
        }
        return shrCollection;
    }

    public void addSHRDataToEAS(Context ctx, UIViewCollection shr_collection) throws BOSException, EASBizException {
        UIViewInfo info = null;
        IUIView UIView = UIViewFactory.getRemoteInstance();
        for (int i = 0; i < shr_collection.size(); ++i) {
            info = shr_collection.get(i);
            UIView.addnew((CoreBaseInfo)info);
        }
    }

    public UIViewCollection compareData(Context ctx, UIViewCollection eas_collection, UIViewCollection shr_collection) throws BOSException, EASBizException {
        UIViewInfo infoEAS = null;
        UIViewInfo infoSHR = null;
        UIViewCollection diffCollectionSHR = new UIViewCollection();
        boolean match = false;
        for (int i = 0; i < shr_collection.size(); ++i) {
            infoSHR = shr_collection.get(i);
            if (infoSHR.getUipk() == null) {
                match = false;
                continue;
            }
            for (int j = 0; j < eas_collection.size(); ++j) {
                infoEAS = eas_collection.get(j);
                if (infoEAS.getUipk() == null || !infoEAS.getId().toString().equals(infoSHR.getId().toString()) && !infoEAS.getUipk().equals(infoSHR.getUipk())) continue;
                match = true;
                break;
            }
            if (!match) {
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }
}

