/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUserGroup;
import com.kingdee.eas.base.permission.UserGroupCollection;
import com.kingdee.eas.base.permission.UserGroupFactory;
import com.kingdee.eas.base.permission.UserGroupInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.mvdt.SynIdMappingFactory;
import com.kingdee.eas.hr.mvdt.SynIdMappingInfo;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.SHRMoveDataHelpUtil;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.eas.hr.mvdt.util.UpdateTool;
import com.kingdee.eas.hr.mvdt.util.WriteExcelDataTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UserGroupMoveHandler {
    public static final String BOSTYPE = "57585F40";
    public static List<String> excelHead = new ArrayList<String>();

    public void verifyData(Connection shrConn, Context ctx, List<List<String>> usergroupDatas) throws BOSException, SQLException, EASBizException {
        UserGroupCollection userGroupCollection_EAS = UserGroupFactory.getRemoteInstance().getUserGroupCollection();
        UserGroupCollection userGroupCollection_SHR = this.getSHRData(shrConn, ctx);
        this.compareData(ctx, userGroupCollection_EAS, userGroupCollection_SHR, usergroupDatas);
    }

    private UserGroupCollection compareData(Context ctx, UserGroupCollection userGroupCollection_EAS, UserGroupCollection userGroupCollection_SHR, List<List<String>> usergroupDatas) throws EASBizException, BOSException {
        int j;
        int i;
        UserGroupInfo infoEAS = new UserGroupInfo();
        UserGroupInfo infoSHR = new UserGroupInfo();
        UserGroupCollection diffCollectionSHR = new UserGroupCollection();
        boolean match = false;
        for (i = 0; i < userGroupCollection_SHR.size(); ++i) {
            infoSHR = userGroupCollection_SHR.get(i);
            for (j = 0; j < userGroupCollection_EAS.size(); ++j) {
                infoEAS = userGroupCollection_EAS.get(j);
                if (!infoEAS.getName().equals(infoSHR.getName())) continue;
                this.generateMappingTrueExcelData(ctx, infoSHR, infoEAS, usergroupDatas);
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInEASMappingExcelData(ctx, infoSHR, infoEAS, usergroupDatas);
                diffCollectionSHR.add(infoSHR);
                continue;
            }
            match = false;
        }
        match = false;
        for (i = 0; i < userGroupCollection_EAS.size(); ++i) {
            infoEAS = userGroupCollection_EAS.get(i);
            for (j = 0; j < userGroupCollection_SHR.size(); ++j) {
                infoSHR = userGroupCollection_SHR.get(j);
                if (!infoEAS.getName().equals(infoSHR.getName())) continue;
                match = true;
                break;
            }
            if (!match) {
                this.generateNotFoundInSHRMappingExcelData(ctx, infoSHR, infoEAS, usergroupDatas);
                continue;
            }
            match = false;
        }
        return diffCollectionSHR;
    }

    private void generateNotFoundInSHRMappingExcelData(Context ctx, UserGroupInfo infoSHR, UserGroupInfo infoEAS, List<List<String>> usergroupDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add(infoEAS.getId().toString());
        resultRow.add(infoEAS.getNumber());
        resultRow.add(String.valueOf(infoEAS.getLevel()));
        resultRow.add(infoEAS.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsLeaf()));
        resultRow.add(infoEAS.getLongNumber());
        if (infoEAS.getParent() != null) {
            resultRow.add(WriteExcelDataTool.transNULLToQuotation(infoEAS.getParent().getId().toString()));
        } else {
            resultRow.add("");
        }
        usergroupDatas.add(resultRow);
    }

    private void generateNotFoundInEASMappingExcelData(Context ctx, UserGroupInfo infoSHR, UserGroupInfo infoEAS, List<List<String>> usergroupDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getId().toString());
        resultRow.add(infoSHR.getNumber());
        resultRow.add(String.valueOf(infoSHR.getLevel()));
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsLeaf()));
        resultRow.add(infoSHR.getLongNumber());
        if (infoSHR.getParent() != null) {
            resultRow.add(WriteExcelDataTool.transNULLToQuotation(infoSHR.getParent().getId().toString()));
        } else {
            resultRow.add("");
        }
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        resultRow.add("");
        usergroupDatas.add(resultRow);
    }

    private void generateMappingTable(Context ctx, UserGroupInfo infoSHR, UserGroupInfo infoEAS) throws EASBizException, BOSException {
        String infoSHRId = infoSHR.getId().toString();
        String infoEASId = infoEAS.getId().toString();
        SynIdMappingInfo synIdMappingInfo = new SynIdMappingInfo();
        synIdMappingInfo.setShrId(infoSHRId);
        synIdMappingInfo.setEasId(infoEASId);
        synIdMappingInfo.setBosType(BOSTYPE);
        SynIdMappingFactory.getLocalInstance(ctx).addnew(synIdMappingInfo);
    }

    private void generateMappingTrueExcelData(Context ctx, UserGroupInfo infoSHR, UserGroupInfo infoEAS, List<List<String>> usergroupDatas) {
        ArrayList<String> resultRow = new ArrayList<String>();
        resultRow.add(infoSHR.getId().toString());
        resultRow.add(infoSHR.getNumber());
        resultRow.add(String.valueOf(infoSHR.getLevel()));
        resultRow.add(infoSHR.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoSHR.isIsLeaf()));
        resultRow.add(infoSHR.getLongNumber());
        if (infoSHR.getParent() != null) {
            resultRow.add(WriteExcelDataTool.transNULLToQuotation(infoSHR.getParent().getId().toString()));
        } else {
            resultRow.add("");
        }
        resultRow.add(infoEAS.getId().toString());
        resultRow.add(infoEAS.getNumber());
        resultRow.add(String.valueOf(infoEAS.getLevel()));
        resultRow.add(infoEAS.getName());
        resultRow.add(WriteExcelDataTool.transBooleanToChinese(infoEAS.isIsLeaf()));
        resultRow.add(infoEAS.getLongNumber());
        if (infoEAS.getParent() != null) {
            resultRow.add(WriteExcelDataTool.transNULLToQuotation(infoEAS.getParent().getId().toString()));
        } else {
            resultRow.add("");
        }
        usergroupDatas.add(resultRow);
    }

    private UserGroupCollection getSHRData(Connection shrConn, Context ctx) throws BOSException, SQLException, EASBizException {
        Statement stmt = null;
        ResultSet rs = null;
        String sql = "select * from T_PM_UserGroup";
        UserGroupCollection shrCollection = new UserGroupCollection();
        UserGroupInfo shrInfo = null;
        Map<String, ColumnInfo> colummnsmap = TableColumnSyncTool.getSHRTableColumnMap(ctx, "T_PM_UserGroup".toUpperCase());
        stmt = shrConn.createStatement();
        rs = stmt.executeQuery(sql);
        while (rs.next()) {
            String fid = colummnsmap.containsKey("fid".toUpperCase()) ? rs.getString("fid") : "";
            String fnumber = colummnsmap.containsKey("fnumber".toUpperCase()) ? rs.getString("fnumber") : "";
            String flevel = colummnsmap.containsKey("flevel".toUpperCase()) ? rs.getString("flevel") : "";
            String fisleaf = colummnsmap.containsKey("fisleaf".toUpperCase()) ? rs.getString("fisleaf") : "";
            String flongnumber = colummnsmap.containsKey("flongnumber".toUpperCase()) ? rs.getString("flongnumber") : "";
            String fparent = colummnsmap.containsKey("fparent".toUpperCase()) ? rs.getString("fparent") : "";
            String fname = colummnsmap.containsKey("fname_l2".toUpperCase()) ? rs.getString("fname_l2") : "";
            String fdescription = colummnsmap.containsKey("fdescription_l2".toUpperCase()) ? rs.getString("fdescription_l2") : "";
            String fcreatorid = colummnsmap.containsKey("fcreatorid".toUpperCase()) ? rs.getString("fcreatorid") : "";
            String fcreatetime = colummnsmap.containsKey("fcreatetime".toUpperCase()) ? rs.getString("fcreatetime") : "";
            String flastupdateuserid = colummnsmap.containsKey("flastupdateuserid".toUpperCase()) ? rs.getString("flastupdateuserid") : "";
            String flastupdatetime = colummnsmap.containsKey("flastupdatetime".toUpperCase()) ? rs.getString("flastupdatetime") : "";
            String fcontrolunitid = colummnsmap.containsKey("fcontrolunitid".toUpperCase()) ? rs.getString("fcontrolunitid") : "";
            String fdisplayname = colummnsmap.containsKey("fdisplayname_l2".toUpperCase()) ? rs.getString("fdisplayname_l2") : "";
            shrInfo = new UserGroupInfo();
            shrInfo.setId(BOSUuid.read((String)fid));
            shrInfo.setName(fname);
            shrInfo.setNumber(fnumber);
            shrInfo.setLongNumber(flongnumber);
            shrInfo.setDescription(fdescription);
            shrInfo.setDisplayName(fdisplayname);
            if (fparent != null && !fparent.isEmpty()) {
                UserGroupInfo info = new UserGroupInfo();
                info.setId(BOSUuid.read((String)fparent));
                shrInfo.setParent(info);
            }
            if (fisleaf != null && !fisleaf.isEmpty()) {
                boolean isleaf = fisleaf.equals("1");
                shrInfo.setIsLeaf(isleaf);
            }
            if (flevel != null && !flevel.isEmpty()) {
                shrInfo.setLevel(Integer.parseInt(flevel));
            }
            if (fcreatorid != null && !fcreatorid.isEmpty()) {
                UserInfo user = new UserInfo();
                user.setId(BOSUuid.read((String)fcreatorid));
                shrInfo.setCreator(user);
            }
            if (fcontrolunitid != null && !fcontrolunitid.isEmpty()) {
                CtrlUnitInfo ctrinfo = new CtrlUnitInfo();
                ctrinfo.setId(BOSUuid.read((String)fcontrolunitid));
                shrInfo.setCU(ctrinfo);
            }
            shrCollection.add(shrInfo);
        }
        rs.close();
        stmt.close();
        return shrCollection;
    }

    public void moveData(Connection shrConn, Context ctx) throws BOSException, SQLException, EASBizException {
        try {
            String tableName = "T_PM_UserGroup ";
            if (SHRMoveDataHelpUtil.checkMoveTableIfFinished(ctx, tableName.toUpperCase())) {
                return;
            }
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, tableName, "moving");
            UpdateTool.commonUpdate(shrConn, "T_PM_UserGroup", "", ctx, 200);
            UpdateTool.updateTablesByTableNameAndSeletedColumns(ctx, "T_PM_UserGroup", "FCREATORID");
            this.updateTable(ctx);
            SHRMoveDataHelpUtil.updateTableMoveStateByTableName(ctx, "T_PM_UserGroup".toUpperCase(), "finished");
        }
        catch (Exception e) {
            e.printStackTrace();
            SHRMoveDataHelpUtil.updateTableMoveExceptionByTableName(ctx, "T_PM_UserGroup".toUpperCase(), e.toString());
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    private void updateTable(Context ctx) throws BOSException, SQLException {
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select * from KSQL_USERTABLES where KSQL_TABNAME ='T_PM_USERGROUPG'");
        if (rs.next()) {
            StringBuffer sql = new StringBuffer();
            sql.append("INSERT INTO t_pm_usergroupg(fuserid,fgroupid )SELECT t_pm_user.fid,t_pm_user.fgroupid FROM   t_pm_user WHERE  NOT EXISTS (SELECT 1 FROM   t_pm_usergroupg WHERE  t_pm_usergroupg.fuserid = t_pm_user.fid").append(" AND t_pm_usergroupg.fgroupid = t_pm_user.fgroupid").append("  )  AND  t_pm_user.fgroupid IS NOT NULL  ");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private UserGroupCollection compareData(Context ctx, UserGroupCollection userGroupCollection_EAS, UserGroupCollection userGroupCollection_SHR) throws EASBizException, BOSException {
        ArrayList<List<String>> userGroupDatas = new ArrayList<List<String>>();
        return this.compareData(ctx, userGroupCollection_EAS, userGroupCollection_SHR, userGroupDatas);
    }

    private void addSHRDataToEAS(Context ctx, UserGroupCollection userGroupCollection_SHR) throws BOSException, EASBizException {
        UserGroupInfo info = null;
        IUserGroup UserGroup = UserGroupFactory.getRemoteInstance();
        for (int i = 0; i < userGroupCollection_SHR.size(); ++i) {
            info = userGroupCollection_SHR.get(i);
            UserGroup.addnew((CoreBaseInfo)info);
        }
    }

    static {
        excelHead.add("ID ");
        excelHead.add("\u7f16\u7801");
        excelHead.add("\u7ea7\u6b21");
        excelHead.add("\u540d\u79f0");
        excelHead.add("\u662f\u5426\u53f6\u5b50\u8282\u70b9");
        excelHead.add("\u957f\u7f16\u7801");
        excelHead.add("\u7236\u7528\u6237\u7ec4");
        excelHead.add("ID");
        excelHead.add("\u7f16\u7801");
        excelHead.add("\u7ea7\u6b21");
        excelHead.add("\u540d\u79f0");
        excelHead.add("\u662f\u5426\u53f6\u5b50\u8282\u70b9");
        excelHead.add("\u957f\u7f16\u7801");
        excelHead.add("\u7236\u7528\u6237\u7ec4");
    }
}

