/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ShellFile;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class BatFile
implements ShellFile {
    private File batFile;
    private String fileName;
    private Properties props;
    private static Logger logger = Logger.getLogger(BatFile.class);

    public BatFile(String fileName) {
        this.batFile = new File(fileName);
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateParameter(String paraName, String value) {
        this.getParameters();
        if (value.equals(this.props.getProperty(paraName))) {
            return;
        }
        File file = this.batFile;
        synchronized (file) {
            FileLock lock = null;
            FileOutputStream tempOut = null;
            OutputStreamWriter tempWriter = null;
            BufferedWriter tempBuffWriter = null;
            BufferedReader buffReader = null;
            BufferedWriter buffWriter = null;
            try {
                paraName = paraName.trim();
                StringBuffer strBuffer = new StringBuffer();
                FileInputStream stream = new FileInputStream(this.batFile);
                InputStreamReader reader = new InputStreamReader(stream);
                buffReader = new BufferedReader(reader);
                String oldLine = "";
                String newLine = "";
                String pattern = "^\\s*SET\\s*" + paraName + "\\s*=\\s*(.*)$";
                Pattern p = Pattern.compile(pattern, 2);
                boolean hasFound = false;
                try {
                    tempOut = new FileOutputStream(this.batFile + ".bak");
                    tempWriter = new OutputStreamWriter(tempOut);
                    tempBuffWriter = new BufferedWriter(tempWriter);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
                while ((oldLine = buffReader.readLine()) != null) {
                    Matcher m;
                    newLine = oldLine;
                    if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                        hasFound = true;
                        String start = m.group(0);
                        String target = m.group(1);
                        if (StringUtils.hasText(target)) {
                            int length = oldLine.indexOf(target);
                            start = oldLine.substring(0, length);
                            oldLine = newLine = start + value;
                        } else {
                            oldLine = newLine = start + value;
                        }
                    }
                    oldLine = oldLine + "\r\n";
                    strBuffer.append(oldLine);
                    try {
                        tempBuffWriter.write(oldLine);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                }
                if (!hasFound) {
                    strBuffer.append("SET " + paraName + "=" + value + "\r\n");
                    try {
                        tempBuffWriter.write("SET " + paraName + "=" + value + "\r\n");
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                }
                try {
                    tempBuffWriter.flush();
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
                FileOutputStream out = new FileOutputStream(this.batFile);
                lock = out.getChannel().tryLock();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                buffWriter = new BufferedWriter(writer);
                buffWriter.write(strBuffer.toString());
                buffWriter.flush();
                if (this.props != null) {
                    this.props.setProperty(paraName, value);
                }
            }
            catch (Exception e) {
                throw new AdminException("Update shell file [" + this.fileName + "]  paraName [" + paraName + "] failed!", e);
            }
            finally {
                try {
                    if (buffReader != null) {
                        buffReader.close();
                    }
                    if (lock != null) {
                        lock.release();
                    }
                    if (buffWriter != null) {
                        buffWriter.close();
                    }
                    if (tempBuffWriter != null) {
                        tempBuffWriter.close();
                    }
                    if (tempWriter != null) {
                        tempWriter.close();
                    }
                    if (tempOut != null) {
                        tempOut.close();
                    }
                    if ("true".equalsIgnoreCase(System.getProperty("renamesetserverenv", "false"))) {
                        if (this.batFile.delete()) {
                            if (!new File(this.batFile + ".bak").renameTo(this.batFile)) {
                                logger.info((Object)("Rename file [" + this.batFile + ".bak] failed"));
                            }
                        } else {
                            logger.info((Object)("Delete file [" + this.batFile + "] failed"));
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public String getParameter(String paraName, String defaultValue) {
        Properties p = this.getParameters();
        return p.getProperty(paraName, defaultValue);
    }

    @Override
    public String getParameterWithoutEmpty(String paramName, String defaultValue) {
        String value = this.getParameter(paramName, defaultValue);
        if (StringUtils.hasText(value)) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public File getFile() {
        return this.batFile;
    }

    @Override
    public Properties getParameters() {
        if (this.props == null) {
            this.loadProperties();
        }
        return this.props;
    }

    private void loadProperties() {
        try {
            Properties temp = new Properties();
            FileInputStream stream = new FileInputStream(this.batFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            ArrayList<String> nameList = new ArrayList<String>();
            String pattern = "^\\s*@?set\\s+([\\S&&[^=]]+)\\s*=([\\s*(\\S+)\\s*]+)$";
            Pattern p = Pattern.compile(pattern, 2);
            while ((oldLine = buffReader.readLine()) != null) {
                Matcher m;
                if (oldLine.trim().length() == 0 || !(m = p.matcher(oldLine)).find()) continue;
                String value = m.group(2);
                value = m.group(2).replace('\\', '/');
                value = value.replaceAll("\"\"", "%Double_Quotation_Marks%");
                value = value.replaceAll("\"", "");
                value = value.replaceAll("%Double_Quotation_Marks%", "\"");
                temp.setProperty(m.group(1), value);
                nameList.add(m.group(1));
                if (!"true".equalsIgnoreCase(System.getProperty("printAllParams", "false"))) continue;
                logger.info((Object)("=============Name:" + m.group(1) + "====value:" + value));
            }
            for (int i = 0; i < nameList.size(); ++i) {
                String name = (String)nameList.get(i);
                String value = temp.getProperty(name);
                for (int k = i + 1; k < nameList.size(); ++k) {
                    String pName = (String)nameList.get(k);
                    String pValue = temp.getProperty(pName);
                    pValue = pValue.replaceAll("%" + name + "%", value);
                    temp.setProperty(pName, pValue);
                }
            }
            stream.close();
            this.props = temp;
        }
        catch (Exception e) {
            throw new AdminException("Load config from shell [" + this.fileName + "] failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String paraName) {
        File file = this.batFile;
        synchronized (file) {
            FileLock lock = null;
            try {
                paraName = paraName.trim();
                StringBuffer strBuffer = new StringBuffer();
                FileInputStream stream = new FileInputStream(this.batFile);
                InputStreamReader reader = new InputStreamReader(stream);
                BufferedReader buffReader = new BufferedReader(reader);
                String oldLine = "";
                String pattern = "^\\s*SET\\s*" + paraName + "\\s*=\\s*(.*)$";
                Pattern p = Pattern.compile(pattern, 2);
                while ((oldLine = buffReader.readLine()) != null) {
                    Matcher m;
                    if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                        oldLine = "@REM " + oldLine;
                    }
                    oldLine = oldLine + "\r\n";
                    strBuffer.append(oldLine);
                }
                FileOutputStream out = new FileOutputStream(this.batFile);
                lock = out.getChannel().tryLock();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                BufferedWriter buffWriter = new BufferedWriter(writer);
                buffWriter.write(strBuffer.toString());
                buffWriter.flush();
                buffWriter.close();
                if (this.props != null) {
                    this.props.remove(paraName);
                }
            }
            catch (Exception e) {
                throw new AdminException("Remove paraName[" + paraName + "] from shell [" + this.fileName + "] failed!", e);
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

