/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB2UDB;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB2VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB400;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DB400VO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DBException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.DatabaseVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.IDatabase;
import com.kingdee.eas.hr.mvdt.patch.executeSql.MySQL;
import com.kingdee.eas.hr.mvdt.patch.executeSql.MySQLVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.Oracle;
import com.kingdee.eas.hr.mvdt.patch.executeSql.OracleVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.PropertiesUtils;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlServer;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SqlServerVO;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SyBase;
import com.kingdee.eas.hr.mvdt.patch.executeSql.SyBaseVO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public final class DatabaseManager {
    private static HashMap cachedDBEnginesRunSQLScript = new HashMap(20);
    private static HashMap cachedDBEnginesQueryAnalyer = new HashMap(20);
    private static HashMap latestVisitTimeQueryAnalyer = new HashMap(20);
    private static Timer timer;
    private static int runInScheduleTime;
    private static int timeOutToRollback;
    private static final Logger logger;

    public static synchronized IDatabase getDBEngine(DatabaseVO dbvo) {
        return DatabaseManager.getDBEngine(dbvo, false);
    }

    public static synchronized IDatabase getDBEngine(DatabaseVO dbvo, boolean isForSQLAnalyer) {
        HashMap cacheEngine = cachedDBEnginesRunSQLScript;
        if (isForSQLAnalyer) {
            Long latestVisitTimeMillis = new Long(System.currentTimeMillis());
            latestVisitTimeQueryAnalyer.put(dbvo.getID(), latestVisitTimeMillis);
            DatabaseManager.exeTimeOutToRollback();
            cacheEngine = cachedDBEnginesQueryAnalyer;
        }
        if (cacheEngine.containsKey(dbvo.getID())) {
            return (IDatabase)cacheEngine.get(dbvo.getID());
        }
        logger.info((Object)("====Create new database engine for [" + dbvo.getIDForOutput() + "]...isForSQLAnalyer[" + isForSQLAnalyer + "]"));
        if ("Oracle".equals(dbvo.getDBType())) {
            Oracle oraEngine = new Oracle((OracleVO)dbvo);
            cacheEngine.put(dbvo.getID(), oraEngine);
            return oraEngine;
        }
        if ("MS SqlServer".equals(dbvo.getDBType())) {
            SqlServer sqlEngine = new SqlServer((SqlServerVO)dbvo);
            cacheEngine.put(dbvo.getID(), sqlEngine);
            return sqlEngine;
        }
        if ("DB2".equals(dbvo.getDBType())) {
            DB2UDB db2Engine = new DB2UDB((DB2VO)dbvo);
            cacheEngine.put(dbvo.getID(), db2Engine);
            return db2Engine;
        }
        if ("DB2/400".equals(dbvo.getDBType())) {
            DB400 db400Engine = new DB400((DB400VO)dbvo);
            cacheEngine.put(dbvo.getID(), db400Engine);
            return db400Engine;
        }
        if ("Sybase".equalsIgnoreCase(dbvo.getDBType())) {
            SyBase sybaseEngine = new SyBase((SyBaseVO)dbvo);
            cacheEngine.put(dbvo.getID(), sybaseEngine);
            return sybaseEngine;
        }
        if ("MySQL".equalsIgnoreCase(dbvo.getDBType())) {
            MySQL mySQLEngine = new MySQL((MySQLVO)dbvo);
            cacheEngine.put(dbvo.getID(), mySQLEngine);
            return mySQLEngine;
        }
        throw new DBException("DBType[" + dbvo.getDBType() + "] is not supported!");
    }

    public static String[] getSupportedDBTypes() {
        return DatabaseVO.getSupportedDBTypes();
    }

    public static int getTimeOutToRollback() {
        return timeOutToRollback;
    }

    public static void setTimeOutToRollback(int timeOutSecs) {
        timeOutToRollback = timeOutSecs;
        logger.info((Object)("TimeOutToRollback have been set,value=[" + timeOutToRollback + "s]"));
    }

    private static void exeTimeOutToRollback() {
        if (timer == null) {
            logger.info((Object)("====Schedule a timer:Task [RollbackTimerTask] delay[20s],period[20s];SQLQueryAnalyerTimeOutToRollback[" + timeOutToRollback + "s]"));
            timer = new Timer(true);
            TimerTask rollbackTimerTask = new TimerTask(){

                @Override
                public void run() {
                    if (timeOutToRollback < 100) {
                        DatabaseManager.setTimeOutToRollback(600);
                    }
                    for (String dbvoID : cachedDBEnginesQueryAnalyer.keySet()) {
                        IDatabase dbEngine;
                        Long latestVisitTimeMillis = (Long)latestVisitTimeQueryAnalyer.get(dbvoID);
                        long latestVisitTime = latestVisitTimeMillis;
                        long currentSysTime = System.currentTimeMillis();
                        if (currentSysTime - latestVisitTime < (long)(timeOutToRollback * 1000) || (dbEngine = (IDatabase)cachedDBEnginesQueryAnalyer.get(dbvoID)).getAutoCommit()) continue;
                        dbEngine.rollbackTransaction();
                        Long rollbackTimeMillis = new Long(System.currentTimeMillis());
                        latestVisitTimeQueryAnalyer.put(dbvoID, rollbackTimeMillis);
                    }
                }
            };
            timer.scheduleAtFixedRate(rollbackTimerTask, runInScheduleTime * 1000, (long)(runInScheduleTime * 1000));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTimeOutToRollbackFromConfigFile() {
        Properties prop = new Properties();
        FileInputStream inStream = null;
        int timeOutFromFile = 600;
        try {
            File file = new File("./config/timeouttorollback.properties");
            if (file.exists()) {
                inStream = new FileInputStream(file);
                PropertiesUtils.load(prop, inStream);
            }
            timeOutFromFile = Integer.valueOf(prop.getProperty("timeoutvalue"));
        }
        catch (Exception e) {
            logger.error((Object)"Get timeout value to rollback from config file error,set default value[600s] !", (Throwable)e);
            timeOutFromFile = 600;
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return timeOutFromFile;
    }

    public static void saveTimeOutToConfigFile(int number) {
        try {
            Properties props = new Properties();
            props.setProperty("timeoutvalue", String.valueOf(number));
            FileWriter writer = new FileWriter("./config/timeouttorollback.properties");
            PropertiesUtils.store(props, writer, "Query Analyer TimeOut To Rollback,unit(second),eg. 600");
        }
        catch (Exception e) {
            logger.error((Object)"Save timeout value to rollback to config file error !", (Throwable)e);
            throw new AdminException("Save timeout value to rollback to config file error !", e);
        }
    }

    static {
        runInScheduleTime = 20;
        timeOutToRollback = 600;
        logger = Logger.getLogger(DatabaseManager.class);
    }
}

