/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.DBSQLException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.MultiSqlProvider;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class DefaultSqlInputStreamExecutor
implements MultiSqlProvider {
    private static final Logger logger = Logger.getLogger(DefaultSqlInputStreamExecutor.class);
    private BufferedReader sqlFileReader;
    private ArrayList exceptions = new ArrayList();
    protected String split = ";";
    private String executorName = "";
    private ArrayList curSQLList = new ArrayList();
    private int curSQLIndex = -1;
    private boolean istransTostoreProc = false;
    private ArrayList curOrgSqlList = new ArrayList();

    public String getCurOrgSql() {
        if (this.curSQLIndex > 0) {
            return (String)this.curOrgSqlList.get(this.curSQLIndex - 1);
        }
        return "";
    }

    public DefaultSqlInputStreamExecutor(String name, InputStream input, String splitStr, String charSet) {
        this.executorName = name;
        if (charSet == null || charSet.length() == 0) {
            charSet = "UTF-8";
        }
        try {
            this.sqlFileReader = new BufferedReader(new InputStreamReader(input, charSet));
            this.split = splitStr;
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)("Unsupported encode[" + charSet + "]"), (Throwable)e);
        }
    }

    public void setIstransTostoreProc(boolean istransTostoreProc) {
        this.istransTostoreProc = istransTostoreProc;
    }

    public boolean isIstransTostoreProc() {
        return this.istransTostoreProc;
    }

    @Override
    public String getProviderName() {
        return this.executorName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean nextSQL() {
        if (this.curSQLList.size() > 0 && this.curSQLIndex < this.curSQLList.size() - 1) {
            ++this.curSQLIndex;
            return true;
        }
        this.curSQLList.clear();
        this.curOrgSqlList.clear();
        StringBuffer sqlBuffer = new StringBuffer();
        String sql = "";
        String s = "";
        try {
            block6: while ((s = this.sqlFileReader.readLine()) != null) {
                if ((s = s.trim()).length() == 0 || s.equals("\n") || s.equals("\r\n")) continue;
                if (Character.getType(s.charAt(0)) == 16) {
                    s = s.substring(1);
                }
                if (s.length() >= 2 && s.substring(0, 2).equals("--")) continue;
                s = s + "\n";
                sqlBuffer.append(s);
                if (!s.endsWith(this.split + "\n")) continue;
                for (int i = 0; i < this.split.length(); ++i) {
                    sqlBuffer.deleteCharAt(sqlBuffer.length() - 2);
                    sql = sqlBuffer.toString();
                    if (sql.equals("\n")) {
                        sqlBuffer.delete(0, sqlBuffer.length());
                        continue;
                    }
                    sqlBuffer.delete(0, sqlBuffer.length());
                    try {
                        String[] aftertranssql = this.preprocessSQL(sql);
                        for (int trani = 0; trani < aftertranssql.length; ++trani) {
                            this.curOrgSqlList.add(sql);
                        }
                        this.curSQLList.addAll(Arrays.asList(aftertranssql));
                        continue block6;
                    }
                    catch (Throwable e) {
                        this.exceptions.add(e);
                        continue block6;
                    }
                }
            }
            if (sqlBuffer.length() > 0) {
                sql = sqlBuffer.toString();
                try {
                    String[] aftertranssql = this.preprocessSQL(sql);
                    for (int trani = 0; trani < aftertranssql.length; ++trani) {
                        this.curOrgSqlList.add(sql);
                    }
                    this.curSQLList.addAll(Arrays.asList(aftertranssql));
                }
                catch (Throwable e) {
                    this.exceptions.add(e);
                }
            }
        }
        catch (Throwable e) {
            this.exceptions.add(e);
        }
        if (this.curSQLList.size() > 0) {
            this.curSQLIndex = 0;
            return true;
        }
        return false;
    }

    @Override
    public String getSql() {
        return (String)this.curSQLList.get(this.curSQLIndex);
    }

    public void release() {
        if (this.sqlFileReader != null) {
            try {
                this.sqlFileReader.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean handleException(DBSQLException sqle) {
        this.exceptions.add(sqle);
        return this.handExceptionInternal((String)this.curSQLList.get(this.curSQLIndex), sqle);
    }

    protected boolean handExceptionInternal(String curSQL, DBSQLException sqle) {
        return true;
    }

    @Override
    public ArrayList getExceptions() {
        return this.exceptions;
    }

    public String[] preprocessSQL(String cursql) {
        return new String[]{cursql};
    }
}

