/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.patch.executeSql;

import com.kingdee.eas.hr.mvdt.patch.executeSql.AdminException;
import com.kingdee.eas.hr.mvdt.patch.executeSql.ShellFile;
import com.kingdee.eas.hr.mvdt.patch.executeSql.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class KShellFile
implements ShellFile {
    private static String LINE_FEED = System.getProperty("line.separator");
    private static Logger logger = Logger.getLogger(KShellFile.class);
    private File kshFile;
    private String fileName;
    private Properties props;

    public KShellFile(String fileName) {
        this.kshFile = new File(fileName);
        this.fileName = fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateParameter(String paraName, String value) {
        this.getParameters();
        if (value.equals(this.props.getProperty(paraName))) {
            return;
        }
        File file = this.kshFile;
        synchronized (file) {
            FileLock lock = null;
            FileOutputStream tempOut = null;
            OutputStreamWriter tempWriter = null;
            BufferedWriter tempBuffWriter = null;
            BufferedReader buffReader = null;
            BufferedWriter buffWriter = null;
            try {
                paraName = paraName.trim();
                StringBuffer strBuffer = new StringBuffer();
                FileInputStream stream = new FileInputStream(this.kshFile);
                InputStreamReader reader = new InputStreamReader(stream);
                buffReader = new BufferedReader(reader);
                String oldLine = "";
                String newLine = "";
                String pattern = "^\\s*" + paraName + "\\s*=\\s*(.*)$";
                Pattern p = Pattern.compile(pattern);
                boolean hasFound = false;
                try {
                    tempOut = new FileOutputStream(this.kshFile + ".bak");
                    tempWriter = new OutputStreamWriter(tempOut);
                    tempBuffWriter = new BufferedWriter(tempWriter);
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
                while ((oldLine = buffReader.readLine()) != null) {
                    Matcher m;
                    newLine = oldLine;
                    if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                        hasFound = true;
                        String start = m.group(0);
                        String target = m.group(1);
                        if (StringUtils.hasText(target)) {
                            int length = oldLine.indexOf(target);
                            start = oldLine.substring(0, length);
                            oldLine = newLine = start + value;
                        } else {
                            oldLine = newLine = start + value;
                        }
                    }
                    oldLine = oldLine + LINE_FEED;
                    strBuffer.append(oldLine);
                    try {
                        tempBuffWriter.write(oldLine);
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                }
                if (!hasFound) {
                    strBuffer.append(paraName + "=" + value + "\n");
                    strBuffer.append("export " + paraName + "\n");
                    try {
                        tempBuffWriter.write(paraName + "=" + value + "\n");
                        tempBuffWriter.write("export " + paraName + "\n");
                    }
                    catch (Exception ex) {
                        logger.error((Object)"", (Throwable)ex);
                    }
                }
                try {
                    tempBuffWriter.flush();
                }
                catch (Exception ex) {
                    logger.error((Object)"", (Throwable)ex);
                }
                FileOutputStream out = new FileOutputStream(this.kshFile);
                lock = out.getChannel().tryLock();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                buffWriter = new BufferedWriter(writer);
                buffWriter.write(strBuffer.toString());
                buffWriter.flush();
                if (this.props != null) {
                    this.props.setProperty(paraName, value);
                }
            }
            catch (Exception e) {
                throw new AdminException("Update shell file [" + this.fileName + "]  paraName [" + paraName + "] failed!", e);
            }
            finally {
                try {
                    if (buffReader != null) {
                        buffReader.close();
                    }
                    if (lock != null) {
                        lock.release();
                    }
                    if (buffWriter != null) {
                        buffWriter.close();
                    }
                    if (tempBuffWriter != null) {
                        tempBuffWriter.close();
                    }
                    if (tempWriter != null) {
                        tempWriter.close();
                    }
                    if (tempOut != null) {
                        tempOut.close();
                    }
                    if ("true".equalsIgnoreCase(System.getProperty("renamesetserverenv", "false"))) {
                        if (this.kshFile.delete()) {
                            if (!new File(this.kshFile + ".bak").renameTo(this.kshFile)) {
                                logger.info((Object)("Rename file [" + this.kshFile + ".bak] failed"));
                            }
                        } else {
                            logger.info((Object)("Delete file [" + this.kshFile + "] failed"));
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public String getParameter(String paraName, String defaultValue) {
        Properties p = this.getParameters();
        return p.getProperty(paraName, defaultValue);
    }

    @Override
    public String getParameterWithoutEmpty(String paramName, String defaultValue) {
        String value = this.getParameter(paramName, defaultValue);
        if (StringUtils.hasText(value)) {
            return value;
        }
        return defaultValue;
    }

    @Override
    public File getFile() {
        return this.kshFile;
    }

    @Override
    public Properties getParameters() {
        if (this.props == null) {
            this.loadProperties();
        }
        return this.props;
    }

    private void loadProperties() {
        try {
            String value;
            Properties temp = new Properties();
            FileInputStream stream = new FileInputStream(this.kshFile);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffReader = new BufferedReader(reader);
            String oldLine = "";
            String name = "";
            ArrayList<String> nameList = new ArrayList<String>();
            while ((oldLine = buffReader.readLine()) != null) {
                int index;
                if (oldLine.trim().length() == 0 || oldLine.startsWith("#") || (index = oldLine.indexOf("=")) <= 0 || (name = oldLine.substring(0, index)).trim().indexOf(" ") != -1) continue;
                nameList.add(name.trim());
                value = oldLine.substring(index + 1).trim();
                value = value.replace('\\', '/');
                value = value.replaceAll("\"\"", "%Double_Quotation_Marks%");
                value = value.replaceAll("\"", "");
                value = value.replaceAll("%Double_Quotation_Marks%", "\"");
                temp.setProperty(name.trim(), value);
            }
            for (int i = 0; i < nameList.size(); ++i) {
                name = (String)nameList.get(i);
                value = temp.getProperty(name);
                for (int k = i + 1; k < nameList.size(); ++k) {
                    String pName = (String)nameList.get(k);
                    String pValue = temp.getProperty(pName);
                    if (value.indexOf("$" + name) >= 0) continue;
                    pValue = pValue.replaceAll("\\$" + name, value);
                    temp.setProperty(pName, pValue);
                }
            }
            stream.close();
            this.props = temp;
        }
        catch (Exception e) {
            throw new AdminException("Load config from shell [" + this.fileName + "] failed!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeParameter(String paraName) {
        File file = this.kshFile;
        synchronized (file) {
            FileLock lock = null;
            try {
                paraName = paraName.trim();
                StringBuffer strBuffer = new StringBuffer();
                FileInputStream stream = new FileInputStream(this.kshFile);
                InputStreamReader reader = new InputStreamReader(stream);
                BufferedReader buffReader = new BufferedReader(reader);
                String oldLine = "";
                String newLine = "";
                String pattern = "^\\s*" + paraName + "\\s*=\\s*(.*)$";
                Pattern p = Pattern.compile(pattern);
                while ((oldLine = buffReader.readLine()) != null) {
                    Matcher m;
                    newLine = oldLine;
                    if (oldLine.trim().length() != 0 && (m = p.matcher(oldLine)).find()) {
                        oldLine = "# " + newLine;
                    }
                    oldLine = oldLine + LINE_FEED;
                    strBuffer.append(oldLine);
                }
                FileOutputStream out = new FileOutputStream(this.kshFile);
                lock = out.getChannel().tryLock();
                OutputStreamWriter writer = new OutputStreamWriter(out);
                BufferedWriter buffWriter = new BufferedWriter(writer);
                buffWriter.write(strBuffer.toString());
                buffWriter.flush();
                buffWriter.close();
                if (this.props != null) {
                    this.props.remove(paraName);
                }
            }
            catch (Exception e) {
                throw new AdminException("Remove paraName[" + paraName + "] from shell [" + this.fileName + "] failed!", e);
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

