/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.mvdt.handler.UserMoveHandler;
import com.kingdee.eas.hr.mvdt.util.ExcelUtil;
import com.kingdee.eas.hr.mvdt.util.SHRDbConnectionTool;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.ui.ModelMap;
import org.springframework.util.ReflectionUtils;

public class ExcelExportDataHelpUtil {
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";

    public static String exportAdminChangeInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            Map<String, Object[]> adminItemMap = ExcelExportDataHelpUtil.getAdminItemMap();
            String path = ExcelExportDataHelpUtil.exportAdminTemplate(adminItemMap, request, response, modelMap, shrConn, ctx);
            ExcelUtil.setExportExcelHead(response, path, "\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u7ec4\u7ec7");
            shrConn.close();
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object[]> getAdminItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u7ec4\u7ec7\u7f16\u7801", new Object[]{"shrNumber"});
        itemMap.put("shr\u7ec4\u7ec7\u540d\u79f0", new Object[]{"shrName"});
        itemMap.put("shr\u7ec4\u7ec7\u957f\u540d\u79f0", new Object[]{"shrLongNumber"});
        itemMap.put("shr\u7ec4\u7ec7\u957f\u7f16\u7801", new Object[]{"shrDisplayName"});
        itemMap.put("shr\u662f\u5426\u5c01\u5b58", new Object[]{"shrIsSealUp"});
        itemMap.put("shr\u7ec4\u7ec7ID", new Object[]{"shrId"});
        itemMap.put("eas\u7ec4\u7ec7\u7f16\u7801", new Object[]{"easNumber"});
        itemMap.put("eas\u7ec4\u7ec7\u540d\u79f0", new Object[]{"easName"});
        itemMap.put("eas\u7ec4\u7ec7\u957f\u540d\u79f0", new Object[]{"easLongNumber"});
        itemMap.put("eas\u7ec4\u7ec7\u957f\u7f16\u7801", new Object[]{"easDisplayName"});
        itemMap.put("eas\u662f\u5426\u5c01\u5b58", new Object[]{"easIsSealUp"});
        itemMap.put("eas\u6240\u5c5e\u7ba1\u7406\u5355\u5143CU", new Object[]{"easControlUnitId"});
        itemMap.put("eas\u7ec4\u7ec7ID", new Object[]{"easId"});
        itemMap.put("all\u662f\u5426\u5339\u914d", new Object[]{"isMatch"});
        itemMap.put("all\u5c01\u5b58\u72b6\u6001\u4e00\u81f4", new Object[]{"sealedState"});
        itemMap.put("all\u7ec4\u7ec7\u957f\u540d\u79f0\u4e00\u81f4", new Object[]{"displayNameIsSame"});
        itemMap.put("all\u7ec4\u7ec7\u7f16\u7801\u4e00\u81f4", new Object[]{"numberIsSame"});
        itemMap.put("all\u7f16\u7801\u91cd\u590d", new Object[]{"numberRepeat"});
        itemMap.put("all\u5339\u914d\u89c4\u5219", new Object[]{"mapMethod"});
        return itemMap;
    }

    public static String exportAdminTemplate(Map<String, Object[]> adminItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Connection shrConn, Context ctx) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet adminSheet = wb.createSheet("\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u7ec4\u7ec7");
        HSSFRow adminRow = null;
        Cell adminCell = null;
        adminRow = adminSheet.createRow(0);
        adminCell = adminRow.createCell(0);
        HSSFFont redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        redFont.setFontHeightInPoints((short)12);
        HSSFFont blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.index);
        blackFont.setFontHeightInPoints((short)12);
        StringBuffer sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u7ec4\u7ec7\u957f\u540d\u79f0\u8fdb\u884c\u5339\u914d\uff0c\u4ee5s-HR\u6570\u636e\u4e3a\u57fa\u51c6\u751f\u6210\u8fd9\u5f20\u5bf9\u6bd4\u8868\uff1b").append("\n").append("\u8bf7\u68c0\u67e5s-HR\u4e2d\u65e0\u5339\u914d\u7684\u7ec4\u7ec7\uff0c\u82e5EAS\u4e2d\u5b58\u5728\u8bf7\u5c06\u7ec4\u7ec7\u8c03\u6574\u6b63\u786e\u540e\u518d\u91cd\u65b0\u667a\u80fd\u68c0\u67e5\u5e76\u786e\u8ba4\uff1b\u82e5EAS\u4e2d\u786e\u5b9e\u4e0d\u5b58\u5728\u4e14EAS\u662f\u5355CU\uff0c\u53ef\u786e\u8ba4\u540e\u7531\u7cfb\u7edf\u81ea\u52a8\u8fc1\u79fb\uff1b\u82e5EAS\u662f\u591aCU\uff0c\u5219\u5fc5\u987b\u5728EAS\u4e2d\u7ef4\u62a4\u76f8\u540c\u7684\u7ec4\u7ec7\uff08\u7ec4\u7ec7\u957f\u540d\u79f0\u76f8\u540c\uff09\u540e\u518d\u91cd\u65b0\u8fdb\u884c\u667a\u80fd\u68c0\u67e5\u5e76\u786e\u8ba4\u3002").append("\n").append("1\u3001\u5f53EAS\u4e2d\u6709\u591a\u4e2a\u7ba1\u7406\u5355\u5143\u65f6\uff0c\u5fc5\u987b\u5148\u5728EAS\u521b\u5efa\u597d\u6240\u6709\u5f85\u8fc1\u79fb\u7684\u7ec4\u7ec7\uff0c\u957f\u540d\u79f0\u9700\u4e00\u81f4\uff1b").append("\n").append("2\u3001\u5f53EAS\u4e2d\u53ea\u6709\u4e00\u4e2a\u7ba1\u7406\u5355\u5143\u65f6\uff0c\u82e5\u65e0\u9700\u5efa\u7acb\u591a\u4e2a\u7ba1\u7406\u5355\u5143\uff0c\u5219s-HR\u4e2d\u65b0\u589e\u7684\u7ec4\u7ec7\u53ef\u4ee5\u7531\u7cfb\u7edf\u81ea\u52a8\u8fc1\u79fb\uff0c\u8fc1\u79fb\u540e\u9ed8\u8ba4\u90fd\u5c5e\u4e8e\u8fd9\u4e2a\u7ba1\u7406\u5355\u5143\uff0c\u4f46\u7ec4\u7ec7\u7f16\u7801\u9700\u4e0d\u4e0eEAS\u4e2d\u7684\u7ec4\u7ec7\u7f16\u7801\u91cd\u590d\uff1b").append("\n").append("3\u3001\u8fc1\u79fb\u540e\u4fdd\u7559EAS\u4e2d\u7ec4\u7ec7\u7f16\u7801\u3001\u6240\u5c5eCU\uff1b\u5339\u914d\u6570\u636e\u4e2d\u82e5\u884c\u653f\u7ec4\u7ec7\u5c01\u5b58\u72b6\u6001\u82e5\u4e0d\u4e00\u81f4\uff0c\u5219\u4fdd\u7559\u542f\u7528\u72b6\u6001\uff08\u8bf7\u5c3d\u91cf\u4fdd\u8bc1\u4e24\u8fb9\u6570\u636e\u5e93\u4e2d\u5339\u914d\u6570\u636e\u7684\u5c01\u5b58\u72b6\u6001\u4e00\u81f4\uff09\uff1b").append("\n").append("4\u3001\u8bf7\u8ba4\u771f\u68c0\u67e5EAS\u548cs-HR\u7ec4\u7ec7\u6570\u636e\u5bf9\u6bd4\u8868\uff0c\u4e0d\u5141\u8bb8\u5b58\u5728\u7f16\u7801\u91cd\u590d\u6807\u8bb0\u4e3a\u662f\u7684\u6570\u636e\uff1b").append("\n").append("5\u3001\u8bf7\u5c3d\u91cf\u907f\u514d\u884c\u653f\u7ec4\u7ec7\u5c01\u5b58\u72b6\u6001\u4e0d\u4e00\u81f4\u7684\u6570\u636e\uff0c\u5982\u4e0d\u4e00\u81f4\uff0c\u4fdd\u7559\u542f\u7528\u7684\u72b6\u6001");
        HSSFRichTextString richString = new HSSFRichTextString(sb.toString());
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(294, 336, (Font)redFont);
        richString.applyFont(337, 416, (Font)blackFont);
        adminCell.setCellValue((RichTextString)richString);
        adminRow.setHeight((short)2600);
        adminSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, adminItemMap.size() - 1));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 12));
        adminRow = adminSheet.createRow(1);
        for (int i = 0; i < 16; ++i) {
            adminCell = adminRow.createCell(i);
            adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        adminRow.setHeight((short)400);
        adminCell = adminRow.createCell(0);
        adminCell.setCellValue("s-HR");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminCell = adminRow.createCell(6);
        adminCell.setCellValue("EAS");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminCell = adminRow.createCell(13);
        adminCell.setCellValue("\u662f\u5426\u5339\u914d");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 13, 13));
        adminCell = adminRow.createCell(14);
        adminCell.setCellValue("\u5c01\u5b58\u72b6\u6001\u4e00\u81f4");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 14, 14));
        adminCell = adminRow.createCell(15);
        adminCell.setCellValue("\u7ec4\u7ec7\u957f\u540d\u79f0\u4e00\u81f4");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 15, 15));
        adminCell = adminRow.createCell(16);
        adminCell.setCellValue("\u7ec4\u7ec7\u7f16\u7801\u4e00\u81f4");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 16, 16));
        adminCell = adminRow.createCell(17);
        adminCell.setCellValue("\u7f16\u7801\u91cd\u590d");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 17, 17));
        adminCell = adminRow.createCell(18);
        adminCell.setCellValue("\u5339\u914d\u89c4\u5219");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 18, 18));
        adminRow = adminSheet.createRow(2);
        adminRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            adminCell = adminRow.createCell(itemCount++);
            adminCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u7ec4\u7ec7\u957f\u540d\u79f0") || itemName.substring(3).equals("\u662f\u5426\u5c01\u5b58")) {
                adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (int i = 0; i < itemCount; ++i) {
            adminSheet.setColumnWidth(i, 6000);
        }
        Statement state = null;
        Object rs = null;
        state = shrConn.createStatement();
        List<Object> resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultAdminList(shrConn, ctx);
        for (int i = 0; i < resultList.size(); ++i) {
            adminRow = adminSheet.createRow(3 + i);
            Map easMap = new HashMap();
            easMap = (Map)resultList.get(i);
            adminCell = adminRow.createCell(0);
            adminCell.setCellValue((String)easMap.get("shrNumber"));
            adminCell = adminRow.createCell(1);
            adminCell.setCellValue((String)easMap.get("shrName"));
            adminCell = adminRow.createCell(2);
            adminCell.setCellValue((String)easMap.get("shrDisplayName"));
            adminCell = adminRow.createCell(3);
            adminCell.setCellValue((String)easMap.get("shrLongNumber"));
            adminCell = adminRow.createCell(4);
            adminCell.setCellValue((String)easMap.get("shrIsSealUp"));
            adminCell = adminRow.createCell(5);
            adminCell.setCellValue((String)easMap.get("shrId"));
            adminCell = adminRow.createCell(6);
            adminCell.setCellValue((String)easMap.get("easNumber"));
            adminCell = adminRow.createCell(7);
            adminCell.setCellValue((String)easMap.get("easName"));
            adminCell = adminRow.createCell(8);
            adminCell.setCellValue((String)easMap.get("easDisplayName"));
            adminCell = adminRow.createCell(9);
            adminCell.setCellValue((String)easMap.get("easLongNumber"));
            adminCell = adminRow.createCell(10);
            adminCell.setCellValue((String)easMap.get("easIsSealUp"));
            adminCell = adminRow.createCell(11);
            adminCell.setCellValue((String)easMap.get("easCuAdminName"));
            adminCell = adminRow.createCell(12);
            adminCell.setCellValue((String)easMap.get("easId"));
            adminCell = adminRow.createCell(13);
            adminCell.setCellValue((String)easMap.get("isMatch"));
            adminCell = adminRow.createCell(14);
            adminCell.setCellValue((String)easMap.get("sealedState"));
            adminCell = adminRow.createCell(15);
            adminCell.setCellValue((String)easMap.get("displayNameIsSame"));
            adminCell = adminRow.createCell(16);
            adminCell.setCellValue((String)easMap.get("numberIsSame"));
            adminCell = adminRow.createCell(17);
            adminCell.setCellValue((String)easMap.get("numberRepeat"));
            adminCell = adminRow.createCell(18);
            adminCell.setCellValue((String)easMap.get("mapMethod"));
        }
        String path = TEMP_DIR + ExcelExportDataHelpUtil.getUUID() + ".xls";
        FileOutputStream out = new FileOutputStream(path);
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    public static List<Map<String, String>> getResultAdminList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "SELECT shrAdmin.FID AS shrId, shrAdmin.FNUMBER AS shrNumber, shrAdmin.FNAME_L2 AS shrName, shrAdmin.FLONGNUMBER AS shrLongnumber, shrAdmin.FDISPLAYNAME_L2 as shrDisplayname, shrCuAdmin.FDISPLAYNAME_L2 as shrCuDisplayname, case when shrAdmin.FIsSealUp = 1 then '\u662f' else '\u5426' end as shrIsSealUp, easAdmin.FID AS easId, easAdmin.FNUMBER AS easNumber, easAdmin.FNAME_L2 AS easName, easAdmin.FLONGNUMBER AS easLongnumber, easAdmin.FDISPLAYNAME_L2 as easDisplayname, easCuAdmin.FDISPLAYNAME_L2 as easCuDisplayname, case when easAdmin.FIsSealUp = 1 then '\u662f' else '\u5426' end as easIsSealUp, synMap.FMapWay as mapWay FROM T_HR_SynIdMapping synMap LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrAdmin ON synMap.FSHRID = shrAdmin.FID LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrCuAdmin ON shrAdmin.FControlUnitId = shrCuAdmin.FID LEFT JOIN T_ORG_ADMIN easAdmin ON synMap.FEASID = easAdmin.FID LEFT JOIN T_ORG_ADMIN easCuAdmin ON easAdmin.FControlUnitId = easCuAdmin.FID where synMap.FBosType = '6A6435BE' ORDER BY shrAdmin.FNUMBER";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String shrNumber = executeQuery.getString("shrNumber") == null ? "" : executeQuery.getString("shrNumber");
                String shrName = executeQuery.getString("shrName") == null ? "" : executeQuery.getString("shrName");
                String shrDisplayName = executeQuery.getString("shrDisplayname") == null ? "" : executeQuery.getString("shrDisplayname");
                String shrLongNumber = executeQuery.getString("shrLongnumber") == null ? "" : executeQuery.getString("shrLongnumber");
                String shrIsSealUp = executeQuery.getString("shrIsSealUp") == null ? "" : executeQuery.getString("shrIsSealUp");
                String shrCuAdminName = executeQuery.getString("shrCuDisplayname") == null ? "" : executeQuery.getString("shrCuDisplayname");
                String shrId = executeQuery.getString("shrId") == null ? "" : executeQuery.getString("shrId");
                String easNumber = executeQuery.getString("easNumber") == null ? "" : executeQuery.getString("easNumber");
                String easName = executeQuery.getString("easName") == null ? "" : executeQuery.getString("easName");
                String easDisplayName = executeQuery.getString("easDisplayname") == null ? "" : executeQuery.getString("easDisplayname");
                String easLongNumber = executeQuery.getString("easLongnumber") == null ? "" : executeQuery.getString("easLongnumber");
                String easIsSealUp = executeQuery.getString("easIsSealUp") == null ? "" : executeQuery.getString("easIsSealUp");
                String easCuAdminName = executeQuery.getString("easCuDisplayname") == null ? "" : executeQuery.getString("easCuDisplayname");
                String easId = executeQuery.getString("easId") == null ? "" : executeQuery.getString("easId");
                map.put("shrNumber", shrNumber);
                map.put("shrName", shrName);
                map.put("shrDisplayName", shrDisplayName);
                map.put("shrLongNumber", shrLongNumber);
                map.put("shrIsSealUp", shrIsSealUp);
                map.put("shrCuAdminName", shrCuAdminName);
                map.put("shrId", shrId);
                map.put("easNumber", easNumber);
                map.put("easName", easName);
                map.put("easDisplayName", easDisplayName);
                map.put("easLongNumber", easLongNumber);
                map.put("easIsSealUp", easIsSealUp);
                map.put("easCuAdminName", easCuAdminName);
                map.put("easId", easId);
                map.put("isMatch", "\u662f");
                if (easIsSealUp.equals(shrIsSealUp)) {
                    map.put("sealedState", "\u662f");
                } else {
                    map.put("sealedState", "\u5426");
                }
                if (easDisplayName.equals(shrDisplayName)) {
                    map.put("displayNameIsSame", "\u662f");
                } else {
                    map.put("displayNameIsSame", "\u5426");
                }
                if (easNumber.equals(shrNumber)) {
                    map.put("numberIsSame", "\u662f");
                } else {
                    map.put("numberIsSame", "\u5426");
                }
                if (executeQuery.getString("mapWay").equals("normal")) {
                    map.put("mapMethod", "\u6309\u7167\u7ec4\u7ec7\u957f\u540d\u79f0\u3001\u7f16\u7801\u5339\u914d");
                } else if (executeQuery.getString("mapWay").equals("displayName")) {
                    map.put("mapMethod", "\u6309\u7167\u7ec4\u7ec7\u957f\u540d\u79f0\u5339\u914d");
                } else if (executeQuery.getString("mapWay").equals("number")) {
                    map.put("mapMethod", "\u6309\u7167\u7ec4\u7ec7\u7f16\u7801\u5339\u914d");
                } else {
                    map.put("mapMethod", "");
                }
                resultList.add(map);
            }
            String shrOtherSql = "SELECT shrAdmin.FID AS shrId, shrAdmin.FNUMBER AS shrNumber, shrAdmin.FNAME_L2 AS shrName, shrAdmin.FLONGNUMBER AS shrLongnumber, shrAdmin.FDISPLAYNAME_L2 as shrDisplayname, shrCuAdmin.FDISPLAYNAME_L2 as shrCuDisplayname, case when shrAdmin.FIsSealUp = 1 then '\u662f' else '\u5426' end as shrIsSealUp FROM T_ORG_ADMIN_SHR_TEMP shrAdmin LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrCuAdmin ON shrAdmin.FControlUnitId = shrCuAdmin.FID where shrAdmin.fid not in (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '6A6435BE') ORDER BY shrAdmin.FNUMBER";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String shrNumber = executeQuery.getString("shrNumber") == null ? "" : executeQuery.getString("shrNumber");
                String shrName = executeQuery.getString("shrName") == null ? "" : executeQuery.getString("shrName");
                String shrDisplayName = executeQuery.getString("shrDisplayname") == null ? "" : executeQuery.getString("shrDisplayname");
                String shrLongNumber = executeQuery.getString("shrLongnumber") == null ? "" : executeQuery.getString("shrLongnumber");
                String shrIsSealUp = executeQuery.getString("shrIsSealUp") == null ? "" : executeQuery.getString("shrIsSealUp");
                String shrCuAdminName = executeQuery.getString("shrCuDisplayname") == null ? "" : executeQuery.getString("shrCuDisplayname");
                String shrId = executeQuery.getString("shrId") == null ? "" : executeQuery.getString("shrId");
                map.put("shrNumber", shrNumber);
                map.put("shrName", shrName);
                map.put("shrDisplayName", shrDisplayName);
                map.put("shrLongNumber", shrLongNumber);
                map.put("shrIsSealUp", shrIsSealUp);
                map.put("shrCuAdminName", shrCuAdminName);
                map.put("shrId", shrId);
                map.put("easNumber", "");
                map.put("easName", "");
                map.put("easDisplayName", "");
                map.put("easLongNumber", "");
                map.put("easIsSealUp", "");
                map.put("easCuAdminName", "");
                map.put("easId", "");
                String checkNumber = "SELECT * FROM T_ORG_ADMIN WHERE FNUMBER = '" + shrNumber + "'";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkNumber);
                if (executeQuery2.size() > 0) {
                    map.put("numberRepeat", "\u662f");
                } else {
                    map.put("numberRepeat", "");
                }
                map.put("mapMethod", "");
                resultList.add(map);
            }
            String easOtherSql = "SELECT  easAdmin.FID AS easId, easAdmin.FNUMBER AS easNumber, easAdmin.FNAME_L2 AS easName, easAdmin.FLONGNUMBER AS easLongnumber, easAdmin.FDISPLAYNAME_L2 as easDisplayname, easCuAdmin.FDISPLAYNAME_L2 as easCuDisplayname, case when easAdmin.FIsSealUp = 1 then '\u662f' else '\u5426' end as easIsSealUp FROM T_ORG_ADMIN easAdmin LEFT JOIN T_ORG_ADMIN easCuAdmin ON easAdmin.FControlUnitId = easCuAdmin.FID where easAdmin.fid not in (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '6A6435BE') ORDER BY easAdmin.FNUMBER";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)easOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String easNumber = executeQuery.getString("easNumber") == null ? "" : executeQuery.getString("easNumber");
                String easName = executeQuery.getString("easName") == null ? "" : executeQuery.getString("easName");
                String easDisplayName = executeQuery.getString("easDisplayname") == null ? "" : executeQuery.getString("easDisplayname");
                String easLongNumber = executeQuery.getString("easLongnumber") == null ? "" : executeQuery.getString("easLongnumber");
                String easIsSealUp = executeQuery.getString("easIsSealUp") == null ? "" : executeQuery.getString("easIsSealUp");
                String easCuAdminName = executeQuery.getString("easCuDisplayname") == null ? "" : executeQuery.getString("easCuDisplayname");
                String easId = executeQuery.getString("easId") == null ? "" : executeQuery.getString("easId");
                map.put("shrNumber", "");
                map.put("shrName", "");
                map.put("shrDisplayName", "");
                map.put("shrLongNumber", "");
                map.put("shrIsSealUp", "");
                map.put("shrCuAdminName", "");
                map.put("shrId", "");
                map.put("easNumber", easNumber);
                map.put("easName", easName);
                map.put("easDisplayName", easDisplayName);
                map.put("easLongNumber", easLongNumber);
                map.put("easIsSealUp", easIsSealUp);
                map.put("easCuAdminName", easCuAdminName);
                map.put("easId", easId);
                resultList.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static String exportPositionChangeInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            Map<String, Object[]> positionItemMap = ExcelExportDataHelpUtil.getPositionItemMap();
            Map<String, Object[]> positionItemMap2 = ExcelExportDataHelpUtil.getPositionItemMap2();
            String path = ExcelExportDataHelpUtil.exportPositionTemplate(positionItemMap, positionItemMap2, request, response, modelMap, shrConn, ctx);
            ExcelUtil.setExportExcelHead(response, path, "\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u804c\u4f4d");
            shrConn.close();
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object[]> getPositionItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u5c97\u4f4d\u7f16\u7801", new Object[]{"shrNumber"});
        itemMap.put("shr\u5c97\u4f4d\u540d\u79f0", new Object[]{"shrName"});
        itemMap.put("shr\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"shrAdminOrgUnit"});
        itemMap.put("shr\u4e0a\u7ea7\u5c97\u4f4d", new Object[]{"shrParent"});
        itemMap.put("shr\u8d1f\u8d23\u4eba\u5c97\u4f4d", new Object[]{"shrIsRespPosition"});
        itemMap.put("shr\u542f\u7528\u72b6\u6001", new Object[]{"shrState"});
        itemMap.put("eas\u804c\u4f4d\u7f16\u7801", new Object[]{"easNumber"});
        itemMap.put("eas\u804c\u4f4d\u540d\u79f0", new Object[]{"easName"});
        itemMap.put("eas\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"easAdminOrgUnit"});
        itemMap.put("eas\u4e0a\u7ea7\u804c\u4f4d", new Object[]{"easParent"});
        itemMap.put("eas\u8d1f\u8d23\u4eba\u804c\u4f4d", new Object[]{"easIsRespPosition"});
        itemMap.put("eas\u542f\u7528\u72b6\u6001", new Object[]{"easState"});
        itemMap.put("all\u662f\u5426\u5339\u914d", new Object[]{"isMatch"});
        itemMap.put("all\u804c\u4f4d\u7f16\u7801\u4e00\u81f4", new Object[]{"isPositionNumberSame"});
        itemMap.put("all\u804c\u4f4d\u540d\u79f0\u4e00\u81f4", new Object[]{"isPositionNameSame"});
        itemMap.put("all\u804c\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4e00\u81f4", new Object[]{"isPositionAdminSame"});
        itemMap.put("all\u4e0a\u7ea7\u804c\u4f4d\u4e00\u81f4", new Object[]{"isParentSame"});
        itemMap.put("all\u542f\u7528\u72b6\u6001\u4e00\u81f4", new Object[]{"isStateSame"});
        itemMap.put("all\u7f16\u7801\u91cd\u590d", new Object[]{"numberRepeat"});
        itemMap.put("all\u5339\u914d\u89c4\u5219", new Object[]{"mapMethod"});
        return itemMap;
    }

    public static Map<String, Object[]> getPositionItemMap2() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("eas\u804c\u4f4d\u7f16\u7801", new Object[]{"easNumber"});
        itemMap.put("eas\u804c\u4f4d\u540d\u79f0", new Object[]{"easName"});
        itemMap.put("eas\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"easAdminOrgUnit"});
        itemMap.put("eas\u4e0a\u7ea7\u804c\u4f4d", new Object[]{"easParent"});
        itemMap.put("eas\u8d1f\u8d23\u4eba\u804c\u4f4d", new Object[]{"easIsRespPosition"});
        return itemMap;
    }

    public static String exportPositionTemplate(Map<String, Object[]> adminItemMap, Map<String, Object[]> adminItemMap2, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Connection shrConn, Context ctx) throws Exception {
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet positionSheet = wb.createSheet("\u804c\u4f4d\u6570\u636e\u5bf9\u6bd4");
        HSSFRow positionRow = null;
        Cell positionCell = null;
        positionRow = positionSheet.createRow(0);
        positionCell = positionRow.createCell(0);
        HSSFFont redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        redFont.setFontHeightInPoints((short)12);
        HSSFFont blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.index);
        blackFont.setFontHeightInPoints((short)12);
        StringBuffer sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("1\u3001\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u5c97\u4f4d\u7f16\u7801\u5bf9\u5e94EAS\u804c\u4f4d\u7f16\u7801\u8fdb\u884c\u6620\u5c04\uff0c\u8bf7\u68c0\u67e5\u5e76\u786e\u4fdd\u804c\u4f4d\u540d\u79f0\u3001\u6240\u5c5e\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u804c\u4f4d\u5b8c\u5168\u4e00\u81f4\uff0c\u5426\u5219\u8fc1\u79fb\u540e\u53ef\u80fd\u5f71\u54cdEAS\u76f8\u5173\u529f\u80fd\uff1b").append("\n").append("2\u3001\u8fc1\u79fb\u540e\u5c06\u4fdd\u7559s-HR\u7684\u5c97\u4f4d\u7f16\u7801\u3001\u540d\u79f0\u7b49\u6240\u6709\u5c97\u4f4d\u4fe1\u606f\uff08\u6240\u5c5e\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u804c\u4f4d\uff09\u7b49\uff0c\u542f\u7528\u72b6\u6001\u4e0d\u4e00\u81f4\u7684\u4fdd\u7559\u542f\u7528\u72b6\u6001\uff1b").append("\n").append("3\u3001\u8bf7\u68c0\u67e5s-HR\u4e2d\u65e0\u6620\u5c04\u7684\u5c97\u4f4d\uff0c\u786e\u8ba4\u540e\u7531\u7cfb\u7edf\u81ea\u52a8\u65b0\u589e\u8fc1\u79fb\u3002").append("\n").append("4\u3001\u5f53\u8fc1\u79fb\u540e\u7684\u5c97\u4f4d\u7f16\u7801\u5728EAS\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u7f16\u7801\u65f6\u5c06\u65e0\u6cd5\u786e\u8ba4\u901a\u8fc7\u3002");
        HSSFRichTextString richString = new HSSFRichTextString(sb.toString());
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(30, 72, (Font)redFont);
        richString.applyFont(73, 77, (Font)blackFont);
        richString.applyFont(78, 112, (Font)redFont);
        richString.applyFont(113, 130, (Font)blackFont);
        richString.applyFont(131, 159, (Font)redFont);
        richString.applyFont(160, 192, (Font)blackFont);
        positionCell.setCellValue((RichTextString)richString);
        positionRow.setHeight((short)1600);
        positionSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, adminItemMap.size() - 1));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 11));
        positionRow = positionSheet.createRow(1);
        for (int i2 = 0; i2 < 13; ++i2) {
            positionCell = positionRow.createCell(i2);
            positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        positionRow.setHeight((short)400);
        positionCell = positionRow.createCell(0);
        positionCell.setCellValue("s-HR");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionCell = positionRow.createCell(6);
        positionCell.setCellValue("EAS");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionCell = positionRow.createCell(12);
        positionCell.setCellValue("\u662f\u5426\u5339\u914d");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 12, 12));
        positionCell = positionRow.createCell(13);
        positionCell.setCellValue("\u804c\u4f4d\u7f16\u7801\u4e00\u81f4");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 13, 13));
        positionCell = positionRow.createCell(14);
        positionCell.setCellValue("\u804c\u4f4d\u540d\u79f0\u4e00\u81f4");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 14, 14));
        positionCell = positionRow.createCell(15);
        positionCell.setCellValue("\u804c\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4e00\u81f4");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 15, 15));
        positionCell = positionRow.createCell(16);
        positionCell.setCellValue("\u4e0a\u7ea7\u804c\u4f4d\u4e00\u81f4");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 16, 16));
        positionCell = positionRow.createCell(17);
        positionCell.setCellValue("\u542f\u7528\u72b6\u6001\u4e00\u81f4");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 17, 17));
        positionCell = positionRow.createCell(18);
        positionCell.setCellValue("\u7f16\u7801\u91cd\u590d");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 18, 18));
        positionCell = positionRow.createCell(19);
        positionCell.setCellValue("\u5339\u914d\u89c4\u5219");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionSheet.addMergedRegion(new CellRangeAddress(1, 2, 19, 19));
        positionRow = positionSheet.createRow(2);
        positionRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            positionCell = positionRow.createCell(itemCount++);
            positionCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u5c97\u4f4d\u540d\u79f0") || itemName.substring(3).equals("\u6240\u5c5e\u7ec4\u7ec7") || itemName.substring(3).equals("\u4e0a\u7ea7\u5c97\u4f4d") || itemName.substring(3).equals("\u8d1f\u8d23\u4eba\u5c97\u4f4d") || itemName.substring(3).equals("\u542f\u7528\u72b6\u6001") || itemName.substring(3).equals("\u804c\u4f4d\u540d\u79f0") || itemName.substring(3).equals("\u4e0a\u7ea7\u804c\u4f4d") || itemName.substring(3).equals("\u8d1f\u8d23\u4eba\u804c\u4f4d")) {
                positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (int i3 = 0; i3 < itemCount; ++i3) {
            positionSheet.setColumnWidth(i3, 6000);
        }
        Statement state = null;
        Object rs = null;
        state = shrConn.createStatement();
        List<Object> resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultPositionList(shrConn, ctx);
        for (int i4 = 0; i4 < resultList.size(); ++i4) {
            positionRow = positionSheet.createRow(3 + i4);
            Map easMap = new HashMap();
            easMap = (Map)resultList.get(i4);
            positionCell = positionRow.createCell(0);
            positionCell.setCellValue((String)easMap.get("shrNumber"));
            positionCell = positionRow.createCell(1);
            positionCell.setCellValue((String)easMap.get("shrName"));
            positionCell = positionRow.createCell(2);
            positionCell.setCellValue((String)easMap.get("shrAdminOrgUnit"));
            positionCell = positionRow.createCell(3);
            positionCell.setCellValue((String)easMap.get("shrParent"));
            positionCell = positionRow.createCell(4);
            positionCell.setCellValue((String)easMap.get("shrIsRespPosition"));
            positionCell = positionRow.createCell(5);
            positionCell.setCellValue((String)easMap.get("shrState"));
            positionCell = positionRow.createCell(6);
            positionCell.setCellValue((String)easMap.get("easNumber"));
            positionCell = positionRow.createCell(7);
            positionCell.setCellValue((String)easMap.get("easName"));
            positionCell = positionRow.createCell(8);
            positionCell.setCellValue((String)easMap.get("easAdminOrgUnit"));
            positionCell = positionRow.createCell(9);
            positionCell.setCellValue((String)easMap.get("easParent"));
            positionCell = positionRow.createCell(10);
            positionCell.setCellValue((String)easMap.get("easIsRespPosition"));
            positionCell = positionRow.createCell(11);
            positionCell.setCellValue((String)easMap.get("easState"));
            positionCell = positionRow.createCell(12);
            positionCell.setCellValue((String)easMap.get("isMatch"));
            positionCell = positionRow.createCell(13);
            positionCell.setCellValue((String)easMap.get("isPositionNumberSame"));
            positionCell = positionRow.createCell(14);
            positionCell.setCellValue((String)easMap.get("isPositionNameSame"));
            positionCell = positionRow.createCell(15);
            positionCell.setCellValue((String)easMap.get("isPositionAdminSame"));
            positionCell = positionRow.createCell(16);
            positionCell.setCellValue((String)easMap.get("isParentSame"));
            positionCell = positionRow.createCell(17);
            positionCell.setCellValue((String)easMap.get("isStateSame"));
            positionCell = positionRow.createCell(18);
            positionCell.setCellValue((String)easMap.get("numberRepeat"));
            positionCell = positionRow.createCell(19);
            positionCell.setCellValue((String)easMap.get("mapMethod"));
        }
        HSSFSheet positionSheet2 = wb.createSheet("EAS\u5f85\u8c03\u6574\u804c\u4f4d");
        positionRow = null;
        positionCell = null;
        positionRow = positionSheet2.createRow(0);
        positionCell = positionRow.createCell(0);
        sb = new StringBuffer("\u4ee5\u4e0b\u6570\u636e\u662fs-HR\u8fc1\u79fb\u7684\u7ec4\u7ec7\u4e0bEAS\u4e2d\u5b58\u5728\u4f46\u672a\u4e0es-HR\u4e2d\u7684\u5c97\u4f4d\u8fdb\u884c\u5339\u914d\u7684\u6570\u636e\uff0c\u8bf7\u624b\u52a8\u8c03\u6574\uff0c\u8bf7\u6839\u636e\u5b9e\u9645\u60c5\u51b5\u5728s-HR\u65b0\u589e\u76f8\u540c\u804c\u4f4d\u6216\u5728EAS\u4e2d\u7981\u7528\u3002");
        richString = new HSSFRichTextString(sb.toString());
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(0, 73, (Font)redFont);
        positionCell.setCellValue((RichTextString)richString);
        positionRow.setHeight((short)800);
        positionSheet2.addMergedRegion(new CellRangeAddress(0, 0, 0, adminItemMap2.size() - 1));
        positionSheet2.addMergedRegion(new CellRangeAddress(1, 1, 0, 4));
        positionRow = positionSheet2.createRow(1);
        for (int i5 = 0; i5 < 5; ++i5) {
            positionCell = positionRow.createCell(i5);
            positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        positionRow.setHeight((short)400);
        positionCell = positionRow.createCell(0);
        positionCell.setCellValue("EAS");
        positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        positionRow = positionSheet2.createRow(2);
        positionRow.setHeight((short)400);
        itemCount = 0;
        for (String itemName : adminItemMap2.keySet()) {
            positionCell = positionRow.createCell(itemCount++);
            positionCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u5c97\u4f4d\u540d\u79f0") || itemName.substring(3).equals("\u6240\u5c5e\u7ec4\u7ec7") || itemName.substring(3).equals("\u4e0a\u7ea7\u5c97\u4f4d") || itemName.substring(3).equals("\u8d1f\u8d23\u4eba\u5c97\u4f4d") || itemName.substring(3).equals("\u542f\u7528\u72b6\u6001") || itemName.substring(3).equals("\u804c\u4f4d\u540d\u79f0") || itemName.substring(3).equals("\u4e0a\u7ea7\u804c\u4f4d") || itemName.substring(3).equals("\u8d1f\u8d23\u4eba\u804c\u4f4d")) {
                positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            positionCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (i = 0; i < itemCount; ++i) {
            positionSheet2.setColumnWidth(i, 6000);
        }
        resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultPositionList2(shrConn, ctx);
        for (i = 0; i < resultList.size(); ++i) {
            positionRow = positionSheet2.createRow(3 + i);
            Map easMap = new HashMap();
            easMap = (Map)resultList.get(i);
            positionCell = positionRow.createCell(0);
            positionCell.setCellValue((String)easMap.get("easNumber"));
            positionCell = positionRow.createCell(1);
            positionCell.setCellValue((String)easMap.get("easName"));
            positionCell = positionRow.createCell(2);
            positionCell.setCellValue((String)easMap.get("easAdminOrgUnit"));
            positionCell = positionRow.createCell(3);
            positionCell.setCellValue((String)easMap.get("easParent"));
            positionCell = positionRow.createCell(4);
            positionCell.setCellValue((String)easMap.get("easIsRespPosition"));
        }
        String path = TEMP_DIR + ExcelExportDataHelpUtil.getUUID() + ".xls";
        FileOutputStream out = new FileOutputStream(path);
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    public static List<Map<String, String>> getResultPositionList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "SELECT shrPosition.FNUMBER AS shrPositionNumber,shrPosition.FID AS shrPositionId, shrPosition.FNAME_L2 AS shrPositionName, shrAdmin.FID AS shrAdminId, shrAdmin.FDISPLAYNAME_L2 AS shrAdminDisplayName, shrParent.FID AS shrParentId, shrParent.FNAME_L2 AS shrParentName, shrParentAdmin.FDISPLAYNAME_L2 as shrParentAdminName, case when shrPosition.FIsRespPosition = 1 then '\u662f' else '\u5426' end as shrIsRespPosition, case when shrPosition.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as shrDeletedStatus, easPosition.FNUMBER AS easPositionNumber,easPosition.FID AS easPositionId, easPosition.FNAME_L2 AS easPositionName, easAdmin.FID AS easAdminId, easAdmin.FDISPLAYNAME_L2 AS easAdminDisplayName, easParent.FID AS easParentId, easParent.FNAME_L2 AS easParentName, easParentAdmin.FDISPLAYNAME_L2 as easParentAdminName, case when easPosition.FIsRespPosition = 1 then '\u662f' else '\u5426' end as easIsRespPosition, case when easPosition.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as easDeletedStatus, synMap.FMapWay as mapWay FROM T_HR_SynIdMapping synMap LEFT JOIN T_ORG_POSITION_SHR_TEMP shrPosition ON synMap.fshrid = shrPosition.fid LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrAdmin ON shrPosition.FAdminOrgUnitID = shrAdmin.FID LEFT JOIN T_ORG_POSITION_SHR_TEMP shrParent ON shrPosition.FParentID = shrParent.FID  LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrParentAdmin ON shrParent.FAdminOrgUnitID = shrParentAdmin.FID  LEFT JOIN T_ORG_POSITION easPosition ON synMap.feasid = easPosition.fid LEFT JOIN T_ORG_ADMIN easAdmin ON easPosition.FAdminOrgUnitID = easAdmin.FID LEFT JOIN T_ORG_POSITION easParent ON easPosition.FParentID = easParent.FID  LEFT JOIN T_ORG_ADMIN easParentAdmin ON easParent.FAdminOrgUnitID = easParentAdmin.FID where FBosType = '74AE612E'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String shrNumber = executeQuery.getString("shrPositionNumber") == null ? "" : executeQuery.getString("shrPositionNumber");
                String shrName = executeQuery.getString("shrPositionName") == null ? "" : executeQuery.getString("shrPositionName");
                String shrAdminId = executeQuery.getString("shrAdminId") == null ? "" : executeQuery.getString("shrAdminId");
                String shrAdminOrgUnit = executeQuery.getString("shrAdminDisplayName") == null ? "" : executeQuery.getString("shrAdminDisplayName");
                String shrParentId = executeQuery.getString("shrParentId") == null ? "" : executeQuery.getString("shrParentId");
                String shrParent = executeQuery.getString("shrParentName") == null ? "" : executeQuery.getString("shrParentName");
                String shrIsRespPosition = executeQuery.getString("shrIsRespPosition") == null ? "" : executeQuery.getString("shrIsRespPosition");
                String shrPpAdminDisplayName = executeQuery.getString("shrParentAdminName") == null ? "" : executeQuery.getString("shrParentAdminName");
                String shrState = executeQuery.getString("shrDeletedStatus") == null ? "" : executeQuery.getString("shrDeletedStatus");
                String shrId = executeQuery.getString("shrPositionId") == null ? "" : executeQuery.getString("shrPositionId");
                String easNumber = executeQuery.getString("easPositionNumber") == null ? "" : executeQuery.getString("easPositionNumber");
                String easName = executeQuery.getString("easPositionName") == null ? "" : executeQuery.getString("easPositionName");
                String easAdminId = executeQuery.getString("easAdminId") == null ? "" : executeQuery.getString("easAdminId");
                String easAdminOrgUnit = executeQuery.getString("easAdminDisplayName") == null ? "" : executeQuery.getString("easAdminDisplayName");
                String easParentId = executeQuery.getString("easParentId") == null ? "" : executeQuery.getString("easParentId");
                String easParent = executeQuery.getString("easParentName") == null ? "" : executeQuery.getString("easParentName");
                String easIsRespPosition = executeQuery.getString("easIsRespPosition") == null ? "" : executeQuery.getString("easIsRespPosition");
                String easPpAdminDisplayName = executeQuery.getString("easParentAdminName") == null ? "" : executeQuery.getString("easParentAdminName");
                String easState = executeQuery.getString("easDeletedStatus") == null ? "" : executeQuery.getString("easDeletedStatus");
                String easId = executeQuery.getString("easPositionId") == null ? "" : executeQuery.getString("easPositionId");
                map.put("shrNumber", shrNumber);
                map.put("shrName", shrName);
                map.put("shrAdminId", shrAdminId);
                map.put("shrAdminOrgUnit", shrAdminOrgUnit);
                map.put("shrParentId", shrParentId);
                map.put("shrParent", shrParent);
                map.put("shrIsRespPosition", shrIsRespPosition);
                map.put("shrPpAdminDisplayName", shrPpAdminDisplayName);
                map.put("shrState", shrState);
                map.put("shrId", shrId);
                map.put("easNumber", easNumber);
                map.put("easName", easName);
                map.put("easAdminId", easAdminId);
                map.put("easAdminOrgUnit", easAdminOrgUnit);
                map.put("easParentId", easParentId);
                map.put("easParent", easParent);
                map.put("easIsRespPosition", easIsRespPosition);
                map.put("easPpAdminDisplayName", easPpAdminDisplayName);
                map.put("easState", easState);
                map.put("easId", easId);
                map.put("isMatch", "\u662f");
                if (shrNumber.equals(easNumber)) {
                    map.put("isPositionNumberSame", "\u662f");
                } else {
                    map.put("isPositionNumberSame", "\u5426");
                }
                if (shrName.equals(easName)) {
                    map.put("isPositionNameSame", "\u662f");
                } else {
                    map.put("isPositionNameSame", "\u5426");
                }
                if (shrAdminOrgUnit.equals(easAdminOrgUnit)) {
                    map.put("isPositionAdminSame", "\u662f");
                } else {
                    map.put("isPositionAdminSame", "\u5426");
                }
                if (shrParent.equals(easParent) && shrPpAdminDisplayName.equals(easPpAdminDisplayName)) {
                    map.put("isParentSame", "\u662f");
                } else {
                    map.put("isParentSame", "\u5426");
                }
                if (easState.equals(shrState)) {
                    map.put("isStateSame", "\u662f");
                } else {
                    map.put("isStateSame", "\u5426");
                }
                if (executeQuery.getString("mapWay").equals("normal")) {
                    map.put("mapMethod", "\u6309\u7167\u5c97\u4f4d\u540d\u79f0\u3001\u6240\u5c5e\u7ec4\u7ec7\u3001\u4e0a\u7ea7\u5c97\u4f4d\u3001\u4e0a\u7ea7\u5c97\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u5339\u914d");
                } else if (executeQuery.getString("mapWay").equals("number")) {
                    map.put("mapMethod", "\u6309\u7167\u5c97\u4f4d\u7f16\u7801\u5339\u914d");
                } else {
                    map.put("mapMethod", "");
                }
                resultList.add(map);
            }
            String shrOtherSql = "SELECT shrPosition.FNUMBER AS shrPositionNumber,shrPosition.FID AS shrPositionId, shrPosition.FNAME_L2 AS shrPositionName, shrAdmin.FID AS shrAdminId, shrAdmin.FDISPLAYNAME_L2 AS shrAdminDisplayName, shrParent.FID AS shrParentId, shrParent.FNAME_L2 AS shrParentName, shrParentAdmin.FDISPLAYNAME_L2 as shrParentAdminName, case when shrPosition.FIsRespPosition = 1 then '\u662f' else '\u5426' end as shrIsRespPosition, case when shrPosition.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as shrDeletedStatus FROM T_ORG_POSITION_SHR_TEMP shrPosition LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrAdmin ON shrPosition.FAdminOrgUnitID = shrAdmin.FID LEFT JOIN T_ORG_POSITION_SHR_TEMP shrParent ON shrPosition.FParentID = shrParent.FID  LEFT JOIN T_ORG_ADMIN_SHR_TEMP shrParentAdmin ON shrParent.FAdminOrgUnitID = shrParentAdmin.FID  where shrPosition.fid not in (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '74AE612E')";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String shrNumber = executeQuery.getString("shrPositionNumber") == null ? "" : executeQuery.getString("shrPositionNumber");
                String shrName = executeQuery.getString("shrPositionName") == null ? "" : executeQuery.getString("shrPositionName");
                String shrAdminId = executeQuery.getString("shrAdminId") == null ? "" : executeQuery.getString("shrAdminId");
                String shrAdminOrgUnit = executeQuery.getString("shrAdminDisplayName") == null ? "" : executeQuery.getString("shrAdminDisplayName");
                String shrParentId = executeQuery.getString("shrParentId") == null ? "" : executeQuery.getString("shrParentId");
                String shrParent = executeQuery.getString("shrParentName") == null ? "" : executeQuery.getString("shrParentName");
                String shrIsRespPosition = executeQuery.getString("shrIsRespPosition") == null ? "" : executeQuery.getString("shrIsRespPosition");
                String shrPpAdminDisplayName = executeQuery.getString("shrParentAdminName") == null ? "" : executeQuery.getString("shrParentAdminName");
                String shrState = executeQuery.getString("shrDeletedStatus") == null ? "" : executeQuery.getString("shrDeletedStatus");
                String shrId = executeQuery.getString("shrPositionId") == null ? "" : executeQuery.getString("shrPositionId");
                map.put("shrNumber", shrNumber);
                map.put("shrName", shrName);
                map.put("shrAdminId", shrAdminId);
                map.put("shrAdminOrgUnit", shrAdminOrgUnit);
                map.put("shrParentId", shrParentId);
                map.put("shrParent", shrParent);
                map.put("shrIsRespPosition", shrIsRespPosition);
                map.put("shrPpAdminDisplayName", shrPpAdminDisplayName);
                map.put("shrState", shrState);
                map.put("shrId", shrId);
                map.put("easNumber", "");
                map.put("easName", "");
                map.put("easAdminId", "");
                map.put("easAdminOrgUnit", "");
                map.put("easParentId", "");
                map.put("easParent", "");
                map.put("easIsRespPosition", "");
                map.put("easPpAdminDisplayName", "");
                map.put("easState", "");
                map.put("easId", "");
                String checkNumber = "SELECT * FROM T_ORG_POSITION WHERE FNUMBER = '" + shrNumber + "'";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkNumber);
                if (executeQuery2.size() > 0) {
                    map.put("numberRepeat", "\u662f");
                } else {
                    map.put("numberRepeat", "");
                }
                map.put("mapMethod", "");
                resultList.add(map);
            }
            String easOtherSql = "SELECT easPosition.FNUMBER AS easPositionNumber,easPosition.FID AS easPositionId, easPosition.FNAME_L2 AS easPositionName, easAdmin.FID AS easAdminId, easAdmin.FDISPLAYNAME_L2 AS easAdminDisplayName, easParent.FID AS easParentId, easParent.FNAME_L2 AS easParentName, easParentAdmin.FDISPLAYNAME_L2 as easParentAdminName, case when easPosition.FIsRespPosition = 1 then '\u662f' else '\u5426' end as easIsRespPosition, case when easPosition.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as easDeletedStatus FROM T_ORG_POSITION easPosition LEFT JOIN T_ORG_ADMIN easAdmin ON easPosition.FAdminOrgUnitID = easAdmin.FID LEFT JOIN T_ORG_POSITION easParent ON easPosition.FParentID = easParent.FID  LEFT JOIN T_ORG_ADMIN easParentAdmin ON easParent.FAdminOrgUnitID = easParentAdmin.FID where easPosition.fid not in (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '74AE612E')";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)easOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String easNumber = executeQuery.getString("easPositionNumber") == null ? "" : executeQuery.getString("easPositionNumber");
                String easName = executeQuery.getString("easPositionName") == null ? "" : executeQuery.getString("easPositionName");
                String easAdminId = executeQuery.getString("easAdminId") == null ? "" : executeQuery.getString("easAdminId");
                String easAdminOrgUnit = executeQuery.getString("easAdminDisplayName") == null ? "" : executeQuery.getString("easAdminDisplayName");
                String easParentId = executeQuery.getString("easParentId") == null ? "" : executeQuery.getString("easParentId");
                String easParent = executeQuery.getString("easParentName") == null ? "" : executeQuery.getString("easParentName");
                String easIsRespPosition = executeQuery.getString("easIsRespPosition") == null ? "" : executeQuery.getString("easIsRespPosition");
                String easPpAdminDisplayName = executeQuery.getString("easParentAdminName") == null ? "" : executeQuery.getString("easParentAdminName");
                String easState = executeQuery.getString("easDeletedStatus") == null ? "" : executeQuery.getString("easDeletedStatus");
                String easId = executeQuery.getString("easPositionId") == null ? "" : executeQuery.getString("easPositionId");
                map.put("shrNumber", "");
                map.put("shrName", "");
                map.put("shrAdminId", "");
                map.put("shrAdminOrgUnit", "");
                map.put("shrParentId", "");
                map.put("shrParent", "");
                map.put("shrIsRespPosition", "");
                map.put("shrPpAdminDisplayName", "");
                map.put("shrState", "");
                map.put("shrId", "");
                map.put("easNumber", easNumber);
                map.put("easName", easName);
                map.put("easAdminId", easAdminId);
                map.put("easAdminOrgUnit", easAdminOrgUnit);
                map.put("easParentId", easParentId);
                map.put("easParent", easParent);
                map.put("easIsRespPosition", easIsRespPosition);
                map.put("easPpAdminDisplayName", easPpAdminDisplayName);
                map.put("easState", easState);
                map.put("easId", easId);
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getResultPositionList2(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> easAdminResultList = new ArrayList<Map<String, String>>();
        try {
            String shrNoMappingId = "SELECT FID FROM T_ORG_POSITION_SHR_TEMP WHERE FID NOT IN (SELECT FID FROM T_ORG_POSITION_EAS_TEMP)";
            String sql = "SELECT FEASID,FSHRID FROM T_HR_SynIdMapping WHERE FBosType = '6A6435BE' AND FEASID IN (SELECT FID FROM T_ORG_ADMIN_EAS_TEMP)";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String easAdminId = executeQuery.getString("FEASID");
                String getPositionSql = "select position.FID AS FID,position.FNUMBER as positionNumber,position.FNAME_L2 as positionName,adminOrg.FNAME_L2 as adminName,parentPosition.FNAME_L2 as parentPositionName, case when position.FIsRespPosition = 1 then '\u662f' else '\u5426' end as FIsRespPosition, case when position.FDeletedStatus = 1 then '\u542f\u7528' else '\u7981\u7528' end as FDeletedStatus from T_ORG_Position position left join T_ORG_ADMIN adminOrg ON position.FAdminOrgUnitID = adminOrg.FID left join T_ORG_Position  parentPosition ON position.FParentID = parentPosition.FID WHERE position.FAdminOrgUnitID = '" + easAdminId + "' AND position.FDeletedStatus = 1 AND position.FID not in (" + shrNoMappingId + ") order by position.FNUMBER";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)getPositionSql);
                while (executeQuery2.next()) {
                    String positionId = executeQuery2.getString("FID");
                    String positionNumber = executeQuery2.getString("positionNumber");
                    String positionName = executeQuery2.getString("positionName");
                    String adminName = executeQuery2.getString("adminName");
                    String parentPositionName = executeQuery2.getString("parentPositionName");
                    String isRespPosition = executeQuery2.getString("FIsRespPosition");
                    String checkSql = "SELECT * FROM T_HR_SynIdMapping WHERE FEASID = '" + positionId + "'";
                    IRowSet executeQuery3 = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                    if (executeQuery3.size() >= 1) continue;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("easNumber", positionNumber);
                    map.put("easName", positionName);
                    map.put("easAdminOrgUnit", adminName);
                    map.put("easParent", parentPositionName);
                    map.put("easIsRespPosition", isRespPosition);
                    easAdminResultList.add(map);
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return easAdminResultList;
    }

    public static String exportPersocChangeInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            Map<String, Object[]> personItemMap = ExcelExportDataHelpUtil.getPersonItemMap();
            Map<String, Object[]> personItemMap2 = ExcelExportDataHelpUtil.getPersonItemMap2();
            String path = ExcelExportDataHelpUtil.exportPersonTemplate(personItemMap, personItemMap2, request, response, modelMap, shrConn, ctx);
            ExcelUtil.setExportExcelHead(response, path, "\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u5458\u5de5");
            shrConn.close();
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object[]> getPersonItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u5458\u5de5\u7f16\u7801", new Object[]{"shrNumber"});
        itemMap.put("shr\u5458\u5de5\u59d3\u540d", new Object[]{"shrName"});
        itemMap.put("shr\u8eab\u4efd\u8bc1\u53f7", new Object[]{"shrIdCard"});
        itemMap.put("shr\u4efb\u804c\u804c\u4f4d", new Object[]{"shrPosition"});
        itemMap.put("shr\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"shrAdminOrgUnit"});
        itemMap.put("eas\u5458\u5de5\u7f16\u7801", new Object[]{"easNumber"});
        itemMap.put("eas\u5458\u5de5\u59d3\u540d", new Object[]{"easName"});
        itemMap.put("eas\u8eab\u4efd\u8bc1\u53f7", new Object[]{"easIdCard"});
        itemMap.put("eas\u4efb\u804c\u804c\u4f4d", new Object[]{"easPosition"});
        itemMap.put("eas\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"easAdminOrgUnit"});
        itemMap.put("all\u662f\u5426\u5339\u914d", new Object[]{"isRepeat"});
        itemMap.put("all\u4efb\u804c\u5339\u914d", new Object[]{"isRelationRepeat"});
        itemMap.put("all\u7f16\u7801\u6216\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d", new Object[]{"isIdCardRepeat"});
        itemMap.put("all\u5339\u914d\u65b9\u5f0f", new Object[]{"mapMethod"});
        return itemMap;
    }

    public static Map<String, Object[]> getPersonItemMap2() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("eas\u5458\u5de5\u7f16\u7801", new Object[]{"easNumber"});
        itemMap.put("eas\u5458\u5de5\u59d3\u540d", new Object[]{"easName"});
        itemMap.put("eas\u8eab\u4efd\u8bc1\u53f7", new Object[]{"easIdCard"});
        itemMap.put("eas\u4efb\u804c\u804c\u4f4d", new Object[]{"easPosition"});
        itemMap.put("eas\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"easAdminOrgUnit"});
        return itemMap;
    }

    public static String exportPersonTemplate(Map<String, Object[]> adminItemMap, Map<String, Object[]> adminItemMap2, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Connection shrConn, Context ctx) throws Exception {
        int i;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet personSheet = wb.createSheet("\u5458\u5de5\u6570\u636e\u5bf9\u6bd4");
        HSSFRow personRow = null;
        Cell personCell = null;
        personRow = personSheet.createRow(0);
        personCell = personRow.createCell(0);
        HSSFFont redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        redFont.setFontHeightInPoints((short)12);
        HSSFFont blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.index);
        blackFont.setFontHeightInPoints((short)12);
        StringBuffer sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("\u7cfb\u7edf\u81ea\u52a8\u6839\u636e\u5458\u5de5\u7f16\u7801+\u5458\u5de5\u59d3\u540d\u81ea\u52a8\u5339\u914d\uff1b").append("\n").append("\u8bf7\u68c0\u67e5\u6709\u5339\u914d\u7684\u5458\u5de5\uff0c\u786e\u4fdd\u6e90\u6570\u636e\u548c\u76ee\u6807\u6570\u636e\u662f\u540c\u4e00\u5458\u5de5\uff1b").append("\n").append("\u8bf7\u68c0\u67e5s-HR\u4e2d\u65e0\u5339\u914d\u7684\u5458\u5de5\uff0c\u82e5EAS\u4e2d\u5b58\u5728\u8bf7\u5c06\u7ec4\u7ec7\u8c03\u6574\u6b63\u786e\u540e\u518d\u91cd\u65b0\u667a\u80fd\u68c0\u67e5\u5e76\u786e\u8ba4\uff1b\u82e5EAS\u4e2d\u786e\u5b9e\u4e0d\u5b58\u5728\uff0c\u53ef\u786e\u8ba4\u540e\u7531\u7cfb\u7edf\u81ea\u52a8\u8fc1\u79fb\u3002");
        HSSFRichTextString richString = new HSSFRichTextString(sb.toString());
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(52, 117, (Font)redFont);
        personCell.setCellValue((RichTextString)richString);
        personRow.setHeight((short)1200);
        personSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, adminItemMap.size() - 1));
        personSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 4));
        personSheet.addMergedRegion(new CellRangeAddress(1, 1, 5, 9));
        personRow = personSheet.createRow(1);
        for (int i2 = 0; i2 < 13; ++i2) {
            personCell = personRow.createCell(i2);
            personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        personRow.setHeight((short)400);
        personCell = personRow.createCell(0);
        personCell.setCellValue("s-HR");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personCell = personRow.createCell(5);
        personCell.setCellValue("EAS");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personCell = personRow.createCell(10);
        personCell.setCellValue("\u662f\u5426\u5339\u914d");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personSheet.addMergedRegion(new CellRangeAddress(1, 2, 10, 10));
        personCell = personRow.createCell(11);
        personCell.setCellValue("\u4efb\u804c\u5339\u914d");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personSheet.addMergedRegion(new CellRangeAddress(1, 2, 11, 11));
        personCell = personRow.createCell(12);
        personCell.setCellValue("\u7f16\u7801\u6216\u8eab\u4efd\u8bc1\u53f7\u91cd\u590d");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personSheet.addMergedRegion(new CellRangeAddress(1, 2, 12, 12));
        personCell = personRow.createCell(13);
        personCell.setCellValue("\u5339\u914d\u65b9\u5f0f");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personSheet.addMergedRegion(new CellRangeAddress(1, 2, 13, 13));
        personRow = personSheet.createRow(2);
        personRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            personCell = personRow.createCell(itemCount++);
            personCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u5458\u5de5\u7f16\u7801") || itemName.substring(3).equals("\u5458\u5de5\u59d3\u540d")) {
                personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (int i3 = 0; i3 < itemCount; ++i3) {
            personSheet.setColumnWidth(i3, 6000);
        }
        Statement state = null;
        Object rs = null;
        state = shrConn.createStatement();
        List<Object> resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultPersonList(shrConn, ctx);
        for (int i4 = 0; i4 < resultList.size(); ++i4) {
            personRow = personSheet.createRow(3 + i4);
            Map easMap = new HashMap();
            easMap = (Map)resultList.get(i4);
            personCell = personRow.createCell(0);
            personCell.setCellValue((String)easMap.get("shrNumber"));
            personCell = personRow.createCell(1);
            personCell.setCellValue((String)easMap.get("shrName"));
            personCell = personRow.createCell(2);
            personCell.setCellValue((String)easMap.get("shrIdCard"));
            personCell = personRow.createCell(3);
            personCell.setCellValue((String)easMap.get("shrPosition"));
            personCell = personRow.createCell(4);
            personCell.setCellValue((String)easMap.get("shrAdminOrgUnit"));
            personCell = personRow.createCell(5);
            personCell.setCellValue((String)easMap.get("easNumber"));
            personCell = personRow.createCell(6);
            personCell.setCellValue((String)easMap.get("easName"));
            personCell = personRow.createCell(7);
            personCell.setCellValue((String)easMap.get("easIdCard"));
            personCell = personRow.createCell(8);
            personCell.setCellValue((String)easMap.get("easPosition"));
            personCell = personRow.createCell(9);
            personCell.setCellValue((String)easMap.get("easAdminOrgUnit"));
            personCell = personRow.createCell(10);
            personCell.setCellValue((String)easMap.get("isRepeat"));
            personCell = personRow.createCell(11);
            personCell.setCellValue((String)easMap.get("isRelationRepeat"));
            personCell = personRow.createCell(12);
            personCell.setCellValue((String)easMap.get("isIdCardRepeat"));
            personCell = personRow.createCell(13);
            personCell.setCellValue((String)easMap.get("mapMethod"));
        }
        HSSFSheet personSheet2 = wb.createSheet("EAS\u5f85\u8c03\u6574\u5458\u5de5");
        personRow = null;
        personCell = null;
        personRow = personSheet2.createRow(0);
        personCell = personRow.createCell(0);
        sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("s-HR\u6240\u8fc1\u79fb\u7684\u7ec4\u7ec7\u4e0b\uff0cEAS\u5b58\u5728\u7684\u672a\u5339\u914d\u7684\u975e\u4f5c\u5e9f\u72b6\u6001\u7684\u5458\u5de5\uff0c\u8bf7\u8c03\u6574 \u4e0es-HR\u4e2d\u7684\u5458\u5de5\u76f8\u5339\u914d\uff0c\u6216\u8c03\u6574\u4e3a\u4f5c\u5e9f\u72b6\u6001\u3002");
        richString = new HSSFRichTextString(sb.toString());
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(3, 61, (Font)redFont);
        personCell.setCellValue((RichTextString)richString);
        personRow.setHeight((short)1200);
        personSheet2.addMergedRegion(new CellRangeAddress(0, 0, 0, adminItemMap2.size() - 1));
        personSheet2.addMergedRegion(new CellRangeAddress(1, 1, 0, 4));
        personRow = personSheet2.createRow(1);
        for (int i5 = 0; i5 < 5; ++i5) {
            personCell = personRow.createCell(i5);
            personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        personRow.setHeight((short)400);
        personCell = personRow.createCell(0);
        personCell.setCellValue("EAS");
        personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        personRow = personSheet2.createRow(2);
        personRow.setHeight((short)400);
        itemCount = 0;
        for (String itemName : adminItemMap2.keySet()) {
            personCell = personRow.createCell(itemCount++);
            personCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u5458\u5de5\u7f16\u7801") || itemName.substring(3).equals("\u5458\u5de5\u59d3\u540d")) {
                personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            personCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (i = 0; i < itemCount; ++i) {
            personSheet2.setColumnWidth(i, 6000);
        }
        resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultPersonList2(shrConn, ctx);
        for (i = 0; i < resultList.size(); ++i) {
            personRow = personSheet2.createRow(3 + i);
            Map easMap = new HashMap();
            easMap = (Map)resultList.get(i);
            personCell = personRow.createCell(0);
            personCell.setCellValue((String)easMap.get("easNumber"));
            personCell = personRow.createCell(1);
            personCell.setCellValue((String)easMap.get("easName"));
            personCell = personRow.createCell(2);
            personCell.setCellValue((String)easMap.get("easIdCard"));
            personCell = personRow.createCell(3);
            personCell.setCellValue((String)easMap.get("easPosition"));
            personCell = personRow.createCell(4);
            personCell.setCellValue((String)easMap.get("easAdminOrgUnit"));
        }
        String path = TEMP_DIR + ExcelExportDataHelpUtil.getUUID() + ".xls";
        FileOutputStream out = new FileOutputStream(path);
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    public static List<Map<String, String>> getResultPersonList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "SELECT shrPerson.FNUMBER as shrNumber, shrPerson.FName_l2 as shrName, shrPerson.FIDCARDNO  as shrIdCard, shrPosition.FNAME_l2 as shrPositionName, shrAdmin.FDISPLAYNAME_l2 as shrAdminName, easPerson.FNUMBER as easNumber, easPerson.FName_l2 as easName, easPerson.FIDCARDNO  as easIdCard, easPosition.FNAME_l2 as easPositionName, easAdmin.FDISPLAYNAME_l2 as easAdminName, synMap.FMapWay as mapWay FROM\u3000T_HR_SynIdMapping synMap LEFT JOIN T_BD_PERSON_SHR_TEMP shrPerson ON shrPerson.FID  = synMap.FSHRID left join T_HR_PERSONPOSITION_SHR_TEMP shrPP on shrPerson.fid =shrPP.FPersonID left join T_ORG_ADMIN_SHR_TEMP shrAdmin on shrPP.FPersonDep = shrAdmin.fid left join T_ORG_POSITION_SHR_TEMP shrPosition on shrPP.FPrimaryPositionID = shrPosition.fid LEFT JOIN T_BD_PERSON easPerson ON  easPerson.FID  = synMap.FEASID left join T_HR_PersonPosition  easPP on  easPerson.fid = easPP.FPersonID left join T_ORG_Admin  easAdmin on  easPP.FPersonDep =  easAdmin.fid left join T_ORG_POSITION  easPosition on  easPP.FPrimaryPositionID =  easPosition.fid where FBosType = '80EF7DED'";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", executeQuery.getString("shrNumber"));
                map.put("shrName", executeQuery.getString("shrName"));
                map.put("shrIdCard", executeQuery.getString("shrIdCard"));
                map.put("shrPosition", executeQuery.getString("shrPositionName"));
                map.put("shrAdminOrgUnit", executeQuery.getString("shrAdminName"));
                map.put("easNumber", executeQuery.getString("easNumber"));
                map.put("easName", executeQuery.getString("easName"));
                map.put("easIdCard", executeQuery.getString("easIdCard"));
                map.put("easPosition", executeQuery.getString("easPositionName"));
                map.put("easAdminOrgUnit", executeQuery.getString("easAdminName"));
                map.put("isRepeat", "\u662f");
                map.put("isRelationRepeat", "\u662f");
                map.put("isIdCardRepeat", "");
                if (executeQuery.getString("mapWay").equals("normal")) {
                    map.put("mapMethod", "\u6309\u7167\u5458\u5de5\u7f16\u7801\u3001\u5458\u5de5\u59d3\u540d\u5339\u914d");
                } else if (executeQuery.getString("mapWay").equals("number")) {
                    map.put("mapMethod", "\u6309\u7167\u5458\u5de5\u7f16\u7801\u5339\u914d");
                } else {
                    map.put("mapMethod", "");
                }
                resultList.add(map);
            }
            String shrOtherSql = "select person.fnumber as personNumber,person.fname_l2 as personName,person.FIDCardNO as personIdCard,adminOrg.FDISPLAYNAME_L2 as adminOrgUnitName,position.fname_l2 as positionName,person.FID as personId from T_BD_PERSON_SHR_TEMP person left join T_HR_PERSONPOSITION_SHR_TEMP pp on person.fid = pp.FPersonID left join T_ORG_ADMIN_SHR_TEMP adminOrg on pp.FPersonDep = adminOrg.fid left join T_ORG_POSITION_SHR_TEMP position on pp.FPrimaryPositionID = position.fid where person.fid not in (SELECT FSHRID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '80EF7DED')";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)shrOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", executeQuery.getString("personNumber"));
                map.put("shrName", executeQuery.getString("personName"));
                map.put("shrIdCard", executeQuery.getString("personIdCard"));
                map.put("shrPosition", executeQuery.getString("positionName"));
                map.put("shrAdminOrgUnit", executeQuery.getString("adminOrgUnitName"));
                map.put("easNumber", "");
                map.put("easName", "");
                map.put("easIdCard", "");
                map.put("easPosition", "");
                map.put("easAdminOrgUnit", "");
                map.put("isRepeat", "");
                map.put("isRelationRepeat", "");
                String checkNumber = "SELECT * FROM T_BD_PERSON WHERE FNUMBER = '" + executeQuery.getString("personNumber") + "'";
                IRowSet executeQuery2 = DbUtil.executeQuery((Context)ctx, (String)checkNumber);
                if (executeQuery2.size() > 0) {
                    map.put("isIdCardRepeat", "\u662f");
                } else {
                    map.put("isIdCardRepeat", "");
                }
                map.put("mapMethod", "");
                resultList.add(map);
            }
            String easOtherSql = "select person.fnumber as personNumber,person.fname_l2 as personName,person.FIDCardNO as personIdCard,adminOrg.FDISPLAYNAME_L2 as adminOrgUnitName,position.fname_l2 as positionName,person.FID as personId from T_BD_PERSON person left join T_HR_PERSONPOSITION pp on person.fid = pp.FPersonID left join T_ORG_ADMIN adminOrg on pp.FPersonDep = adminOrg.fid left join T_ORG_POSITION position on pp.FPrimaryPositionID = position.fid where person.fid not in (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '80EF7DED')";
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)easOtherSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrNumber", "");
                map.put("shrName", "");
                map.put("shrIdCard", "");
                map.put("shrPosition", "");
                map.put("shrAdminOrgUnit", "");
                map.put("easNumber", executeQuery.getString("personNumber"));
                map.put("easName", executeQuery.getString("personName"));
                map.put("easIdCard", executeQuery.getString("personIdCard"));
                map.put("easPosition", executeQuery.getString("positionName"));
                map.put("easAdminOrgUnit", executeQuery.getString("adminOrgUnitName"));
                map.put("isRepeat", "");
                map.put("isRelationRepeat", "");
                map.put("isIdCardRepeat", "");
                map.put("mapMethod", "");
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getResultPersonList2(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> easAdminResultList = new ArrayList<Map<String, String>>();
        try {
            String getAdminSql = "SELECT FEASID FROM T_HR_SynIdMapping WHERE FBosType = '6A6435BE'";
            String sql = "select person.FID as personId,person.fnumber as easNumber,person.fname_l2 as easName,person.FIDCardNO as easIdCard,adminOrg.FDISPLAYNAME_L2 as easAdminOrgUnit,position.fname_l2 as easPosition from t_bd_person person left join T_HR_PersonPosition pp on person.fid = pp.FPersonID left join T_ORG_Admin adminOrg on pp.FPersonDep = adminOrg.fid left join T_ORG_POSITION position on pp.FPrimaryPositionID = position.fid WHERE pp.FPersonDep in (" + getAdminSql + ") and person.FDeletedStatus = 1 and person.fid NOT IN (SELECT FEASID FROM T_HR_SynIdMapping where FBosType = '80EF7DED')";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                String personId = executeQuery.getString("personId");
                String personNumber = executeQuery.getString("easNumber");
                String personName = executeQuery.getString("easName");
                String idCard = executeQuery.getString("easIdCard");
                String positionName = executeQuery.getString("easPosition");
                String adminOrgName = executeQuery.getString("easAdminOrgUnit");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easNumber", personNumber);
                map.put("easName", personName);
                map.put("easIdCard", idCard);
                map.put("easPosition", positionName);
                map.put("easAdminOrgUnit", adminOrgName);
                easAdminResultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return easAdminResultList;
    }

    public static String exportJobChangeInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            Connection shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            Map<String, Object[]> jobCategoryItemMap = ExcelExportDataHelpUtil.getJobCategoryMap();
            Map<String, Object[]> jobItemMap = ExcelExportDataHelpUtil.getJobItemMap();
            String path = ExcelExportDataHelpUtil.exportJobTemplate(jobCategoryItemMap, jobItemMap, request, response, modelMap, shrConn, ctx);
            ExcelUtil.setExportExcelHead(response, path, "\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u804c\u52a1_\u804c\u52a1\u7c7b");
            shrConn.close();
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    public static Map<String, Object[]> getJobCategoryMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u804c\u4f4d\u7c7b\u7f16\u7801", new Object[]{"shrJobCategoryNumber"});
        itemMap.put("shr\u804c\u4f4d\u7c7b\u540d\u79f0", new Object[]{"shrJobCategoryName"});
        itemMap.put("shr\u804c\u4f4d\u65cf", new Object[]{"shrJobFamily"});
        itemMap.put("eas\u804c\u4f4d\u7c7b\u7f16\u7801", new Object[]{"easJobCategoryNumber"});
        itemMap.put("eas\u804c\u4f4d\u7c7b\u540d\u79f0", new Object[]{"easJobCategoryName"});
        itemMap.put("eas\u804c\u4f4d\u65cf", new Object[]{"easJobFamily"});
        itemMap.put("all\u662f\u5426\u5339\u914d", new Object[]{"isRepeat"});
        itemMap.put("all\u7f16\u7801\u540d\u79f0\u76f8\u540c", new Object[]{"numberAndNameSame"});
        itemMap.put("all\u7f16\u7801\u91cd\u590d", new Object[]{"isNumberRepeat"});
        return itemMap;
    }

    public static Map<String, Object[]> getJobItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u804c\u4f4d\u7f16\u7801", new Object[]{"shrJobNumber"});
        itemMap.put("shr\u804c\u4f4d\u540d\u79f0", new Object[]{"shrJobName"});
        itemMap.put("shr\u804c\u4f4d\u5b50\u7c7b", new Object[]{"shrJobSubCategory"});
        itemMap.put("shr\u804c\u4f4d\u7c7b\u7f16\u7801", new Object[]{"shrJobCategoryNumber"});
        itemMap.put("shr\u804c\u4f4d\u7c7b\u540d\u79f0", new Object[]{"shrJobCategoryName"});
        itemMap.put("shr\u804c\u4f4d\u65cf", new Object[]{"shrJobFamily"});
        itemMap.put("eas\u804c\u52a1\u7f16\u7801", new Object[]{"easJobNumber"});
        itemMap.put("eas\u804c\u52a1\u540d\u79f0", new Object[]{"easJobName"});
        itemMap.put("eas\u804c\u52a1\u7c7b\u578b\u7f16\u7801", new Object[]{"easJobCategoryNumber"});
        itemMap.put("eas\u804c\u52a1\u7c7b\u578b\u540d\u79f0", new Object[]{"easJobCategoryName"});
        itemMap.put("all\u662f\u5426\u5339\u914d", new Object[]{"isRepeat"});
        itemMap.put("all\u804c\u4f4d\u7c7b\u662f\u5426\u5339\u914d", new Object[]{"isJobCategoryRepeat"});
        itemMap.put("all\u7f16\u7801\u540d\u79f0\u76f8\u540c", new Object[]{"numberAndNameSame"});
        itemMap.put("all\u7f16\u7801\u91cd\u590d", new Object[]{"isNumberRepeat"});
        return itemMap;
    }

    public static String exportJobTemplate(Map<String, Object[]> jobCategoryItemMap, Map<String, Object[]> jobItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Connection shrConn, Context ctx) throws Exception {
        int i;
        Map easMap;
        int i2;
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet jobSheet = wb.createSheet("\u804c\u4f4d\u7c7b\u6570\u636e\u5bf9\u6bd4");
        HSSFRow jobRow = null;
        Cell jobCell = null;
        jobRow = jobSheet.createRow(0);
        jobCell = jobRow.createCell(0);
        HSSFFont redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        redFont.setFontHeightInPoints((short)12);
        HSSFFont blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.index);
        blackFont.setFontHeightInPoints((short)12);
        StringBuffer sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("\u7cfb\u7edfs-HR\u6839\u636e\u804c\u4f4d\u7c7b\u7f16\u7801\uff08\u5bf9\u5e94EAS\u804c\u52a1\u7c7b\u578b\u7f16\u7801\uff09+\u804c\u4f4d\u7c7b\u540d\u79f0\uff08\u5bf9\u5e94EAS\u804c\u52a1\u7c7b\u578b\u540d\u79f0\uff09\u4e0eEAS\u81ea\u52a8\u5339\u914d\uff1b").append("\n").append("s-HR\u804c\u4f4d\u7c7b\u5bf9\u5e94EAS\u804c\u52a1\u7c7b\u578b\uff1b").append("\n").append("1\u3001\u82e5s-HR\u7684\u6240\u6709\u804c\u4f4d\u7c7b\u5747\u6ca1\u6709\u5339\u914dEAS\u7684\u804c\u52a1\u7c7b\uff0c\u5c06\u76f4\u63a5\u65b0\u589e\u8fc1\u79fb\uff0c\u4f46\u7f16\u7801\u6709\u91cd\u590d\u65f6\u4f1a\u5168\u90e8\u52a0\u4e0a_shr\u540e\u7f00\u540e\u65b0\u589e\u5230EAS\u4e2d\uff1b").append("\n").append("2\u3001\u82e5s-HR\u7684\u6240\u6709\u804c\u4f4d\u7c7b\u5747\u80fd\u5728EAS\u627e\u5230\u76f8\u5339\u914d\u7684\u804c\u52a1\u7c7b\u578b\uff0c\u6216EAS\u7684\u6240\u6709\u804c\u52a1\u7c7b\u578b\u5747\u6709s-HR\u627e\u5230\u76f8\u5339\u914d\u7684\u804c\u4f4d\u7c7b\uff0c\u5219\u81ea\u52a8\u8fdb\u884c\u6620\u5c04\u8fc1\u79fb\uff1b").append("\n").append("3\u3001\u82e5s-HR\u4ec5\u6709\u90e8\u5206\u804c\u4f4d\u7c7b\u4e0eEAS\u5339\u914d\uff0c\u90e8\u5206\u6570\u636e\u6709\u5dee\u5f02\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u53ef\u8bfb\u6027\uff0c\u5c06\u628as-HR\u4e2d\u7684\u804c\u4f4d\u7c7b\u7684\u7f16\u7801\u52a0\u4e0a_shr\u540e\u7f00\u540e\u65b0\u589e\u5230EAS\u4e2d\uff0c\u4fdd\u7559\u539f").append("\n").append("EAS\u7684\u6240\u6709\u804c\u52a1\uff0c\u53ef\u4ee5\u901a\u8fc7\u7f16\u7801\u533a\u5206\uff1b").append("\n").append("4\u3001\u82e5EAS\u662f\u591aCU\uff0c\u8fc1\u79fb\u8fc7\u53bb\u7684\u804c\u52a1\u7c7b\u578b\u4f1a\u653e\u5728EAS\u6839CU\u4e0b\u3002");
        HSSFRichTextString richString = new HSSFRichTextString(sb.toString());
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(299, 330, (Font)redFont);
        jobCell.setCellValue((RichTextString)richString);
        jobRow.setHeight((short)2560);
        jobSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, jobCategoryItemMap.size() - 1));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 2));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 1, 3, 5));
        jobRow = jobSheet.createRow(1);
        for (int i3 = 0; i3 < 8; ++i3) {
            jobCell = jobRow.createCell(i3);
            jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        jobRow.setHeight((short)400);
        jobCell = jobRow.createCell(0);
        jobCell.setCellValue("s-HR");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobCell = jobRow.createCell(3);
        jobCell.setCellValue("EAS");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobCell = jobRow.createCell(6);
        jobCell.setCellValue("\u662f\u5426\u5339\u914d");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 6, 6));
        jobCell = jobRow.createCell(7);
        jobCell.setCellValue("\u7f16\u7801\u540d\u79f0\u76f8\u540c");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 7, 7));
        jobCell = jobRow.createCell(8);
        jobCell.setCellValue("\u7f16\u7801\u91cd\u590d");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 8, 8));
        jobRow = jobSheet.createRow(2);
        jobRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : jobCategoryItemMap.keySet()) {
            jobCell = jobRow.createCell(itemCount++);
            jobCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u804c\u4f4d\u7c7b\u7f16\u7801") || itemName.substring(3).equals("\u804c\u4f4d\u7c7b\u540d\u79f0") || itemName.substring(3).equals("\u804c\u4f4d\u65cf") || itemName.substring(3).equals("\u804c\u52a1\u7c7b\u578b\u7f16\u7801") || itemName.substring(3).equals("\u804c\u52a1\u7c7b\u578b\u540d\u79f0") || itemName.substring(3).equals("\u4e0a\u7ea7\u804c\u52a1\u7c7b\u578b")) {
                jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (int i4 = 0; i4 < itemCount; ++i4) {
            jobSheet.setColumnWidth(i4, 6000);
        }
        Statement state = null;
        Object rs = null;
        state = shrConn.createStatement();
        List<Object> resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultJobCategoryList(shrConn, ctx);
        for (i2 = 0; i2 < resultList.size(); ++i2) {
            jobRow = jobSheet.createRow(3 + i2);
            easMap = new HashMap();
            easMap = (Map)resultList.get(i2);
            jobCell = jobRow.createCell(0);
            jobCell.setCellValue((String)easMap.get("shrJobCategoryNumber"));
            jobCell = jobRow.createCell(1);
            jobCell.setCellValue((String)easMap.get("shrJobCategoryName"));
            jobCell = jobRow.createCell(2);
            jobCell.setCellValue((String)easMap.get("shrJobFamily"));
            jobCell = jobRow.createCell(3);
            jobCell.setCellValue((String)easMap.get("easJobCategoryNumber"));
            jobCell = jobRow.createCell(4);
            jobCell.setCellValue((String)easMap.get("easJobCategoryName"));
            jobCell = jobRow.createCell(5);
            jobCell.setCellValue((String)easMap.get("easJobFamily"));
            jobCell = jobRow.createCell(6);
            jobCell.setCellValue((String)easMap.get("isRepeat"));
            jobCell = jobRow.createCell(7);
            jobCell.setCellValue((String)easMap.get("numberAndNameSame"));
            jobCell = jobRow.createCell(8);
            jobCell.setCellValue((String)easMap.get("isNumberRepeat"));
        }
        jobSheet = wb.createSheet("\u804c\u4f4d\u6570\u636e\u5bf9\u6bd4");
        jobRow = null;
        jobCell = null;
        jobRow = jobSheet.createRow(0);
        jobCell = jobRow.createCell(0);
        sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("\u7cfb\u7edfs-HR\u6839\u636e\u804c\u4f4d\u7f16\u7801\uff08\u5bf9\u5e94EAS\u804c\u52a1\u7f16\u7801\uff09+\u804c\u4f4d\u540d\u79f0\uff08\u5bf9\u5e94EAS\u804c\u52a1\u540d\u79f0\uff09\u4e0eEAS\u81ea\u52a8\u5339\u914d\uff1b").append("\n").append("s-HR\u804c\u4f4d\u5bf9\u5e94EAS\u804c\u52a1\uff1b").append("\n").append("1\u3001\u82e5s-HR\u7684\u6240\u6709\u804c\u4f4d\u5747\u6ca1\u6709\u5339\u914dEAS\u7684\u804c\u52a1\uff0c\u5c06\u76f4\u63a5\u65b0\u589e\u8fc1\u79fb\uff0c\u4f46\u7f16\u7801\u6709\u91cd\u590d\u65f6\u4f1a\u5168\u90e8\u52a0\u4e0a_shr\u540e\u7f00\u540e\u65b0\u589e\u5230EAS\u4e2d\uff1b").append("\n").append("2\u3001\u82e5s-HR\u7684\u6240\u6709\u804c\u4f4d\u5747\u80fd\u5728EAS\u627e\u5230\u76f8\u5339\u914d\u7684\u804c\u52a1\uff0c\u6216EAS\u7684\u6240\u6709\u804c\u52a1\u5747\u6709s-HR\u627e\u5230\u76f8\u5339\u914d\u7684\u804c\u4f4d\uff0c\u5219\u81ea\u52a8\u8fdb\u884c\u6620\u5c04\u8fc1\u79fb\uff1b").append("\n").append("3\u3001\u82e5s-HR\u4ec5\u6709\u90e8\u5206\u804c\u4f4d\u4e0eEAS\u5339\u914d\uff0c\u90e8\u5206\u6570\u636e\u6709\u5dee\u5f02\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u53ef\u8bfb\u6027\uff0c\u5c06\u628as-HR\u4e2d\u7684\u804c\u4f4d\u7c7b\u7684\u7f16\u7801\u52a0\u4e0a_shr\u540e\u7f00\u540e\u65b0\u589e\u5230EAS\u4e2d\uff0c\u4fdd\u7559\u539fEAS\u7684\u6240\u6709\u804c\u52a1\uff0c\u53ef\u4ee5\u901a\u8fc7\u7f16\u7801\u533a\u5206\uff1b").append("\n").append("4\u3001\u82e5EAS\u662f\u591aCU\uff0c\u8fc1\u79fb\u8fc7\u53bb\u7684\u804c\u52a1\u7c7b\u578b\u4f1a\u653e\u5728EAS\u6839CU\u4e0b\u3002");
        richString = new HSSFRichTextString(sb.toString());
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        richString.applyFont(279, 311, (Font)redFont);
        jobCell.setCellValue((RichTextString)richString);
        jobRow.setHeight((short)2300);
        jobSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, jobItemMap.size() - 1));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 5));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 1, 6, 8));
        jobRow = jobSheet.createRow(1);
        for (i2 = 0; i2 < 13; ++i2) {
            jobCell = jobRow.createCell(i2);
            jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        jobRow.setHeight((short)400);
        jobCell = jobRow.createCell(0);
        jobCell.setCellValue("s-HR");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobCell = jobRow.createCell(5);
        jobCell.setCellValue("EAS");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobCell = jobRow.createCell(10);
        jobCell.setCellValue("\u662f\u5426\u5339\u914d");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 10, 10));
        jobCell = jobRow.createCell(11);
        jobCell.setCellValue("\u804c\u4f4d\u7c7b\u662f\u5426\u5339\u914d");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 11, 11));
        jobCell = jobRow.createCell(12);
        jobCell.setCellValue("\u7f16\u7801\u540d\u79f0\u76f8\u540c");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 12, 12));
        jobCell = jobRow.createCell(13);
        jobCell.setCellValue("\u7f16\u7801\u91cd\u590d");
        jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        jobSheet.addMergedRegion(new CellRangeAddress(1, 2, 13, 13));
        jobRow = jobSheet.createRow(2);
        jobRow.setHeight((short)400);
        itemCount = 0;
        for (String itemName : jobItemMap.keySet()) {
            jobCell = jobRow.createCell(itemCount++);
            jobCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u804c\u4f4d\u7f16\u7801") || itemName.substring(3).equals("\u804c\u4f4d\u540d\u79f0") || itemName.substring(3).equals("\u804c\u4f4d\u7c7b\u7f16\u7801") || itemName.substring(3).equals("\u804c\u4f4d\u7c7b\u540d\u79f0") || itemName.substring(3).equals("\u804c\u52a1\u7f16\u7801") || itemName.substring(3).equals("\u804c\u52a1\u540d\u79f0") || itemName.substring(3).equals("\u804c\u52a1\u7c7b\u578b\u7f16\u7801") || itemName.substring(3).equals("\u804c\u52a1\u7c7b\u578b\u540d\u79f0")) {
                jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            jobCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (i = 0; i < itemCount; ++i) {
            jobSheet.setColumnWidth(i, 6000);
        }
        resultList = new ArrayList();
        resultList = ExcelExportDataHelpUtil.getResultJobList(shrConn, ctx);
        for (i = 0; i < resultList.size(); ++i) {
            jobRow = jobSheet.createRow(3 + i);
            easMap = new HashMap();
            easMap = (Map)resultList.get(i);
            jobCell = jobRow.createCell(0);
            jobCell.setCellValue((String)easMap.get("shrJobNumber"));
            jobCell = jobRow.createCell(1);
            jobCell.setCellValue((String)easMap.get("shrJobName"));
            jobCell = jobRow.createCell(2);
            jobCell.setCellValue((String)easMap.get("shrJobSubCategory"));
            jobCell = jobRow.createCell(3);
            jobCell.setCellValue((String)easMap.get("shrJobCategoryNumber"));
            jobCell = jobRow.createCell(4);
            jobCell.setCellValue((String)easMap.get("shrJobCategoryName"));
            jobCell = jobRow.createCell(5);
            jobCell.setCellValue((String)easMap.get("shrJobFamily"));
            jobCell = jobRow.createCell(6);
            jobCell.setCellValue((String)easMap.get("easJobNumber"));
            jobCell = jobRow.createCell(7);
            jobCell.setCellValue((String)easMap.get("easJobName"));
            jobCell = jobRow.createCell(8);
            jobCell.setCellValue((String)easMap.get("easJobCategoryNumber"));
            jobCell = jobRow.createCell(9);
            jobCell.setCellValue((String)easMap.get("easJobCategoryName"));
            jobCell = jobRow.createCell(10);
            jobCell.setCellValue((String)easMap.get("isRepeat"));
            jobCell = jobRow.createCell(11);
            jobCell.setCellValue((String)easMap.get("isJobCategoryRepeat"));
            jobCell = jobRow.createCell(12);
            jobCell.setCellValue((String)easMap.get("numberAndNameSame"));
            jobCell = jobRow.createCell(13);
            jobCell.setCellValue((String)easMap.get("isNumberRepeat"));
        }
        String path = TEMP_DIR + ExcelExportDataHelpUtil.getUUID() + ".xls";
        FileOutputStream out = new FileOutputStream(path);
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    public static List<Map<String, String>> getShrJobCategoryList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        Statement state = null;
        ResultSet rs = null;
        String shrSql = "select jobCat.FNAME_L2 as JobCategoryName,jobCat.FNUMBER as JobCategoryNumber, jobFamily.FNAME_L2 as JobFamilyName,parentJobCat.FNAME_L2 as parentName from T_ORG_JobCategory jobCat left join T_HR_JobFamily jobFamily on jobCat.FJobFamilyID = jobFamily.FID left join T_ORG_JobCategory parentJobCat on jobCat.FParentID = parentJobCat.fid";
        try {
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrJobCategoryNumber", rs.getString(2));
                map.put("shrJobCategoryName", rs.getString(1));
                map.put("shrJobFamily", rs.getString(3));
                resultList.add(map);
            }
            state.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getEasJobCategoryList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "select jobCat.FNAME_L2 as JobCategoryName,jobCat.FNUMBER as JobCategoryNumber, jobFamily.FNAME_L2 as JobFamilyName,parentJobCat.FNAME_L2 as parentName from T_ORG_JobCategory jobCat left join T_HR_JobFamily jobFamily on jobCat.FJobFamilyID = jobFamily.FID left join T_ORG_JobCategory parentJobCat on jobCat.FParentID = parentJobCat.fid";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easJobCategoryNumber", executeQuery.getString("JobCategoryNumber"));
                map.put("easJobCategoryName", executeQuery.getString("JobCategoryName"));
                map.put("easJobFamily", executeQuery.getString("JobFamilyName"));
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getResultJobCategoryList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        List<Map<String, String>> shrJobCategoryResultList = ExcelExportDataHelpUtil.getShrJobCategoryList(shrConn, ctx);
        List<Map<String, String>> easJobCategoryResultList = ExcelExportDataHelpUtil.getEasJobCategoryList(shrConn, ctx);
        for (int i = 0; i < shrJobCategoryResultList.size(); ++i) {
            Map<Object, Object> shrMap = new HashMap();
            shrMap = shrJobCategoryResultList.get(i);
            String shrJobCategoryNumber = shrMap.get("shrJobCategoryNumber") == null ? "" : (String)shrMap.get("shrJobCategoryNumber");
            String shrJobCategoryName = shrMap.get("shrJobCategoryName") == null ? "" : (String)shrMap.get("shrJobCategoryName");
            String shrJobFamily = shrMap.get("shrJobFamily") == null ? "" : (String)shrMap.get("shrJobFamily");
            for (int j = 0; j < easJobCategoryResultList.size(); ++j) {
                String easJobFamily;
                Map<Object, Object> easMap = new HashMap();
                easMap = easJobCategoryResultList.get(j);
                String easJobCategoryNumber = easMap.get("easJobCategoryNumber") == null ? "" : (String)easMap.get("easJobCategoryNumber");
                String easJobCategoryName = easMap.get("easJobCategoryName") == null ? "" : (String)easMap.get("easJobCategoryName");
                String string = easJobFamily = easMap.get("easJobFamily") == null ? "" : (String)easMap.get("easJobFamily");
                if (!shrJobCategoryNumber.equals(easJobCategoryNumber) || !shrJobCategoryName.equals(easJobCategoryName)) continue;
                shrMap.put("easJobCategoryNumber", easMap.get("easJobCategoryNumber"));
                shrMap.put("easJobCategoryName", easMap.get("easJobCategoryName"));
                shrMap.put("easJobFamily", easMap.get("easJobFamily"));
                shrMap.put("isRepeat", "\u662f");
                if (easJobCategoryNumber.equals(shrJobCategoryNumber) && easJobCategoryName.equals(shrJobCategoryName)) {
                    shrMap.put("numberAndNameSame", "\u662f");
                    break;
                }
                shrMap.put("numberAndNameSame", "\u5426");
                break;
            }
            if (shrMap.get("easJobCategoryNumber") == null) {
                shrMap.put("easJobCategoryNumber", "");
                shrMap.put("easJobCategoryName", "");
                shrMap.put("easJobFamily", "");
                shrMap.put("isRepeat", "");
                String sql = "SELECT * FROM T_ORG_JobCategory WHERE FNUMBER = '" + (String)shrMap.get("shrJobCategoryNumber") + "'";
                try {
                    IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (executeQuery.size() > 0) {
                        shrMap.put("isNumberRepeat", "\u662f");
                    } else {
                        shrMap.put("isNumberRepeat", "\u5426");
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            resultList.add(shrMap);
        }
        try {
            String easNoMapSql = "select jobCat.FNAME_L2 as JobCategoryName,jobCat.FNUMBER as JobCategoryNumber, jobFamily.FNAME_L2 as JobFamilyName,parentJobCat.FNAME_L2 as parentName from T_ORG_JobCategory jobCat left join T_HR_JobFamily jobFamily on jobCat.FJobFamilyID = jobFamily.FID left join T_ORG_JobCategory parentJobCat on jobCat.FParentID = parentJobCat.fid where jobCat.fid not in (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = 'B48B2DB6')";
            IRowSet executeQuery = null;
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)easNoMapSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrJobCategoryNumber", "");
                map.put("shrJobCategoryName", "");
                map.put("shrJobFamily", "");
                map.put("easJobCategoryNumber", executeQuery.getString("JobCategoryNumber"));
                map.put("easJobCategoryName", executeQuery.getString("JobCategoryName"));
                map.put("easJobFamily", executeQuery.getString("parentName"));
                resultList.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getShrJobList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        Statement state = null;
        ResultSet rs = null;
        String shrSql = "select jobTemp.fnumber as JobNumber,jobTemp.FNAME_l2 as JobName,jobCat.FNUMBER as JobCategoryNumber, jobCat.FNAME_L2 as JobCategoryName,jobFamily.fname_l2 as JobFamilyName,jobSubCat.fname_l2 as JobSubCategoryName from T_ORG_Job jobTemp left join T_ORG_JobCategory jobCat ON jobTemp.FJobCategoryID = jobCat.FID left join T_HR_JobFamily jobFamily ON jobFamily.FID = jobTemp.FJobFamilyID left join T_HR_JobSubCategory jobSubCat ON jobSubCat.FID = jobTemp.FJobSubCategoryID";
        try {
            state = shrConn.createStatement();
            rs = state.executeQuery(shrSql);
            while (rs.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrJobNumber", rs.getString(1));
                map.put("shrJobName", rs.getString(2));
                map.put("shrJobSubCategory", rs.getString(6));
                map.put("shrJobCategoryNumber", rs.getString(3));
                map.put("shrJobCategoryName", rs.getString(4));
                map.put("shrJobFamily", rs.getString(5));
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getEasJobList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        try {
            String sql = "select jobTemp.fnumber as JobNumber,jobTemp.FNAME_l2 as JobName,jobCat.FNUMBER as JobCategoryNumber, jobCat.FNAME_L2 as JobCategoryName,jobFamily.fname_l2 as JobFamilyName,jobSubCat.fname_l2 as JobSubCategoryName from T_ORG_Job jobTemp left join T_ORG_JobCategory jobCat ON jobTemp.FJobCategoryID = jobCat.FID left join T_HR_JobFamily jobFamily ON jobFamily.FID = jobTemp.FJobFamilyID left join T_HR_JobSubCategory jobSubCat ON jobSubCat.FID = jobTemp.FJobSubCategoryID";
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("easJobNumber", executeQuery.getString("JobNumber"));
                map.put("easJobName", executeQuery.getString("JobName"));
                map.put("easJobSubCategory", executeQuery.getString("JobSubCategoryName"));
                map.put("easJobCategoryNumber", executeQuery.getString("JobCategoryNumber"));
                map.put("easJobCategoryName", executeQuery.getString("JobCategoryName"));
                map.put("easJobFamily", executeQuery.getString("JobFamilyName"));
                resultList.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static List<Map<String, String>> getResultJobList(Connection shrConn, Context ctx) {
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        List<Map<String, String>> shrJobResultList = ExcelExportDataHelpUtil.getShrJobList(shrConn, ctx);
        List<Map<String, String>> easJobResultList = ExcelExportDataHelpUtil.getEasJobList(shrConn, ctx);
        for (int i = 0; i < shrJobResultList.size(); ++i) {
            Map<Object, Object> shrMap = new HashMap();
            shrMap = shrJobResultList.get(i);
            String shrJobNumber = shrMap.get("shrJobNumber") == null ? "" : (String)shrMap.get("shrJobNumber");
            String shrJobName = shrMap.get("shrJobName") == null ? "" : (String)shrMap.get("shrJobName");
            String shrJobCategoryNumber = shrMap.get("shrJobCategoryNumber") == null ? "" : (String)shrMap.get("shrJobCategoryNumber");
            String shrJobCategoryName = shrMap.get("shrJobCategoryName") == null ? "" : (String)shrMap.get("shrJobCategoryName");
            for (int j = 0; j < easJobResultList.size(); ++j) {
                String easJobCategoryName;
                Map<Object, Object> easMap = new HashMap();
                easMap = easJobResultList.get(j);
                String easJobNumber = easMap.get("easJobNumber") == null ? "" : (String)easMap.get("easJobNumber");
                String easJobName = easMap.get("easJobName") == null ? "" : (String)easMap.get("easJobName");
                String easJobCategoryNumber = easMap.get("easJobCategoryNumber") == null ? "" : (String)easMap.get("easJobCategoryNumber");
                String string = easJobCategoryName = easMap.get("easJobCategoryName") == null ? "" : (String)easMap.get("easJobCategoryName");
                if (!shrJobNumber.equals(easJobNumber) || !shrJobName.equals(easJobName)) continue;
                shrMap.put("easJobNumber", easMap.get("easJobNumber"));
                shrMap.put("easJobName", easMap.get("easJobName"));
                shrMap.put("easJobSubCategory", easMap.get("easJobSubCategory"));
                shrMap.put("easJobCategoryNumber", easMap.get("easJobCategoryNumber"));
                shrMap.put("easJobCategoryName", easMap.get("easJobCategoryName"));
                shrMap.put("easJobFamily", easMap.get("easJobFamily"));
                shrMap.put("isRepeat", "\u662f");
                if (easJobNumber.equals(shrJobNumber) && easJobName.equals(shrJobName)) {
                    shrMap.put("numberAndNameSame", "\u662f");
                } else {
                    shrMap.put("numberAndNameSame", "\u5426");
                }
                if (easJobCategoryNumber.equals(shrJobCategoryNumber) && easJobCategoryName.equals(shrJobCategoryName)) {
                    shrMap.put("isJobCategoryRepeat", "\u662f");
                    break;
                }
                shrMap.put("isJobCategoryRepeat", "\u5426");
                break;
            }
            if (shrMap.get("easJobNumber") == null) {
                shrMap.put("easJobNumber", "");
                shrMap.put("easJobName", "");
                shrMap.put("easJobSubCategory", "");
                shrMap.put("easJobCategoryNumber", "");
                shrMap.put("easJobCategoryName", "");
                shrMap.put("easJobFamily", "");
                shrMap.put("isRepeat", "");
                shrMap.put("isJobCategoryRepeat", "");
                String sql = "SELECT * FROM T_ORG_Job WHERE FNUMBER = '" + (String)shrMap.get("shrJobNumber") + "'";
                try {
                    IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)sql);
                    if (executeQuery.size() > 0) {
                        shrMap.put("isNumberRepeat", "\u662f");
                    } else {
                        shrMap.put("isNumberRepeat", "\u5426");
                    }
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            }
            resultList.add(shrMap);
        }
        try {
            String easNoMapSql = "select jobTemp.fnumber as JobNumber,jobTemp.FNAME_l2 as JobName,jobCat.FNUMBER as JobCategoryNumber, jobCat.FNAME_L2 as JobCategoryName,jobFamily.fname_l2 as JobFamilyName,jobSubCat.fname_l2 as JobSubCategoryName from T_ORG_Job jobTemp left join T_ORG_JobCategory jobCat ON jobTemp.FJobCategoryID = jobCat.FID left join T_HR_JobFamily jobFamily ON jobFamily.FID = jobTemp.FJobFamilyID left join T_HR_JobSubCategory jobSubCat ON jobSubCat.FID = jobTemp.FJobSubCategoryID where jobTemp.fid not in (SELECT FEASID FROM T_HR_SynIdMapping WHERE FBOSTYPE = '75702498')";
            IRowSet executeQuery = null;
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)easNoMapSql);
            while (executeQuery.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("shrJobNumber", "");
                map.put("shrJobName", "");
                map.put("shrJobSubCategory", "");
                map.put("shrJobCategoryNumber", "");
                map.put("shrJobCategoryName", "");
                map.put("shrJobFamily", "");
                map.put("easJobNumber", executeQuery.getString("JobNumber"));
                map.put("easJobName", executeQuery.getString("JobName"));
                map.put("easJobSubCategory", executeQuery.getString("JobSubCategoryName"));
                map.put("easJobCategoryNumber", executeQuery.getString("JobCategoryNumber"));
                map.put("easJobCategoryName", executeQuery.getString("JobCategoryName"));
                map.put("easJobFamily", executeQuery.getString("JobFamilyName"));
                resultList.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static HSSFCellStyle getBlackCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(IndexedColors.BLACK.index);
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont(font);
        return cellStyle;
    }

    public static HSSFCellStyle getRedToYellowCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(IndexedColors.RED.index);
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont(font);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.YELLOW.index);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.index);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.index);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    public static HSSFCellStyle getBlackToYellowCellStyle(HSSFWorkbook wb) {
        HSSFCellStyle cellStyle = wb.createCellStyle();
        HSSFFont font = wb.createFont();
        font.setColor(IndexedColors.BLACK.index);
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont(font);
        cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        cellStyle.setFillForegroundColor(IndexedColors.YELLOW.index);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setTopBorderColor(IndexedColors.BLACK.index);
        cellStyle.setLeftBorderColor(IndexedColors.BLACK.index);
        cellStyle.setRightBorderColor(IndexedColors.BLACK.index);
        cellStyle.setBottomBorderColor(IndexedColors.BLACK.index);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        return cellStyle;
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String exportUserChangeInfoAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            String className = "com.kingdee.eas.hr.mvdt.handler.UserMoveHandler";
            String verifyDataMethodName = "verifyData";
            Connection conn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            Class clazz = MsfClassLoaderFactory.forName((String)className);
            Method verifyDataMethod = ReflectionUtils.findMethod((Class)clazz, (String)verifyDataMethodName, (Class[])new Class[]{Connection.class, Context.class});
            ReflectionUtils.invokeMethod((Method)verifyDataMethod, clazz.newInstance(), (Object[])new Object[]{conn, ctx});
            Map<String, Object[]> userItemMap = ExcelExportDataHelpUtil.getUserItemMap();
            Connection shrConn = SHRDbConnectionTool.getSHRDBConnection(ctx);
            String path = ExcelExportDataHelpUtil.exportUserTemplate(userItemMap, request, response, modelMap, shrConn, ctx);
            ExcelUtil.setExportExcelHead(response, path, "\u5bfc\u51fa\u5bf9\u6bd4\u8868_\u7528\u6237");
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    private static String exportUserTemplate(Map<String, Object[]> userItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Connection shrConn, Context ctx) throws SQLException, EASBizException, BOSException, IOException {
        HSSFWorkbook wb = new HSSFWorkbook();
        HSSFSheet adminSheet = wb.createSheet("\u7528\u6237\u6570\u636e\u5bf9\u6bd4");
        HSSFRow adminRow = null;
        Cell adminCell = null;
        adminRow = adminSheet.createRow(0);
        adminCell = adminRow.createCell(0);
        HSSFFont redFont = wb.createFont();
        redFont.setColor(IndexedColors.RED.index);
        redFont.setFontHeightInPoints((short)12);
        HSSFFont blackFont = wb.createFont();
        blackFont.setColor(IndexedColors.BLACK.index);
        blackFont.setFontHeightInPoints((short)12);
        StringBuffer sb = new StringBuffer("\u8bf4\u660e:");
        sb.append("\n").append("\u7cfb\u7edf\u6839\u636e\u7528\u6237\u5b9e\u540d\u81ea\u52a8\u5339\u914d\uff08\u5f53\u7c7b\u578b\u4e3a\u804c\u5458\u65f6\uff0c\u6839\u636e\u804c\u5458\u81ea\u52a8\u5339\u914d\uff09\uff1b").append("\n").append("\u8bf7\u68c0\u67e5\u6709\u5339\u914d\u81ea\u52a8\u5408\u5e76\u7684\u7528\u6237\uff0c\u8fc1\u79fb\u540e\u4fdd\u7559EAS\u8d26\u53f7\u548c\u7528\u6237\u72b6\u6001\uff0c\u4f7f\u7528EAS\u8d26\u53f7\u5bc6\u7801\u767b\u9646\uff0c\u5408\u5e76s-HR\u7684\u7ec4\u7ec7\u8303\u56f4\u548c\u529f\u80fd\u6743\u9650\uff1b").append("\n").append("\u8bf7\u68c0\u67e5\u4e0d\u8fc1\u79fb\u7684\u7528\u6237\uff0c\u9700\u8981\u5728\u8fc1\u79fb\u5b8c\u6210\u540e\u5728EAS\u76ee\u6807\u6570\u636e\u5e93\u4e2d\u624b\u52a8\u5904\u7406\uff1b").append("\n").append("\u8fc1\u79fb\u540e\u8bf7\u68c0\u67e5\u7528\u6237\u5173\u8054\u7684\u89d2\u8272\u53ca\u89d2\u8272\u6743\u9650\u3002");
        HSSFRichTextString richString = new HSSFRichTextString(sb.toString());
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackCellStyle(wb));
        adminCell.setCellValue((RichTextString)richString);
        adminRow.setHeight((short)2600);
        adminSheet.addMergedRegion(new CellRangeAddress(0, 0, 0, userItemMap.size() - 1));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 1, 0, 9));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 1, 10, 19));
        adminRow = adminSheet.createRow(1);
        for (int i = 0; i < 23; ++i) {
            adminCell = adminRow.createCell(i);
            adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        adminRow.setHeight((short)400);
        adminCell = adminRow.createCell(0);
        adminCell.setCellValue("s-HR");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminCell = adminRow.createCell(10);
        adminCell.setCellValue("EAS");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminCell = adminRow.createCell(20);
        adminCell.setCellValue("\u8fc1\u79fb\u65b9\u5f0f");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 20, 20));
        adminCell = adminRow.createCell(21);
        adminCell.setCellValue("\u7981\u7528\u72b6\u6001\u4e00\u81f4");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 21, 21));
        adminCell = adminRow.createCell(22);
        adminCell.setCellValue("\u8d26\u53f7\u91cd\u590d");
        adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        adminSheet.addMergedRegion(new CellRangeAddress(1, 2, 22, 22));
        adminRow = adminSheet.createRow(2);
        adminRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : userItemMap.keySet()) {
            adminCell = adminRow.createCell(itemCount++);
            adminCell.setCellValue(itemName.substring(3));
            if (itemName.substring(3).equals("\u7ec4\u7ec7\u957f\u540d\u79f0") || itemName.substring(3).equals("\u662f\u5426\u5c01\u5b58")) {
                adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getRedToYellowCellStyle(wb));
                continue;
            }
            adminCell.setCellStyle((CellStyle)ExcelExportDataHelpUtil.getBlackToYellowCellStyle(wb));
        }
        for (int i = 0; i < itemCount; ++i) {
            adminSheet.setColumnWidth(i, 6000);
        }
        UserMoveHandler userMove = new UserMoveHandler();
        userMove.exportUserExcle(shrConn, ctx, wb, adminSheet);
        String path = TEMP_DIR + ExcelExportDataHelpUtil.getUUID() + ".xls";
        FileOutputStream out = new FileOutputStream(path);
        wb.write((OutputStream)out);
        out.close();
        return path;
    }

    private static Map<String, Object[]> getUserItemMap() {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("shr\u7528\u6237\u8d26\u53f7", new Object[]{"shrNumber"});
        itemMap.put("shr\u7c7b\u578b", new Object[]{"shrName"});
        itemMap.put("shr\u7528\u6237\u5b9e\u540d", new Object[]{"shrLongNumber"});
        itemMap.put("shr\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"shrDisplayName"});
        itemMap.put("shr\u6240\u5c5e\u7528\u6237\u7ec4", new Object[]{"shrIsSealUp"});
        itemMap.put("shr\u6388\u6743\u6743", new Object[]{"shrId"});
        itemMap.put("shr\u8d26\u6237\u751f\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("shr\u8d26\u6237\u5931\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("shr\u5bc6\u7801\u751f\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("shr\u7981\u7528\u72b6\u6001", new Object[]{"easNumber"});
        itemMap.put("eas\u7528\u6237\u8d26\u53f7", new Object[]{"shrNumber"});
        itemMap.put("eas\u7c7b\u578b", new Object[]{"shrName"});
        itemMap.put("eas\u7528\u6237\u5b9e\u540d", new Object[]{"shrLongNumber"});
        itemMap.put("eas\u6240\u5c5e\u7ec4\u7ec7", new Object[]{"shrDisplayName"});
        itemMap.put("eas\u6240\u5c5e\u7528\u6237\u7ec4", new Object[]{"shrIsSealUp"});
        itemMap.put("eas\u6388\u6743\u6743", new Object[]{"shrId"});
        itemMap.put("eas\u8d26\u6237\u751f\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("eas\u8d26\u6237\u5931\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("eas\u5bc6\u7801\u751f\u6548\u65f6\u95f4", new Object[]{"easNumber"});
        itemMap.put("eas\u7981\u7528\u72b6\u6001", new Object[]{"easNumber"});
        itemMap.put("all\u8fc1\u79fb\u65b9\u5f0f", new Object[]{"isMatch"});
        itemMap.put("all\u7981\u7528\u72b6\u6001\u4e00\u81f4", new Object[]{"sealedState"});
        itemMap.put("all\u8d26\u53f7\u91cd\u590d", new Object[]{"numberRepeat"});
        return itemMap;
    }
}

