/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.csinterface.syncdatabase.InterfaceDataBaseException;
import com.kingdee.eas.hr.mvdt.util.ColumnInfo;
import com.kingdee.eas.hr.mvdt.util.TableColumnSyncTool;
import com.kingdee.jdbc.rowset.impl.JdbcRowSet;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class InsertTool {
    public static void commonInsert(Connection shrConn, String tableName, String condition, Context ctx, int rowNum) throws InterfaceDataBaseException, BOSException {
        InsertTool.commonInsert(shrConn, tableName, condition, ctx, rowNum, true);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void commonInsert(Connection shrConn, String tableName, String condition, Context ctx, int rowNum, boolean hasPrimaryKey) throws InterfaceDataBaseException, BOSException {
        Connection easConn2 = null;
        try {
            easConn2 = EJBFactory.getQueryConnection((Context)ctx);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<Object> primaryKeyList = new ArrayList();
        if (hasPrimaryKey && ((primaryKeyList = TableColumnSyncTool.getTablePrimaryKeyName(easConn2, tableName)) == null || primaryKeyList.isEmpty())) {
            hasPrimaryKey = false;
        }
        Connection easConn = null;
        ResultSet rs = null;
        Object rs2 = null;
        Statement stmt = null;
        Statement stmt2 = null;
        PreparedStatement pstmt = null;
        PreparedStatement dpstmt = null;
        tableName = tableName.toUpperCase();
        Map<String, ColumnInfo> ColumnMap = TableColumnSyncTool.getSHRTableColumnMap(ctx, tableName);
        Iterator<String> columns = ColumnMap.keySet().iterator();
        StringBuffer iSQL = new StringBuffer("insert into " + tableName + "(''");
        StringBuffer valuesSQL = new StringBuffer(" values(''");
        StringBuffer deleteSQL = new StringBuffer();
        if (hasPrimaryKey) {
            deleteSQL.append("delete " + tableName + " where ");
            for (int i = 0; i < primaryKeyList.size(); ++i) {
                deleteSQL.append((String)primaryKeyList.get(i) + "=?").append(" and ");
            }
            deleteSQL.delete(deleteSQL.length() - 4, deleteSQL.length());
        }
        String[] columnNames = new String[ColumnMap.size()];
        String[] columnTypes = new String[ColumnMap.size()];
        int i = 0;
        Iterator<Object> iterator = primaryKeyList.iterator();
        while (iterator.hasNext()) {
            String primaryKey;
            String columnName = primaryKey = (String)iterator.next();
            String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(ColumnMap.get(primaryKey));
            columnNames[i] = columnName.trim();
            columnTypes[i] = columnTypeName.trim();
            iSQL.append("," + primaryKey);
            valuesSQL.append(",?");
            ++i;
        }
        boolean isContainClob = false;
        while (columns.hasNext()) {
            String columnName = columns.next();
            String columnTypeName = TableColumnSyncTool.getTableColumnTypeName(ColumnMap.get(columnName));
            if ("CLOB".equals(columnTypeName.trim()) || "NCLOB".equals(columnTypeName.trim()) || "BLOB".equals(columnTypeName.trim()) || "text".equals(columnTypeName.trim()) || "ntext".equals(columnTypeName.trim())) {
                isContainClob = true;
            }
            if (primaryKeyList.contains(columnName)) continue;
            columnNames[i] = columnName.trim();
            columnTypes[i] = columnTypeName.trim();
            iSQL.append("," + columnName);
            valuesSQL.append(",?");
            ++i;
        }
        iSQL.append(")");
        valuesSQL.append(")");
        iSQL.append(valuesSQL);
        String insertSQL = iSQL.toString().replaceAll("'',", "");
        String selectSQL = "SELECT " + iSQL.substring(iSQL.indexOf(",") + 1, iSQL.indexOf(")")).toString() + " FROM " + tableName + " " + (condition != null ? condition : "");
        try {
            easConn = EJBFactory.getQueryConnection((Context)ctx);
            pstmt = easConn.prepareStatement(insertSQL);
            if (hasPrimaryKey) {
                dpstmt = easConn.prepareStatement(deleteSQL.toString());
            }
            String shrDbType = shrConn.getMetaData().getDatabaseProductName();
            String easDbType = easConn.getMetaData().getDatabaseProductName();
            stmt2 = easConn.createStatement();
            stmt = shrConn.createStatement();
            ResultSet rowset = stmt.executeQuery(selectSQL);
            if (isContainClob) {
                JdbcRowSet rsTmp = new JdbcRowSet();
                rsTmp.populate(rowset);
                rs = rsTmp;
                rowset.close();
            } else {
                rs = rowset;
            }
            int num = 0;
            while (true) {
                HashMap<String, String> kvMap;
                if (rs.next()) {
                    ++num;
                    kvMap = new HashMap<String, String>();
                    if (hasPrimaryKey) {
                        for (int pos = 0; pos < primaryKeyList.size(); ++pos) {
                            dpstmt.setString(pos + 1, rs.getString((String)primaryKeyList.get(pos)));
                        }
                        for (String string : primaryKeyList) {
                            kvMap.put(string, rs.getString(string));
                        }
                    }
                } else {
                    if (num % rowNum == 0) return;
                    if (dpstmt != null && easConn != null) {
                        dpstmt.executeBatch();
                        easConn.commit();
                        dpstmt.clearBatch();
                    }
                    if (pstmt == null) return;
                    if (easConn == null) return;
                    pstmt.executeBatch();
                    easConn.commit();
                    pstmt.clearBatch();
                    return;
                }
                for (int j = 0; j < columnTypes.length; ++j) {
                    StringReader reader;
                    StringReader reader2;
                    String value;
                    if (columnTypes[j].indexOf("CHAR") != -1) {
                        void var32_45;
                        Object var32_42 = null;
                        if (hasPrimaryKey && j < primaryKeyList.size()) {
                            String string = (String)kvMap.get(primaryKeyList.get(j));
                        } else {
                            String string = rs.getString(j + 1);
                        }
                        pstmt.setString(j + 1, (String)var32_45);
                        continue;
                    }
                    if ("DATE".equalsIgnoreCase(columnTypes[j]) || "datetime".equalsIgnoreCase(columnTypes[j])) {
                        pstmt.setDate(j + 1, rs.getDate(columnNames[j]));
                        continue;
                    }
                    if ("TIMESTAMP(6)".equalsIgnoreCase(columnTypes[j]) || "TIMESTAMP".equalsIgnoreCase(columnTypes[j])) {
                        pstmt.setTimestamp(j + 1, rs.getTimestamp(columnNames[j]));
                        continue;
                    }
                    if ("NUMBER".equalsIgnoreCase(columnTypes[j]) && 10 == ColumnMap.get(columnNames[j]).getPrecision() && 0 == ColumnMap.get(columnNames[j]).getScale() || "int".equalsIgnoreCase(columnTypes[j])) {
                        pstmt.setInt(j + 1, rs.getInt(columnNames[j]));
                        continue;
                    }
                    if ("NUMERIC".equalsIgnoreCase(columnTypes[j])) {
                        pstmt.setFloat(j + 1, rs.getFloat(columnNames[j]));
                        continue;
                    }
                    if ("NCLOB".equalsIgnoreCase(columnTypes[j]) || "CLOB".equalsIgnoreCase(columnTypes[j])) {
                        if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                            Clob clob = rs.getClob(columnNames[j]);
                            if (clob != null) {
                                value = clob.toString();
                                reader2 = new StringReader(value);
                                pstmt.setCharacterStream(j + 1, (Reader)reader2, value.length());
                                continue;
                            }
                            reader = new StringReader("");
                            pstmt.setCharacterStream(j + 1, (Reader)reader, 0);
                            continue;
                        }
                        String string = rs.getString(columnNames[j]);
                        if (string != null) {
                            reader = new StringReader(string);
                            pstmt.setCharacterStream(j + 1, (Reader)reader, string.length());
                            continue;
                        }
                        reader = new StringReader("");
                        pstmt.setCharacterStream(j + 1, (Reader)reader, 0);
                        continue;
                    }
                    if (!"BLOB".equalsIgnoreCase(columnTypes[j])) continue;
                    if ("Oracle".equals(shrDbType) && "Oracle".equals(easDbType)) {
                        Blob blob = rs.getBlob(columnNames[j]);
                        if (blob != null) {
                            value = blob.toString();
                            reader2 = new StringReader(value);
                            pstmt.setCharacterStream(j + 1, (Reader)reader2, value.length());
                            continue;
                        }
                        reader = new StringReader("");
                        pstmt.setCharacterStream(j + 1, (Reader)reader, 0);
                        continue;
                    }
                    String string = rs.getString(columnNames[j]);
                    if (string != null) {
                        pstmt.setBytes(j + 1, string.getBytes());
                        continue;
                    }
                    pstmt.setBytes(j + 1, null);
                }
                if (dpstmt != null) {
                    dpstmt.addBatch();
                }
                if (pstmt != null) {
                    pstmt.addBatch();
                }
                if (num % rowNum != 0) continue;
                if (dpstmt != null && easConn != null) {
                    dpstmt.executeBatch();
                    easConn.commit();
                    dpstmt.clearBatch();
                }
                if (pstmt == null || easConn == null) continue;
                pstmt.executeBatch();
                easConn.commit();
                pstmt.clearBatch();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                if (easConn != null) {
                    easConn.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
                if (shrConn == null) {
                    // empty if block
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

