/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.mvdt.util;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.query.PropertyRefCollection;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitCollection;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectCollection;
import com.kingdee.eas.hr.mvdt.DataMoveRecordInfo;
import com.kingdee.eas.hr.mvdt.util.StructureConfigConstant;
import com.kingdee.shr.base.syssetting.util.MetaDataUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StructureConfigUtils {
    public static boolean containsEntity(QueryInfo query, String fullName) {
        if (query != null) {
            SubObjectCollection coll = query.getSubObjects();
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                EntityObjectInfo entity = (EntityObjectInfo)coll.get(i).getStateManager().getStateValue("entityRef");
                if (entity == null || !StringUtils.equalsIgnoreCase((CharSequence)entity.getFullName(), (CharSequence)fullName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<Map<String, Object>> getMappingInfos(QueryInfo query, Map<String, String> mappingFields) {
        ArrayList<Map<String, Object>> mappingInfos = new ArrayList<Map<String, Object>>();
        if (query != null) {
            PropertyUnitCollection coll = query.getUnits();
            int total = coll.size();
            for (int i = 0; i < total; ++i) {
                PropertyUnitInfo propertyUnit = coll.get(i);
                PropertyRefCollection proRefColl = (PropertyRefCollection)propertyUnit.getStateManager().getStateValue("propertyRefs");
                if (proRefColl == null || proRefColl.isEmpty()) continue;
                PropertyRefInfo propertyRef = proRefColl.get(0);
                SubEntityInfo subEntity = (SubEntityInfo)propertyRef.getStateManager().getStateValue("subEntity");
                PropertyInfo refProperty = (PropertyInfo)propertyRef.getStateManager().getStateValue("refProperty");
                EntityObjectInfo sourceEntity = (EntityObjectInfo)subEntity.getStateManager().getStateValue("entityRef");
                String fieldFullName = sourceEntity.getFullName() + "." + refProperty.getName();
                if (mappingFields.get(fieldFullName) == null) continue;
                Map<String, Object> mappingInfo = StructureConfigUtils.getMappingInfo(fieldFullName, mappingFields.get(fieldFullName));
                mappingInfos.add(mappingInfo);
            }
        }
        return mappingInfos;
    }

    public static Map<String, Object> getMappingInfo(String sourceFieldFullName, String targetFieldFullName) {
        HashMap<String, Object> mappingInfo = new HashMap<String, Object>();
        String sourceEntityFullName = StructureConfigUtils.getEntityFullName(sourceFieldFullName);
        String targetEntityFullName = StructureConfigUtils.getEntityFullName(targetFieldFullName);
        String targetFieldName = StructureConfigUtils.getPropertyName(targetFieldFullName);
        Map<String, String> sourceNames = StructureConfigConstant.sourceNamesInit();
        Map<String, String> sourceAliases = StructureConfigConstant.sourceAilasesInit();
        HashMap<String, String> sourceEntity = new HashMap<String, String>();
        sourceEntity.put("name", sourceNames.get(sourceEntityFullName));
        sourceEntity.put("alias", sourceAliases.get(sourceEntityFullName));
        HashMap<String, String> sourceProperty = new HashMap<String, String>();
        sourceProperty.put("name", sourceNames.get(sourceFieldFullName));
        sourceProperty.put("alias", sourceAliases.get(sourceFieldFullName));
        EntityObjectInfo targetEntity = MetaDataUtil.getEntityObjectByEntityName((String)targetEntityFullName);
        PropertyInfo targetProperty = targetEntity.getPropertyByName(targetFieldName);
        mappingInfo.put("sourceEntityMap", sourceEntity);
        mappingInfo.put("sourcePropertyMap", sourceProperty);
        mappingInfo.put("targetEntity", targetEntity);
        mappingInfo.put("targetProperty", targetProperty);
        return mappingInfo;
    }

    public static String getEntityFullName(String fieldFullName) {
        return fieldFullName.substring(0, fieldFullName.lastIndexOf("."));
    }

    public static String getEntityPropertyName(String fieldFullName) {
        return fieldFullName.substring(fieldFullName.lastIndexOf(".", fieldFullName.lastIndexOf(".") - 1) + 1);
    }

    public static String getPropertyName(String fieldFullName) {
        return fieldFullName.substring(fieldFullName.lastIndexOf(".") + 1);
    }

    public static String getClassFullName(String entityFullName) {
        return entityFullName.substring(0, entityFullName.lastIndexOf(".", entityFullName.lastIndexOf(".") - 1)) + entityFullName.substring(entityFullName.lastIndexOf("."));
    }

    public static Map<String, Object> generateCheckRecord(String classify, String location, String number, String name, String remark) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("classify", classify != null ? classify : "");
        record.put("location", location != null ? location : "");
        record.put("number", number != null ? number : "");
        record.put("name", name != null ? name : "");
        record.put("remark", remark != null ? remark : "");
        return record;
    }

    public static DataMoveRecordInfo assemDataMoveRecord(String classify, String location, String number, String name, String remark) {
        DataMoveRecordInfo record = new DataMoveRecordInfo();
        record.setClassify(classify != null ? classify : "");
        record.setLocation(location != null ? location : "");
        record.setNumber(number != null ? number : "");
        record.setName(name != null ? name : "");
        record.setDiscription(remark != null ? remark : "");
        return record;
    }
}

