/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.LocaleUtils;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.hr.mvdt.handler.ExcelUtil;
import com.kingdee.shr.hr.mvdt.handler.SHREmpDbUtilTool;
import com.kingdee.shr.ml.util.BOSConfigUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class AdminDataExportHandler {
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";
    public static final String ADMINNAME = "\u884c\u653f\u7ec4\u7ec7";
    public static final String ISJURIDICALCOMPANY1 = "1";
    public static final String ISJURIDICALCOMPANY0 = "0";
    public static final String YES = "\u662f";
    public static final String NO = "\u5426";
    public static String NUMBER_NAME_SPLIT = "##";
    public static final int Oracle = 2;
    public static final int MS_SQL_Server = 3;
    public static final int Oracle9 = 7;
    public static final int Oracle10 = 8;

    public static String exportAdminAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            ServletOutputStream out = null;
            Map<String, Object[]> adminItemMap = AdminDataExportHandler.getAdminItemMap();
            byte[] bytes = AdminDataExportHandler.exportAdminTemplate(adminItemMap, request, response, modelMap, ctx);
            String fileName = "\u884c\u653f\u7ec4\u7ec7.xlsx";
            WebUtil.setFileResponseHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName);
            out = response.getOutputStream();
            out.write(bytes, 0, bytes.length);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Map<String, Object[]> getAdminItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7f16\u7801", new Object[]{"number"});
        List languageMapingList = BOSConfigUtil.getLanguageMapingList();
        if (languageMapingList.size() > 1) {
            for (Map lan : languageMapingList) {
                itemMap.put("\u884c\u653f\u7ec4\u7ec7\u540d\u79f0." + (String)lan.get("locale"), new Object[]{"name." + (String)lan.get("lang")});
            }
        } else {
            itemMap.put("\u884c\u653f\u7ec4\u7ec7\u540d\u79f0", new Object[]{"name"});
        }
        itemMap.put("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7", new Object[]{"parentNumberAndName"});
        itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b", new Object[]{"layerTypeName"});
        itemMap.put("\u884c\u653f\u7ec4\u7ec7\u7b80\u79f0", new Object[]{"simpleName"});
        itemMap.put("\u4e1a\u52a1\u677f\u5757", new Object[]{"orgPropertyNumber"});
        itemMap.put("\u884c\u653f\u7ec4\u7ec7\u804c\u80fd", new Object[]{"orgFunctionNumber"});
        itemMap.put("\u662f\u5426\u6cd5\u4eba\u516c\u53f8", new Object[]{"isJuridicalCompany"});
        itemMap.put("\u6cd5\u4eba\u4ee3\u8868", new Object[]{"personNumberAndName"});
        itemMap.put("\u767b\u8bb0\u6ce8\u518c\u7c7b\u578b", new Object[]{"registTypeNumber"});
        itemMap.put("\u6210\u7acb\u65e5\u671f", new Object[]{"setupDate"});
        itemMap.put("\u8425\u4e1a\u6709\u6548\u671f", new Object[]{"endupDate"});
        itemMap.put("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7", new Object[]{"taxNumber"});
        itemMap.put("\u57ce\u5e02", new Object[]{"cityNumber"});
        itemMap.put("\u4f01\u4e1a\u6027\u8d28", new Object[]{"enterpriseNatureNumber"});
        itemMap.put("\u884c\u4e1a", new Object[]{"industryNumberAndNumber"});
        itemMap.put("\u751f\u6548\u65e5\u671f", new Object[]{"EFFDT"});
        return itemMap;
    }

    private static byte[] exportAdminTemplate(Map<String, Object[]> adminItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Context ctx) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)wb);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setColor(IndexedColors.DARK_RED.getIndex());
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont((Font)font);
        XSSFSheet adminSheet = wb.createSheet(ADMINNAME);
        CellStyle textStyle = AdminDataExportHandler.textStyle((Workbook)wb);
        XSSFRow adminRow = null;
        Cell adminCell = null;
        adminRow = adminSheet.createRow(0);
        adminRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            adminCell = adminRow.createCell(itemCount++);
            adminCell.setCellValue(itemName);
            if (!itemName.equals("\u884c\u653f\u7ec4\u7ec7\u7f16\u7801") && !itemName.equals("\u884c\u653f\u7ec4\u7ec7\u540d\u79f0") && !itemName.contains("\u884c\u653f\u7ec4\u7ec7\u540d\u79f0.") && !itemName.equals("\u4e0a\u7ea7\u884c\u653f\u7ec4\u7ec7\u7f16\u7801") && !itemName.equals("\u884c\u653f\u7ec4\u7ec7\u7c7b\u578b")) continue;
            adminCell.setCellStyle(styles.get("mustInputHead"));
        }
        for (int i = 0; i < itemCount; ++i) {
            adminSheet.setColumnWidth(i, 4000);
            adminSheet.setDefaultColumnStyle(i, textStyle);
        }
        String countSql = "select count(1) count from t_org_admin";
        int pageSize = 5000;
        int totalNum = 0;
        int export_times = 0;
        int type = 0;
        Connection conn = null;
        String sql = "";
        int count = 0;
        IRowSet executeQuery = null;
        List languageMapingList = BOSConfigUtil.getLanguageMapingList();
        String l = LocaleUtils.getShortCode((Context)ctx);
        int m = languageMapingList.size() - 1;
        String multilingualSql = "";
        for (Map lan : languageMapingList) {
            multilingualSql = multilingualSql + "orgAdmin.fname_" + (String)lan.get("lang") + " as name_" + (String)lan.get("lang") + ",";
        }
        try {
            executeQuery = DbUtil.executeQuery((Context)ctx, (String)countSql);
            while (executeQuery.next()) {
                totalNum = executeQuery.getInt("count");
            }
            export_times = totalNum % pageSize > 0 ? totalNum / pageSize + 1 : totalNum / pageSize;
            conn = EJBFactory.getConnection((Context)ctx);
            type = KSqlUtil.getDbType((Connection)conn);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        if (type != 2 && type != 3 && type != 7 && type != 8) {
            export_times = 1;
        }
        for (int i = 1; i <= export_times; ++i) {
            if (type == 2 || type == 7 || type == 8) {
                sql = "SELECT * FROM (SELECT tableA.*,ROWNUM RN  FROM (SELECT orgAdmin.fnumber as number, " + multilingualSql + " parent.fnumber as parentNumber, parent.fname_" + l + " as parentName, layertype.fname_" + l + " as layerTypeName, orgAdmin.FSIMPLENAME as simpleName, orgAdmin.FISJURIDICALCOMPANY as isJuridicalCompany, person.FNUMBER as personNumber, person.fname_" + l + " as personName, orgAdmin.FSETUPDATE as setupDate, orgAdmin.FENDUPDATE as endupDate, orgAdmin.FTaxNumber as taxNumber, industry.fnumber as industryNumber, industry.fname_" + l + " as industryName, orgAdmin.FEFFECTDATE as EFFDT  FROM t_org_admin orgAdmin left join t_org_admin parent on parent.fid = orgAdmin.fparentid left join t_org_layertype layertype on layertype.fid = orgAdmin.flayertypeid left join t_bd_person person on person.fid = orgAdmin.fjuridicalpersonid left join T_BD_Industry industry on industry.fid = orgAdmin.findustryid ORDER BY orgAdmin.FNUMBER) tableA) WHERE RN >" + (i - 1) * pageSize + " AND RN <= " + i * pageSize;
                count = (i - 1) * pageSize;
            } else if (type == 3) {
                sql = "/*dialect*/SELECT * FROM( select *,row_number() over(order by number) rownumber FROM ( SELECT TOP " + i * pageSize + " * from ( SELECT orgAdmin.fnumber as number, " + multilingualSql + " parent.fnumber as parentNumber, parent.fname_" + l + " as parentName, layertype.fname_" + l + " as layerTypeName, orgAdmin.FSIMPLENAME as simpleName, orgAdmin.FISJURIDICALCOMPANY as isJuridicalCompany, person.FNUMBER as personNumber, person.fname_" + l + " as personName, orgAdmin.FSETUPDATE as setupDate, orgAdmin.FENDUPDATE as endupDate, orgAdmin.FTaxNumber as taxNumber, industry.fnumber as industryNumber, industry.fname_" + l + " as industryName, orgAdmin.FEFFECTDATE as EFFDT FROM t_org_admin orgAdmin left join t_org_admin parent on parent.fid = orgAdmin.fparentid left join t_org_layertype layertype on layertype.fid = orgAdmin.flayertypeid left join t_bd_person person on person.fid = orgAdmin.fjuridicalpersonid left join T_BD_Industry industry on industry.fid = orgAdmin.findustryid) AS tableA order by number) AS tableB ) AS tableC where rownumber>" + (i - 1) * pageSize;
                count = (i - 1) * pageSize;
            } else {
                sql = "SELECT orgAdmin.fnumber as number, " + multilingualSql + " parent.fnumber as parentNumber, parent.fname_" + l + " as parentName, layertype.fname_" + l + " as layerTypeName, orgAdmin.FSIMPLENAME as simpleName, orgAdmin.FISJURIDICALCOMPANY as isJuridicalCompany, person.FNUMBER as personNumber, person.fname_" + l + " as personName, orgAdmin.FSETUPDATE as setupDate, orgAdmin.FENDUPDATE as endupDate, orgAdmin.FTaxNumber as taxNumber, industry.fnumber as industryNumber, industry.fname_" + l + " as industryName, orgAdmin.FEFFECTDATE as EFFDT FROM t_org_admin orgAdmin left join t_org_admin parent on parent.fid = orgAdmin.fparentid left join t_org_layertype layertype on layertype.fid = orgAdmin.flayertypeid left join t_bd_person person on person.fid = orgAdmin.fjuridicalpersonid left join T_BD_Industry industry on industry.fid = orgAdmin.findustryid ORDER BY orgAdmin.FNUMBER";
                count = 0;
            }
            executeQuery = SHREmpDbUtilTool.executeQuery(ctx, sql);
            while (executeQuery.next()) {
                String number = executeQuery.getString("number");
                String parentNumber = executeQuery.getString("parentNumber");
                String parentName = executeQuery.getString("parentName");
                String parentNumberAndName = "";
                parentNumberAndName = StringUtils.isEmpty((String)parentNumber) ? parentName : (StringUtils.isEmpty((String)parentName) ? parentNumber : parentNumber + NUMBER_NAME_SPLIT + parentName);
                String layerTypeName = executeQuery.getString("layerTypeName");
                String simpleName = executeQuery.getString("simpleName");
                String isJuridicalCompany = executeQuery.getString("isJuridicalCompany");
                String personNumber = executeQuery.getString("personNumber");
                String personName = executeQuery.getString("personName");
                String personNumberAndName = "";
                personNumberAndName = StringUtils.isEmpty((String)personNumber) ? personName : (StringUtils.isEmpty((String)personName) ? personNumber : personNumber + NUMBER_NAME_SPLIT + personName);
                String setupDate = executeQuery.getString("setupDate");
                String endupDate = executeQuery.getString("endupDate");
                String taxNumber = executeQuery.getString("taxNumber");
                String industryNumber = executeQuery.getString("industryNumber");
                String industryName = executeQuery.getString("industryName");
                String industryNumberAndNumber = "";
                industryNumberAndNumber = StringUtils.isEmpty((String)industryNumber) ? industryName : (StringUtils.isEmpty((String)industryName) ? industryNumber : industryNumber + NUMBER_NAME_SPLIT + industryName);
                String EFFDT = executeQuery.getString("EFFDT");
                adminRow = adminSheet.createRow(1 + count);
                adminCell = adminRow.createCell(0);
                adminCell.setCellValue(number);
                adminCell.setCellStyle(textStyle);
                for (int j = 0; j < languageMapingList.size(); ++j) {
                    Map lan = (Map)languageMapingList.get(j);
                    adminCell = adminRow.createCell(1 + j);
                    adminCell.setCellValue(executeQuery.getString("name_" + (String)lan.get("lang")));
                    adminCell.setCellStyle(textStyle);
                }
                adminCell = adminRow.createCell(2 + m);
                adminCell.setCellValue(parentNumberAndName);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(3 + m);
                adminCell.setCellValue(layerTypeName);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(4 + m);
                adminCell.setCellValue(simpleName);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(5 + m);
                adminCell.setCellValue("");
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(6 + m);
                adminCell.setCellValue("");
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(7 + m);
                if (ISJURIDICALCOMPANY1.equals(isJuridicalCompany)) {
                    adminCell.setCellValue(YES);
                } else if (ISJURIDICALCOMPANY0.equals(isJuridicalCompany)) {
                    adminCell.setCellValue(NO);
                } else {
                    adminCell.setCellValue("");
                }
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(8 + m);
                adminCell.setCellValue(personNumberAndName);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(9 + m);
                adminCell.setCellValue("");
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(10 + m);
                if (!StringUtils.isEmpty((String)setupDate)) {
                    adminCell.setCellValue(setupDate.substring(0, 10));
                } else {
                    adminCell.setCellValue(setupDate);
                }
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(11 + m);
                if (!StringUtils.isEmpty((String)endupDate)) {
                    adminCell.setCellValue(endupDate.substring(0, 10));
                } else {
                    adminCell.setCellValue(endupDate);
                }
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(12 + m);
                adminCell.setCellValue(taxNumber);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(13 + m);
                adminCell.setCellValue("");
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(14 + m);
                adminCell.setCellValue("");
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(15 + m);
                adminCell.setCellValue(industryNumberAndNumber);
                adminCell.setCellStyle(textStyle);
                adminCell = adminRow.createCell(16 + m);
                if (!StringUtils.isEmpty((String)EFFDT)) {
                    adminCell.setCellValue(EFFDT.substring(0, 10));
                } else {
                    adminCell.setCellValue(EFFDT);
                }
                adminCell.setCellStyle(textStyle);
                ++count;
            }
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wb.write((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static CellStyle textStyle(Workbook wb) {
        CellStyle css = wb.createCellStyle();
        DataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        return css;
    }
}

