/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.alibaba.fastjson.JSONArray;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.ats.AttencePolicyCollection;
import com.kingdee.eas.hr.ats.AttencePolicyFactory;
import com.kingdee.eas.hr.ats.AttencePolicyInfo;
import com.kingdee.eas.hr.ats.AttendanceProjectCollection;
import com.kingdee.eas.hr.ats.AttendanceProjectFactory;
import com.kingdee.eas.hr.ats.AttendanceProjectInfo;
import com.kingdee.eas.hr.ats.DataTypeEnum;
import com.kingdee.eas.hr.ats.IAttencePolicy;
import com.kingdee.eas.hr.ats.OverTimeCompensCollection;
import com.kingdee.eas.hr.ats.OverTimeCompensFactory;
import com.kingdee.eas.hr.ats.OverTimeCompensInfo;
import com.kingdee.eas.hr.ats.util.AtsDateUtils;
import com.kingdee.eas.hr.ats.util.AtsDbUtil;
import com.kingdee.eas.hr.mvdt.util.ExcelExportUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ControlAttendanceDataMoveHandler
implements ISHRControlMoveDataHandler {
    public static String CalFormulanumber = "CalFormula";
    public static String HolidayRuleConditionNumber = "HolidayRuleCondition";
    public static String AtsOTEmploeeConditionNumber = "AtsOTEmployeCondition";
    public static final String EXPORT_COLUMN_NO = "no";
    public static final String EXPORT_COLUMN_NO_ALIAS = "\u5e8f\u53f7";
    public static final String EXPORT_COLUMN_MODULE = "module";
    public static final String EXPORT_COLUMN_MODULE_ALIAS = "\u9886\u57df";
    public static final String EXPORT_COLUMN_OPTION = "option";
    public static final String EXPORT_COLUMN_OPTION_ALIAS = "\u68c0\u67e5\u9879";
    public static final String EXPORT_COLUMN_DES = "des";
    public static final String EXPORT_COLUMN_DES_ALIAS = "\u68c0\u67e5\u9879\u63cf\u8ff0";
    public static final String EXPORT_COLUMN_RESULT = "result";
    public static final String EXPORT_COLUMN_RESULT_ALIAS = "\u68c0\u67e5\u7ed3\u679c";
    public static final String EXPORT_COLUMN_GUIDE = "guide";
    public static final String EXPORT_COLUMN_GUIDE_ALIAS = "\u4fee\u590d\u6307\u5bfc";

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        this.updateCalFormula(ctx);
        this.updateHolidayRuleCondition(ctx);
        this.updateAtsOTEmployeCondition(ctx);
        this.updateAttencePolicy(ctx);
        this.updateFileAndBURelation(ctx);
        this.updateAtsHolidayResultSum(ctx);
        return null;
    }

    public void updateCalFormula(Context ctx) throws EASBizException, BOSException, SQLException {
        SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, CalFormulanumber, "moving");
        String queryCalFormula = "select Fexpress,FListItem,FTableToConfigId,fid from T_HR_ATS_CalFormula";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)queryCalFormula);
            while (result.next()) {
                String fexpress = result.getString("Fexpress");
                String fListItem = result.getString("FListItem");
                String fTableToConfigId = result.getString("FTableToConfigId");
                String fid = result.getString("fid");
                String newFTableToConfigId = "";
                if (!fexpress.toLowerCase().contains("T_HR_PersonPosition".toLowerCase())) continue;
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FJobStartDate", "T_HR_PersonOtherInfo_FJobStartDate");
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FNewWorkTime", "T_HR_PersonOtherInfo_FSocialServiceYears");
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FRetireDate", "T_HR_PersonOtherInfo_FRetireDate");
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FEnterDate", "T_HR_PersonOtherInfo_FEnterDate");
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FTryoutMonth", "T_HR_PersonOtherInfo_FTryoutMonth");
                fexpress.replaceAll("(?i)T_HR_PersonPosition_FFormalDate", "T_HR_PersonOtherInfo_FFormalDate");
                if (fListItem.toLowerCase().contains("T_HR_PersonPosition".toLowerCase())) {
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FjobStartDate", "T_HR_PersonOtherInfo~FJobStartDate");
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FNewWorkTime", "T_HR_PersonOtherInfo~FSocialServiceYears");
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FRetireDate", "T_HR_PersonOtherInfo~FRetireDate");
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FEnterDate", "T_HR_EmpLaborRelation~FEnterDate");
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FTryoutMonth", "T_HR_EmpLaborRelation~FTryoutMonth");
                    fexpress.replaceAll("(?i)T_HR_PersonPosition~FFormalDate", "T_HR_EmpLaborRelation~FFormalDate");
                }
                if (fTableToConfigId.toLowerCase().contains("T_HR_PersonPosition".toLowerCase())) {
                    String[] fListItemArr = fListItem.split(";");
                    String[] fTableToConfigIdArr = fTableToConfigId.split(";");
                    int size = fListItemArr.length;
                    for (int i = 0; i < size; ++i) {
                        String ListItemTablename = fListItemArr[i].split("~")[1];
                        String configTableName = fTableToConfigIdArr[i];
                        newFTableToConfigId = newFTableToConfigId + configTableName.replaceAll(configTableName.substring(0, configTableName.indexOf("~")), ListItemTablename) + ";";
                    }
                    newFTableToConfigId.substring(0, newFTableToConfigId.length() - 1);
                } else {
                    newFTableToConfigId = fTableToConfigId;
                }
                String updateCalFormula = "update T_HR_ATS_CalFormula set Fexpress='" + fexpress + "', FListItem='" + fListItem + "', FTableToConfigId='" + newFTableToConfigId + "' where fid='" + fid + "'";
                DbUtil.execute((Context)ctx, (String)updateCalFormula);
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, CalFormulanumber, "finished");
        }
        catch (BOSException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, CalFormulanumber, "\u67e5\u8be2\u8003\u52e4\u516c\u5f0f\u5931\u8d25");
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, CalFormulanumber, "\u66f4\u65b0\u8003\u52e4\u516c\u5f0f\u5931\u8d25");
            throw e;
        }
    }

    public void updateHolidayRuleCondition(Context ctx) throws EASBizException, BOSException, SQLException {
        SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, HolidayRuleConditionNumber, "moving");
        String HolidayRuleCondition = "select fconfig,fid from T_HR_ATS_HolidayRuleCondition";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)HolidayRuleCondition);
            while (result.next()) {
                String fconfig = result.getString("fconfig");
                String fid = result.getString("fid");
                if (!fconfig.toLowerCase().contains("PersonPosition".toLowerCase())) continue;
                fconfig.replaceAll("(?i)PersonPosition.jobStartDate", "PersonOtherInfo.jobStartDate");
                fconfig.replaceAll("(?i)PersonPosition.newWorkTime", "PersonOtherInfo.socialServiceYears");
                fconfig.replaceAll("(?i)PersonPosition.retireDate", "PersonOtherInfo.retireDate");
                fconfig.replaceAll("(?i)PersonPosition.enterDate", "PersonOtherInfo.enterDate");
                fconfig.replaceAll("(?i)PersonPosition.tryoutMonth", "PersonOtherInfo.tryoutMonth");
                fconfig.replaceAll("(?i)PersonPosition.formalDate", "PersonOtherInfo.formalDate");
                String updateCalFormula = "update T_HR_ATS_HolidayRuleCondition set fconfig='" + fconfig + "' where fid='" + fid + "'";
                DbUtil.execute((Context)ctx, (String)updateCalFormula);
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, HolidayRuleConditionNumber, "finished");
        }
        catch (BOSException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, HolidayRuleConditionNumber, "\u67e5\u8be2\u8003\u52e4\u989d\u5ea6\u89c4\u5219\u5931\u8d25");
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, HolidayRuleConditionNumber, "\u66f4\u65b0\u8003\u52e4\u989d\u5ea6\u89c4\u5219\u5931\u8d25");
            throw e;
        }
    }

    public void updateAtsOTEmployeCondition(Context ctx) throws EASBizException, BOSException, SQLException {
        SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, AtsOTEmploeeConditionNumber, "moving");
        String queryAtsOTEmploeeCondition = "select fconfig,fid from T_ATS_AtsOTEmploeeCondition";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)queryAtsOTEmploeeCondition);
            while (result.next()) {
                String fconfig = result.getString("fconfig");
                String fid = result.getString("fid");
                if (!fconfig.toLowerCase().contains("PersonPosition".toLowerCase())) continue;
                fconfig.replaceAll("(?i)PersonPosition.jobStartDate", "PersonOtherInfo.jobStartDate");
                fconfig.replaceAll("(?i)PersonPosition.newWorkTime", "PersonOtherInfo.socialServiceYears");
                fconfig.replaceAll("(?i)PersonPosition.retireDate", "PersonOtherInfo.retireDate");
                fconfig.replaceAll("(?i)PersonPosition.enterDate", "PersonOtherInfo.enterDate");
                fconfig.replaceAll("(?i)PersonPosition.tryoutMonth", "PersonOtherInfo.tryoutMonth");
                fconfig.replaceAll("(?i)PersonPosition.formalDate", "PersonOtherInfo.formalDate");
                String updateCalFormula = "update T_ATS_AtsOTEmploeeCondition set fconfig='" + fconfig + "' where fid='" + fid + "'";
                DbUtil.execute((Context)ctx, (String)updateCalFormula);
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, AtsOTEmploeeConditionNumber, "finished");
        }
        catch (BOSException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, AtsOTEmploeeConditionNumber, "\u67e5\u8be2\u8003\u52e4\u4e2a\u4eba\u989d\u5ea6\u65b9\u6848\u5931\u8d25");
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            SHRControlMoveDataHelpUtil.updateTableMoveExceptionByClassifyNumber(ctx, AtsOTEmploeeConditionNumber, "\u66f4\u65b0\u8003\u52e4\u4e2a\u4eba\u989d\u5ea6\u65b9\u6848\u8868\u5931\u8d25");
            throw e;
        }
    }

    public void updateAttencePolicy(Context ctx) {
        String hrOrgUnitId = "00000000-0000-0000-0000-000000000000CCE7AED4";
        StringBuffer availableOverTimeCompensStr = new StringBuffer();
        OverTimeCompensInfo defaultOverTimeCompens = null;
        try {
            OverTimeCompensCollection defaultColl = OverTimeCompensFactory.getLocalInstance((Context)ctx).getOverTimeCompensCollection("where hrOrgUnit.id = '" + hrOrgUnitId + "' and isDefault = 1");
            if (defaultColl.size() > 0) {
                defaultOverTimeCompens = defaultColl.get(0);
            }
            String availableSql = "SELECT FbaseInfoId from T_ATS_AtsOTCompensAvailable where FHROrgUseID = '" + hrOrgUnitId + "' and Fstate = 100 ";
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)availableSql);
            try {
                while (result.next()) {
                    availableOverTimeCompensStr.append(result.getString("FbaseInfoId"));
                    availableOverTimeCompensStr.append(",");
                }
                if (availableOverTimeCompensStr.length() > 0) {
                    availableOverTimeCompensStr.deleteCharAt(availableOverTimeCompensStr.length() - 1);
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            IAttencePolicy iAttencePolicy = AttencePolicyFactory.getLocalInstance((Context)ctx);
            AttencePolicyCollection coll = iAttencePolicy.getAttencePolicyCollection();
            CoreBaseCollection updateColl = new CoreBaseCollection();
            for (int i = 0; i < coll.size(); ++i) {
                AttencePolicyInfo info = coll.get(i);
                info.setOtCompens1(availableOverTimeCompensStr.toString());
                info.setOtCompens2(availableOverTimeCompensStr.toString());
                info.setOtCompens3(availableOverTimeCompensStr.toString());
                info.setDefaultotCompens1(defaultOverTimeCompens);
                info.setDefaultotCompens2(defaultOverTimeCompens);
                info.setDefaultotCompens3(defaultOverTimeCompens);
                updateColl.add((CoreBaseInfo)info);
            }
            if (updateColl.size() > 0) {
                iAttencePolicy.update(updateColl);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
    }

    public void updateFileAndBURelation(Context ctx) {
        String today = AtsDateUtils.dateShortToString((Date)new Date());
        String sql = " UPDATE T_HR_PersonBURelation  SET FState = 1,  FItemState = 2,  FBeginDate = {TS '" + today + "'} WHERE  \tFID IN (  \t\tSELECT  \t\t\tbuRela.FID  \t\tFROM  \t\t\tT_HR_PersonBURelation buRela  \t\tLEFT JOIN T_HR_ATS_ATTENDANCEFILE attfile ON attfile.fproposerid = buRela.fpersonid  \t\tLEFT JOIN T_HR_EmpOrgRelation emp ON emp.fid = buRela.FEMPORGRELATIONID  \t\tWHERE  \t\t\tbuRela.fbizmanagetypeid = 'a1XVAx7aQEiqGkQqicFzfmWJ1dE='  \t\tAND attfile.fpositionId = emp.fpositionid  \t\tAND attfile.FMANAGERELATIONID IS NULL  \t)";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        sql = " UPDATE T_HR_ATS_ATTENDANCEFILE  SET FMANAGERELATIONID = (  SELECT  min(T_HR_PersonBURelation.fid)  FROM  T_HR_PersonBURelation  LEFT JOIN T_HR_EmpOrgRelation ON T_HR_EmpOrgRelation.fid = T_HR_PersonBURelation.FEMPORGRELATIONID  WHERE  T_HR_PersonBURelation.fbizmanagetypeid = 'a1XVAx7aQEiqGkQqicFzfmWJ1dE='  AND T_HR_ATS_ATTENDANCEFILE.fproposerId = T_HR_PersonBURelation.fpersonid  AND T_HR_ATS_ATTENDANCEFILE.fpositionId = T_HR_EmpOrgRelation.fpositionid  )  WHERE  FMANAGERELATIONID IS NULL";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        sql = " UPDATE T_HR_PersonBURelation  SET FState = 1,   FItemState = 2,  FBeginDate = {TS '" + today + "'} WHERE  \tFID IN (  \t\tSELECT  \t\t\tbuRela.FID  \t\tFROM  \t\t\tT_HR_PersonBURelation buRela  \t\tLEFT JOIN T_HR_ATS_AtsHolidayFile attfile ON attfile.fproposerid = buRela.fpersonid  \t\tLEFT JOIN T_HR_EmpOrgRelation emp ON emp.fid = buRela.FEMPORGRELATIONID  \t\tWHERE  \t\t\tbuRela.fbizmanagetypeid = 'WMwl/vtBvkmbWdGELoP6Y2WJ1dE='  \t\tAND attfile.fpositionId = emp.fpositionid  \t\tAND attfile.FMANAGERELATIONID IS NULL  \t)";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        sql = " UPDATE T_HR_ATS_AtsHolidayFile  SET FMANAGERELATIONID = (  SELECT  min(T_HR_PersonBURelation.fid)  FROM  T_HR_PersonBURelation  LEFT JOIN T_HR_EmpOrgRelation ON T_HR_EmpOrgRelation.fid = T_HR_PersonBURelation.FEMPORGRELATIONID  WHERE  T_HR_PersonBURelation.fbizmanagetypeid = 'WMwl/vtBvkmbWdGELoP6Y2WJ1dE='  AND T_HR_ATS_AtsHolidayFile.fproposerId = T_HR_PersonBURelation.fpersonid  AND T_HR_ATS_AtsHolidayFile.fpositionId = T_HR_EmpOrgRelation.fpositionid  )  WHERE  FMANAGERELATIONID IS NULL";
        try {
            DbUtil.execute((Context)ctx, (String)sql);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    public void updateAtsHolidayResultSum(Context ctx) {
        try {
            AttendanceProjectCollection coll = AttendanceProjectFactory.getLocalInstance((Context)ctx).getAttendanceProjectCollection("where projectCategory.id = '0JqnV+VmTDWn8G6u2XuV6slQZlY=' and isInternal = 2 ");
            for (int i = 0; i < coll.size(); ++i) {
                AttendanceProjectInfo info = coll.get(i);
                String columnName = "S" + info.getColumnNO();
                AtsDbUtil.addTableColumn((String)"T_ATS_HolidayResultSum", (String)columnName, (DataTypeEnum)info.getDataType(), (Context)ctx);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        int checkProgress = 0;
        int passProgress = 0;
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ATTCHECK", checkProgress, passProgress);
        int checkTotalNum = 4;
        if (ControlAttendanceDataMoveHandler.checkDuplcateFile(ctx, "T_HR_ATS_AttendanceFile")) {
            ++passProgress;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ATTCHECK", ++checkProgress * 100 / checkTotalNum, passProgress * 100 / checkTotalNum);
        if (ControlAttendanceDataMoveHandler.checkDuplcateHisFile(ctx, "T_HR_ATS_AttendanceFileHis")) {
            ++passProgress;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ATTCHECK", ++checkProgress * 100 / checkTotalNum, passProgress * 100 / checkTotalNum);
        if (ControlAttendanceDataMoveHandler.checkDuplcateFile(ctx, "T_HR_ATS_AtsHolidayFile")) {
            ++passProgress;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ATTCHECK", ++checkProgress * 100 / checkTotalNum, passProgress * 100 / checkTotalNum);
        if (ControlAttendanceDataMoveHandler.checkDuplcateHisFile(ctx, "T_HR_ATS_AtsHolidayFileHis")) {
            ++passProgress;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "ATTCHECK", ++checkProgress * 100 / checkTotalNum, passProgress * 100 / checkTotalNum);
    }

    public static boolean checkDuplcateFile(Context ctx, String tableName) {
        boolean isPass = true;
        String availableSql = "SELECT Fname_l2,FNumber FROM T_bd_person where fid in (SELECT FproposerID from " + tableName + " GROUP BY FproposerID HAVING COUNT(*)>1)";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)availableSql);
            if (result.size() > 0) {
                isPass = false;
            }
            while (result.next()) {
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPass;
    }

    public static boolean checkDuplcateHisFile(Context ctx, String tableName) {
        boolean isPass = true;
        String availableSql = "SELECT Fname_l2,FNumber FROM T_bd_person where fid in (\r\nSELECT DISTINCT FproposerID FROM " + tableName + " t\r\nWHERE EXISTS (\r\n\t\tSELECT 1 FROM ( SELECT FID,FproposerID,Feffdt,fleffdt FROM " + tableName + " ) TEMP\r\n\t\tWHERE\r\n\t\t\tTEMP.FproposerID = t.FproposerID\r\n\t\tAND TEMP.Feffdt <= t.FLeffdt\r\n\t\tAND TEMP.FLeffdt >= t.Feffdt\r\n\t\tAND TEMP.FID <> t.FID\r\n\t)\r\n)";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)availableSql);
            if (result.size() > 0) {
                isPass = false;
            }
            while (result.next()) {
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPass;
    }

    public static List<Map<String, String>> getDuplcateFile(Context ctx, String tableName) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String availableSql = "SELECT Fname_l2,FNumber FROM T_bd_person where fid in (SELECT FproposerID from " + tableName + " GROUP BY FproposerID HAVING COUNT(*)>1)";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)availableSql);
            while (result.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", result.getString("Fname_l2"));
                map.put("number", result.getString("FNumber"));
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<Map<String, String>> getDuplcateHisFile(Context ctx, String tableName) {
        ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
        String availableSql = "SELECT Fname_l2,FNumber FROM T_bd_person where fid in (\r\nSELECT DISTINCT FproposerID FROM " + tableName + " t\r\nWHERE EXISTS (\r\n\t\tSELECT 1 FROM ( SELECT FID,FproposerID,Feffdt,fleffdt FROM " + tableName + " ) TEMP\r\n\t\tWHERE\r\n\t\t\tTEMP.FproposerID = t.FproposerID\r\n\t\tAND TEMP.Feffdt <= t.FLeffdt\r\n\t\tAND TEMP.FLeffdt >= t.Feffdt\r\n\t\tAND TEMP.FID <> t.FID\r\n\t)\r\n)";
        try {
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)availableSql);
            while (result.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", result.getString("Fname_l2"));
                map.put("number", result.getString("FNumber"));
                list.add(map);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static SXSSFWorkbook getCheckReport(Context ctx) throws BOSException {
        Map<String, Object> record;
        Map<String, String> map;
        int i;
        JSONArray recordArray = new JSONArray();
        List<Map<String, String>> duplcateFileAtt = ControlAttendanceDataMoveHandler.getDuplcateFile(ctx, "T_HR_ATS_AttendanceFile");
        List<Map<String, String>> duplcateFileHol = ControlAttendanceDataMoveHandler.getDuplcateFile(ctx, "T_HR_ATS_AtsHolidayFile");
        List<Map<String, String>> duplcateHisFileAtt = ControlAttendanceDataMoveHandler.getDuplcateHisFile(ctx, "T_HR_ATS_AttendanceFileHis");
        List<Map<String, String>> duplcateHisFileHol = ControlAttendanceDataMoveHandler.getDuplcateHisFile(ctx, "T_HR_ATS_AtsHolidayFileHis");
        int total = duplcateFileAtt.size();
        for (i = 0; i < total; ++i) {
            map = duplcateFileAtt.get(i);
            record = ControlAttendanceDataMoveHandler.generateCheckRecord(String.valueOf(i), "\u8003\u52e4", "\u8003\u52e4\u6863\u6848", "", "\u5458\u5de5 " + map.get("name") + "(" + map.get("number") + ")\u7684\u8003\u52e4\u6863\u6848\u91cd\u590d", "");
            recordArray.add(record);
        }
        total = duplcateFileHol.size();
        for (i = 0; i < total; ++i) {
            map = duplcateFileHol.get(i);
            record = ControlAttendanceDataMoveHandler.generateCheckRecord(String.valueOf(i), "\u5047\u671f", "\u5047\u671f\u6863\u6848", "", "\u5458\u5de5 " + map.get("name") + "(" + map.get("number") + ")\u7684\u5047\u671f\u6863\u6848\u91cd\u590d", "");
            recordArray.add(record);
        }
        total = duplcateHisFileAtt.size();
        for (i = 0; i < total; ++i) {
            map = duplcateHisFileAtt.get(i);
            record = ControlAttendanceDataMoveHandler.generateCheckRecord(String.valueOf(i), "\u8003\u52e4", "\u8003\u52e4\u6863\u6848\u5386\u53f2", "", "\u5458\u5de5 " + map.get("name") + "(" + map.get("number") + ")\u7684\u8003\u52e4\u6863\u6848\u5386\u53f2\u6709\u4ea4\u53c9", "");
            recordArray.add(record);
        }
        total = duplcateHisFileHol.size();
        for (i = 0; i < total; ++i) {
            map = duplcateHisFileHol.get(i);
            record = ControlAttendanceDataMoveHandler.generateCheckRecord(String.valueOf(i), "\u5047\u671f", "\u5047\u671f\u6863\u6848\u5386\u53f2", "", "\u5458\u5de5 " + map.get("name") + "(" + map.get("number") + ")\u7684\u5047\u671f\u6863\u6848\u5386\u53f2\u6709\u4ea4\u53c9", "");
            recordArray.add(record);
        }
        ArrayList<LinkedHashMap<String, String>> titleList = new ArrayList<LinkedHashMap<String, String>>();
        LinkedHashMap<String, String> titleMap = new LinkedHashMap<String, String>();
        titleMap.put("title1", "\u8003\u52e4\u6a21\u5757\u6570\u636e\u68c0\u67e5\u62a5\u544a");
        titleMap.put("title2", "");
        LinkedHashMap<String, String> headMap = new LinkedHashMap<String, String>();
        headMap.put(EXPORT_COLUMN_NO, EXPORT_COLUMN_NO_ALIAS);
        headMap.put(EXPORT_COLUMN_MODULE, EXPORT_COLUMN_MODULE_ALIAS);
        headMap.put(EXPORT_COLUMN_OPTION, EXPORT_COLUMN_OPTION_ALIAS);
        headMap.put(EXPORT_COLUMN_DES, EXPORT_COLUMN_DES_ALIAS);
        headMap.put(EXPORT_COLUMN_RESULT, EXPORT_COLUMN_RESULT_ALIAS);
        headMap.put(EXPORT_COLUMN_GUIDE, EXPORT_COLUMN_GUIDE_ALIAS);
        titleList.add(titleMap);
        titleList.add(headMap);
        return ExcelExportUtil.exportExcel(titleList, recordArray);
    }

    public static Map<String, Object> generateCheckRecord(String no, String module, String option, String des, String result, String guide) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put(EXPORT_COLUMN_NO, no != null ? no : "");
        record.put(EXPORT_COLUMN_MODULE, module != null ? module : "");
        record.put(EXPORT_COLUMN_OPTION, option != null ? option : "");
        record.put(EXPORT_COLUMN_DES, des != null ? des : "");
        record.put(EXPORT_COLUMN_RESULT, result != null ? result : "");
        record.put(EXPORT_COLUMN_GUIDE, guide != null ? guide : "");
        return record;
    }
}

