/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.classloader.MsfClassLoaderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.hr.mvdt.handler.ISHRControlMoveDataHandler;
import com.kingdee.shr.hr.mvdt.handler.cmp.CmpMoveExecutor;
import com.kingdee.shr.hr.mvdt.handler.cmp.CmpMoveHelper;
import com.kingdee.shr.hr.mvdt.handler.cmp.io.StyleUtil;
import com.kingdee.shr.hr.mvdt.util.SHRControlMoveDataHelpUtil;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class ControlCompensationDataMoveHandler
implements ISHRControlMoveDataHandler {
    private static final String CONTACT_SEPARATE = "###";
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";

    @Override
    public String moveData(Context ctx) throws BOSException, EASBizException, SQLException {
        return this.execute(ctx, "execute");
    }

    @Override
    public String beforeMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        String resultError = "";
        boolean isExistCmpStructureErrorData = false;
        String checkCmpStructure = "SELECT \r\ntmp.count count\r\nFROM \r\n(SELECT count(FPERSONID) count,FPERSONID person,FCMPITEMID cmpitem,FEFFECTDAY effectday FROM T_HR_SFixAdjustSalary group by FPERSONID,FCMPITEMID,FEFFECTDAY ) tmp\r\nwhere tmp.count > 1";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkCmpStructure);
        if (executeQuery.size() > 0) {
            isExistCmpStructureErrorData = true;
        }
        if (isExistCmpStructureErrorData) {
            resultError = "\u5b58\u5728\u3010\u540c\u4e00\u4e2a\u4eba\u540c\u4e00\u4e2a\u85aa\u916c\u9879\u76ee\u540c\u4e00\u4e2a\u751f\u6548\u65e5\u671f\u5b58\u5728\u4e24\u6761\u6216\u591a\u6761\u85aa\u916c\u7ed3\u6784\u6570\u636e\u3011<a href='javascript:void(0)' id = 'cmpBeforeMoveCheckReport'>\u67e5\u770b\u68c0\u67e5\u62a5\u544a</a>";
        }
        return resultError;
    }

    @Override
    public ArrayList<HashMap<String, String>> exportFinishedReport(Context ctx) throws BOSException, EASBizException, SQLException {
        return null;
    }

    private String execute(Context ctx, String method) throws BOSException, EASBizException {
        Class<?> clazz;
        int i;
        ArrayList<CmpMoveExecutor> exeList = new ArrayList<CmpMoveExecutor>();
        List<String> classNameList = CmpMoveHelper.getExecutorCalssFullName();
        int size = classNameList.size();
        for (i = 0; i < size; ++i) {
            try {
                clazz = MsfClassLoaderFactory.forName((String)classNameList.get(i));
                try {
                    if (!clazz.getClass().isInstance(CmpMoveExecutor.class)) continue;
                    exeList.add((CmpMoveExecutor)clazz.newInstance());
                    continue;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    throw new BOSException(e.getMessage());
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
        }
        Collections.sort(exeList);
        size = exeList.size();
        for (i = 0; i < size; ++i) {
            clazz = ((CmpMoveExecutor)exeList.get(i)).getClass();
            Method m = null;
            try {
                m = clazz.getMethod(method, ctx.getClass());
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            catch (SecurityException e) {
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            if (null == m) continue;
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, clazz.getSimpleName(), "moving");
            try {
                m.invoke(exeList.get(i), ctx);
            }
            catch (IllegalAccessException e) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, clazz.getSimpleName(), "failed");
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            catch (IllegalArgumentException e) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, clazz.getSimpleName(), "failed");
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, clazz.getSimpleName(), "failed");
                e.printStackTrace();
                throw new BOSException(e.getMessage());
            }
            SHRControlMoveDataHelpUtil.updateMoveStateByMvClassify(ctx, clazz.getSimpleName(), "finished");
        }
        return null;
    }

    @Override
    public void afterMoveCheck(Context ctx) throws BOSException, EASBizException, SQLException {
        this.checkCalSchemeCalTable(ctx);
        String[] tableArr = new String[]{"T_HR_SPersonCmp", "T_HR_SSocPersonRecord", "T_HR_SAdjustPersonRecord"};
        int time = 0;
        for (String tableName : tableArr) {
            this.checkCmpSocAdjPersonRecord(ctx, "CMPCHECK", tableName, ++time);
        }
    }

    public String exportDataCheckReportAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            String[] tableArr;
            Context ctx = SHRContext.getInstance().getContext();
            XSSFWorkbook wb = new XSSFWorkbook();
            Map<String, CellStyle> styles = StyleUtil.createStyles((Workbook)wb);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setColor(IndexedColors.DARK_RED.getIndex());
            font.setFontHeightInPoints((short)12);
            cellStyle.setWrapText(true);
            cellStyle.setFont((Font)font);
            this.exportCalSchemeCheckData(ctx, wb, styles);
            for (String tableName : tableArr = new String[]{"T_HR_SPersonCmp", "T_HR_SSocPersonRecord", "T_HR_SAdjustPersonRecord"}) {
                this.exportCmpSocAdjCheckData(ctx, wb, styles, tableName);
            }
            String path = TEMP_DIR + UUID.randomUUID().toString() + ".xlsx";
            FileOutputStream out = new FileOutputStream(path);
            wb.write((OutputStream)out);
            out.close();
            this.setExportExcelHead(response, path, "\u85aa\u916c\u6570\u636e\u68c0\u67e5\u62a5\u544a");
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    private void exportCalSchemeCheckData(Context ctx, XSSFWorkbook wb, Map<String, CellStyle> styles) throws BOSException, SQLException {
        LinkedHashMap<String, Object[]> calSchemeMap = new LinkedHashMap<String, Object[]>();
        calSchemeMap.put("\u5e8f\u53f7", new Object[]{"index"});
        calSchemeMap.put("\u8ba1\u7b97\u89c4\u5219", new Object[]{"calScheme"});
        calSchemeMap.put("\u7edf\u8ba1\u5e74", new Object[]{"periodYear"});
        calSchemeMap.put("\u7edf\u8ba1\u6708", new Object[]{"periodMonth"});
        calSchemeMap.put("\u6838\u7b97\u6b21\u6570", new Object[]{"calTime"});
        calSchemeMap.put("\u6838\u7b97\u5458\u5de5", new Object[]{"personRecords"});
        calSchemeMap.put("\u6570\u636e\u63cf\u8ff0", new Object[]{"errorDescription"});
        calSchemeMap.put("\u4fee\u6539\u5efa\u8bae", new Object[]{"fixAdvice"});
        String calSchemeSheetName = "\u85aa\u916c\u6838\u7b97\u72b6\u6001\u6570\u636e";
        String calSchemeQuerySql = "SELECT \r\ncalScheme.FNAME_L2 calSchemeName,\r\ncalScheme.FPERIODYEAR periodYear,\r\ncalScheme.FPERIODMONTH periodMonth,\r\ncalScheme.FCALTIME calTime,\r\ncmpCalTable.FCALSTATE calState,\r\nperson.FNAME_L2 personName,\r\nperson.FNUMBER personNumber \r\n FROM T_HR_SCmpCalTable cmpCalTable\r\nINNER JOIN T_HR_SCalScheme calScheme on calScheme.FID = cmpCalTable.FCALSCHEMEID and calScheme.FPERIODYEAR = cmpCalTable.FPERIODYEAR and calScheme.FPERIODMONTH = cmpCalTable.FPERIODMONTH and calScheme.FCALTIME = cmpCalTable.FCALTIME \r\nINNER JOIN T_BD_Person person on cmpCalTable.FPERSONID = person.FID \r\nwhere calScheme.FCALSTATE = 12 and cmpCalTable.FCALSTATE < 12";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)calSchemeQuerySql);
        if (executeQuery.size() > 0) {
            XSSFSheet calSchemeSheet = this.createSheet(ctx, wb, calSchemeSheetName, calSchemeMap, styles);
            XSSFRow row = null;
            Cell cell = null;
            int count = 0;
            int index = 0;
            int periodYear = 0;
            int periodMonth = 0;
            int calTime = 0;
            String personNumber = "";
            String personName = "";
            String calSchemeName = "";
            String errorDescription = "";
            String personRecords = "";
            String errorMessageFormat = "\u5df2\u5ba1\u6279\u7684\u8ba1\u7b97\u89c4\u5219\u3010{0}\u3011\u5728\u3010{1}\u3011\u5e74\u3010{2}\u3011\u6708\u3010{3}\u3011\u6b21\u4e2d\u5b58\u5728\u4ee5\u4e0b\u3010{4}\u3011{5}\u540d\u5458\u5de5\u7684\u6838\u7b97\u72b6\u6001\u4e0d\u662f\u5df2\u5ba1\u6279\uff01";
            LinkedHashMap calSchemeCalTableMap = new LinkedHashMap();
            String calSchemeCalTableMapKey = "";
            String fixAdvice = "\u91cd\u65b0\u8c03\u6574\u6838\u7b97\u5458\u5de5\u660e\u7ec6\u72b6\u6001\u3002\u64cd\u4f5c\u8def\u5f84\uff1a\u85aa\u916c\u6838\u7b97-\u85aa\u916c\u6838\u7b97\u5411\u5bfc-\u85aa\u916c\u53d1\u653e\u5217\u8868";
            while (executeQuery.next()) {
                List<String> calSchemeCalTableMapValue = new ArrayList();
                calSchemeName = this.getExeValue(executeQuery.getString("calSchemeName"));
                personNumber = this.getExeValue(executeQuery.getString("personNumber"));
                personName = this.getExeValue(executeQuery.getString("personName"));
                periodYear = executeQuery.getInt("periodYear");
                periodMonth = executeQuery.getInt("periodMonth");
                calTime = executeQuery.getInt("calTime");
                calSchemeCalTableMapKey = calSchemeName + CONTACT_SEPARATE + periodYear + CONTACT_SEPARATE + periodMonth + CONTACT_SEPARATE + calTime;
                if (calSchemeCalTableMap.containsKey(calSchemeCalTableMapKey)) {
                    calSchemeCalTableMapValue = (List)calSchemeCalTableMap.get(calSchemeCalTableMapKey);
                }
                personRecords = personName + "\uff08" + personNumber + "\uff09";
                calSchemeCalTableMapValue.add(personRecords);
                calSchemeCalTableMap.put(calSchemeCalTableMapKey, calSchemeCalTableMapValue);
            }
            for (String key : calSchemeCalTableMap.keySet()) {
                row = calSchemeSheet.createRow(1 + count);
                String[] keyList = key.split(CONTACT_SEPARATE);
                calSchemeName = keyList[0];
                periodYear = Integer.parseInt(keyList[1]);
                periodMonth = Integer.parseInt(keyList[2]);
                calTime = Integer.parseInt(keyList[3]);
                personRecords = ((List)calSchemeCalTableMap.get(key)).toString();
                cell = row.createCell(0);
                index = count + 1;
                cell.setCellValue((double)index);
                cell = row.createCell(1);
                cell.setCellValue(calSchemeName);
                cell = row.createCell(2);
                cell.setCellValue((double)periodYear);
                cell = row.createCell(3);
                cell.setCellValue((double)periodMonth);
                cell = row.createCell(4);
                cell.setCellValue((double)calTime);
                cell = row.createCell(5);
                cell.setCellValue(personRecords);
                cell = row.createCell(6);
                errorDescription = MessageFormat.format(errorMessageFormat, calSchemeName, periodYear + "", periodMonth, calTime, personRecords, ((List)calSchemeCalTableMap.get(key)).size());
                cell.setCellValue(errorDescription);
                cell = row.createCell(7);
                cell.setCellValue(fixAdvice);
                ++count;
            }
        }
    }

    private void exportCmpSocAdjCheckData(Context ctx, XSSFWorkbook wb, Map<String, CellStyle> styles, String tableName) throws BOSException, SQLException {
        LinkedHashMap<String, Object[]> recordMap = new LinkedHashMap<String, Object[]>();
        recordMap.put("\u5e8f\u53f7", new Object[]{"index"});
        recordMap.put("\u5458\u5de5\u7f16\u7801", new Object[]{"personNumber"});
        recordMap.put("\u5458\u5de5\u59d3\u540d", new Object[]{"personName"});
        recordMap.put("\u4e1a\u52a1\u7ec4\u7ec7\u7f16\u7801", new Object[]{"hrOrgUnitNumber"});
        recordMap.put("\u4e1a\u52a1\u7ec4\u7ec7\u540d\u79f0", new Object[]{"hrOrgUnitName"});
        recordMap.put("\u6570\u636e\u63cf\u8ff0", new Object[]{"errorDescription"});
        recordMap.put("\u4fee\u6539\u5efa\u8bae", new Object[]{"fixAdvice"});
        String checkSelectFields = "select FPERSONID personID,FHRORGUNITID HRORGUNITID,count(FPERSONID) count ";
        String groupFields = " group by FPERSONID,FHRORGUNITID  having count(FPERSONID)>1";
        String checkSql = checkSelectFields + " from " + tableName + groupFields;
        StringBuffer recordQuerySql = new StringBuffer();
        recordQuerySql.append("select \r\n").append("person.fname_l2 personName,\r\n").append("person.fnumber personNumber,\r\n").append("hrOrgUnit.fname_l2 hrOrgUnitName,\r\n").append("hrOrgUnit.fnumber hrOrgUnitNumber,\r\n").append("tmp.count count\r\n").append("FROM \r\n").append("(").append(checkSql).append(") tmp\r\n").append("INNER JOIN T_bd_person person on person.FID = tmp.personID\r\n").append("INNER JOIN T_ORG_HRO hrOrgUnit on hrOrgUnit.FID = tmp.HRORGUNITID");
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)recordQuerySql.toString());
        if (executeQuery.size() > 0) {
            String recordLable = this.getLableByTableName(tableName);
            String recordySheetName = recordLable + "\u6863\u6848\u6570\u636e";
            String personName = "";
            String personNumber = "";
            String hrOrgUnitName = "";
            String hrOrgUnitNumber = "";
            String person = "";
            String hrOrgUnit = "";
            String errorDescription = "";
            XSSFSheet fixAdjustSalarySheet = this.createSheet(ctx, wb, recordySheetName, recordMap, styles);
            XSSFRow row = null;
            Cell cell = null;
            int count = 0;
            int index = 0;
            int errorCount = 0;
            String errorMessageFormat = "\u5458\u5de5\u3010{0}\u3011\u5728{1}\u4e1a\u52a1\u7ec4\u7ec7\u3010{2}\u3011\u4e0b\u6709{3}\u6761{1}\u6863\u6848\uff01";
            String fixAdvice = this.getFixAdviceByTableName(tableName);
            while (executeQuery.next()) {
                row = fixAdjustSalarySheet.createRow(1 + count);
                personNumber = this.getExeValue(executeQuery.getString("personNumber"));
                personName = this.getExeValue(executeQuery.getString("personName"));
                person = personName + "\uff08" + personNumber + "\uff09";
                hrOrgUnitNumber = this.getExeValue(executeQuery.getString("hrOrgUnitNumber"));
                hrOrgUnitName = this.getExeValue(executeQuery.getString("hrOrgUnitName"));
                hrOrgUnit = hrOrgUnitName + "\uff08" + hrOrgUnitNumber + "\uff09";
                errorCount = executeQuery.getInt("count");
                cell = row.createCell(0);
                index = count + 1;
                cell.setCellValue((double)index);
                cell = row.createCell(1);
                cell.setCellValue(personNumber);
                cell = row.createCell(2);
                cell.setCellValue(personName);
                cell = row.createCell(3);
                cell.setCellValue(hrOrgUnitNumber);
                cell = row.createCell(4);
                cell.setCellValue(hrOrgUnitName);
                cell = row.createCell(5);
                errorDescription = MessageFormat.format(errorMessageFormat, person, recordLable, hrOrgUnit, errorCount);
                cell.setCellValue(errorDescription);
                cell = row.createCell(6);
                cell.setCellValue(fixAdvice);
                ++count;
            }
        }
    }

    private int getCmpCheckPass(Context ctx) throws SQLException, BOSException {
        String updateSql = "select FPassProgress from T_HR_DataCheckMark where FType = 'CMPCHECK'";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)updateSql);
        int result = 0;
        if (executeQuery.size() > 0) {
            while (executeQuery.next()) {
                result = executeQuery.getInt("FPassProgress");
            }
        }
        return result;
    }

    private boolean checkCalSchemeCalTable(Context ctx) throws BOSException, EASBizException {
        boolean result = true;
        String checkSql = "SELECT \r\ncalScheme.FNAME_L2 calSchemeName,\r\ncalScheme.FPERIODYEAR periodYear,\r\ncalScheme.FPERIODMONTH periodMonth,\r\ncalScheme.FCALTIME calTime,\r\ncmpCalTable.FCALSTATE calState,\r\nperson.FNAME_L2 personName,\r\nperson.FNUMBER personNumber \r\n FROM T_HR_SCmpCalTable cmpCalTable\r\nINNER JOIN T_HR_SCalScheme calScheme on calScheme.FID = cmpCalTable.FCALSCHEMEID and calScheme.FPERIODYEAR = cmpCalTable.FPERIODYEAR and calScheme.FPERIODMONTH = cmpCalTable.FPERIODMONTH and calScheme.FCALTIME = cmpCalTable.FCALTIME \r\nINNER JOIN T_BD_Person person on cmpCalTable.FPERSONID = person.FID \r\nwhere calScheme.FCALSTATE = 12 and cmpCalTable.FCALSTATE < 12";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        if (executeQuery.size() > 0) {
            result = false;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "CMPCHECK", 25, result ? 25 : 0);
        return result;
    }

    private boolean checkCmpSocAdjPersonRecord(Context ctx, String type, String tableName, int time) throws BOSException, SQLException, EASBizException {
        String checkSelectFields = "select FPERSONID personID,FHRORGUNITID HRORGUNITID,count(FPERSONID) count ";
        String groupFields = " group by FPERSONID,FHRORGUNITID  having count(FPERSONID)>1";
        String checkSql = checkSelectFields + " from " + tableName + groupFields;
        boolean result = true;
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)checkSql);
        if (executeQuery.size() > 0) {
            result = false;
        }
        SHRControlMoveDataHelpUtil.updateDataCheckProgress(ctx, "CMPCHECK", 25 + time * 25, result ? this.getCmpCheckPass(ctx) + 25 : this.getCmpCheckPass(ctx));
        return result;
    }

    public String exportBeforeCheckAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            LinkedHashMap<String, Object[]> cmpStructureItemMap = new LinkedHashMap<String, Object[]>();
            cmpStructureItemMap.put("\u5e8f\u53f7", new Object[]{"index"});
            cmpStructureItemMap.put("\u5458\u5de5\u7f16\u7801", new Object[]{"personNumber"});
            cmpStructureItemMap.put("\u5458\u5de5\u59d3\u540d", new Object[]{"personName"});
            cmpStructureItemMap.put("\u85aa\u916c\u9879\u76ee\u540d\u79f0", new Object[]{"cmpItemName"});
            cmpStructureItemMap.put("\u751f\u6548\u65e5\u671f", new Object[]{"effectDate"});
            cmpStructureItemMap.put("\u95ee\u9898\u63cf\u8ff0", new Object[]{"errorDescription"});
            cmpStructureItemMap.put("\u4fee\u6539\u5efa\u8bae", new Object[]{"fixAdvice"});
            XSSFWorkbook wb = new XSSFWorkbook();
            Map<String, CellStyle> styles = StyleUtil.createStyles((Workbook)wb);
            XSSFCellStyle cellStyle = wb.createCellStyle();
            XSSFFont font = wb.createFont();
            font.setColor(IndexedColors.DARK_RED.getIndex());
            font.setFontHeightInPoints((short)12);
            cellStyle.setWrapText(true);
            cellStyle.setFont((Font)font);
            String cmpStructureSheetName = "\u85aa\u916c\u7ed3\u6784\u6570\u636e";
            String cmpStructureQuerySql = "SELECT \r\nperson.fid personID, \r\nperson.fnumber personNumber,\r\nperson.fname_l2 personName,\r\ncmpitem.fid cmpItemID,\r\ncmpitem.fname_l2 cmpItemName,\r\ntmp.effectday effectDate,\r\ntmp.count count\r\nFROM \r\n(SELECT count(FPERSONID) count,FPERSONID person,FCMPITEMID cmpitem,FEFFECTDAY effectday FROM T_HR_SFixAdjustSalary group by FPERSONID,FCMPITEMID,FEFFECTDAY ) tmp\r\nINNER JOIN T_bd_person person on person.fid = tmp.person\r\nINNER JOIN T_HR_SCMPITEM cmpitem on cmpitem.fid = tmp.cmpitem \r\nwhere tmp.count > 1";
            XSSFSheet cmpStructureSheet = this.createSheet(ctx, wb, cmpStructureSheetName, cmpStructureItemMap, styles);
            XSSFRow row = null;
            Cell cell = null;
            int count = 0;
            IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)cmpStructureQuerySql);
            int index = 0;
            int errorCount = 0;
            String personID = "";
            String personNumber = "";
            String personName = "";
            String cmpItemID = "";
            String cmpItemName = "";
            String effectDate = "";
            String errorDescription = "";
            String fixAdvice = "";
            String cmpStructureErrorMessage = "\u5458\u5de5\u3010{0}\uff08{1}\uff09\u3011\u7684\u85aa\u916c\u9879\u76ee\u3010{2}\u3011\u5b58\u5728{3}\u6761\u751f\u6548\u65e5\u671f\u4e3a{4}\u7684\u85aa\u916c\u7ed3\u6784\u6570\u636e\uff01";
            String cmpStructureFixAdviceMessage = "\u9700\u540e\u53f0\u6570\u636e\u5e93\u5904\u7406\uff1a\u901a\u8fc7\u4ee5\u4e0bsql\u67e5\u8be2\u5f02\u5e38\u6570\u636e\uff0c\u4e1a\u52a1\u786e\u8ba4\u5220\u9664\uff08delete\uff09\u91cd\u590d\u7684\u85aa\u916c\u7ed3\u6784\u6570\u636e\u3002\r\n\u67e5\u8be2SQL\uff1aSELECT * FROM T_HR_SFIXADJUSTSALARY \r\nwhere FPERSONID = {0} \r\nand FCMPITEMID = {1} \r\nand FEFFECTDAY = {2}";
            while (executeQuery.next()) {
                row = cmpStructureSheet.createRow(1 + count);
                cell = row.createCell(0);
                index = count + 1;
                cell.setCellValue((double)index);
                personID = this.getExeValue(executeQuery.getString("personID"));
                cmpItemID = this.getExeValue(executeQuery.getString("cmpItemID"));
                cell = row.createCell(1);
                personNumber = this.getExeValue(executeQuery.getString("personNumber"));
                cell.setCellValue(personNumber);
                cell = row.createCell(2);
                personName = this.getExeValue(executeQuery.getString("personName"));
                cell.setCellValue(personName);
                cell = row.createCell(3);
                cmpItemName = this.getExeValue(executeQuery.getString("cmpItemName"));
                cell.setCellValue(cmpItemName);
                cell = row.createCell(4);
                effectDate = this.getExeValue(dateFormat.format(executeQuery.getDate("effectDate")));
                cell.setCellValue(effectDate);
                cell = row.createCell(5);
                errorCount = executeQuery.getInt("count");
                errorDescription = MessageFormat.format(cmpStructureErrorMessage, personName, personNumber, cmpItemName, errorCount, effectDate);
                cell.setCellValue(errorDescription);
                cell = row.createCell(6);
                fixAdvice = MessageFormat.format(cmpStructureFixAdviceMessage, "'" + personID + "'", "'" + cmpItemID + "'", "{ts '" + effectDate + "'}");
                cell.setCellValue(fixAdvice);
                ++count;
            }
            String path = TEMP_DIR + UUID.randomUUID().toString() + ".xlsx";
            FileOutputStream out = new FileOutputStream(path);
            wb.write((OutputStream)out);
            out.close();
            this.setExportExcelHead(response, path, "\u6821\u9a8c\u62a5\u544a");
            return null;
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
    }

    private String getExeValue(Object temp) {
        if (temp == null) {
            return "";
        }
        return temp.toString();
    }

    private XSSFSheet createSheet(Context ctx, XSSFWorkbook wb, String sheetName, Map<String, Object[]> itemMap, Map<String, CellStyle> styles) throws BOSException, SQLException {
        XSSFSheet sheet = wb.createSheet(sheetName);
        XSSFRow row = null;
        Cell cell = null;
        row = sheet.createRow(0);
        row.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : itemMap.keySet()) {
            cell = row.createCell(itemCount++);
            cell.setCellValue(itemName);
            cell.setCellStyle(styles.get("mustInputHead"));
        }
        for (int i = 0; i < itemCount; ++i) {
            if (i == 1) {
                sheet.setColumnWidth(i, 4000);
                continue;
            }
            sheet.setColumnWidth(i, 4000);
        }
        return sheet;
    }

    private void setExportExcelHead(HttpServletResponse response, String path, String fileName) throws Exception {
        int len;
        response.setContentType("application/vnd.ms-excel");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName + ".xlsx", "UTF-8"));
        ServletOutputStream out = response.getOutputStream();
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(path));
        byte[] buffer = new byte[5120];
        while ((len = bis.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
        out.flush();
        out.close();
        bis.close();
    }

    private String getLableByTableName(String tableName) {
        String result = "";
        if ("T_HR_SPersonCmp".equals(tableName)) {
            result = "\u53d1\u85aa";
        } else if ("T_HR_SSocPersonRecord".equals(tableName)) {
            result = "\u793e\u4fdd";
        } else if ("T_HR_SAdjustPersonRecord".equals(tableName)) {
            result = "\u5b9a\u8c03\u85aa";
        }
        return result;
    }

    private String getFixAdviceByTableName(String tableName) {
        String fixAdvice = "";
        if ("T_HR_SPersonCmp".equals(tableName)) {
            fixAdvice = "\u4e1a\u52a1\u786e\u8ba4\u5220\u9664\u91cd\u590d\u7684\u5458\u5de5\u85aa\u916c\u6863\u6848\u8bb0\u5f55\uff0c\u5982\u5df2\u5173\u8054\u4e1a\u52a1\u6570\u636e\uff0c\u8fd8\u9700\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u6570\u636e\u624d\u80fd\u518d\u5220\u9664\u6863\u6848\u3002\u64cd\u4f5c\u8def\u5f84\uff1a\u85aa\u916c\u6838\u7b97-\u5458\u5de5\u85aa\u916c\u6863\u6848-\u8fdb\u5165\u6863\u6848\u8868\u5355-\u5220\u9664\u4efb\u804c\u8bb0\u5f55";
        } else if ("T_HR_SSocPersonRecord".equals(tableName)) {
            fixAdvice = "\u4e1a\u52a1\u786e\u8ba4\u5220\u9664\u91cd\u590d\u7684\u5458\u5de5\u793e\u4fdd\u6863\u6848\u8bb0\u5f55\uff0c\u5982\u5df2\u5173\u8054\u4e1a\u52a1\u6570\u636e\uff0c\u8fd8\u9700\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u6570\u636e\u624d\u80fd\u518d\u5220\u9664\u6863\u6848\u3002\u64cd\u4f5c\u8def\u5f84\uff1a\u85aa\u916c\u6838\u7b97-\u5458\u5de5\u793e\u4fdd\u6863\u6848-\u5220\u9664\u6863\u6848";
        } else if ("T_HR_SAdjustPersonRecord".equals(tableName)) {
            fixAdvice = "\u4e1a\u52a1\u786e\u8ba4\u5220\u9664\u91cd\u590d\u7684\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848\u8bb0\u5f55\uff0c\u5982\u5df2\u5173\u8054\u4e1a\u52a1\u6570\u636e\uff0c\u8fd8\u9700\u5220\u9664\u5173\u8054\u7684\u4e1a\u52a1\u6570\u636e\u624d\u80fd\u518d\u5220\u9664\u6863\u6848\u3002\u64cd\u4f5c\u8def\u5f84\uff1a\u85aa\u916c\u8bbe\u8ba1-\u5458\u5de5\u5b9a\u8c03\u85aa\u6863\u6848-\u8fdb\u5165\u6863\u6848\u8868\u5355-\u5220\u9664\u4efb\u804c\u8bb0\u5f55";
        }
        return fixAdvice;
    }
}

