/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.hr.emp.app.util.SHREmpImportTool;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.hr.mvdt.handler.ExcelUtil;
import com.kingdee.shr.hr.mvdt.handler.SHREmpDbUtilTool;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class PersonAndPersonContactMethodExportHandler {
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";
    public static final String PERSONNAME = "\u5458\u5de5\u57fa\u672c\u4fe1\u606f\u548c\u8054\u7cfb\u65b9\u5f0f";
    public static String NUMBER_NAME_SPLIT = "##";

    public static String exportPersonAndPersonContactMethodAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            ServletOutputStream out = null;
            Map<String, Object[]> empPersonAndPersonContactMethodItemMap = PersonAndPersonContactMethodExportHandler.getPersonAndPersonContactMethodItemMap();
            byte[] bytes = PersonAndPersonContactMethodExportHandler.exportPersonAndPersonContactMethodTemplate(empPersonAndPersonContactMethodItemMap, request, response, modelMap, ctx);
            String fileName = "\u5458\u5de5\u57fa\u672c\u4fe1\u606f\u548c\u8054\u7cfb\u65b9\u5f0f.xlsx";
            WebUtil.setFileResponseHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName);
            out = response.getOutputStream();
            out.write(bytes, 0, bytes.length);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Map<String, Object[]> getPersonAndPersonContactMethodItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("\u5458\u5de5\u7f16\u7801", new Object[]{"personNumber"});
        itemMap.put("\u59d3\u540d", new Object[]{"personName"});
        itemMap.put("\u8eab\u4efd\u8bc1\u53f7\u7801", new Object[]{"idCardNO"});
        itemMap.put("\u5a5a\u59fb\u72b6\u51b5", new Object[]{"wedNumberAndName"});
        itemMap.put("\u653f\u6cbb\u9762\u8c8c", new Object[]{"politicalFaceNumberAndName"});
        itemMap.put("\u6237\u53e3\u7c7b\u578b", new Object[]{"regresidenceNumberAndName"});
        itemMap.put("\u6237\u53e3\u6240\u5728\u5730", new Object[]{"hjAddress"});
        itemMap.put("\u53c2\u52a0\u5de5\u4f5c\u65e5\u671f", new Object[]{"jobStartDate"});
        itemMap.put("\u56fd\u9645\u533a\u53f7", new Object[]{"globalRoaming"});
        itemMap.put("\u624b\u673a\u53f7\u7801", new Object[]{"mobile"});
        itemMap.put("\u529e\u516c\u7535\u8bdd", new Object[]{"officePhone"});
        itemMap.put("\u7535\u5b50\u90ae\u4ef6", new Object[]{"email"});
        itemMap.put("\u901a\u4fe1\u5730\u5740", new Object[]{"addressTX"});
        itemMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u59d3\u540d", new Object[]{"linkName"});
        itemMap.put("\u7d27\u6025\u8054\u7cfb\u4eba\u7535\u8bdd", new Object[]{"linkTelNum"});
        return itemMap;
    }

    private static byte[] exportPersonAndPersonContactMethodTemplate(Map<String, Object[]> adminItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Context ctx) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)wb);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setColor(IndexedColors.DARK_RED.getIndex());
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont((Font)font);
        XSSFSheet personSheet = wb.createSheet(PERSONNAME);
        CellStyle textStyle = PersonAndPersonContactMethodExportHandler.textStyle((Workbook)wb);
        XSSFRow personRow = null;
        Cell personCell = null;
        personRow = personSheet.createRow(0);
        personRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            personCell = personRow.createCell(itemCount++);
            personCell.setCellValue(itemName);
            if (!itemName.equals("\u59d3\u540d")) continue;
            personCell.setCellStyle(styles.get("mustInputHead"));
        }
        for (int i = 0; i < itemCount; ++i) {
            personSheet.setColumnWidth(i, 4000);
            personSheet.setDefaultColumnStyle(i, textStyle);
        }
        String sql = "SELECT  person.FNUMBER as personNumber, person.FNAME_l2 as personName, person.FIDCARDNO as idCardNO, wed.FNUMBER as wedNumber, wed.FNAME_l2 as wedName, politicalFace.FNUMBER as politicalFaceNumber, politicalFace.FNAME_l2 as politicalFaceName,  regresidence.FNUMBER as regresidenceNumber, regresidence.FNAME_l2 as regresidenceName, contactMethod.FHJADDRESS as hjAddress, pp.FjobStartDate as jobStartDate, contactMethod.FMOBILE as mobile, contactMethod.FOFFICEPHONE as officePhone, contactMethod.FEMAIL as email, contactMethod.FADDRESS as addressTX FROM t_bd_person person left join T_HR_PersonContactMethod contactMethod ON person.FID = contactMethod.FPERSONID left join T_BD_HRWed wed ON wed.FID = person.FWEDID left join T_BD_HRPolitical politicalFace ON politicalFace.FID = person.FPOLITICALFACEID left join T_BD_Regpermresidence regresidence ON regresidence.FID = contactMethod.FREGRESIDENCEID left join T_HR_PersonPosition pp ON pp.FPersonID = person.fid ORDER BY person.FNUMBER";
        int count = 0;
        IRowSet executeQuery = SHREmpDbUtilTool.executeQuery(ctx, sql);
        while (executeQuery.next()) {
            String personNumber = executeQuery.getString("personNumber");
            String personName = executeQuery.getString("personName");
            String idCardNO = executeQuery.getString("idCardNO");
            String wedNumber = executeQuery.getString("wedNumber");
            String wedName = executeQuery.getString("wedName");
            String wedNumberAndNumber = "";
            wedNumberAndNumber = StringUtils.isEmpty((String)wedNumber) ? wedName : (StringUtils.isEmpty((String)wedName) ? wedNumber : wedNumber + NUMBER_NAME_SPLIT + wedName);
            String politicalFaceNumber = executeQuery.getString("politicalFaceNumber");
            String politicalFaceName = executeQuery.getString("politicalFaceName");
            String politicalFaceNumberAndNumber = "";
            politicalFaceNumberAndNumber = StringUtils.isEmpty((String)politicalFaceNumber) ? politicalFaceName : (StringUtils.isEmpty((String)politicalFaceName) ? politicalFaceNumber : politicalFaceNumber + NUMBER_NAME_SPLIT + politicalFaceName);
            String regresidenceNumber = executeQuery.getString("regresidenceNumber");
            String regresidenceName = executeQuery.getString("regresidenceName");
            String regresidenceNumberAndNumber = "";
            regresidenceNumberAndNumber = StringUtils.isEmpty((String)regresidenceNumber) ? regresidenceName : (StringUtils.isEmpty((String)regresidenceName) ? regresidenceNumber : regresidenceNumber + NUMBER_NAME_SPLIT + regresidenceName);
            String hjAddress = executeQuery.getString("hjAddress");
            String jobStartDate = executeQuery.getString("jobStartDate");
            String mobile = executeQuery.getString("mobile");
            String officePhone = executeQuery.getString("officePhone");
            String email = executeQuery.getString("email");
            String addressTX = executeQuery.getString("addressTX");
            personRow = personSheet.createRow(1 + count);
            personCell = personRow.createCell(0);
            personCell.setCellValue(personNumber);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(1);
            personCell.setCellValue(personName);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(2);
            personCell.setCellValue(idCardNO);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(3);
            personCell.setCellValue(wedNumberAndNumber);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(4);
            personCell.setCellValue(politicalFaceNumberAndNumber);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(5);
            personCell.setCellValue(regresidenceNumberAndNumber);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(6);
            personCell.setCellValue(hjAddress);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(7);
            if (!StringUtils.isEmpty((String)jobStartDate)) {
                personCell.setCellValue(jobStartDate.substring(0, 10));
            } else {
                personCell.setCellValue(jobStartDate);
            }
            personCell.setCellStyle(textStyle);
            String globalRoaming = "";
            if (!StringUtils.isEmpty((String)mobile) && mobile.contains(SHREmpImportTool.HORIZONTAL_BAR)) {
                globalRoaming = mobile.split(SHREmpImportTool.HORIZONTAL_BAR)[0];
                mobile = mobile.split(SHREmpImportTool.HORIZONTAL_BAR)[1];
            } else if (!StringUtils.isEmpty((String)mobile)) {
                globalRoaming = SHREmpImportTool.SPECIAL_AREA_CODE;
            }
            personCell = personRow.createCell(8);
            personCell.setCellValue(globalRoaming);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(9);
            personCell.setCellValue(mobile);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(10);
            personCell.setCellValue(officePhone);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(11);
            personCell.setCellValue(email);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(12);
            personCell.setCellValue(addressTX);
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(13);
            personCell.setCellValue("");
            personCell.setCellStyle(textStyle);
            personCell = personRow.createCell(14);
            personCell.setCellValue("");
            personCell.setCellStyle(textStyle);
            ++count;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wb.write((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static CellStyle textStyle(Workbook wb) {
        CellStyle css = wb.createCellStyle();
        DataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        return css;
    }
}

