/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.hr.mvdt.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.context.SHRContext;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.web.util.WebUtil;
import com.kingdee.shr.hr.mvdt.handler.ExcelUtil;
import com.kingdee.shr.hr.mvdt.handler.SHREmpDbUtilTool;
import com.kingdee.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.ui.ModelMap;

public class PersonWorkExpCurDataExportHandler {
    public static final String TEMP_DIR = System.getProperty("EAS_HOME") + "/server/deploy/easweb.ear/eas_web.war/tmp/";
    public static final String EMPNAME = "\u53d8\u52a8\u5386\u53f2";
    public static final String ISPRIMARYM = "1";
    public static final String ISPRIMARYP = "0";
    public static final String MAIN = "\u4e3b\u8981\u4efb\u804c";
    public static final String PARTTIME = "\u517c\u804c\u4efb\u804c";
    public static final String ISSYSTEM = "\u662f";
    public static final String ISNOTSYSTEM = "\u5426";
    public static String NUMBER_NAME_SPLIT = "##";

    public static String exportPersonWorkExpCurAction(HttpServletRequest request, HttpServletResponse response, ModelMap modelMap) throws SHRWebException {
        try {
            Context ctx = SHRContext.getInstance().getContext();
            ServletOutputStream out = null;
            Map<String, Object[]> personWorkExpCurItemMap = PersonWorkExpCurDataExportHandler.getPersonWorkExpCurItemMap();
            byte[] bytes = PersonWorkExpCurDataExportHandler.exportPersonWorkExpCurItemMapTemplate(personWorkExpCurItemMap, request, response, modelMap, ctx);
            String fileName = "\u53d8\u52a8\u5386\u53f2.xlsx";
            WebUtil.setFileResponseHeader((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName);
            out = response.getOutputStream();
            out.write(bytes, 0, bytes.length);
        }
        catch (BOSException e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            throw new SHRWebException(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private static Map<String, Object[]> getPersonWorkExpCurItemMap() throws BOSException {
        LinkedHashMap<String, Object[]> itemMap = new LinkedHashMap<String, Object[]>();
        itemMap.put("\u5458\u5de5\u7f16\u7801", new Object[]{"empNumber"});
        itemMap.put("\u59d3\u540d", new Object[]{"empName"});
        itemMap.put("\u804c\u4f4d", new Object[]{"positionNumberAndName"});
        itemMap.put("\u6240\u5c5e\u884c\u653f\u7ec4\u7ec7", new Object[]{"orgAdminNumber"});
        itemMap.put("\u6240\u5c5e\u516c\u53f8", new Object[]{"companyNumber"});
        itemMap.put("\u4efb\u804c\u7c7b\u578b", new Object[]{"assignType"});
        itemMap.put("\u7528\u5de5\u5173\u7cfb\u72b6\u6001", new Object[]{"employeeTypeNumberAndName"});
        itemMap.put("\u5f00\u59cb\u65e5\u671f", new Object[]{"EFFDT"});
        itemMap.put("\u7ed3\u675f\u65e5\u671f", new Object[]{"LEFFDT"});
        itemMap.put("\u7cfb\u7edf\u5185", new Object[]{"isSystem"});
        itemMap.put("\u5907\u6ce8", new Object[]{"remark"});
        itemMap.put("\u5386\u53f2\u804c\u4f4d\uff08\u6587\u672c\uff09", new Object[]{"pastPosition"});
        itemMap.put("\u5386\u53f2\u7ec4\u7ec7\uff08\u6587\u672c\uff09", new Object[]{"pastDept"});
        return itemMap;
    }

    private static byte[] exportPersonWorkExpCurItemMapTemplate(Map<String, Object[]> adminItemMap, HttpServletRequest request, HttpServletResponse response, ModelMap modelMap, Context ctx) throws Exception {
        XSSFWorkbook wb = new XSSFWorkbook();
        Map<String, CellStyle> styles = ExcelUtil.createStyles((Workbook)wb);
        XSSFCellStyle cellStyle = wb.createCellStyle();
        XSSFFont font = wb.createFont();
        font.setColor(IndexedColors.DARK_RED.getIndex());
        font.setFontHeightInPoints((short)12);
        cellStyle.setWrapText(true);
        cellStyle.setFont((Font)font);
        XSSFSheet pWorkExpCurSheet = wb.createSheet(EMPNAME);
        CellStyle textStyle = PersonWorkExpCurDataExportHandler.textStyle((Workbook)wb);
        XSSFRow pWorkExpCurRow = null;
        Cell pWorkExpCurCell = null;
        pWorkExpCurRow = pWorkExpCurSheet.createRow(0);
        pWorkExpCurRow.setHeight((short)400);
        int itemCount = 0;
        for (String itemName : adminItemMap.keySet()) {
            pWorkExpCurCell = pWorkExpCurRow.createCell(itemCount++);
            pWorkExpCurCell.setCellValue(itemName);
            if (!itemName.equals("\u59d3\u540d") && !itemName.equals("\u804c\u4f4d") && !itemName.equals("\u4efb\u804c\u7c7b\u578b") && !itemName.equals("\u7528\u5de5\u5173\u7cfb\u72b6\u6001") && !itemName.equals("\u5f00\u59cb\u65e5\u671f") && !itemName.equals("\u7ed3\u675f\u65e5\u671f")) continue;
            pWorkExpCurCell.setCellStyle(styles.get("mustInputHead"));
        }
        for (int i = 0; i < itemCount; ++i) {
            pWorkExpCurSheet.setColumnWidth(i, 4000);
            pWorkExpCurSheet.setDefaultColumnStyle(i, textStyle);
        }
        String sql = "SELECT person.fnumber as empNumber, person.fname_l2 as empName,position.FNUMBER as positionNumber, position.FNAME_L2 as positionName, workexpcur.fisprimary as isprimary , employeeType.FNUMBER as employeeTypeNumber, employeeType.FNAME_L2 as employeeTypeName, workexpcur.fbegindate as beginDate , workexpcur.fenddate as endDate, workexpcur.fpositionid as positionId, workexpcur.FPASTPOSITON as pastPosition, workexpcur.FPASTDEPT as pastDept from T_HR_PersonWorkExpCur workexpcur left join t_bd_person person on person.fid = workexpcur.fpersonid left join t_org_position position on position.fid = workexpcur.fpositionid left join t_org_admin adminOrg on adminOrg.fid = workexpcur.fdeptid left join T_HR_BDEmployeeType employeeType on employeeType.fid = person.femployeetypeid where not exists (select 1  from (select max(fcreatetime) maxcreatetime,fpersonid from T_HR_PersonWorkExpCur where fpersonid not in (select fpersonid from T_ORG_PositionMember) and FISPRIMARY=1 group by fpersonid) temp where temp.maxcreatetime=workexpcur.fcreatetime and temp.fpersonid = workexpcur.fpersonid) union all  SELECT person.fnumber as empNumber, person.fname_l2 as empName,position.FNUMBER as positionNumber, position.FNAME_L2 as positionName, workexpcur1.fisprimary as isprimary , employeeType.FNUMBER as employeeTypeNumber, employeeType.FNAME_L2 as employeeTypeName, workexpcur1.fbegindate as beginDate , ADD_DAYS(TO_DATE(workexpcur1.fenddate),-1) as endDate, workexpcur1.fpositionid as positionId, workexpcur1.FPASTPOSITON as pastPosition, workexpcur1.FPASTDEPT as pastDept from T_HR_Personworkexpcur workexpcur1 left join t_bd_person person on person.fid = workexpcur1.fpersonid left join t_org_position position on position.fid = workexpcur1.fpositionid left join t_org_admin adminOrg on adminOrg.fid = workexpcur1.fdeptid left join T_HR_BDEmployeeType employeeType on employeeType.fid = person.femployeetypeid where exists (select 1  from (select max(fcreatetime) maxcreatetime,fpersonid from T_HR_Personworkexpcur where fpersonid not in (select fpersonid from T_ORG_PositionMember) and FISPRIMARY=1 group by fpersonid) temp where temp.maxcreatetime=workexpcur1.fcreatetime and temp.fpersonid = workexpcur1.fpersonid) order by empNumber,isprimary desc,endDate";
        int count = 0;
        IRowSet executeQuery = SHREmpDbUtilTool.executeQuery(ctx, sql);
        while (executeQuery.next()) {
            String empNumber = executeQuery.getString("empNumber");
            String empName = executeQuery.getString("empName");
            String positionNumber = executeQuery.getString("positionNumber");
            String positionName = executeQuery.getString("positionName");
            String positionNumberAndName = "";
            positionNumberAndName = StringUtils.isEmpty((String)positionNumber) ? positionName : (StringUtils.isEmpty((String)positionName) ? positionNumber : positionNumber + NUMBER_NAME_SPLIT + positionName);
            String isprimary = executeQuery.getString("isprimary");
            String employeeTypeNumber = executeQuery.getString("employeeTypeNumber");
            String employeeTypeName = executeQuery.getString("employeeTypeName");
            String employeeTypeNumberAndName = "";
            employeeTypeNumberAndName = StringUtils.isEmpty((String)employeeTypeNumber) ? employeeTypeName : (StringUtils.isEmpty((String)employeeTypeName) ? employeeTypeNumber : employeeTypeNumber + NUMBER_NAME_SPLIT + employeeTypeName);
            String beginDate = executeQuery.getString("beginDate");
            String endDate = executeQuery.getString("endDate");
            String positionId = executeQuery.getString("positionId");
            String pastPosition = executeQuery.getString("pastPosition");
            String pastDept = executeQuery.getString("pastDept");
            pWorkExpCurRow = pWorkExpCurSheet.createRow(1 + count);
            pWorkExpCurCell = pWorkExpCurRow.createCell(0);
            pWorkExpCurCell.setCellValue(empNumber);
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(1);
            pWorkExpCurCell.setCellValue(empName);
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(2);
            pWorkExpCurCell.setCellValue(positionNumberAndName);
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(3);
            pWorkExpCurCell.setCellValue("");
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(4);
            pWorkExpCurCell.setCellValue("");
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(5);
            if (ISPRIMARYM.equals(isprimary)) {
                pWorkExpCurCell.setCellValue(MAIN);
            } else if (ISPRIMARYP.equals(isprimary)) {
                pWorkExpCurCell.setCellValue(PARTTIME);
            } else {
                pWorkExpCurCell.setCellValue("");
            }
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(6);
            pWorkExpCurCell.setCellValue(employeeTypeNumberAndName);
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(7);
            if (!StringUtils.isEmpty((String)beginDate)) {
                pWorkExpCurCell.setCellValue(beginDate.substring(0, 10));
            } else {
                pWorkExpCurCell.setCellValue(beginDate);
            }
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(8);
            if (!StringUtils.isEmpty((String)endDate)) {
                pWorkExpCurCell.setCellValue(endDate.substring(0, 10));
            } else {
                pWorkExpCurCell.setCellValue(endDate);
            }
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(9);
            if (!StringUtils.isEmpty((String)positionId)) {
                pWorkExpCurCell.setCellValue(ISSYSTEM);
            } else {
                pWorkExpCurCell.setCellValue(ISNOTSYSTEM);
            }
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(10);
            pWorkExpCurCell.setCellValue("");
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(11);
            pWorkExpCurCell.setCellValue(pastPosition);
            pWorkExpCurCell.setCellStyle(textStyle);
            pWorkExpCurCell = pWorkExpCurRow.createCell(12);
            pWorkExpCurCell.setCellValue(pastDept);
            pWorkExpCurCell.setCellStyle(textStyle);
            ++count;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        wb.write((OutputStream)outputStream);
        return outputStream.toByteArray();
    }

    private static CellStyle textStyle(Workbook wb) {
        CellStyle css = wb.createCellStyle();
        DataFormat format = wb.createDataFormat();
        css.setDataFormat(format.getFormat("@"));
        return css;
    }
}

